/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.writer;

import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFWriterRegistry;
import org.apache.jena.sys.JenaSystem;
import org.junit.Assert;
import org.junit.Test;

public class TestWriterRegistration {
    @Test
    public void registration_01() {
        this.testregistration(Lang.RDFXML);
    }

    @Test
    public void registration_02() {
        this.testregistration(Lang.NTRIPLES);
    }

    @Test
    public void registration_03() {
        this.testregistration(Lang.NT);
    }

    @Test
    public void registration_04() {
        this.testregistration(Lang.N3);
    }

    @Test
    public void registration_05() {
        this.testregistration(Lang.TURTLE);
    }

    @Test
    public void registration_06() {
        this.testregistration(Lang.TTL);
    }

    @Test
    public void registration_07() {
        this.testregistration(Lang.RDFJSON);
    }

    @Test
    public void registration_08() {
        this.testregistration(Lang.NQUADS);
    }

    @Test
    public void registration_09() {
        this.testregistration(Lang.NQ);
    }

    @Test
    public void registration_10() {
        this.testregistration(Lang.TRIG);
    }

    @Test
    public void registration_11() {
        this.testregistration(Lang.RDFNULL);
    }

    @Test
    public void registration_20() {
        this.testregistration(RDFFormat.TURTLE_PRETTY);
    }

    @Test
    public void registration_21() {
        this.testregistration(RDFFormat.TURTLE);
    }

    @Test
    public void registration_22() {
        this.testregistration(RDFFormat.TTL);
    }

    @Test
    public void registration_23() {
        this.testregistration(RDFFormat.TURTLE_BLOCKS);
    }

    @Test
    public void registration_24() {
        this.testregistration(RDFFormat.TURTLE_FLAT);
    }

    @Test
    public void registration_25() {
        this.testregistration(RDFFormat.NTRIPLES);
    }

    @Test
    public void registration_26() {
        this.testregistration(RDFFormat.NQUADS);
    }

    @Test
    public void registration_25a() {
        this.testregistration(RDFFormat.NTRIPLES_UTF8);
    }

    @Test
    public void registration_26a() {
        this.testregistration(RDFFormat.NQUADS_UTF8);
    }

    @Test
    public void registration_25b() {
        this.testregistration(RDFFormat.NTRIPLES_ASCII);
    }

    @Test
    public void registration_26b() {
        this.testregistration(RDFFormat.NQUADS_ASCII);
    }

    @Test
    public void registration_27() {
        this.testregistration(RDFFormat.TRIG_PRETTY);
    }

    @Test
    public void registration_28() {
        this.testregistration(RDFFormat.TRIG);
    }

    @Test
    public void registration_29() {
        this.testregistration(RDFFormat.TRIG_BLOCKS);
    }

    @Test
    public void registration_30() {
        this.testregistration(RDFFormat.TRIG_FLAT);
    }

    @Test
    public void registration_31() {
        this.testregistration(RDFFormat.RDFXML_PRETTY);
    }

    @Test
    public void registration_32() {
        this.testregistration(RDFFormat.RDFXML_ABBREV);
    }

    @Test
    public void registration_33() {
        this.testregistration(RDFFormat.RDFXML);
    }

    @Test
    public void registration_34() {
        this.testregistration(RDFFormat.RDFXML_PLAIN);
    }

    @Test
    public void registration_35() {
        this.testregistration(RDFFormat.RDFJSON);
    }

    @Test
    public void registration_36() {
        this.testregistration(RDFFormat.RDFNULL);
    }

    private void testregistration(Lang lang) {
        Assert.assertTrue((String)("No writer registered for language " + lang), (boolean)RDFWriterRegistry.contains((Lang)lang));
        Assert.assertTrue((RDFWriterRegistry.getWriterGraphFactory((Lang)lang) != null || RDFWriterRegistry.getWriterDatasetFactory((Lang)lang) != null ? 1 : 0) != 0);
    }

    private void testregistration(RDFFormat format) {
        Assert.assertTrue((String)("No writer registered for format " + format), (boolean)RDFWriterRegistry.contains((RDFFormat)format));
        Assert.assertTrue((RDFWriterRegistry.getWriterGraphFactory((RDFFormat)format) != null || RDFWriterRegistry.getWriterDatasetFactory((RDFFormat)format) != null ? 1 : 0) != 0);
    }

    static {
        JenaSystem.init();
        RDFWriterRegistry.init();
    }
}

