/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core.mem;

import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.sparql.core.mem.AbstractTestTupleTable;
import org.apache.jena.sparql.core.mem.TupleSlot;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractTestTupleTableForms<TableForm extends Predicate<Set<TupleSlot>>>
extends Assert {
    protected abstract Stream<TableForm> tableForms();

    protected abstract Stream<Set<TupleSlot>> queryPatterns();

    @Test
    public void anAllWildcardQueryCannotAvoidTraversal() {
        AbstractTestTupleTableForms.assertTrue((boolean)this.tableForms().noneMatch(form -> form.test(AbstractTestTupleTable.allWildcardQuery)));
    }

    @Test
    public void anyIndexCanAnswerAnEntirelyConcretePattern() {
        this.tableForms().allMatch(form -> form.test(AbstractTestTupleTable.allWildcardQuery));
    }

    protected boolean canAvoidTraversal(Set<TupleSlot> pattern) {
        return this.tableForms().anyMatch(form -> form.test(pattern));
    }

    @Test
    public void allQueriesWithAtLeastOneConcreteNodeCanAvoidTraversal() {
        AbstractTestTupleTableForms.assertTrue((boolean)this.queryPatterns().filter(p -> !AbstractTestTupleTable.allWildcardQuery.equals(p)).allMatch(this::canAvoidTraversal));
    }

    protected void avoidsTraversal(Predicate<Set<TupleSlot>> indexForm, Set<Set<TupleSlot>> correctAnswers) {
        Set answers = this.queryPatterns().filter(indexForm::test).collect(Collectors.toSet());
        AbstractTestTupleTableForms.assertEquals(correctAnswers, answers);
    }

    @Test
    public void aCorrectIndexIsChosenForEachPattern() {
        this.answerKey().forEach((sample, correctAnswers) -> AbstractTestTupleTableForms.assertTrue((boolean)correctAnswers.contains(this.chooseFrom((Set<TupleSlot>)sample))));
    }

    protected abstract TableForm chooseFrom(Set<TupleSlot> var1);

    protected abstract Map<Set<TupleSlot>, Set<TableForm>> answerKey();
}

