/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core.mem;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.mem.DatasetGraphInMemory;
import org.awaitility.Awaitility;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDatasetGraphInMemoryThreading
extends Assert {
    Logger log = LoggerFactory.getLogger(TestDatasetGraphInMemoryThreading.class);
    Quad q = Quad.create((Node)NodeFactory.createBlankNode(), (Node)NodeFactory.createBlankNode(), (Node)NodeFactory.createBlankNode(), (Node)NodeFactory.createBlankNode());

    @Test
    public void abortedChangesNeverBecomeVisible() {
        final DatasetGraphInMemory dsg = new DatasetGraphInMemory();
        final AtomicBoolean addedButNotAborted = new AtomicBoolean(false);
        final AtomicBoolean addedCheckedButNotAborted = new AtomicBoolean(false);
        final AtomicBoolean aborted = new AtomicBoolean(false);
        dsg.begin(ReadWrite.READ);
        TestDatasetGraphInMemoryThreading.assertTrue((boolean)dsg.isEmpty());
        dsg.end();
        new Thread(){

            @Override
            public void run() {
                dsg.begin(ReadWrite.WRITE);
                TestDatasetGraphInMemoryThreading.this.log.debug("Writer: Added test quad.");
                dsg.add(TestDatasetGraphInMemoryThreading.this.q);
                Assert.assertFalse((boolean)dsg.isEmpty());
                addedButNotAborted.set(true);
                TestDatasetGraphInMemoryThreading.this.log.debug("Writer: Waiting to abort addition of test quad.");
                Awaitility.await().untilTrue(addedCheckedButNotAborted);
                Assert.assertFalse((boolean)dsg.isEmpty());
                TestDatasetGraphInMemoryThreading.this.log.debug("Writer: Aborting test quad.");
                dsg.abort();
                TestDatasetGraphInMemoryThreading.this.log.debug("Writer: Aborted test quad.");
                aborted.set(true);
            }
        }.start();
        this.log.debug("Reader: Waiting for test quad to be added in Writer thread.");
        Awaitility.await().untilTrue(addedButNotAborted);
        dsg.begin(ReadWrite.READ);
        TestDatasetGraphInMemoryThreading.assertTrue((boolean)dsg.isEmpty());
        dsg.end();
        this.log.debug("Reader: Checked to see test quad is not visible.");
        addedCheckedButNotAborted.set(true);
        this.log.debug("Reader: Waiting to see Writer transaction aborted.");
        Awaitility.await().untilTrue(aborted);
        dsg.begin(ReadWrite.READ);
        TestDatasetGraphInMemoryThreading.assertTrue((boolean)dsg.isEmpty());
        dsg.end();
    }

    @Test
    public void snapshotsShouldBeIsolated() {
        final DatasetGraphInMemory dsg = new DatasetGraphInMemory();
        final AtomicBoolean addedButNotCommitted = new AtomicBoolean(false);
        final AtomicBoolean addedCheckedButNotCommitted = new AtomicBoolean(false);
        final AtomicBoolean committed = new AtomicBoolean(false);
        dsg.begin(ReadWrite.READ);
        TestDatasetGraphInMemoryThreading.assertTrue((boolean)dsg.isEmpty());
        dsg.end();
        new Thread(){

            @Override
            public void run() {
                dsg.begin(ReadWrite.WRITE);
                TestDatasetGraphInMemoryThreading.this.log.debug("Writer: Added test quad.");
                dsg.add(TestDatasetGraphInMemoryThreading.this.q);
                Assert.assertFalse((boolean)dsg.isEmpty());
                addedButNotCommitted.set(true);
                TestDatasetGraphInMemoryThreading.this.log.debug("Writer: Waiting to commit test quad.");
                Awaitility.await().untilTrue(addedCheckedButNotCommitted);
                TestDatasetGraphInMemoryThreading.this.log.debug("Writer: Committing test quad.");
                dsg.commit();
                TestDatasetGraphInMemoryThreading.this.log.debug("Writer: Committed test quad.");
                committed.set(true);
            }
        }.start();
        this.log.debug("Reader: Waiting for test quad to be added in Writer thread.");
        Awaitility.await().untilTrue(addedButNotCommitted);
        dsg.begin(ReadWrite.READ);
        TestDatasetGraphInMemoryThreading.assertTrue((boolean)dsg.isEmpty());
        this.log.debug("Reader: Checked to see test quad is not yet visible.");
        addedCheckedButNotCommitted.set(true);
        this.log.debug("Reader: Waiting to see test quad committed.");
        Awaitility.await().untilTrue(committed);
        TestDatasetGraphInMemoryThreading.assertTrue((boolean)dsg.isEmpty());
        dsg.end();
        dsg.begin(ReadWrite.READ);
        TestDatasetGraphInMemoryThreading.assertFalse((boolean)dsg.isEmpty());
        dsg.end();
    }

    @Test
    public void locksAreCorrectlyDistributed() {
        final DatasetGraphInMemory dsg = new DatasetGraphInMemory();
        final AtomicBoolean readLockCaptured = new AtomicBoolean(false);
        final AtomicBoolean writeLockCaptured = new AtomicBoolean(false);
        dsg.begin(ReadWrite.WRITE);
        new Thread(){

            @Override
            public void run() {
                dsg.begin(ReadWrite.READ);
                readLockCaptured.set(true);
                dsg.end();
                dsg.begin(ReadWrite.WRITE);
                writeLockCaptured.set(true);
            }
        }.start();
        Awaitility.await().untilTrue(readLockCaptured);
        if (writeLockCaptured.get()) {
            TestDatasetGraphInMemoryThreading.fail((String)"Write lock captured by two threads at once!");
        }
        dsg.abort();
        dsg.end();
        Awaitility.await().untilTrue(writeLockCaptured);
        TestDatasetGraphInMemoryThreading.assertTrue((String)"Lock was not handed over to waiting thread!", (boolean)writeLockCaptured.get());
    }
}

