/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core.mem;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.ext.com.google.common.collect.ImmutableSet;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.mem.AbstractTestQuadTable;
import org.apache.jena.sparql.core.mem.HexTable;
import org.apache.jena.sparql.core.mem.QuadTable;
import org.apache.jena.sparql.core.mem.TupleSlot;
import org.junit.Assert;
import org.junit.Test;

public class TestHexTable
extends AbstractTestQuadTable {
    private final HexTable testTable = new HexTable();

    @Test
    public void testListGraphNodes() {
        int nodesToTry = 50;
        HexTable index = new HexTable();
        HashSet<Node> graphNodes = new HashSet<Node>(50);
        index.begin(null);
        for (int i = 0; i < 50; ++i) {
            Node node = NodeFactory.createBlankNode();
            index.add(Quad.create((Node)node, (Node)node, (Node)node, (Node)node));
            graphNodes.add(node);
            Assert.assertEquals(graphNodes, index.listGraphNodes().collect(Collectors.toSet()));
        }
        index.end();
    }

    @Test
    public void checkConcreteQueries() {
        this.queryPatterns().filter(p -> !allWildcardQuery.equals(p)).map(TestHexTable::exampleFrom).forEach(testQuery -> {
            HexTable index = new HexTable();
            index.begin(null);
            index.add(this.testTuple());
            Node node = NodeFactory.createBlankNode();
            Quad noiseQuad = Quad.create((Node)node, (Node)node, (Node)node, (Node)node);
            index.add(noiseQuad);
            index.commit();
            index.begin(null);
            Set contents = index.find(testQuery.getGraph(), testQuery.getSubject(), testQuery.getPredicate(), testQuery.getObject()).collect(Collectors.toSet());
            Assert.assertEquals((Object)ImmutableSet.of((Object)this.testTuple()), contents);
            contents = index.find(null, Node.ANY, null, Node.ANY).collect(Collectors.toSet());
            Assert.assertEquals((Object)ImmutableSet.of((Object)this.testTuple(), (Object)noiseQuad), contents);
            index.end();
        });
    }

    private static Quad exampleFrom(Set<TupleSlot> pattern) {
        return Quad.create((Node)(pattern.contains(TupleSlot.GRAPH) ? sampleNode : Node.ANY), (Node)(pattern.contains(TupleSlot.SUBJECT) ? sampleNode : Node.ANY), (Node)(pattern.contains(TupleSlot.PREDICATE) ? sampleNode : Node.ANY), (Node)(pattern.contains(TupleSlot.OBJECT) ? sampleNode : Node.ANY));
    }

    @Override
    protected QuadTable table() {
        return this.testTable;
    }

    @Override
    protected Stream<Quad> tuples() {
        return this.table().find(Node.ANY, Node.ANY, Node.ANY, Node.ANY);
    }
}

