/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.binding;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.jena.atlas.legacy.BaseTest2;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerText;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.binding.BindingInputStream;
import org.apache.jena.sparql.engine.binding.BindingOutputStream;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.sparql.resultset.ResultSetCompare;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.sse.builders.BuilderBinding;
import org.apache.jena.sparql.util.EqualityTest;
import org.apache.jena.sparql.util.NodeUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestBindingStreams {
    static Binding b12 = TestBindingStreams.build("(?a 1) (?b 2)");
    static Binding b19 = TestBindingStreams.build("(?a 1) (?b 9)");
    static Binding b02 = TestBindingStreams.build("(?b 2)");
    static Binding b10 = TestBindingStreams.build("(?a 1)");
    static Binding b0 = TestBindingStreams.build("");
    static Binding bb1 = TestBindingStreams.build("(?a _:XYZ) (?b 1)");
    static Binding bb2 = TestBindingStreams.build("(?a 'a\"b\"c') (?b 1)");
    static Binding bb3 = TestBindingStreams.build("(?a 'a\u03a9c') (?b 1)");
    static PrefixMap pmap = PrefixMapFactory.create();
    static Binding x10;

    @BeforeClass
    public static void beforeClass() {
        BaseTest2.setTestLogging();
    }

    @AfterClass
    public static void afterClass() {
        BaseTest2.unsetTestLogging();
    }

    @Test
    public void bindingStream_01() {
        TestBindingStreams.testRead("VARS ?a ?b . 1 2 .", b12);
    }

    @Test
    public void bindingStream_02() {
        TestBindingStreams.testRead("VARS ?a ?b . - 2 .", b02);
    }

    @Test
    public void bindingStream_03() {
        TestBindingStreams.testRead("VARS ?a ?b . - 2 . 1 - . ", b02, b10);
    }

    @Test
    public void bindingStream_04() {
        TestBindingStreams.testRead("VARS ?a . 1 . VARS ?b . 2 . ", b10, b02);
    }

    @Test(expected=RiotException.class)
    public void bindingStream_05() {
        TestBindingStreams.testRead("VARS ?a ?b . 99 . ", new Binding[0]);
    }

    @Test(expected=RiotException.class)
    public void bindingStream_06() {
        TestBindingStreams.testRead("VARS ?a ?b . 99 11 22 . ", new Binding[0]);
    }

    @Test
    public void bindingStream_10() {
        TestBindingStreams.testRead("VARS ?a ?b . 1 2 . * 9 .", b12, b19);
    }

    @Test
    public void bindingStream_11() {
        TestBindingStreams.testRead("VARS ?a ?b ?c . 1 2 - . * 9 - .", b12, b19);
    }

    @Test
    public void bindingStream_12() {
        BindingBuilder builder = Binding.builder();
        builder.add(Var.alloc((String)"a"), NodeConst.nodeTrue);
        builder.add(Var.alloc((String)"c"), NodeConst.nodeFalse);
        Binding b = builder.build();
        TestBindingStreams.testRead("VARS ?a ?b ?c . true - false . ", b);
    }

    @Test
    public void bindingStream_20() {
        TestBindingStreams.testRead("PREFIX : <http://example/> . VARS ?x .\n:abc  .\n- .", x10, b0);
    }

    @Test
    public void bindingStream_50() {
        TestBindingStreams.testWriteRead(b12);
    }

    @Test
    public void bindingStream_51() {
        TestBindingStreams.testWriteRead(b0);
    }

    @Test
    public void bindingStream_52() {
        TestBindingStreams.testWriteRead(pmap, b12, x10, b19);
    }

    @Test
    public void bindingStream_60() {
        TestBindingStreams.testWriteRead(bb1);
    }

    @Test
    public void bindingStream_61() {
        Node bn = NodeFactory.createBlankNode((String)"unusual");
        Binding b = BindingFactory.binding((Var)Var.alloc((String)"v"), (Node)bn);
        TestBindingStreams.testWriteRead(b);
    }

    @Test
    public void bindingStream_62() {
        TestBindingStreams.testWriteRead(bb2);
    }

    @Test
    public void bindingStream_63() {
        TestBindingStreams.testWriteRead(bb3);
    }

    static void testRead(String x, Binding ... bindings) {
        Tokenizer t = TokenizerText.create().fromString(x).build();
        BindingInputStream inStream = new BindingInputStream(t);
        if (bindings.length == 0) {
            while (inStream.hasNext()) {
                inStream.next();
            }
            return;
        }
        int i = 0;
        while (inStream.hasNext()) {
            Binding b = inStream.next();
            Assert.assertTrue((String)("Bindings do not match: expected=" + bindings[i] + " got=" + b), (boolean)TestBindingStreams.equalBindings(bindings[i], b));
            ++i;
        }
        Assert.assertEquals((String)("Wrong length: expect= " + bindings.length + " got=" + i), (long)bindings.length, (long)i);
    }

    static void testWriteRead(Binding ... bindings) {
        TestBindingStreams.testWriteRead(null, bindings);
    }

    static void testWriteRead(PrefixMap prefixMap, Binding ... bindings) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BindingOutputStream output = new BindingOutputStream((OutputStream)out, prefixMap);
        for (Binding b : bindings) {
            output.write(b);
        }
        output.flush();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        BindingInputStream input = new BindingInputStream((InputStream)in);
        ArrayList<Binding> results = new ArrayList<Binding>();
        while (input.hasNext()) {
            results.add(input.next());
        }
        Assert.assertEquals((long)bindings.length, (long)results.size());
        for (int i = 0; i < bindings.length; ++i) {
            Binding b1 = bindings[i];
            Binding b2 = (Binding)results.get(i);
            Assert.assertTrue((String)("Bindings do not match: expected=" + b1 + " got=" + b2), (boolean)TestBindingStreams.equalBindings(b1, b2));
        }
    }

    private static boolean equalBindings(Binding binding1, Binding binding2) {
        return ResultSetCompare.equal((Binding)binding1, (Binding)binding2, (EqualityTest)NodeUtils.sameNode);
    }

    private static Binding build(String string) {
        Item item = SSE.parse((String)("(binding " + string + ")"));
        return BuilderBinding.build((Item)item);
    }

    static {
        pmap.add(":", "http://example/");
        x10 = TestBindingStreams.build("(?x <http://example/abc>)");
    }
}

