/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractTestDistinctReduced {
    static List<String> data1 = Arrays.asList("0", "1", "1", "3", "9", "5", "6", "8", "9", "0");
    static List<String> results1 = Arrays.asList("0", "1", "3", "9", "5", "6", "8");
    static List<String> data2 = Arrays.asList("0", "0", "0", "0");
    static List<String> results2 = Arrays.asList("0", "0", "0", "0");
    static Var var_a = Var.alloc((String)"a");
    static Var var_b = Var.alloc((String)"b");

    private static List<Binding> build(List<String> items) {
        return ((Stream)items.stream().sequential()).map(s -> BindingFactory.binding((Var)var_a, (Node)NodeFactory.createLiteral((String)s))).collect(Collectors.toList());
    }

    protected abstract QueryIterator createQueryIter(List<Binding> var1);

    @Test
    public void distinct0() {
        this.distinct(new ArrayList<String>(), new ArrayList<String>());
    }

    @Test
    public void distinct1() {
        List<String> data = Arrays.asList("0", "1", "1", "3", "9", "5", "6", "8", "9", "0");
        List<String> results = Arrays.asList("0", "1", "3", "9", "5", "6", "8");
        this.distinct(data, results);
    }

    @Test
    public void distinct2() {
        List<String> data = Arrays.asList("0", "0", "0", "0");
        List<String> results = Arrays.asList("0");
        this.distinct(data, results);
    }

    @Test
    public void distinct3() {
        List<String> data = Arrays.asList("0", "1", "1", "A", "2", "2", "2", "B", "2", "3", "3", "C", "4", "4", "5");
        List<String> results = Arrays.asList("0", "1", "A", "2", "B", "3", "C", "4", "5");
        this.distinct(data, results);
    }

    private void distinct(List<String> data, List<String> results) {
        List<Binding> input = AbstractTestDistinctReduced.build(data);
        List<Binding> output = AbstractTestDistinctReduced.build(results);
        QueryIterator qIter = this.createQueryIter(input);
        List iterList = Iter.toList((Iterator)qIter);
        Assert.assertEquals((String)(output + " :: " + iterList), (long)output.size(), (long)iterList.size());
        HashSet<Binding> testExpected = new HashSet<Binding>(output);
        HashSet testResult = new HashSet(iterList);
        Assert.assertEquals(testExpected, testResult);
    }

    private void testSame(QueryIterator qIter, List<Binding> data) {
        List iterList = Iter.toList((Iterator)qIter);
        Assert.assertEquals(data, (Object)iterList);
    }
}

