/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import org.apache.jena.query.QueryParseException;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.LibTestExpr;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.XSDFuncOp;
import org.apache.jena.sparql.util.ExprUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestExpressions2 {
    @Test
    public void gregorian_eq_01() {
        TestExpressions2.eval("'1999'^^xsd:gYear = '1999'^^xsd:gYear", true);
    }

    @Test
    public void gregorian_eq_02() {
        TestExpressions2.eval("'1999'^^xsd:gYear != '1999'^^xsd:gYear", false);
    }

    @Test(expected=ExprEvalException.class)
    public void gregorian_eq_03() {
        TestExpressions2.eval("'1999'^^xsd:gYear = '1999Z'^^xsd:gYear");
    }

    @Test
    public void gregorian_eq_04() {
        TestExpressions2.eval("'1999'^^xsd:gYear = '2001Z'^^xsd:gYear", false);
    }

    @Test
    public void gregorian_eq_05() {
        TestExpressions2.eval("'1999-01'^^xsd:gYearMonth != '2001Z'^^xsd:gYear", true);
    }

    @Test
    public void gregorian_eq_06() {
        TestExpressions2.eval("'--01'^^xsd:gMonth != '--01-25'^^xsd:gMonthDay", true);
    }

    @Test
    public void gregorian_eq_07() {
        TestExpressions2.eval("'---25'^^xsd:gDay = '---25'^^xsd:gDay", true);
    }

    @Test
    public void gregorian_eq_08() {
        TestExpressions2.eval("'1999-01'^^xsd:gYearMonth != '2001Z'^^xsd:gYear", true);
    }

    @Test
    public void gregorian_eq_09() {
        TestExpressions2.eval("'1999-01'^^xsd:gYearMonth != '2001Z'^^xsd:gYear", true);
    }

    @Test
    public void gregorian_cmp_01() {
        TestExpressions2.eval("'1999'^^xsd:gYear < '2001'^^xsd:gYear", true);
    }

    @Test
    public void gregorian_cmp_02() {
        TestExpressions2.eval("'1999'^^xsd:gYear > '2001'^^xsd:gYear", false);
    }

    @Test
    public void gregorian_cmp_03() {
        TestExpressions2.eval("'1999'^^xsd:gYear < '2001+01:00'^^xsd:gYear", true);
    }

    @Test(expected=ExprEvalException.class)
    public void gregorian_cmp_04() {
        TestExpressions2.eval("'1999'^^xsd:gYear < '1999+05:00'^^xsd:gYear");
    }

    public void gregorian_cast_01() {
        TestExpressions2.eval("xsd:gYear('2010-03-22'^^xsd:date) = '2010'^^xsd:gYear", true);
    }

    @Test(expected=ExprEvalException.class)
    public void coalesce_01() {
        TestExpressions2.eval("COALESCE()");
    }

    @Test
    public void coalesce_02() {
        TestExpressions2.eval("COALESCE(1) = 1", true);
    }

    @Test
    public void coalesce_03() {
        TestExpressions2.eval("COALESCE(?x,1) = 1", true);
    }

    @Test
    public void coalesce_04() {
        TestExpressions2.eval("COALESCE(9,1) = 9", true);
    }

    @Test
    public void if_01() {
        TestExpressions2.eval("IF(1+2=3, 'yes', 'no') = 'yes'", true);
    }

    @Test
    public void if_02() {
        TestExpressions2.eval("IF(1+2=4, 'yes', 'no') = 'no'", true);
    }

    @Test
    public void if_03() {
        TestExpressions2.eval("IF(true, 'yes', 1/0) = 'yes'", true);
    }

    @Test(expected=ExprEvalException.class)
    public void if_04() {
        TestExpressions2.eval("IF(true, 1/0, 'no') = 'no'");
    }

    @Test
    public void in_01() {
        TestExpressions2.eval("1 IN(1,2,3)", true);
    }

    @Test
    public void in_02() {
        TestExpressions2.eval("1 IN(<x>,2,1)", true);
    }

    @Test
    public void in_03() {
        TestExpressions2.eval("1 IN()", false);
    }

    @Test
    public void in_04() {
        TestExpressions2.eval("1 IN(7)", false);
    }

    @Test
    public void not_in_01() {
        TestExpressions2.eval("1 NOT IN(1,2,3)", false);
    }

    @Test
    public void not_in_02() {
        TestExpressions2.eval("1 NOT IN(<x>,2,1)", false);
    }

    @Test
    public void not_in_03() {
        TestExpressions2.eval("1 NOT IN()", true);
    }

    @Test
    public void not_in_04() {
        TestExpressions2.eval("1 NOT IN(7)", true);
    }

    @Test
    public void term_constructor_iri_01() {
        TestExpressions2.eval("IRI('http://example/') = <http://example/>", true);
    }

    @Test(expected=ExprEvalException.class)
    public void term_constructor_iri_02() {
        TestExpressions2.eval("IRI(123)");
    }

    @Test
    public void term_constructor_iri_03() {
        TestExpressions2.eval("IRI(<http://example/>) = <http://example/>", true);
    }

    @Test
    public void term_constructor_iri_04() {
        TestExpressions2.eval("isIRI(IRI(BNODE()))", true);
    }

    @Test
    public void term_constructor_iri_05() {
        TestExpressions2.eval("regex(str(IRI(BNODE())), '^_:' )", true);
    }

    @Test
    public void term_constructor_iri_06() {
        TestExpressions2.eval("isIRI(IRI(str(IRI(BNODE()))))", true);
    }

    @Test
    public void term_constructor_bnode_01() {
        TestExpressions2.eval("isBlank(BNODE())", true);
    }

    @Test
    public void term_constructor_bnode_02() {
        TestExpressions2.eval("isBlank(BNODE('abc'))", true);
    }

    @Test
    public void term_constructor_bnode_03() {
        TestExpressions2.eval("isBlank(BNODE('abc'))", true);
    }

    @Test
    public void term_constructor_bnode_04() {
        TestExpressions2.eval("BNODE('abc') = BNODE('abc')", true);
    }

    @Test
    public void term_constructor_bnode_05() {
        TestExpressions2.eval("BNODE('abc') = BNODE('def')", false);
    }

    @Test
    public void term_constructor_strdt_01() {
        TestExpressions2.eval("STRDT('123',xsd:integer) = 123", true);
    }

    @Test
    public void term_constructor_strdt_02() {
        TestExpressions2.eval("STRDT('123',<http://example/DT>) = '123'^^<http://example/DT>", true);
    }

    @Test(expected=ExprEvalException.class)
    public void term_constructor_strdt_03() {
        TestExpressions2.eval("STRDT('123','abc') = '123'");
    }

    @Test(expected=ExprEvalException.class)
    public void term_constructor_strdt_04() {
        TestExpressions2.eval("STRDT('123'^^xsd:integer,<http://example/DT>) = '123'^^<http://example/DT>");
    }

    @Test
    public void term_constructor_strlang_01() {
        TestExpressions2.eval("STRLANG('abc', 'en') = 'abc'@en", true);
    }

    @Test(expected=ExprEvalException.class)
    public void term_constructor_strlang_02() {
        TestExpressions2.eval("STRLANG(<http://example/>, 'en') = 'abc'@en");
    }

    @Test(expected=ExprEvalException.class)
    public void term_constructor_strlang_03() {
        TestExpressions2.eval("STRLANG('abc'@en, 'en') = 'abc'@en");
    }

    @Test
    public void triple_term_cmp_01() {
        TestExpressions2.eval("<<<ex:s> <ex:p> <ex:p>>> = <<<ex:s> <ex:p> <ex:p>>>");
    }

    @Test
    public void triple_term_cmp_02() {
        TestExpressions2.eval("<<<ex:s> <ex:p> <ex:o1>>> != <<<ex:s> <ex:p> <ex:o2>>>");
    }

    @Test
    public void triple_term_cmp_03() {
        TestExpressions2.eval("<<<ex:s> <ex:p> 1>> < <<<ex:s> <ex:p> 2>>");
    }

    @Test(expected=ExprEvalException.class)
    public void triple_term_cmp_04() {
        TestExpressions2.eval("<<<ex:s> <ex:p1> 2>> < <<<ex:s> <ex:p2> 2>>");
    }

    @Test
    public void xsd_cast_01() {
        TestExpressions2.eval("xsd:integer('1') = 1", true);
    }

    @Test
    public void xsd_cast_02() {
        TestExpressions2.eval("xsd:boolean('1') = true", true);
    }

    @Test
    public void xsd_cast_03() {
        TestExpressions2.eval("sameTerm(xsd:double('1.0e0'),1.0e0)", true);
    }

    @Test
    public void xsd_cast_04() {
        TestExpressions2.eval("xsd:double('1') = 1", true);
    }

    @Test(expected=ExprEvalException.class)
    public void xsd_cast_10() {
        TestExpressions2.eval("xsd:integer(' 1')");
    }

    @Test(expected=ExprEvalException.class)
    public void xsd_cast_11() {
        TestExpressions2.eval("xsd:boolean(' 1')");
    }

    @Test(expected=ExprEvalException.class)
    public void xsd_cast_12() {
        TestExpressions2.eval("xsd:double(' 1.0e0')");
    }

    @Test(expected=ExprEvalException.class)
    public void xsd_cast_13() {
        TestExpressions2.eval("xsd:double(' 1.0e0')");
    }

    @Test(expected=QueryParseException.class)
    public void dynamic_call_01() {
        TestExpressions2.eval("CALL()", false);
    }

    @Test
    public void dynamic_call_02() {
        TestExpressions2.eval("CALL(xsd:double, '1') = 1");
    }

    @Test
    public void dynamic_call_03() {
        TestExpressions2.eval("CALL(fn:concat, 'A', 2+3 ) = 'A5'");
    }

    @Test(expected=ExprEvalException.class)
    public void dynamic_call_10() {
        TestExpressions2.eval("CALL(xsd:double)");
    }

    @Test(expected=ExprEvalException.class)
    public void dynamic_call_11() {
        TestExpressions2.eval("CALL(xsd:noSuchFunc)");
    }

    static void eval(String string) {
        TestExpressions2.eval(string, true);
    }

    static void eval(String string, boolean result) {
        Expr expr = ExprUtils.parse((String)string);
        NodeValue nv = expr.eval(null, LibTestExpr.createTest());
        boolean b = XSDFuncOp.booleanEffectiveValue((NodeValue)nv);
        Assert.assertEquals((String)string, (Object)result, (Object)b);
    }
}

