/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.util.NodeUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestOrdering {
    NodeValue nvInt2 = NodeValue.makeNodeInteger((long)2L);
    NodeValue nvInt3 = NodeValue.makeNodeInteger((String)"3");
    NodeValue nvInt03 = NodeValue.makeNodeInteger((String)"03");
    NodeValue nvStr3 = NodeValue.makeNodeString((String)"3");
    NodeValue nvStr03 = NodeValue.makeNodeString((String)"03");
    NodeValue nvInt9 = NodeValue.makeNodeInteger((long)9L);
    NodeValue nvPosInt9 = NodeValue.makeNode((String)"9", (RDFDatatype)XSDDatatype.XSDpositiveInteger);
    NodeValue nvInt10 = NodeValue.makeNodeInteger((long)10L);
    NodeValue nvDouble9 = NodeValue.makeNodeDouble((double)9.0);
    NodeValue nvFloat8 = NodeValue.makeNode((String)"8.0", (RDFDatatype)XSDDatatype.XSDfloat);
    NodeValue nvByte10 = NodeValue.makeNode((String)"10", (RDFDatatype)XSDDatatype.XSDbyte);
    Node nInt2 = this.nvInt2.getNode();
    Node nInt3 = this.nvInt3.getNode();
    Node nInt03 = this.nvInt03.getNode();
    Node nStr3 = this.nvStr3.getNode();
    Node nStr03 = this.nvStr03.getNode();
    Node nInt9 = this.nvInt9.getNode();
    Node nPosInt9 = this.nvPosInt9.getNode();
    Node nInt10 = this.nvInt10.getNode();
    Node nDouble9 = this.nvDouble9.getNode();
    Node nFloat8 = this.nvFloat8.getNode();
    Node nByte10 = this.nvByte10.getNode();

    @Test
    public void testComp_2_3() {
        int x = NodeValue.compareAlways((NodeValue)this.nvInt2, (NodeValue)this.nvInt3);
        Assert.assertTrue((String)"2 should be value-less than 3", (-1 == x ? 1 : 0) != 0);
        int y = NodeUtils.compareRDFTerms((Node)this.nInt2, (Node)this.nInt3);
        Assert.assertTrue((String)"2 should be strict-less than 3", (-1 == y ? 1 : 0) != 0);
    }

    @Test
    public void testComp_3_str3() {
        int x = NodeValue.compareAlways((NodeValue)this.nvInt3, (NodeValue)this.nvStr3);
        int y = NodeUtils.compareRDFTerms((Node)this.nInt3, (Node)this.nStr3);
        Assert.assertTrue((String)"3 should be compareAlways greater than \"3\"", (1 == x ? 1 : 0) != 0);
        Assert.assertTrue((String)"3 should be syntactic-greater than to \"3\"", (1 == y ? 1 : 0) != 0);
    }

    @Test
    public void testComp_03_str3() {
        int x = NodeValue.compareAlways((NodeValue)this.nvInt03, (NodeValue)this.nvStr3);
        int y = NodeUtils.compareRDFTerms((Node)this.nInt03, (Node)this.nStr3);
        Assert.assertTrue((String)"03 (typed) should be compareAlways 'less than' than \"3\"", (-1 == x ? 1 : 0) != 0);
        Assert.assertTrue((String)"03 should be syntactic-less than to \"3\"", (-1 == y ? 1 : 0) != 0);
    }

    @Test
    public void testComp_int_double_1() {
        int x = NodeValue.compareAlways((NodeValue)this.nvInt10, (NodeValue)this.nvDouble9);
        int y = NodeUtils.compareRDFTerms((Node)this.nInt10, (Node)this.nDouble9);
        Assert.assertTrue((String)"Int 10 less than double 9", (1 == x ? 1 : 0) != 0);
        Assert.assertTrue((String)"Int 10 less than double 9 in syntactic compare", (-1 == y ? 1 : 0) != 0);
    }

    @Test
    public void testComp_byte_double_1() {
        int x = NodeValue.compareAlways((NodeValue)this.nvByte10, (NodeValue)this.nvDouble9);
        int y = NodeUtils.compareRDFTerms((Node)this.nByte10, (Node)this.nDouble9);
        Assert.assertTrue((String)"Byte 10 less than double 9", (1 == x ? 1 : 0) != 0);
        Assert.assertTrue((String)"Byte 10 greater than double 9 in non-value compare (dataype URIs compare)", (-1 == y ? 1 : 0) != 0);
    }

    @Test
    public void testComp_int_float_1() {
        int x = NodeValue.compareAlways((NodeValue)this.nvInt10, (NodeValue)this.nvFloat8);
        int y = NodeUtils.compareRDFTerms((Node)this.nInt10, (Node)this.nFloat8);
        Assert.assertTrue((String)"Int 10 less than float 8", (1 == x ? 1 : 0) != 0);
        Assert.assertTrue((String)"Int 10 less than float 8 in syntatic compare", (-1 == y ? 1 : 0) != 0);
    }

    @Test
    public void testComp_int_posint_1() {
        int x = NodeValue.compareAlways((NodeValue)this.nvInt9, (NodeValue)this.nvPosInt9);
        Assert.assertTrue((String)"Int 9 should be not equals to positive integer 9", (0 != x ? 1 : 0) != 0);
    }

    @Test
    public void testComp_int_posint_2() {
        int x = NodeValue.compareAlways((NodeValue)this.nvInt10, (NodeValue)this.nvPosInt9);
        Assert.assertTrue((String)"Int 10 not greater than positive integer 9", (1 == x ? 1 : 0) != 0);
    }

    @Test
    public void test_xsd_string1() {
        NodeValue nv2;
        NodeValue nv1 = NodeValue.makeNode((Node)NodeFactory.createLiteral((String)"abc"));
        int x = NodeValue.compare((NodeValue)nv1, (NodeValue)(nv2 = NodeValue.makeNode((Node)NodeFactory.createLiteral((String)"abc", (RDFDatatype)XSDDatatype.XSDstring))));
        Assert.assertTrue((0 == x ? 1 : 0) != 0);
    }

    @Test
    public void test_xsd_string2() {
        NodeValue nv2;
        NodeValue nv1 = NodeValue.makeNode((Node)NodeFactory.createLiteral((String)"xyz"));
        int x = NodeValue.compare((NodeValue)nv1, (NodeValue)(nv2 = NodeValue.makeNode((Node)NodeFactory.createLiteral((String)"abc", (RDFDatatype)XSDDatatype.XSDstring))));
        Assert.assertTrue((1 == x ? 1 : 0) != 0);
    }

    @Test
    public void test_xsd_string3() {
        NodeValue nv2;
        NodeValue nv1 = NodeValue.makeNode((Node)NodeFactory.createLiteral((String)"xyz", (RDFDatatype)XSDDatatype.XSDstring));
        int x = NodeValue.compare((NodeValue)nv1, (NodeValue)(nv2 = NodeValue.makeNode((Node)NodeFactory.createLiteral((String)"abc"))));
        Assert.assertTrue((1 == x ? 1 : 0) != 0);
    }

    @Test
    public void test_xsd_string4() {
        NodeValue nv2;
        NodeValue nv1 = NodeValue.makeNode((Node)NodeFactory.createLiteral((String)"abc"));
        int x = NodeValue.compare((NodeValue)nv1, (NodeValue)(nv2 = NodeValue.makeNode((Node)NodeFactory.createLiteral((String)"xyz", (RDFDatatype)XSDDatatype.XSDstring))));
        Assert.assertTrue((-1 == x ? 1 : 0) != 0);
    }

    @Test
    public void test_xsd_string5() {
        NodeValue nv2;
        NodeValue nv1 = NodeValue.makeNode((Node)NodeFactory.createLiteral((String)"abc", (RDFDatatype)XSDDatatype.XSDstring));
        int x = NodeValue.compare((NodeValue)nv1, (NodeValue)(nv2 = NodeValue.makeNode((Node)NodeFactory.createLiteral((String)"xyz"))));
        Assert.assertTrue((-1 == x ? 1 : 0) != 0);
    }

    @Test
    public void test_lang1() {
        NodeValue nv1 = NodeValue.makeNode((Node)NodeFactory.createLiteral((String)"abc", (String)"en"));
        NodeValue nv2 = NodeValue.makeNode((Node)NodeFactory.createLiteral((String)"abc"));
        int x = NodeUtils.compareRDFTerms((Node)nv1.asNode(), (Node)nv2.asNode());
        Assert.assertTrue((String)"Lang tags should sort after plain literal", (1 == x ? 1 : 0) != 0);
    }

    @Test
    public void test_lang2() {
        NodeValue nv1 = NodeValue.makeNode((Node)NodeFactory.createLiteral((String)"abc", (String)"en"));
        NodeValue nv2 = NodeValue.makeNode((Node)NodeFactory.createLiteral((String)"abc", (String)"EN"));
        int x = NodeUtils.compareRDFTerms((Node)nv1.asNode(), (Node)nv2.asNode());
        Assert.assertTrue((String)"Lang tags should sort by case", (1 == x ? 1 : 0) != 0);
    }

    @Test
    public void test_lang3() {
        NodeValue nv2;
        NodeValue nv1 = NodeValue.makeNode((Node)NodeFactory.createLiteral((String)"ABC", (String)"en"));
        int x = NodeValue.compareAlways((NodeValue)nv1, (NodeValue)(nv2 = NodeValue.makeNode((Node)NodeFactory.createLiteral((String)"abc", (String)"EN"))));
        Assert.assertTrue((String)"Lang nodes should sort by lexical if tags value-same", (-1 == x ? 1 : 0) != 0);
        int y = NodeUtils.compareRDFTerms((Node)nv1.asNode(), (Node)nv2.asNode());
        Assert.assertTrue((String)"Lang nodes should sort by case (syntactically)", (-1 == y ? 1 : 0) != 0);
    }

    @Test
    public void test_lang4() {
        NodeValue nv2;
        NodeValue nv1 = NodeValue.makeNode((Node)NodeFactory.createLiteral((String)"ABC", (String)"en"));
        int x = NodeValue.compareAlways((NodeValue)nv1, (NodeValue)(nv2 = NodeValue.makeNode((Node)NodeFactory.createLiteral((String)"abc", (String)"en"))));
        Assert.assertTrue((String)"Lang nodes should sort by lexical if tags the same", (-1 == x ? 1 : 0) != 0);
        int y = NodeUtils.compareRDFTerms((Node)nv1.asNode(), (Node)nv2.asNode());
        Assert.assertTrue((String)"Lang nodes should sort by lexical form if lang tags the same", (-1 == x ? 1 : 0) != 0);
    }

    @Test
    public void test_lang5() {
        NodeValue nv2;
        NodeValue nv1 = NodeValue.makeNode((Node)NodeFactory.createLiteral((String)"abc"));
        int x = NodeValue.compareAlways((NodeValue)nv1, (NodeValue)(nv2 = NodeValue.makeNode((Node)NodeFactory.createLiteral((String)"xyz", (String)"en"))));
        Assert.assertTrue((String)"Lang nodes should sort by lexical form if one is plain", (-1 == x ? 1 : 0) != 0);
        int y = NodeUtils.compareRDFTerms((Node)nv1.asNode(), (Node)nv2.asNode());
        Assert.assertTrue((-1 == x ? 1 : 0) != 0);
    }

    @Test
    public void test_lang6() {
        NodeValue nv2;
        NodeValue nv1 = NodeValue.makeNode((Node)NodeFactory.createLiteral((String)"xyz"));
        int x = NodeValue.compareAlways((NodeValue)nv1, (NodeValue)(nv2 = NodeValue.makeNode((Node)NodeFactory.createLiteral((String)"abc", (String)"en"))));
        Assert.assertTrue((String)"Lang nodes should sort by lexical form if one is plain", (1 == x ? 1 : 0) != 0);
        int y = NodeUtils.compareRDFTerms((Node)nv1.asNode(), (Node)nv2.asNode());
        Assert.assertTrue((1 == x ? 1 : 0) != 0);
    }

    @Test
    public void test_lang7() {
        NodeValue nv2;
        NodeValue nv1 = NodeValue.makeNode((Node)NodeFactory.createLiteral((String)"abc", (RDFDatatype)XSDDatatype.XSDstring));
        int x = NodeValue.compareAlways((NodeValue)nv1, (NodeValue)(nv2 = NodeValue.makeNode((Node)NodeFactory.createLiteral((String)"xyz", (String)"en"))));
        Assert.assertTrue((String)"Lang nodes should sort by lexical form if other is XSD string", (-1 == x ? 1 : 0) != 0);
        int y = NodeUtils.compareRDFTerms((Node)nv1.asNode(), (Node)nv2.asNode());
        Assert.assertTrue((-1 == x ? 1 : 0) != 0);
    }

    @Test
    public void test_lang8() {
        NodeValue nv2;
        NodeValue nv1 = NodeValue.makeNode((Node)NodeFactory.createLiteral((String)"xyz", (RDFDatatype)XSDDatatype.XSDstring));
        int x = NodeValue.compareAlways((NodeValue)nv1, (NodeValue)(nv2 = NodeValue.makeNode((Node)NodeFactory.createLiteral((String)"abc", (String)"en"))));
        Assert.assertTrue((String)"Lang nodes should sort by lexical form if other is XSD string", (1 == x ? 1 : 0) != 0);
        int y = NodeUtils.compareRDFTerms((Node)nv1.asNode(), (Node)nv2.asNode());
        Assert.assertTrue((1 == x ? 1 : 0) != 0);
    }

    @Test
    public void test_variable1() {
        Node y;
        Node x = NodeFactory.createVariable((String)"x");
        int res = NodeUtils.compareRDFTerms((Node)x, (Node)(y = NodeFactory.createVariable((String)"x")));
        Assert.assertTrue((String)"Variable nodes should sort by variable names", (0 == res ? 1 : 0) != 0);
    }

    @Test
    public void test_variable2() {
        Node y;
        Node x = NodeFactory.createVariable((String)"x");
        int res = NodeUtils.compareRDFTerms((Node)x, (Node)(y = NodeFactory.createVariable((String)"y")));
        Assert.assertTrue((String)"Variable nodes should sort by variable names", (-1 == res ? 1 : 0) != 0);
        res = NodeUtils.compareRDFTerms((Node)y, (Node)x);
        Assert.assertTrue((String)"Variable nodes should sort by variable names", (1 == res ? 1 : 0) != 0);
    }

    @Test
    public void test_variable3() {
        Node y;
        Node x = NodeFactory.createVariable((String)"x");
        int res = NodeUtils.compareRDFTerms((Node)x, (Node)(y = NodeFactory.createBlankNode()));
        Assert.assertTrue((String)"Variable nodes should be less than blank nodes", (-1 == res ? 1 : 0) != 0);
        res = NodeUtils.compareRDFTerms((Node)y, (Node)x);
        Assert.assertTrue((String)"Variable nodes should be less than blank nodes", (1 == res ? 1 : 0) != 0);
    }

    @Test
    public void test_variable4() {
        Node y;
        Node x = NodeFactory.createVariable((String)"x");
        int res = NodeUtils.compareRDFTerms((Node)x, (Node)(y = NodeFactory.createURI((String)"http://uri")));
        Assert.assertTrue((String)"Variable nodes should be less than URI nodes", (-1 == res ? 1 : 0) != 0);
        res = NodeUtils.compareRDFTerms((Node)y, (Node)x);
        Assert.assertTrue((String)"Variable nodes should be less than URI nodes", (1 == res ? 1 : 0) != 0);
    }

    @Test
    public void test_variable5() {
        Node y;
        Node x = NodeFactory.createVariable((String)"x");
        int res = NodeUtils.compareRDFTerms((Node)x, (Node)(y = NodeFactory.createLiteral((String)"test")));
        Assert.assertTrue((String)"Variable nodes should be less than literal nodes", (-1 == res ? 1 : 0) != 0);
        res = NodeUtils.compareRDFTerms((Node)y, (Node)x);
        Assert.assertTrue((String)"Variable nodes should be less than literal nodes", (1 == res ? 1 : 0) != 0);
    }

    @Test
    public void test_nodeTriple_1() {
        Node y;
        Node x = SSE.parseNode((String)"<<:s :p 1>>");
        int res = NodeUtils.compareRDFTerms((Node)x, (Node)(y = SSE.parseNode((String)"<<:s :p 2>>")));
        Assert.assertTrue((-1 == res ? 1 : 0) != 0);
        res = NodeUtils.compareRDFTerms((Node)y, (Node)x);
        Assert.assertTrue((1 == res ? 1 : 0) != 0);
    }

    @Test
    public void test_nodeTriple_2() {
        Node y;
        Node x = SSE.parseNode((String)"<<:s2 :p 1>>");
        int res = NodeUtils.compareRDFTerms((Node)x, (Node)(y = SSE.parseNode((String)"<<:s1 :p 2>>")));
        Assert.assertTrue((1 == res ? 1 : 0) != 0);
        res = NodeUtils.compareRDFTerms((Node)y, (Node)x);
        Assert.assertTrue((-1 == res ? 1 : 0) != 0);
    }

    @Test
    public void test_nodeTriple_3() {
        Node y;
        Node x = SSE.parseNode((String)"<<:s :p 2>>");
        int res = NodeUtils.compareRDFTerms((Node)x, (Node)(y = SSE.parseNode((String)"<<:s :p 2>>")));
        Assert.assertTrue((0 == res ? 1 : 0) != 0);
    }

    @Test
    public void test_nodeTriple_4() {
        Node y;
        Node x = SSE.parseNode((String)"'abc'");
        int res = NodeUtils.compareRDFTerms((Node)x, (Node)(y = SSE.parseNode((String)"<<:s :p 2>>")));
        Assert.assertTrue((-1 == res ? 1 : 0) != 0);
        res = NodeUtils.compareRDFTerms((Node)y, (Node)x);
        Assert.assertTrue((1 == res ? 1 : 0) != 0);
    }

    @Test
    public void test_nodeTriple_5() {
        Node y;
        Node x = SSE.parseNode((String)"<uri>");
        int res = NodeUtils.compareRDFTerms((Node)x, (Node)(y = SSE.parseNode((String)"<<:s :p 2>>")));
        Assert.assertTrue((-1 == res ? 1 : 0) != 0);
        res = NodeUtils.compareRDFTerms((Node)y, (Node)x);
        Assert.assertTrue((1 == res ? 1 : 0) != 0);
    }
}

