/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.aggregate.AggregateRegistry;
import org.apache.jena.sparql.expr.aggregate.lib.StandardAggregates;
import org.apache.jena.sparql.sse.SSE;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestStatisticsAggregates {
    static String NL = "\n";
    static String PRE = StrUtils.strjoinNL((String[])new String[]{"PREFIX agg:     <http://jena.apache.org/ARQ/function/aggregate#>"});
    static DatasetGraph ds = SSE.parseDatasetGraph((String)"(dataset (graph (:x :p1 -1) (:x :p2 2) (:x :p3 3) (:x :p4 3) ))");
    static DatasetGraph dsEmpty = SSE.parseDatasetGraph((String)"(dataset)");
    static DatasetGraph ds1 = SSE.parseDatasetGraph((String)"(dataset (graph (:x :p -1)) )");
    static double VALUEstdev_samp = 1.8929694486000912;
    static double VALUEstdev_sampd = 2.0816659994661326;
    static double VALUEstdev_pop = 1.6393596310755;
    static double VALUEstdev_popd = 1.699673171197595;
    static double VALUEvar_samp = 3.5833333333333335;
    static double VALUEvar_sampd = 4.333333333333333;
    static double VALUEvar_pop = 2.6875;
    static double VALUEvar_popd = 2.888888888888889;

    @BeforeClass
    public static void setupClass() {
        StandardAggregates.register();
    }

    @Test
    public void agg_stat_stdev_uri() {
        TestStatisticsAggregates.test("agg:stdev(?x)", VALUEstdev_samp, Syntax.syntaxSPARQL_11);
    }

    @Test
    public void agg_stat_stdev_uri_distinct() {
        TestStatisticsAggregates.test("agg:stdev(DISTINCT ?x)", VALUEstdev_sampd, Syntax.syntaxSPARQL_11);
    }

    @Test
    public void agg_stat_stdev_kw() {
        TestStatisticsAggregates.test("STDEV(?x)", VALUEstdev_samp, Syntax.syntaxARQ);
    }

    @Test
    public void agg_stat_stdev_kw_distinct() {
        TestStatisticsAggregates.test("STDEV(DISTINCT ?x)", VALUEstdev_sampd, Syntax.syntaxARQ);
    }

    @Test
    public void agg_stat_stdev_agg() {
        TestStatisticsAggregates.test("AGG agg:stdev(?x)", VALUEstdev_samp, Syntax.syntaxARQ);
    }

    @Test
    public void agg_stat_stdev_agg_distinct() {
        TestStatisticsAggregates.test("AGG agg:stdev(DISTINCT ?x)", VALUEstdev_sampd, Syntax.syntaxARQ);
    }

    @Test
    public void agg_stat_stdev_samp_uri() {
        TestStatisticsAggregates.test("agg:stdev_samp(?x)", VALUEstdev_samp, Syntax.syntaxSPARQL_11);
    }

    @Test
    public void agg_stat_stdev_samp_uri_distinct() {
        TestStatisticsAggregates.test("agg:stdev_samp(DISTINCT ?x)", VALUEstdev_sampd, Syntax.syntaxSPARQL_11);
    }

    @Test
    public void agg_stat_stdev_samp_kw() {
        TestStatisticsAggregates.test("STDEV_SAMP(?x)", VALUEstdev_samp, Syntax.syntaxARQ);
    }

    @Test
    public void agg_stat_stdev_samp_kw_distinct() {
        TestStatisticsAggregates.test("STDEV_SAMP(DISTINCT ?x)", VALUEstdev_sampd, Syntax.syntaxARQ);
    }

    @Test
    public void agg_stat_stdev_samp_agg() {
        TestStatisticsAggregates.test("AGG agg:stdev_samp(?x)", VALUEstdev_samp, Syntax.syntaxARQ);
    }

    @Test
    public void agg_stat_stdev_samp_agg_distinct() {
        TestStatisticsAggregates.test("AGG agg:stdev_samp(DISTINCT ?x)", VALUEstdev_sampd, Syntax.syntaxARQ);
    }

    @Test
    public void agg_stat_stdevp_uri() {
        TestStatisticsAggregates.test("agg:stdev_pop(?x)", VALUEstdev_pop, Syntax.syntaxSPARQL_11);
    }

    @Test
    public void agg_stat_stdev_pop_uri_distinct() {
        TestStatisticsAggregates.test("agg:stdev_pop(DISTINCT ?x)", VALUEstdev_popd, Syntax.syntaxSPARQL_11);
    }

    @Test
    public void agg_stat_stdev_pop_kw() {
        TestStatisticsAggregates.test("STDEV_POP(?x)", VALUEstdev_pop, Syntax.syntaxARQ);
    }

    @Test
    public void agg_stat_stdev_pop_kw_distinct() {
        TestStatisticsAggregates.test("STDEV_POP(DISTINCT ?x)", VALUEstdev_popd, Syntax.syntaxARQ);
    }

    @Test
    public void agg_stat_stdev_pop_agg() {
        TestStatisticsAggregates.test("AGG agg:stdev_pop(?x)", VALUEstdev_pop, Syntax.syntaxARQ);
    }

    @Test
    public void agg_stat_stdev_pop_agg_distinct() {
        TestStatisticsAggregates.test("AGG agg:stdev_pop(DISTINCT ?x)", VALUEstdev_popd, Syntax.syntaxARQ);
    }

    @Test
    public void agg_stat_var_uri() {
        TestStatisticsAggregates.test("agg:variance(?x)", VALUEvar_samp, Syntax.syntaxSPARQL_11);
    }

    @Test
    public void agg_stat_var_uri_distinct() {
        TestStatisticsAggregates.test("agg:variance(DISTINCT ?x)", VALUEvar_sampd, Syntax.syntaxSPARQL_11);
    }

    @Test
    public void agg_stat_var_kw() {
        TestStatisticsAggregates.test("VARIANCE(?x)", VALUEvar_samp, Syntax.syntaxARQ);
    }

    @Test
    public void agg_stat_var_kw_distinct() {
        TestStatisticsAggregates.test("VARIANCE(DISTINCT ?x)", VALUEvar_sampd, Syntax.syntaxARQ);
    }

    @Test
    public void agg_stat_var_agg() {
        TestStatisticsAggregates.test("AGG agg:variance(?x)", VALUEvar_samp, Syntax.syntaxARQ);
    }

    @Test
    public void agg_stat_var_agg_distinct() {
        TestStatisticsAggregates.test("AGG agg:variance(DISTINCT ?x)", VALUEvar_sampd, Syntax.syntaxARQ);
    }

    @Test
    public void agg_stat_var_samp_uri() {
        TestStatisticsAggregates.test("agg:var_samp(?x)", VALUEvar_samp, Syntax.syntaxSPARQL_11);
    }

    @Test
    public void agg_stat_var_samp_uri_distinct() {
        TestStatisticsAggregates.test("agg:var_samp(DISTINCT ?x)", VALUEvar_sampd, Syntax.syntaxSPARQL_11);
    }

    @Test
    public void agg_stat_var_samp_kw() {
        TestStatisticsAggregates.test("VAR_SAMP(?x)", VALUEvar_samp, Syntax.syntaxARQ);
    }

    @Test
    public void agg_stat_var_samp_kw_distinct() {
        TestStatisticsAggregates.test("VAR_SAMP(DISTINCT ?x)", VALUEvar_sampd, Syntax.syntaxARQ);
    }

    @Test
    public void agg_stat_var_samp_agg() {
        TestStatisticsAggregates.test("AGG agg:var_samp(?x)", VALUEvar_samp, Syntax.syntaxARQ);
    }

    @Test
    public void agg_stat_var_samp_agg_distinct() {
        TestStatisticsAggregates.test("AGG agg:var_samp(DISTINCT ?x)", VALUEvar_sampd, Syntax.syntaxARQ);
    }

    @Test
    public void agg_stat_var_pop_uri() {
        TestStatisticsAggregates.test("agg:var_pop(?x)", VALUEvar_pop, Syntax.syntaxSPARQL_11);
    }

    @Test
    public void agg_stat_var_pop_uri_distinct() {
        TestStatisticsAggregates.test("agg:var_pop(DISTINCT ?x)", VALUEvar_popd, Syntax.syntaxSPARQL_11);
    }

    @Test
    public void agg_stat_var_pop_kw() {
        TestStatisticsAggregates.test("VAR_POP(?x)", VALUEvar_pop, Syntax.syntaxARQ);
    }

    @Test
    public void agg_stat_var_pop_kw_distinct() {
        TestStatisticsAggregates.test("VAR_POP(DISTINCT ?x)", VALUEvar_popd, Syntax.syntaxARQ);
    }

    @Test
    public void agg_stat_var_pop_agg() {
        TestStatisticsAggregates.test("AGG agg:var_pop(?x)", VALUEvar_pop, Syntax.syntaxARQ);
    }

    @Test
    public void agg_stat_var_pop_agg_distinct() {
        TestStatisticsAggregates.test("AGG agg:var_pop(DISTINCT ?x)", VALUEvar_popd, Syntax.syntaxARQ);
    }

    @Test
    public void agg_stat_stdev_full_uri() {
        TestStatisticsAggregates.test("<http://jena.apache.org/ARQ/function/aggregate#stdev>(?x)", VALUEstdev_samp, Syntax.syntaxSPARQL_11);
    }

    @Test
    public void agg_stat_registry() {
        Assert.assertTrue((boolean)AggregateRegistry.isRegistered((String)"http://jena.apache.org/ARQ/function/aggregate#stdev"));
        Assert.assertTrue((boolean)AggregateRegistry.isRegistered((String)"http://jena.apache.org/ARQ/function/aggregate#stdev_samp"));
        Assert.assertTrue((boolean)AggregateRegistry.isRegistered((String)"http://jena.apache.org/ARQ/function/aggregate#stdev_pop"));
        Assert.assertTrue((boolean)AggregateRegistry.isRegistered((String)"http://jena.apache.org/ARQ/function/aggregate#variance"));
        Assert.assertTrue((boolean)AggregateRegistry.isRegistered((String)"http://jena.apache.org/ARQ/function/aggregate#var_samp"));
        Assert.assertTrue((boolean)AggregateRegistry.isRegistered((String)"http://jena.apache.org/ARQ/function/aggregate#var_pop"));
        Assert.assertFalse((boolean)AggregateRegistry.isRegistered((String)"http://jena.apache.org/ARQ/function#e"));
    }

    @Test
    public void agg_stat_stdev_empty() {
        this.testEmpty("agg:stdev(?x)", dsEmpty, Syntax.syntaxSPARQL_11);
    }

    @Test
    public void agg_stat_stdev_samp_empty() {
        this.testEmpty("agg:stdev_samp(?x)", dsEmpty, Syntax.syntaxSPARQL_11);
    }

    @Test
    public void agg_stat_stdev_pop_empty() {
        this.testEmpty("agg:stdev_pop(?x)", dsEmpty, Syntax.syntaxSPARQL_11);
    }

    @Test
    public void agg_stat_stdev_size_one() {
        this.testErr("agg:stdev(?x)", ds1, Syntax.syntaxSPARQL_11);
    }

    @Test
    public void agg_stat_stdev_samp_size_one() {
        this.testErr("agg:stdev_samp(?x)", ds1, Syntax.syntaxSPARQL_11);
    }

    @Test
    public void agg_stat_var_size_one_1() {
        this.testErr("agg:var_samp(?x)", ds1, Syntax.syntaxSPARQL_11);
    }

    @Test
    public void agg_stat_stdev_pop_size_one() {
        Query query = TestStatisticsAggregates.buildGroupBy("agg:stdev_pop(?x)", Syntax.syntaxSPARQL_11);
        TestStatisticsAggregates.test(query, 0.0, ds1);
    }

    @Test
    public void agg_stat_var_pop_size_one() {
        Query query = TestStatisticsAggregates.buildGroupBy("agg:var_pop(?x)", Syntax.syntaxSPARQL_11);
        TestStatisticsAggregates.test(query, 0.0, ds1);
    }

    private static void test(String qsAgg, double expected, Syntax syntax) {
        TestStatisticsAggregates.test(qsAgg, expected, syntax, ds);
    }

    private static void test(String qsAgg, double expected, Syntax syntax, DatasetGraph dsg) {
        Query query = TestStatisticsAggregates.buildGroupBy(qsAgg, syntax);
        TestStatisticsAggregates.test(query, expected, dsg);
    }

    private static void test(Query query, double expected, DatasetGraph dsg) {
        try (QueryExecution qExec = QueryExecutionFactory.create((Query)query, (Dataset)DatasetFactory.wrap((DatasetGraph)dsg));){
            Literal literal = qExec.execSelect().next().getLiteral("X");
            double result = literal.getDouble();
            Assert.assertEquals((double)expected, (double)result, (double)0.001);
        }
    }

    private static Query buildGroupBy(String qsAgg, Syntax syntax) {
        String NL = "\n";
        String qs = PRE + NL + "SELECT (" + qsAgg + NL + "AS ?X) WHERE {?s ?p ?x} GROUP BY ?s";
        Query query = QueryFactory.create((String)qs, (Syntax)syntax);
        return query;
    }

    private static Query buildNoGroupBy(String qsAgg, Syntax syntax) {
        String NL = "\n";
        String qs = PRE + NL + "SELECT (" + qsAgg + NL + "AS ?X) WHERE {?s ?p ?x}";
        Query query = QueryFactory.create((String)qs, (Syntax)syntax);
        return query;
    }

    private void testErr(String qsAgg, DatasetGraph ds, Syntax syntax) {
        Query query = TestStatisticsAggregates.buildGroupBy(qsAgg, syntax);
        try (QueryExecution qExec = QueryExecutionFactory.create((Query)query, (Dataset)DatasetFactory.wrap((DatasetGraph)ds));){
            ResultSet rs = qExec.execSelect();
            Assert.assertTrue((boolean)rs.getResultVars().contains("X"));
            Binding b = rs.nextBinding();
            Assert.assertFalse((boolean)b.contains(Var.alloc((String)"X")));
        }
    }

    private void testEmpty(String qsAgg, DatasetGraph ds, Syntax syntax) {
        this.testEmptyNoGroupBy(qsAgg, ds, syntax);
        this.testEmptyGroupBy(qsAgg, ds, syntax);
    }

    private void testEmptyNoGroupBy(String qsAgg, DatasetGraph ds, Syntax syntax) {
        Query query = TestStatisticsAggregates.buildNoGroupBy(qsAgg, syntax);
        try (QueryExecution qExec = QueryExecutionFactory.create((Query)query, (Dataset)DatasetFactory.wrap((DatasetGraph)ds));){
            ResultSet rs = qExec.execSelect();
            Assert.assertTrue((boolean)rs.hasNext());
            Assert.assertTrue((boolean)rs.getResultVars().contains("X"));
            Binding b = rs.nextBinding();
            Assert.assertFalse((boolean)b.contains(Var.alloc((String)"X")));
        }
    }

    private void testEmptyGroupBy(String qsAgg, DatasetGraph ds, Syntax syntax) {
        Query query = TestStatisticsAggregates.buildGroupBy(qsAgg, syntax);
        try (QueryExecution qExec = QueryExecutionFactory.create((Query)query, (Dataset)DatasetFactory.wrap((DatasetGraph)ds));){
            ResultSet rs = qExec.execSelect();
            Assert.assertFalse((boolean)rs.hasNext());
        }
    }
}

