/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function.library;

import java.util.Date;
import java.util.TimeZone;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.LibTestExpr;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.util.ExprUtils;
import org.apache.jena.sys.JenaSystem;
import org.junit.Assert;
import org.junit.Test;

public class TestFnFunctionsDateTimeDuration {
    @Test
    public void datetime_1() {
        LibTestExpr.test("fn:dateTime('2017-09-14'^^xsd:date, '10:11:23'^^xsd:time) = '2017-09-14T10:11:23'^^xsd:dateTime");
    }

    @Test
    public void datetime_2() {
        LibTestExpr.test("fn:dateTime('2017-09-14+01:00'^^xsd:date, '10:11:23'^^xsd:time) = '2017-09-14T10:11:23+01:00'^^xsd:dateTime");
    }

    @Test
    public void datetime_3() {
        LibTestExpr.test("fn:dateTime('2017-09-14'^^xsd:date, '10:11:23+01:00'^^xsd:time) = '2017-09-14T10:11:23+01:00'^^xsd:dateTime");
    }

    @Test
    public void datetime_4() {
        LibTestExpr.test("fn:dateTime('2017-09-14+01:00'^^xsd:date, '10:11:23+01:00'^^xsd:time) = '2017-09-14T10:11:23+01:00'^^xsd:dateTime");
    }

    @Test(expected=ExprEvalException.class)
    public void datetime_5() {
        LibTestExpr.test("fn:dateTime('2017-09-14+09:00'^^xsd:date, '10:11:23+01:00'^^xsd:time) = '2017-09-14T10:11:23+01:00'^^xsd:dateTime");
    }

    @Test(expected=ExprEvalException.class)
    public void datetime_6() {
        LibTestExpr.test("fn:dateTime('xyz', '10:11:23+01:00'^^xsd:time) = '2017-09-14T10:11:23+01:00'^^xsd:dateTime");
    }

    @Test(expected=ExprEvalException.class)
    public void datetime_7() {
        LibTestExpr.test("fn:dateTime('2017-09-14+09:00', 'now'^^xsd:time) = '2017-09-14T10:11:23+01:00'^^xsd:dateTime");
    }

    @Test
    public void fromDateTime() {
        LibTestExpr.test("fn:years-from-dateTime('2017-09-14T17:01:02'^^xsd:dateTime)", "2017");
        LibTestExpr.test("fn:months-from-dateTime('2017-09-14T17:01:02'^^xsd:dateTime)", "09");
        LibTestExpr.test("fn:days-from-dateTime('2017-09-14T17:01:02'^^xsd:dateTime)", "14");
        LibTestExpr.test("fn:hours-from-dateTime('2017-09-14T17:01:02'^^xsd:dateTime)", "17");
        LibTestExpr.test("fn:minutes-from-dateTime('2017-09-14T17:01:02'^^xsd:dateTime)", "01");
        LibTestExpr.test("fn:seconds-from-dateTime('2017-09-14T17:01:02.5'^^xsd:dateTime)", "02.5");
        LibTestExpr.test("fn:timezone-from-dateTime('2017-09-14T17:01:02+01:00'^^xsd:dateTime)", "'PT1H'^^xsd:dayTimeDuration");
    }

    @Test
    public void fromDate() {
        LibTestExpr.test("fn:years-from-date('2017-09-14'^^xsd:date)", "2017");
        LibTestExpr.test("fn:months-from-date('2017-09-14'^^xsd:date)", "09");
        LibTestExpr.test("fn:days-from-date('2017-09-14'^^xsd:date)", "14");
        LibTestExpr.test("fn:timezone-from-date('2017-09-14+01:00'^^xsd:date)", "'PT1H'^^xsd:dayTimeDuration");
    }

    @Test
    public void fromTime() {
        LibTestExpr.test("fn:hours-from-time('17:01:02'^^xsd:time)", "17");
        LibTestExpr.test("fn:minutes-from-time('17:01:02'^^xsd:time)", "01");
        LibTestExpr.test("fn:seconds-from-time('17:01:02.5'^^xsd:time)", "02.5");
        LibTestExpr.test("fn:timezone-from-time('17:01:02+01:00'^^xsd:time)", "'PT1H'^^xsd:dayTimeDuration");
    }

    @Test
    public void fromDuration() {
        String s = "'P1Y2M3DT4H5M6.7S'^^xsd:duration";
        LibTestExpr.test("fn:years-from-duration(" + s + ")", "1");
        LibTestExpr.test("fn:months-from-duration(" + s + ")", "2");
        LibTestExpr.test("fn:days-from-duration(" + s + ")", "3");
        LibTestExpr.test("fn:hours-from-duration(" + s + ")", "4");
        LibTestExpr.test("fn:minutes-from-duration(" + s + ")", "5");
        LibTestExpr.test("fn:seconds-from-duration(" + s + ")", "6.7");
    }

    @Test
    public void fromMisc() {
        LibTestExpr.test("fn:hours-from-time('17:01:02'^^xsd:time)", "17");
        LibTestExpr.test("fn:minutes-from-time('17:01:02'^^xsd:time)", "01");
        LibTestExpr.test("fn:seconds-from-time('17:01:02.5'^^xsd:time)", "02.5");
        LibTestExpr.test("fn:timezone-from-time('17:01:02+01:00'^^xsd:time)", "'PT1H'^^xsd:dayTimeDuration");
    }

    @Test
    public void from_strict() {
        ARQ.getContext().set(ARQ.strictSPARQL, true);
        try {
            TestFnFunctionsDateTimeDuration.testException("fn:years-from-dateTime('2017-09-14'^^xsd:date)");
            TestFnFunctionsDateTimeDuration.testException("fn:months-from-date('P1Y2M3DT4H5M6.7S'^^xsd:duration)");
            TestFnFunctionsDateTimeDuration.testException("fn:days-from-time('2017-09-14T17:01:02'^^xsd:dateTime)");
        }
        finally {
            ARQ.getContext().set(ARQ.strictSPARQL, false);
        }
    }

    private static void testException(String exprStr) {
        Expr expr = ExprUtils.parse((String)exprStr);
        try {
            NodeValue rExpected = expr.eval(null, LibTestExpr.createTest());
            Assert.fail((String)("Expected exception: " + exprStr));
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
    }

    @Test
    public void exprAdjustDatetimeToTz_01() {
        LibTestExpr.test("fn:adjust-dateTime-to-timezone('2002-03-07T10:00:00'^^xsd:dateTime)", "fn:adjust-dateTime-to-timezone('2002-03-07T10:00:00'^^xsd:dateTime,'" + this.getDynamicDurationString() + "'^^xsd:dayTimeDuration)");
    }

    @Test
    public void exprAdjustDatetimeToTz_02() {
        LibTestExpr.test("fn:adjust-dateTime-to-timezone('2002-03-07T10:00:00-07:00'^^xsd:dateTime)", "fn:adjust-dateTime-to-timezone('2002-03-07T10:00:00-07:00'^^xsd:dateTime,'" + this.getDynamicDurationString() + "'^^xsd:dayTimeDuration)");
    }

    @Test
    public void exprAdjustDatetimeToTz_03() {
        LibTestExpr.test("fn:adjust-dateTime-to-timezone('2002-03-07T10:00:00'^^xsd:dateTime,'-PT10H'^^xsd:dayTimeDuration)", NodeValue.makeDateTime((String)"2002-03-07T10:00:00-10:00"));
    }

    @Test
    public void exprAdjustDatetimeToTz_04() {
        LibTestExpr.test("fn:adjust-dateTime-to-timezone('2002-03-07T10:00:00-07:00'^^xsd:dateTime,'-PT10H'^^xsd:dayTimeDuration)", NodeValue.makeDateTime((String)"2002-03-07T07:00:00-10:00"));
    }

    @Test
    public void exprAdjustDatetimeToTz_05() {
        LibTestExpr.test("fn:adjust-dateTime-to-timezone('2002-03-07T10:00:00-07:00'^^xsd:dateTime,'PT10H'^^xsd:dayTimeDuration)", NodeValue.makeDateTime((String)"2002-03-08T03:00:00+10:00"));
    }

    @Test
    public void exprAdjustDatetimeToTz_06() {
        LibTestExpr.test("fn:adjust-dateTime-to-timezone('2002-03-07T00:00:00+01:00'^^xsd:dateTime,'-PT8H'^^xsd:dayTimeDuration)", NodeValue.makeDateTime((String)"2002-03-06T15:00:00-08:00"));
    }

    @Test
    public void exprAdjustDatetimeToTz_07() {
        LibTestExpr.test("fn:adjust-dateTime-to-timezone('2002-03-07T10:00:00'^^xsd:dateTime,'')", NodeValue.makeDateTime((String)"2002-03-07T10:00:00"));
    }

    @Test
    public void exprAdjustDatetimeToTz_08() {
        LibTestExpr.test("fn:adjust-dateTime-to-timezone('2002-03-07T10:00:00-07:00'^^xsd:dateTime,'')", NodeValue.makeDateTime((String)"2002-03-07T10:00:00"));
    }

    @Test
    public void exprAdjustDateToTz_01() {
        LibTestExpr.test("fn:adjust-date-to-timezone('2002-03-07'^^xsd:date)", "fn:adjust-date-to-timezone('2002-03-07'^^xsd:date,'" + this.getDynamicDurationString() + "'^^xsd:dayTimeDuration)");
    }

    @Test
    public void exprAdjustDateToTz_02() {
        LibTestExpr.test("fn:adjust-date-to-timezone('2002-03-07-07:00'^^xsd:date)", "fn:adjust-date-to-timezone('2002-03-07-07:00'^^xsd:date,'" + this.getDynamicDurationString() + "'^^xsd:dayTimeDuration)");
    }

    @Test
    public void exprAdjustDateToTz_03() {
        LibTestExpr.test("fn:adjust-date-to-timezone('2002-03-07'^^xsd:date,'-PT10H'^^xsd:dayTimeDuration)", NodeValue.makeDate((String)"2002-03-07-10:00"));
    }

    @Test
    public void exprAdjustDateToTz_04() {
        LibTestExpr.test("fn:adjust-date-to-timezone('2002-03-07-07:00'^^xsd:date,'-PT10H'^^xsd:dayTimeDuration)", NodeValue.makeDate((String)"2002-03-06-10:00"));
    }

    @Test
    public void exprAdjustDateToTz_05() {
        LibTestExpr.test("fn:adjust-date-to-timezone('2002-03-07'^^xsd:date,'')", NodeValue.makeDate((String)"2002-03-07"));
    }

    @Test
    public void exprAdjustDateToTz_06() {
        LibTestExpr.test("fn:adjust-date-to-timezone('2002-03-07-07:00'^^xsd:date,'')", NodeValue.makeDate((String)"2002-03-07"));
    }

    @Test
    public void exprAdjustTimeToTz_01() {
        LibTestExpr.test("fn:adjust-time-to-timezone('10:00:00'^^xsd:time)", "fn:adjust-time-to-timezone('10:00:00'^^xsd:time,'" + this.getDynamicDurationString() + "'^^xsd:dayTimeDuration)");
    }

    @Test
    public void exprAdjustTimeToTz_02() {
        LibTestExpr.test("fn:adjust-time-to-timezone('10:00:00-07:00'^^xsd:time)", "fn:adjust-time-to-timezone('10:00:00-07:00'^^xsd:time,'" + this.getDynamicDurationString() + "'^^xsd:dayTimeDuration)");
    }

    @Test
    public void exprAdjustTimeToTz_03() {
        LibTestExpr.test("fn:adjust-time-to-timezone('10:00:00'^^xsd:time,'-PT10H'^^xsd:dayTimeDuration)", NodeValue.makeNode((String)"10:00:00-10:00", (RDFDatatype)XSDDatatype.XSDtime));
    }

    @Test
    public void exprAdjustTimeToTz_04() {
        LibTestExpr.test("fn:adjust-time-to-timezone('10:00:00-07:00'^^xsd:time,'-PT10H'^^xsd:dayTimeDuration)", NodeValue.makeNode((String)"07:00:00-10:00", (RDFDatatype)XSDDatatype.XSDtime));
    }

    @Test
    public void exprAdjustTimeToTz_05() {
        LibTestExpr.test("fn:adjust-time-to-timezone('10:00:00'^^xsd:time,'')", NodeValue.makeNode((String)"10:00:00", (RDFDatatype)XSDDatatype.XSDtime));
    }

    @Test
    public void exprAdjustTimeToTz_06() {
        LibTestExpr.test("fn:adjust-time-to-timezone('10:00:00-07:00'^^xsd:time,'')", NodeValue.makeNode((String)"10:00:00", (RDFDatatype)XSDDatatype.XSDtime));
    }

    @Test
    public void exprAdjustTimeToTz_07() {
        LibTestExpr.test("fn:adjust-time-to-timezone('10:00:00-07:00'^^xsd:time,'PT10H'^^xsd:dayTimeDuration)", NodeValue.makeNode((String)"03:00:00+10:00", (RDFDatatype)XSDDatatype.XSDtime));
    }

    @Test
    public void localTimezone_1() {
        LibTestExpr.test("fn:implicit-timezone()", nv -> nv.isDayTimeDuration());
    }

    private String getDynamicDurationString() {
        int tzOffset = TimeZone.getDefault().getOffset(new Date().getTime()) / 60000;
        String off = "PT" + Math.abs(tzOffset) + "M";
        if (tzOffset < 0) {
            off = "-" + off;
        }
        return off;
    }

    static {
        JenaSystem.init();
    }
}

