/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.negation;

import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collection;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.query.ResultSetRewindable;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestGraphDeltas {
    private static final String testData = StrUtils.strjoinNL((String[])new String[]{"<http://r1> <http://r1> <http://r1> .", "<http://r2> <http://r2> <http://r2> ."});
    private static final String testData2 = StrUtils.strjoinNL((String[])new String[]{"<http://r1> <http://r1> <http://r1> , <http://r2> .", "<http://r2> <http://r2> <http://r2> ."});
    private static final String testData3 = StrUtils.strjoinNL((String[])new String[]{"<http://r1> <http://r1> <http://r1> , \"value\" .", "<http://r2> <http://r2> <http://r2> , 1234 ."});
    private static final String testData4 = StrUtils.strjoinNL((String[])new String[]{"<http://r1> <http://r1> <http://r1> , \"value\" , 1234, 123e4, 123.4, true, false .", "<http://r2> <http://r2> <http://r2> ."});
    private static final String MinusQuery = StrUtils.strjoinNL((String[])new String[]{"SELECT *", "{", "  GRAPH <http://a>", "  {", "     ?s ?p ?o .", "  }", "  MINUS", "  {", "    GRAPH <http://b> { ?s ?p ?o }", "  }", "}"});
    private static final String OptionalSameTermQuery1 = StrUtils.strjoinNL((String[])new String[]{"SELECT *", "{", "  GRAPH <http://a>", "  {", "     ?s ?p ?o .", "  }", "  OPTIONAL", "  {", "     GRAPH <http://b> { ?s0 ?p0 ?o0 . }", "     FILTER (SAMETERM(?s, ?s0) && SAMETERM(?p, ?p0) && SAMETERM(?o, ?o0))", "  }", "  FILTER(!BOUND(?s0))", "}"});
    private static final String OptionalSameTermQuery2 = StrUtils.strjoinNL((String[])new String[]{"SELECT *", "{", "  GRAPH <http://a>", "  {", "    ?s ?p ?o .", "  }", "  OPTIONAL", "  {", "    GRAPH <http://b> { ?s ?p ?o0 . }", "    FILTER (SAMETERM(?o, ?o0))", "  }", "  FILTER(!BOUND(?o0))", "}"});
    private static final String NotExistsQuery = StrUtils.strjoinNL((String[])new String[]{"SELECT *", "{", "  GRAPH <http://a>", "  {", "     ?s ?p ?o .", "  }", "  FILTER NOT EXISTS { GRAPH <http://b> { ?s ?p ?o } }", "}"});
    static boolean[] $enabled = new boolean[]{true};
    static boolean[] $disabled = new boolean[]{false};

    @AfterClass
    public static void afterTests() {
        ARQ.getContext().set(ARQ.optimization, true);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({$enabled}, {$disabled});
    }

    public TestGraphDeltas(boolean[] optimized) {
        ARQ.getContext().set(ARQ.optimization, optimized[0]);
    }

    private void testQuery(Dataset ds, String query, String queryName, int differences) {
        try (QueryExecution qe = QueryExecutionFactory.create((String)query, (Dataset)ds);){
            ResultSetRewindable results = ResultSetFactory.makeRewindable((ResultSet)qe.execSelect());
            Assert.assertEquals((String)(queryName + " gave incorrect results"), (long)differences, (long)results.size());
        }
    }

    private void testDeltas(Model a, Model b, int differences) {
        Dataset ds = DatasetFactory.createGeneral();
        ds.addNamedModel("http://a", a);
        ds.addNamedModel("http://b", b);
        this.testQuery(ds, MinusQuery, "Minus", differences);
        this.testQuery(ds, OptionalSameTermQuery1, "OptionalSameTerm1", differences);
        this.testQuery(ds, OptionalSameTermQuery2, "OptionalSameTerm2", differences);
        this.testQuery(ds, NotExistsQuery, "NotExists", differences);
    }

    @Test
    public void sparql_graph_delta_01() {
        Model a = ModelFactory.createDefaultModel();
        Model b = ModelFactory.createDefaultModel();
        a.read((Reader)new StringReader(testData), null, "TTL");
        b.read((Reader)new StringReader(testData), null, "TTL");
        this.testDeltas(a, b, 0);
        this.testDeltas(b, a, 0);
    }

    @Test
    public void sparql_graph_delta_02() {
        Model a = ModelFactory.createDefaultModel();
        Model b = ModelFactory.createDefaultModel();
        a.read((Reader)new StringReader(testData), null, "TTL");
        b.read((Reader)new StringReader(testData2), null, "TTL");
        this.testDeltas(a, b, 0);
        this.testDeltas(b, a, 1);
    }

    @Test
    public void sparql_graph_delta_03() {
        Model a = ModelFactory.createDefaultModel();
        Model b = ModelFactory.createDefaultModel();
        a.read((Reader)new StringReader(testData), null, "TTL");
        b.read((Reader)new StringReader(testData2), null, "TTL");
        b.removeAll(b.createResource("http://r1"), null, null);
        Assert.assertEquals((long)1L, (long)b.size());
        this.testDeltas(a, b, 1);
        this.testDeltas(b, a, 0);
    }

    @Test
    public void sparql_graph_delta_04() {
        Model a = ModelFactory.createDefaultModel();
        Model b = ModelFactory.createDefaultModel();
        a.read((Reader)new StringReader(testData), null, "TTL");
        this.testDeltas(a, b, 2);
        this.testDeltas(b, a, 0);
    }

    @Test
    public void sparql_graph_delta_05() {
        Model a = ModelFactory.createDefaultModel();
        Model b = ModelFactory.createDefaultModel();
        a.read((Reader)new StringReader(testData3), null, "TTL");
        b.read((Reader)new StringReader(testData), null, "TTL");
        this.testDeltas(a, b, 2);
        this.testDeltas(b, a, 0);
    }

    @Test
    public void sparql_graph_delta_06() {
        Model a = ModelFactory.createDefaultModel();
        Model b = ModelFactory.createDefaultModel();
        a.read((Reader)new StringReader(testData4), null, "TTL");
        b.read((Reader)new StringReader(testData), null, "TTL");
        this.testDeltas(a, b, 6);
        this.testDeltas(b, a, 0);
    }
}

