/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfconnection;

import java.util.Objects;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.graph.Graph;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdfconnection.Isolation;
import org.apache.jena.rdfconnection.RDFConn;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.DatasetGraphReadOnly;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.graph.GraphReadOnly;
import org.apache.jena.system.Txn;
import org.apache.jena.update.UpdateExecutionFactory;
import org.apache.jena.update.UpdateRequest;

public class RDFConnectionLocal
implements RDFConnection {
    private ThreadLocal<Boolean> transactionActive = ThreadLocal.withInitial(() -> false);
    private Dataset dataset;
    private final Isolation isolation;

    public RDFConnectionLocal(Dataset dataset) {
        this(dataset, Isolation.NONE);
    }

    public RDFConnectionLocal(Dataset dataset, Isolation isolation) {
        this.dataset = dataset;
        this.isolation = isolation;
    }

    @Override
    public QueryExecution query(Query query) {
        this.checkOpen();
        return (QueryExecution)Txn.calculateRead((Transactional)this.dataset, () -> QueryExecutionFactory.create((Query)query, (Dataset)this.dataset));
    }

    @Override
    public void update(UpdateRequest update) {
        this.checkOpen();
        Txn.executeWrite((Transactional)this.dataset, () -> UpdateExecutionFactory.create((UpdateRequest)update, (Dataset)this.dataset).execute());
    }

    @Override
    public void load(String graph, String file) {
        this.checkOpen();
        this.doPutPost(graph, file, false);
    }

    @Override
    public void load(String file) {
        this.checkOpen();
        this.doPutPost(null, file, false);
    }

    @Override
    public void load(String graphName, Model model) {
        this.checkOpen();
        Txn.executeWrite((Transactional)this.dataset, () -> {
            Model modelDst = this.modelFor(graphName);
            modelDst.add(model);
        });
    }

    @Override
    public void load(Model model) {
        this.load(null, model);
    }

    @Override
    public Model fetch(String graph) {
        return (Model)Txn.calculateRead((Transactional)this.dataset, () -> {
            Model model = this.modelFor(graph);
            return this.isolate(model);
        });
    }

    @Override
    public Model fetch() {
        this.checkOpen();
        return this.fetch(null);
    }

    @Override
    public void put(String file) {
        this.checkOpen();
        this.doPutPost(null, file, true);
    }

    @Override
    public void put(String graph, String file) {
        this.checkOpen();
        this.doPutPost(graph, file, true);
    }

    @Override
    public void put(Model model) {
        this.put(null, model);
    }

    @Override
    public void put(String graphName, Model model) {
        this.checkOpen();
        Txn.executeWrite((Transactional)this.dataset, () -> {
            Model modelDst = this.modelFor(graphName);
            modelDst.removeAll();
            modelDst.add(model);
        });
    }

    @Override
    public void delete(String graph) {
        this.checkOpen();
        Txn.executeWrite((Transactional)this.dataset, () -> {
            if (RDFConn.isDefault(graph)) {
                this.dataset.getDefaultModel().removeAll();
            } else {
                this.dataset.removeNamedModel(graph);
            }
        });
    }

    @Override
    public void delete() {
        this.checkOpen();
        this.delete(null);
    }

    private void doPutPost(String graph, String file, boolean replace) {
        Objects.requireNonNull(file);
        Lang lang = RDFLanguages.filenameToLang((String)file);
        Txn.executeWrite((Transactional)this.dataset, () -> {
            if (RDFLanguages.isTriples((Lang)lang)) {
                Model model;
                Model model2 = model = RDFConn.isDefault(graph) ? this.dataset.getDefaultModel() : this.dataset.getNamedModel(graph);
                if (replace) {
                    model.removeAll();
                }
                RDFDataMgr.read((Model)model, (String)file);
            } else if (RDFLanguages.isQuads((Lang)lang)) {
                if (replace) {
                    this.dataset.asDatasetGraph().clear();
                }
                RDFDataMgr.read((Dataset)this.dataset, (String)file);
            } else {
                throw new ARQException("Not an RDF format: " + file + " (lang=" + lang + ")");
            }
        });
    }

    private Model isolate(Model model) {
        switch (this.isolation) {
            case COPY: {
                Model m2 = ModelFactory.createDefaultModel();
                m2.add(model);
                return m2;
            }
            case READONLY: {
                GraphReadOnly g = new GraphReadOnly(model.getGraph());
                return ModelFactory.createModelForGraph((Graph)g);
            }
            case NONE: {
                return model;
            }
        }
        throw new InternalErrorException();
    }

    private Dataset isolate(Dataset dataset) {
        switch (this.isolation) {
            case COPY: {
                DatasetGraph dsg2 = DatasetGraphFactory.create();
                dataset.asDatasetGraph().find().forEachRemaining(q -> dsg2.add(q));
                return DatasetFactory.wrap((DatasetGraph)dsg2);
            }
            case READONLY: {
                DatasetGraphReadOnly dsg = new DatasetGraphReadOnly(dataset.asDatasetGraph());
                return DatasetFactory.wrap((DatasetGraph)dsg);
            }
            case NONE: {
                return dataset;
            }
        }
        throw new InternalErrorException();
    }

    private Model modelFor(String graph) {
        if (RDFConn.isDefault(graph)) {
            return this.dataset.getDefaultModel();
        }
        return this.dataset.getNamedModel(graph);
    }

    @Override
    public Dataset fetchDataset() {
        this.checkOpen();
        return (Dataset)Txn.calculateRead((Transactional)this.dataset, () -> this.isolate(this.dataset));
    }

    @Override
    public void loadDataset(String file) {
        this.checkOpen();
        Txn.executeWrite((Transactional)this.dataset, () -> RDFDataMgr.read((Dataset)this.dataset, (String)file));
    }

    @Override
    public void loadDataset(Dataset dataset) {
        Txn.executeWrite((Transactional)dataset, () -> dataset.asDatasetGraph().find().forEachRemaining(q -> this.dataset.asDatasetGraph().add(q)));
    }

    @Override
    public void putDataset(String file) {
        this.checkOpen();
        Txn.executeWrite((Transactional)this.dataset, () -> {
            this.dataset.asDatasetGraph().clear();
            RDFDataMgr.read((Dataset)this.dataset, (String)file);
        });
    }

    @Override
    public void putDataset(Dataset dataset) {
        Txn.executeWrite((Transactional)dataset, () -> {
            this.dataset = this.isolate(dataset);
        });
    }

    @Override
    public void close() {
        this.dataset = null;
    }

    @Override
    public boolean isClosed() {
        return this.dataset == null;
    }

    private void checkOpen() {
        if (this.dataset == null) {
            throw new ARQException("closed");
        }
    }

    public void begin(ReadWrite readWrite) {
        this.dataset.begin(readWrite);
    }

    public void commit() {
        this.dataset.commit();
    }

    public void abort() {
        this.dataset.abort();
    }

    public boolean isInTransaction() {
        return this.dataset.isInTransaction();
    }

    public void end() {
        this.dataset.end();
    }
}

