/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.index.bplustree;

import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.Alg;
import org.apache.jena.tdb.base.block.Block;
import org.apache.jena.tdb.base.buffer.PtrBuffer;
import org.apache.jena.tdb.base.buffer.RecordBuffer;
import org.apache.jena.tdb.base.record.Record;
import org.apache.jena.tdb.index.bplustree.BPTreeException;
import org.apache.jena.tdb.index.bplustree.BPTreeNodeMgr;
import org.apache.jena.tdb.index.bplustree.BPTreePage;
import org.apache.jena.tdb.index.bplustree.BPTreeRecords;
import org.apache.jena.tdb.index.bplustree.BPlusTree;
import org.apache.jena.tdb.index.bplustree.BPlusTreeParams;
import org.apache.jena.tdb.sys.SystemTDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BPTreeNode
extends BPTreePage {
    private static final short READ = 1;
    private static final short WRITE = 2;
    private static Logger log = LoggerFactory.getLogger(BPTreeNode.class);
    private Block block;
    private int id;
    private short blockState = 1;
    int parent;
    int count;
    boolean isLeaf;
    private RecordBuffer records;
    PtrBuffer ptrs;

    void setRecordBuffer(RecordBuffer r) {
        this.records = r;
    }

    private BPTreeNode create(int parent, boolean isLeaf) {
        return BPTreeNode.create(this.bpTree, parent, isLeaf);
    }

    private static BPTreeNode create(BPlusTree bpTree, int parent, boolean isLeaf) {
        BPTreeNode n = bpTree.getNodeManager().createNode(parent);
        n.isLeaf = isLeaf;
        return n;
    }

    BPTreeNode(BPlusTree bpTree, Block block) {
        super(bpTree);
        this.block = block;
        this.id = block.getId().intValue();
    }

    @Override
    public void reset(Block block) {
        this.block = block;
        BPTreeNodeMgr.formatBPTreeNode(this, this.bpTree, block, this.isLeaf, this.parent, this.count);
    }

    private BPTreePage get(int idx, short state) {
        int subId = this.ptrs.get(idx);
        if (state == 1) {
            return this.getMgrRead(subId);
        }
        if (state == 2) {
            return this.getMgrWrite(subId);
        }
        log.error("Unknown state: " + state);
        return null;
    }

    private BPTreePage getMgrRead(int subId) {
        if (this.isLeaf) {
            return (BPTreePage)this.bpTree.getRecordsMgr().getRead(subId);
        }
        return this.bpTree.getNodeManager().getRead(subId, this.id);
    }

    private BPTreePage getMgrWrite(int subId) {
        if (this.isLeaf) {
            return (BPTreePage)this.bpTree.getRecordsMgr().getWrite(subId);
        }
        return this.bpTree.getNodeManager().getWrite(subId, this.id);
    }

    public static Record search(BPTreeNode root, Record rec) {
        root.internalCheckNodeDeep();
        if (root.id != 0) {
            throw new BPTreeException("Search not starting from the root: " + root);
        }
        Record r = root.internalSearch(rec);
        return r;
    }

    public static Record insert(BPTreeNode root, Record record) {
        if (BPTreeNode.logging()) {
            log.debug(String.format("** insert(%s) / start", record));
            if (BPlusTreeParams.DumpTree) {
                root.dump();
            }
        }
        if (!root.isRoot()) {
            throw new BPTreeException("Insert begins but this is not the root");
        }
        if (root.isFull()) {
            BPTreeNode.splitRoot(root);
            if (BPlusTreeParams.DumpTree) {
                root.dump();
            }
        }
        Record result = root.internalInsert(record);
        root.internalCheckNodeDeep();
        if (BPTreeNode.logging()) {
            log.debug(String.format("** insert(%s) / finish", record));
            if (BPlusTreeParams.DumpTree) {
                root.dump();
            }
        }
        return result;
    }

    public static Record delete(BPTreeNode root, Record rec) {
        if (BPTreeNode.logging()) {
            log.debug(String.format("** delete(%s) / start", rec));
            if (BPlusTreeParams.DumpTree) {
                root.dump();
            }
        }
        if (!root.isRoot()) {
            throw new BPTreeException("Delete begins but this is not the root");
        }
        if (root.isLeaf && root.count == 0) {
            BPTreePage page = root.get(0, (short)2);
            if (BPlusTreeParams.CheckingNode && !(page instanceof BPTreeRecords)) {
                root.error("Zero size leaf root but not pointing a records block", new Object[0]);
            }
            Record r = page.internalDelete(rec);
            page.release();
            return r;
        }
        Record v = root.internalDelete(rec);
        if (!root.isLeaf && root.count == 0) {
            root.reduceRoot();
            root.internalCheckNodeDeep();
        }
        if (BPTreeNode.logging()) {
            log.debug(String.format("** delete(%s) / finish", rec));
            if (BPlusTreeParams.DumpTree) {
                root.dump();
            }
        }
        return v;
    }

    static int recordsPageId(BPTreeNode node, Record fromRec) {
        int id;
        while (!node.isLeaf()) {
            BPTreePage page = fromRec == null ? node.get(0, (short)1) : node.findHere(fromRec);
            BPTreeNode n = (BPTreeNode)page;
            if (!node.isRoot()) {
                node.release();
            }
            node = n;
        }
        if (fromRec == null) {
            id = node.getPtrBuffer().getLow();
        } else {
            int idx = node.findSlot(fromRec);
            idx = BPTreeNode.convert(idx);
            id = node.getPtrBuffer().get(idx);
        }
        if (!node.isRoot()) {
            node.release();
        }
        return id;
    }

    @Override
    protected Record maxRecord() {
        BPTreePage page = this.get(this.count, (short)1);
        Record r = page.maxRecord();
        page.release();
        return r;
    }

    @Override
    protected Record minRecord() {
        BPTreePage page = this.get(0, (short)1);
        Record r = page.minRecord();
        page.release();
        return r;
    }

    @Override
    final Record getLowRecord() {
        return this.records.getLow();
    }

    @Override
    final Record getHighRecord() {
        return this.records.getHigh();
    }

    @Override
    final int getMaxSize() {
        return this.params.getOrder();
    }

    @Override
    final int getCount() {
        return this.count;
    }

    @Override
    final void setCount(int count) {
        this.count = count;
    }

    @Override
    public Block getBackingBlock() {
        return this.block;
    }

    RecordBuffer getRecordBuffer() {
        return this.records;
    }

    PtrBuffer getPtrBuffer() {
        return this.ptrs;
    }

    void setIsLeaf(boolean isLeaf) {
        this.isLeaf = isLeaf;
    }

    boolean isLeaf() {
        return this.isLeaf;
    }

    @Override
    public final int getId() {
        return this.id;
    }

    @Override
    final void write() {
        this.bpTree.getNodeManager().write(this);
    }

    @Override
    final void promote() {
        this.bpTree.getNodeManager().promote(this);
    }

    @Override
    final void release() {
        this.bpTree.getNodeManager().release(this);
    }

    @Override
    final void free() {
        this.bpTree.getNodeManager().free(this);
    }

    @Override
    final Record internalSearch(Record rec) {
        if (BPlusTreeParams.CheckingNode) {
            this.internalCheckNode();
        }
        BPTreePage page = this.findHere(rec);
        Record r = page.internalSearch(rec);
        page.release();
        return r;
    }

    private final BPTreePage findHere(Record rec) {
        int idx = this.findSlot(rec);
        idx = BPTreeNode.convert(idx);
        BPTreePage page = this.get(idx, (short)1);
        return page;
    }

    @Override
    final Record internalInsert(Record record) {
        if (BPTreeNode.logging()) {
            log.debug(String.format("internalInsert: %s [%s]", record, this));
        }
        this.internalCheckNode();
        int idx = this.findSlot(record);
        if (BPTreeNode.logging()) {
            log.debug(String.format("internalInsert: idx=%d=>%d", idx, BPTreeNode.convert(idx)));
        }
        idx = BPTreeNode.convert(idx);
        BPTreePage page = this.get(idx, (short)1);
        if (BPTreeNode.logging()) {
            log.debug(String.format("internalInsert: next: %s", page));
        }
        if (page.isFull()) {
            this.split(idx, page);
            if (Record.keyGT(record, this.records.get(idx))) {
                page.release();
                page = this.get(++idx, (short)1);
            }
            this.internalCheckNode();
        }
        Record r = page.internalInsert(record);
        page.release();
        return r;
    }

    private static int convert(int idx) {
        if (idx >= 0) {
            return idx;
        }
        return Alg.decodeIndex((int)idx);
    }

    private void split(int idx, BPTreePage y) {
        boolean logging = BPTreeNode.logging();
        if (logging) {
            log.debug(String.format("split >> y.id=%d  this.id=%d idx=%d", y.getId(), this.id, idx));
            log.debug("split --   " + y);
        }
        this.internalCheckNode();
        if (BPlusTreeParams.CheckingNode) {
            if (!y.isFull()) {
                this.error("Node is not full", new Object[0]);
            }
            if (this.ptrs.get(idx) != y.getId()) {
                int a = this.ptrs.get(idx);
                int b = y.getId();
                this.error("Node to be split isn't in right place [%d/%d]", a, b);
            }
        }
        this.internalCheckNodeDeep();
        this.promote();
        y.promote();
        Record splitKey = y.getSplitKey();
        splitKey = this.keyRecord(splitKey);
        if (logging) {
            log.debug(String.format("Split key: %s", splitKey));
        }
        BPTreePage z = y.split();
        if (logging) {
            log.debug(String.format("Split: %s", y));
            log.debug(String.format("Split: %s", z));
        }
        if (splitKey.hasSeparateValue()) {
            splitKey = this.params.getKeyFactory().create(splitKey.getKey());
        }
        this.records.add(idx, splitKey);
        this.ptrs.add(idx + 1, z.getId());
        ++this.count;
        if (logging) {
            log.debug("split <<   " + this);
            log.debug("split <<   " + y);
            log.debug("split <<   " + z);
        }
        y.write();
        z.write();
        z.release();
        this.write();
        if (BPlusTreeParams.CheckingTree) {
            if (Record.keyNE(splitKey, y.maxRecord())) {
                this.error("Split key %d but max subtree %s", splitKey, y.maxRecord());
            }
            this.internalCheckNodeDeep();
        }
    }

    @Override
    final Record getSplitKey() {
        int ix = this.params.SplitIndex;
        Record split = this.records.get(ix);
        return split;
    }

    @Override
    final BPTreePage split() {
        int ix = this.params.SplitIndex;
        BPTreeNode z = this.create(this.parent, this.isLeaf);
        int maxRec = this.maxRecords();
        this.records.copy(ix + 1, z.records, 0, maxRec - (ix + 1));
        this.records.clear(ix, maxRec - ix);
        this.records.setSize(ix);
        this.ptrs.copy(ix + 1, z.ptrs, 0, this.params.MaxPtr - (ix + 1));
        this.ptrs.clear(ix + 1, this.params.MaxPtr - (ix + 1));
        this.ptrs.setSize(ix + 1);
        this.setCount(ix);
        this.internalCheckNode();
        z.isLeaf = this.isLeaf;
        z.setCount(maxRec - (ix + 1));
        z.internalCheckNode();
        return z;
    }

    private static void splitRoot(BPTreeNode root) {
        BPlusTree bpTree = root.bpTree;
        if (BPlusTreeParams.CheckingNode && root.id != 0) {
            root.error("Not root: %d (root is id zero)", root.id);
        }
        root.internalCheckNode();
        root.promote();
        int splitIdx = root.params.SplitIndex;
        Record rec = root.records.get(splitIdx);
        if (BPTreeNode.logging()) {
            log.debug(String.format("** Split root %d (%s)", splitIdx, rec));
            log.debug("splitRoot >>   " + root);
        }
        BPTreeNode left = BPTreeNode.create(bpTree, root.id, root.isLeaf);
        BPTreeNode right = BPTreeNode.create(bpTree, root.id, root.isLeaf);
        root.records.copy(0, left.records, 0, splitIdx);
        root.ptrs.copy(0, left.ptrs, 0, splitIdx + 1);
        left.count = splitIdx;
        root.records.copy(splitIdx + 1, right.records, 0, root.maxRecords() - (splitIdx + 1));
        root.ptrs.copy(splitIdx + 1, right.ptrs, 0, root.params.MaxPtr - (splitIdx + 1));
        right.count = root.maxRecords() - (splitIdx + 1);
        if (BPTreeNode.logging()) {
            log.debug("splitRoot -- left:   " + left);
            log.debug("splitRoot -- right:  " + right);
        }
        BPTreeNodeMgr.formatForRoot(root, false);
        root.count = 1;
        root.records.add(0, rec);
        root.ptrs.setSize(2);
        root.ptrs.set(0, left.id);
        root.ptrs.set(1, right.id);
        if (BPTreeNode.logging()) {
            log.debug("splitRoot <<   " + root);
            log.debug("splitRoot <<   " + left);
            log.debug("splitRoot <<   " + right);
        }
        left.write();
        right.write();
        left.release();
        right.release();
        root.write();
        if (BPlusTreeParams.CheckingTree) {
            root.checkNodeDeep();
        } else if (BPlusTreeParams.CheckingNode) {
            root.internalCheckNode();
            left.internalCheckNode();
            right.internalCheckNode();
        }
    }

    @Override
    final Record internalDelete(Record rec) {
        this.internalCheckNode();
        if (BPTreeNode.logging()) {
            log.debug(String.format("internalDelete(%s) : %s", rec, this));
        }
        int x = this.findSlot(rec);
        int y = BPTreeNode.convert(x);
        BPTreePage page = this.get(y, (short)1);
        boolean thisWriteNeeded = false;
        if (page.isMinSize()) {
            this.promote();
            page = this.rebalance(page, y);
            thisWriteNeeded = true;
            x = this.findSlot(rec);
            if (BPlusTreeParams.CheckingNode) {
                this.internalCheckNode();
                page.checkNode();
            }
            this.write();
        }
        Record r2 = page.internalDelete(rec);
        if (x >= 0) {
            this.promote();
            this.records.set(x, this.keyRecord(page.maxRecord()));
            this.write();
        }
        page.release();
        return r2;
    }

    private void reduceRoot() {
        if (BPTreeNode.logging()) {
            log.debug(String.format("reduceRoot >> %s", this));
        }
        if (BPlusTreeParams.CheckingNode && (!this.isRoot() || this.count != 0)) {
            this.error("Not an empty root", new Object[0]);
        }
        if (this.isLeaf) {
            if (BPTreeNode.logging()) {
                log.debug(String.format("reduceRoot << leaf root", new Object[0]));
            }
            return;
        }
        BPTreePage sub = this.get(0, (short)2);
        BPTreeNode n = this.cast(sub);
        BPTreeNodeMgr.formatForRoot(this, n.isLeaf);
        n.records.copy(0, this.records, 0, n.count);
        n.ptrs.copy(0, this.ptrs, 0, n.count + 1);
        this.isLeaf = n.isLeaf;
        this.count = n.count;
        this.write();
        n.free();
        this.internalCheckNodeDeep();
        if (BPTreeNode.logging()) {
            log.debug(String.format("reduceRoot << %s", this));
        }
    }

    private BPTreePage rebalance(BPTreePage node, int idx) {
        if (BPTreeNode.logging()) {
            log.debug(String.format("rebalance(id=%d, idx=%d)", node.getId(), idx));
            log.debug(String.format(">> this: %s", this));
            log.debug(String.format(">> node: %s", node));
        }
        this.internalCheckNode();
        this.promote();
        node.promote();
        BPTreePage left = null;
        if (idx > 0) {
            left = this.get(idx - 1, (short)2);
        }
        if (left != null && !left.isMinSize()) {
            if (BPTreeNode.logging()) {
                log.debug("rebalance/shiftRight");
            }
            this.shiftRight(left, node, idx - 1);
            if (BPTreeNode.logging()) {
                log.debug("<< rebalance: " + this);
            }
            if (BPlusTreeParams.CheckingNode) {
                left.checkNode();
                node.checkNode();
                this.internalCheckNode();
            }
            left.release();
            return node;
        }
        BPTreePage right = null;
        if (idx < this.count) {
            right = this.get(idx + 1, (short)2);
        }
        if (right != null && !right.isMinSize()) {
            if (BPTreeNode.logging()) {
                log.debug("rebalance/shiftLeft");
            }
            this.shiftLeft(node, right, idx);
            if (BPTreeNode.logging()) {
                log.debug("<< rebalance: " + this);
            }
            if (BPlusTreeParams.CheckingNode) {
                right.checkNode();
                node.checkNode();
                this.internalCheckNode();
            }
            if (left != null) {
                left.release();
            }
            right.release();
            return node;
        }
        if (BPlusTreeParams.CheckingNode && left == null && right == null) {
            this.error("No siblings", new Object[0]);
        }
        if (left != null) {
            if (BPTreeNode.logging()) {
                log.debug(String.format("rebalance/merge/left: left=%d n=%d [%d]", left.getId(), node.getId(), idx - 1));
            }
            if (BPlusTreeParams.CheckingNode && left.getId() == node.getId()) {
                this.error("Left and n the same: %s", left);
            }
            BPTreePage page = this.merge(left, node, idx - 1);
            if (right != null) {
                right.release();
            }
            return page;
        }
        if (BPTreeNode.logging()) {
            log.debug(String.format("rebalance/merge/right: n=%d right=%d [%d]", node.getId(), right.getId(), idx));
        }
        if (BPlusTreeParams.CheckingNode && right.getId() == node.getId()) {
            this.error("N and right the same: %s", right);
        }
        BPTreePage page = this.merge(node, right, idx);
        return page;
    }

    private BPTreePage merge(BPTreePage left, BPTreePage right, int dividingSlot) {
        if (BPTreeNode.logging()) {
            log.debug(String.format(">> merge(@%d): %s", dividingSlot, this));
            log.debug(">> left:  " + left);
            log.debug(">> right: " + right);
        }
        Record splitKey = this.records.get(dividingSlot);
        BPTreePage page = left.merge(right, splitKey);
        if (BPTreeNode.logging()) {
            log.debug("-- merge: " + page);
        }
        left.write();
        right.free();
        if (page == right) {
            this.error("Returned page is not the left", new Object[0]);
        }
        if (BPlusTreeParams.CheckingNode) {
            if (this.isLeaf) {
                if (left.getCount() + 1 != left.getMaxSize() && left.getCount() != left.getMaxSize()) {
                    this.error("Inconsistent data node size: %d/%d", left.getCount(), left.getMaxSize());
                }
            } else if (!left.isFull()) {
                this.error("Inconsistent node size: %d/%d", left.getCount(), left.getMaxSize());
            }
        }
        this.shuffleDown(dividingSlot);
        this.write();
        this.internalCheckNodeDeep();
        if (BPTreeNode.logging()) {
            log.debug("<< merge: " + this);
            log.debug("<< left:  " + left);
        }
        return left;
    }

    @Override
    BPTreePage merge(BPTreePage right, Record splitKey) {
        return BPTreeNode.merge(this, splitKey, this.cast(right));
    }

    private static BPTreeNode merge(BPTreeNode left, Record splitKey, BPTreeNode right) {
        left.records.add(splitKey);
        right.records.copyToTop(left.records);
        right.ptrs.copyToTop(left.ptrs);
        left.count = left.count + right.count + 1;
        left.internalCheckNode();
        right.records.clear();
        right.ptrs.clear();
        return left;
    }

    private void shiftRight(BPTreePage left, BPTreePage right, int i) {
        if (BPTreeNode.logging()) {
            log.debug(">> shiftRight: this:  " + this);
            log.debug(">> shiftRight: left:  " + left);
            log.debug(">> shiftRight: right: " + right);
        }
        Record r1 = this.records.get(i);
        Record r2 = left.shiftRight(right, r1);
        r2 = this.keyRecord(r2);
        this.records.set(i, r2);
        left.write();
        right.write();
        if (BPTreeNode.logging()) {
            log.debug("<< shiftRight: this:  " + this);
            log.debug("<< shiftRight: left:  " + left);
            log.debug("<< shiftRight: right: " + right);
        }
    }

    private void shiftLeft(BPTreePage left, BPTreePage right, int i) {
        if (BPTreeNode.logging()) {
            log.debug(">> shiftLeft: this:  " + this);
            log.debug(">> shiftLeft: left:  " + left);
            log.debug(">> shiftLeft: right: " + right);
        }
        Record r1 = this.records.get(i);
        Record r2 = left.shiftLeft(right, r1);
        r2 = this.keyRecord(r2);
        this.records.set(i, r2);
        left.write();
        right.write();
        if (BPTreeNode.logging()) {
            log.debug("<< shiftLeft: this:  " + this);
            log.debug("<< shiftLeft: left:  " + left);
            log.debug("<< shiftLeft: right: " + right);
        }
    }

    @Override
    Record shiftRight(BPTreePage other, Record splitKey) {
        BPTreeNode node = this.cast(other);
        if (BPlusTreeParams.CheckingNode) {
            if (this.count == 0) {
                this.error("Node is empty - can't shift a slot out", new Object[0]);
            }
            if (node.isFull()) {
                this.error("Destination node is full", new Object[0]);
            }
        }
        Record r = this.records.getHigh();
        this.records.removeTop();
        node.records.add(0, splitKey);
        this.ptrs.shiftRight(node.ptrs);
        --this.count;
        ++node.count;
        this.internalCheckNode();
        node.internalCheckNode();
        return r;
    }

    @Override
    Record shiftLeft(BPTreePage other, Record splitKey) {
        BPTreeNode node = this.cast(other);
        if (BPlusTreeParams.CheckingNode) {
            if (this.count == 0) {
                this.error("Node is empty - can't shift a slot out", new Object[0]);
            }
            if (this.isFull()) {
                this.error("Destination node is full", new Object[0]);
            }
        }
        Record r = node.records.getLow();
        this.records.add(splitKey);
        node.records.shiftDown(0);
        this.ptrs.shiftLeft(node.ptrs);
        ++this.count;
        --node.count;
        return r;
    }

    private void shuffleDown(int x) {
        if (BPTreeNode.logging()) {
            log.debug(String.format("ShuffleDown: i=%d count=%d MaxRec=%d", x, this.count, this.maxRecords()));
            log.debug("shuffleDown >> " + this);
        }
        if (BPlusTreeParams.CheckingNode && x >= this.count) {
            this.error("shuffleDown out of bounds", new Object[0]);
        }
        if (x == this.count - 1) {
            this.records.removeTop();
            this.ptrs.removeTop();
            --this.count;
            if (BPTreeNode.logging()) {
                log.debug("shuffleDown << Clear top");
                log.debug("shuffleDown << " + this);
            }
            this.internalCheckNode();
            return;
        }
        this.records.shiftDown(x);
        this.ptrs.shiftDown(x + 1);
        --this.count;
        if (BPTreeNode.logging()) {
            log.debug("shuffleDown << " + this);
        }
        this.internalCheckNode();
    }

    private final BPTreeNode cast(BPTreePage other) {
        try {
            return (BPTreeNode)other;
        }
        catch (ClassCastException ex) {
            this.error("Wrong type: " + other, new Object[0]);
            return null;
        }
    }

    final int findSlot(Record rec) {
        int x = this.records.find(rec);
        return x;
    }

    final boolean isRoot() {
        return this.id == 0;
    }

    private Record keyRecord(Record record) {
        return this.bpTree.getRecordFactory().createKeyOnly(record);
    }

    private final int maxRecords() {
        return this.params.MaxRec;
    }

    @Override
    final boolean isFull() {
        if (BPlusTreeParams.CheckingNode && this.count > this.maxRecords()) {
            this.error("isFull: Moby block: %s", this);
        }
        return this.count >= this.maxRecords();
    }

    @Override
    final boolean hasAnyKeys() {
        if (this.count > 0) {
            return true;
        }
        if (!this.isRoot()) {
            return false;
        }
        int id = this.getPtrBuffer().getLow();
        BPTreePage page = this.get(id, (short)1);
        boolean b = page.hasAnyKeys();
        page.release();
        return b;
    }

    @Override
    final boolean isMinSize() {
        int min = this.params.getMinRec();
        if (BPlusTreeParams.CheckingNode && this.count < min) {
            this.error("isMinSize: Dwarf block: %s", this);
        }
        return this.count <= min;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.isLeaf) {
            b.append("LEAF: ");
        } else {
            b.append("NODE: ");
        }
        String labelStr = "??";
        if (this.parent >= 0) {
            labelStr = Integer.toString(this.parent);
        } else if (this.parent == -2) {
            labelStr = "root";
        }
        if (this.isLeaf) {
            labelStr = labelStr + "/leaf";
        }
        b.append(String.format("%d [%s] (size %d) -- ", this.id, labelStr, this.count));
        for (int i = 0; i < this.maxRecords(); ++i) {
            b.append(this.childStr(i));
            b.append(" (");
            b.append(this.recstr(this.records, i));
            b.append(") ");
        }
        b.append(this.childStr(this.params.HighPtr));
        return b.toString();
    }

    private final String recstr(RecordBuffer records, int idx) {
        if (records.isClear(idx)) {
            return "----";
        }
        Record r = records._get(idx);
        return r.toString();
    }

    public void dump() {
        this.dump(IndentedWriter.stdout);
    }

    public void dump(IndentedWriter out) {
        this.output(out);
        out.ensureStartOfLine();
        out.flush();
    }

    public String dumpToString() {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        this.output((IndentedWriter)buff);
        return buff.asString();
    }

    public void output(IndentedWriter out) {
        out.print(this.toString());
        out.incIndent();
        for (int i = 0; i < this.count + 1; ++i) {
            out.println();
            BPTreePage page = this.get(i, (short)1);
            page.output(out);
            page.release();
        }
        out.decIndent();
    }

    private String childStr(int i) {
        if (i >= this.ptrs.size()) {
            return "*";
        }
        int x = this.ptrs.get(i);
        return Integer.toString(x);
    }

    private final void internalCheckNode() {
        if (BPlusTreeParams.CheckingNode) {
            this.checkNode(null, null);
        }
    }

    private final void internalCheckNodeDeep() {
        if (!BPlusTreeParams.CheckingTree) {
            return;
        }
        this.checkNodeDeep();
    }

    @Override
    final void checkNode() {
        this.checkNode(null, null);
    }

    @Override
    final void checkNodeDeep() {
        if (this.isRoot() && this.parent != -2) {
            this.error("Root parent is wrong", new Object[0]);
        }
        this.checkNodeDeep(null, null);
    }

    private final void checkNode(Record min, Record max) {
        int i;
        if (this.count != this.records.size()) {
            this.error("Inconsistent: id=%d, count=%d, records.size()=%d : %s", this.id, this.count, this.records.size(), this);
        }
        if (!this.isLeaf && this.count + 1 != this.ptrs.size()) {
            this.error("Inconsistent: id=%d, count+1=%d, ptrs.size()=%d ; %s", this.id, this.count + 1, this.ptrs.size(), this);
        }
        if (!this.isRoot() && this.count < this.params.MinRec) {
            this.error("Runt node: %s", this);
        }
        if (!this.isRoot() && this.count > this.maxRecords()) {
            this.error("Over full node: %s", this);
        }
        if (!this.isLeaf && this.parent == this.id) {
            this.error("Parent same as id: %s", this);
        }
        Record k = min;
        for (i = 0; i < this.count; ++i) {
            if (this.records.get(i) == null) {
                this.error("Node: %d : Invalid record @%d :: %s", this.id, i, this);
            }
            if (k != null && Record.keyGT(k, this.records.get(i))) {
                Record r = this.records.get(i);
                this.error("Node: %d: Not sorted (%d) (%s, %s) :: %s ", this.id, i, k, r, this);
            }
            k = this.records.get(i);
        }
        if (k != null && max != null && Record.keyGT(k, max)) {
            this.error("Node: %d - Record is too high (max=%s):: %s", this.id, max, this);
        }
        if (SystemTDB.NullOut) {
            for (i = this.count; i < this.maxRecords(); ++i) {
                if (this.records.isClear(i)) continue;
                this.error("Node: %d - not clear (idx=%d) :: %s", this.id, i, this);
            }
        }
        for (i = 0; i < this.count + 1; ++i) {
            if (this.ptrs.get(i) < 0) {
                this.error("Node: %d: Invalid child pointer @%d :: %s", this.id, i, this);
            }
            if (!BPlusTreeParams.CheckingTree || !this.isLeaf) continue;
            int ptr = this.ptrs.get(i);
            BPTreeRecords records = (BPTreeRecords)this.bpTree.getRecordsMgr().getRead(ptr);
            int id = records.getId();
            if (id != this.ptrs.get(i)) {
                this.error("Records: Block @%d has a different id: %d :: %s", id, i, this);
            }
            int link = records.getLink();
            if (i != this.count) {
                BPTreeRecords page = (BPTreeRecords)this.bpTree.getRecordsMgr().getRead(this.ptrs.get(i));
                int id2 = page.getLink();
                if (link != id2) {
                    this.error("Records: Link not to next block @%d/@%d has a different id: %d :: %s", id, id2, i, records);
                }
                this.bpTree.getRecordsMgr().release(page);
            }
            records.release();
        }
        if (SystemTDB.NullOut) {
            int x = this.params.MaxPtr;
            while (i < x) {
                if (!this.ptrs.isClear(i)) {
                    this.error("Node: %d: Unexpected pointer @%d :: %s", this.id, i, this);
                }
                ++i;
            }
        }
    }

    private void checkNodeDeep(Record min, Record max) {
        this.checkNode(min, max);
        int limit = this.count == 0 ? 0 : this.count + 1;
        for (int i = 0; i < limit; ++i) {
            Record min1 = min;
            Record max1 = max;
            BPTreePage n = this.get(i, (short)1);
            if (i != this.count) {
                Record keySubTree = n.getHighRecord();
                Record keyHere = this.records.get(i);
                if (keySubTree == null) {
                    this.error("Node: %d: Can't get high record from %d", this.id, n.getId());
                }
                if (keySubTree.getKey() == null) {
                    this.error("Node: %d: Can't get high record is missing it's key from %d", this.id, n.getId());
                }
                if (keyHere == null) {
                    this.error("Node: %d: record is null", this.id);
                }
                if (keyHere.getKey() == null) {
                    this.error("Node: %d: Record key is null", this.id);
                }
                if (Record.keyGT(keySubTree, keyHere)) {
                    this.error("Node: %d: Child key %s is greater than this key %s", this.id, keySubTree, keyHere);
                }
                Record keyMax = n.maxRecord();
                Record keyMin = n.minRecord();
                if (Record.keyNE(keyHere, keyMax)) {
                    this.error("Node: %d: Key %s is not the max [%s] of the sub-tree idx=%d", this.id, keyHere, keyMax, i);
                }
                if (min != null && Record.keyGT(min, keyMin)) {
                    this.error("Node: %d: Minimun for this node should be %s but it's %s", this.id, min, keyMin);
                }
                if (max != null && Record.keyLT(max, keyMax)) {
                    this.error("Node: %d: Maximum for this node should be %s but it's %s", this.id, max, keyMax);
                }
                if (min != null && Record.keyGT(min, keyHere)) {
                    this.error("Node: %d: Key too small: %s - min should be %s", this.id, keyHere, min);
                }
                if (max != null && Record.keyLT(max, keyHere)) {
                    this.error("Node: %d: Key too large: %s - max should be %s", this.id, keyHere, max);
                }
            }
            if (!(n instanceof BPTreeNode)) {
                n.checkNodeDeep();
                n.release();
                continue;
            }
            if (this.isLeaf) {
                if (!this.bpTree.getRecordsMgr().getBlockMgr().valid(this.ptrs.get(i))) {
                    this.error("Node: %d: Dangling ptr (records) in block @%d :: %s", this.id, i, this);
                }
            } else if (!this.bpTree.getNodeManager().valid(this.ptrs.get(i))) {
                this.error("Node: %d: Dangling ptr in block @%d :: %s", this.id, i, this);
            }
            if (i == 0) {
                max1 = this.records.get(0);
            } else if (i == this.count) {
                min1 = this.records.get(this.count - 1);
                max1 = null;
            } else {
                min1 = this.records.get(i - 1);
                max1 = this.records.get(i);
            }
            ((BPTreeNode)n).checkNodeDeep(min1, max1);
            n.release();
        }
    }

    private static boolean logging() {
        return BPlusTreeParams.logging(log);
    }

    private void warning(String msg, Object ... args) {
        msg = String.format(msg, args);
        System.out.println("Warning: " + msg);
        System.out.flush();
    }

    private void error(String msg, Object ... args) {
        msg = String.format(msg, args);
        System.out.println();
        System.out.println(msg);
        System.out.flush();
        try {
            this.dumpBlocks();
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new BPTreeException(msg);
    }

    private void dumpBlocks() {
        System.out.println("---Nodes");
        this.bpTree.getNodeManager().dump();
        System.out.println("---Records");
        this.bpTree.getRecordsMgr().dump();
        System.out.println("---");
        System.out.flush();
    }
}

