/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.lib;

import java.util.HashMap;
import java.util.Map;

public class StringAbbrev {
    Map<String, String> prefix2string = new HashMap<String, String>();

    public StringAbbrev() {
        this.prefix2string.put("_", ":");
    }

    public void add(String prefix, String string) {
        if (prefix.contains(":")) {
            throw new IllegalArgumentException("Prefix contains ':' -- " + prefix);
        }
        if (prefix.equals("")) {
            throw new IllegalArgumentException("Prefix is the empty string");
        }
        this.prefix2string.put(prefix, string);
    }

    public String abbreviate(String s) {
        for (Map.Entry<String, String> e : this.prefix2string.entrySet()) {
            String prefix = e.getKey();
            String string = e.getValue();
            if (!s.startsWith(string)) continue;
            String s2 = ":" + prefix + ":" + s.substring(string.length());
            return s2;
        }
        if (s.startsWith(":")) {
            s = ":" + s;
        }
        return s;
    }

    public String expand(String s) {
        if (!s.startsWith(":")) {
            return s;
        }
        int i = s.indexOf(":", 1);
        if (i < 0) {
            return s;
        }
        if (i == 1) {
            return s.substring(1);
        }
        String prefix = s.substring(1, i);
        if (prefix == null) {
            return s.substring(i + 1);
        }
        String start = this.prefix2string.get(prefix);
        return start + s.substring(i + 1);
    }
}

