/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper.access;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Supplier;

public final class Meta {
    private Meta() {
    }

    public static <T extends Annotation> T getAnnotation(Method holder, Class<T> api) {
        return Meta.getDirectAnnotation(holder, api);
    }

    public static <T extends Annotation> T getAnnotation(Field holder, Class<T> api) {
        return Meta.getDirectAnnotation(holder, api);
    }

    public static <T extends Annotation> T getClassOrPackageAnnotation(Method holder, Class<T> api) {
        return Meta.getIndirectAnnotation(api, holder::getDeclaringClass, () -> holder.getDeclaringClass().getPackage());
    }

    public static <T extends Annotation> T getClassOrPackageAnnotation(Field holder, Class<T> api) {
        return Meta.getIndirectAnnotation(api, holder::getDeclaringClass, () -> holder.getDeclaringClass().getPackage());
    }

    private static <T extends Annotation> T getDirectAnnotation(AccessibleObject holder, Class<T> api) {
        T annotation = holder.getAnnotation(api);
        if (annotation != null) {
            return annotation;
        }
        T meta = Meta.findMeta(holder.getAnnotations(), api);
        if (meta != null) {
            return meta;
        }
        return null;
    }

    private static <T extends Annotation> T getIndirectAnnotation(Class<T> api, Supplier<Class<?>> ownerSupplier, Supplier<Package> packageSupplier) {
        T pckAnnotation;
        T ownerAnnotation = ownerSupplier.get().getAnnotation(api);
        if (ownerAnnotation != null) {
            return ownerAnnotation;
        }
        Package pck = packageSupplier.get();
        if (pck != null && (pckAnnotation = pck.getAnnotation(api)) != null) {
            return pckAnnotation;
        }
        return null;
    }

    public static <T extends Annotation> T getAnnotation(Class<?> clazz, Class<T> api) {
        HashSet visited = new HashSet();
        for (Class<?> current = clazz; current != null && current != Object.class; current = current.getSuperclass()) {
            if (!visited.add(current)) {
                return null;
            }
            T annotation = current.getAnnotation(api);
            if (annotation != null) {
                return annotation;
            }
            T meta = Meta.findMeta(clazz.getAnnotations(), api);
            if (meta == null) continue;
            return meta;
        }
        return null;
    }

    public static <T extends Annotation> T getAnnotation(Package pck, Class<T> api) {
        T annotation = pck.getAnnotation(api);
        if (annotation != null) {
            return annotation;
        }
        return Meta.findMeta(pck.getAnnotations(), api);
    }

    public static <T extends Annotation> T findMeta(Annotation[] annotations, Class<T> api) {
        for (Annotation a : annotations) {
            Class<? extends Annotation> userType = a.annotationType();
            T aa = userType.getAnnotation(api);
            if (aa == null) continue;
            boolean overriden = false;
            HashMap<String, Method> mapping = new HashMap<String, Method>();
            for (Class cm : Arrays.asList(api, userType)) {
                for (Method m : cm.getMethods()) {
                    overriden = mapping.put(m.getName(), m) != null || overriden;
                }
            }
            if (!overriden) {
                return aa;
            }
            return (T)((Annotation)api.cast(Meta.newAnnotation(mapping, a, aa)));
        }
        return null;
    }

    private static <T extends Annotation> T newAnnotation(Map<String, Method> methodMapping, Annotation user, T johnzon) {
        return (T)((Annotation)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{johnzon.annotationType()}, (proxy, method, args) -> {
            Method m = (Method)methodMapping.get(method.getName());
            try {
                if (m.getDeclaringClass() == user.annotationType()) {
                    return m.invoke((Object)user, args);
                }
                return m.invoke((Object)johnzon, args);
            }
            catch (InvocationTargetException ite) {
                throw ite.getTargetException();
            }
        }));
    }
}

