/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi;

import javax.naming.NamingException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.replication.ReplicationNotifier;
import org.apache.juddi.rmi.JNDIRegistration;
import org.apache.juddi.rmi.RMIRegistration;
import org.apache.juddi.subscription.SubscriptionNotifier;

public class Registry {
    private static Registry registry = null;
    private static Log log = LogFactory.getLog(Registry.class);
    private static SubscriptionNotifier subscriptionNotifier = null;
    private static ReplicationNotifier replicationNotifier = null;

    private Registry() {
    }

    public static synchronized void stop() throws ConfigurationException {
        if (registry != null) {
            log.info((Object)"Stopping jUDDI registry...");
            if (subscriptionNotifier != null) {
                log.info((Object)"Shutting down SubscriptionNotifier");
                subscriptionNotifier.cancel();
                subscriptionNotifier = null;
            }
            if (replicationNotifier != null) {
                replicationNotifier.cancel();
                replicationNotifier = null;
            }
            if (AppConfig.getConfiguration().getBoolean("juddi.jndi.registration", false)) {
                try {
                    JNDIRegistration.getInstance().unregister();
                }
                catch (NamingException e) {
                    log.error((Object)("Unable to Register jUDDI services with JNDI. " + e.getMessage()), (Throwable)e);
                }
            }
            registry = null;
            log.info((Object)"jUDDI shutdown completed.");
        }
    }

    public static synchronized void start() throws ConfigurationException {
        if (registry == null) {
            log.info((Object)("Starting jUDDI registry...This is node " + AppConfig.getConfiguration().getString("juddi.nodeId", "")));
            registry = new Registry();
            replicationNotifier = new ReplicationNotifier();
            AppConfig.triggerReload();
            if (AppConfig.getConfiguration().getBoolean("juddi.subscription.notification", true)) {
                subscriptionNotifier = new SubscriptionNotifier();
            }
            if (AppConfig.getConfiguration().getBoolean("juddi.jndi.registration", false)) {
                try {
                    int port = AppConfig.getConfiguration().getInteger("juddi.rmi.port", Integer.valueOf(0));
                    JNDIRegistration.getInstance().register(port);
                }
                catch (NamingException e) {
                    log.error((Object)("Unable to Register jUDDI services with JNDI. " + e.getMessage()), (Throwable)e);
                }
            }
            if (AppConfig.getConfiguration().getBoolean("juddi.rmi.registration", false)) {
                try {
                    int rmiport = AppConfig.getConfiguration().getInteger("juddi.rmi.registry.port", Integer.valueOf(1099));
                    int port = AppConfig.getConfiguration().getInteger("juddi.rmi.port", Integer.valueOf(0));
                    RMIRegistration.getInstance(rmiport).register(port);
                }
                catch (Exception e) {
                    log.error((Object)("Unable to Register jUDDI services with RMI Registry. " + e.getMessage()), (Throwable)e);
                }
            }
            log.info((Object)"jUDDI registry started successfully.");
        }
    }
}

