/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.api.impl;

import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.jws.WebService;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.ws.Holder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.ClassUtil;
import org.apache.juddi.api.impl.AuthenticatedService;
import org.apache.juddi.api.impl.ServiceCounterLifecycleResource;
import org.apache.juddi.api.impl.UDDIPublicationImpl;
import org.apache.juddi.api.impl.UDDIReplicationImpl;
import org.apache.juddi.api.impl.UDDISecurityImpl;
import org.apache.juddi.api.impl.UDDIServiceCounter;
import org.apache.juddi.api.impl.UDDISubscriptionImpl;
import org.apache.juddi.api.impl.XRegisterHelper;
import org.apache.juddi.api.util.JUDDIQuery;
import org.apache.juddi.api.util.QueryStatus;
import org.apache.juddi.api_v3.AdminSaveBusinessWrapper;
import org.apache.juddi.api_v3.AdminSaveTModelWrapper;
import org.apache.juddi.api_v3.ClerkDetail;
import org.apache.juddi.api_v3.ClerkList;
import org.apache.juddi.api_v3.ClientSubscriptionInfoDetail;
import org.apache.juddi.api_v3.DeleteClerk;
import org.apache.juddi.api_v3.DeleteClientSubscriptionInfo;
import org.apache.juddi.api_v3.DeleteNode;
import org.apache.juddi.api_v3.DeletePublisher;
import org.apache.juddi.api_v3.GetAllClientSubscriptionInfoDetail;
import org.apache.juddi.api_v3.GetAllPublisherDetail;
import org.apache.juddi.api_v3.GetClientSubscriptionInfoDetail;
import org.apache.juddi.api_v3.GetEntityHistoryMessageRequest;
import org.apache.juddi.api_v3.GetEntityHistoryMessageResponse;
import org.apache.juddi.api_v3.GetFailedReplicationChangeRecordsMessageRequest;
import org.apache.juddi.api_v3.GetFailedReplicationChangeRecordsMessageResponse;
import org.apache.juddi.api_v3.GetPublisherDetail;
import org.apache.juddi.api_v3.NodeDetail;
import org.apache.juddi.api_v3.NodeList;
import org.apache.juddi.api_v3.PublisherDetail;
import org.apache.juddi.api_v3.SaveClerk;
import org.apache.juddi.api_v3.SaveClientSubscriptionInfo;
import org.apache.juddi.api_v3.SaveNode;
import org.apache.juddi.api_v3.SavePublisher;
import org.apache.juddi.api_v3.SubscriptionWrapper;
import org.apache.juddi.api_v3.SyncSubscription;
import org.apache.juddi.api_v3.SyncSubscriptionDetail;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.config.PersistenceManager;
import org.apache.juddi.mapping.MappingApiToModel;
import org.apache.juddi.mapping.MappingModelToApi;
import org.apache.juddi.model.BusinessEntity;
import org.apache.juddi.model.ChangeRecord;
import org.apache.juddi.model.Clerk;
import org.apache.juddi.model.ClientSubscriptionInfo;
import org.apache.juddi.model.Node;
import org.apache.juddi.model.Publisher;
import org.apache.juddi.model.Tmodel;
import org.apache.juddi.model.UddiEntityPublisher;
import org.apache.juddi.replication.ReplicationNotifier;
import org.apache.juddi.subscription.NotificationList;
import org.apache.juddi.subscription.notify.TemporaryMailContainer;
import org.apache.juddi.subscription.notify.USERFRIENDLYSMTPNotifier;
import org.apache.juddi.v3.client.transport.Transport;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.FatalErrorException;
import org.apache.juddi.v3.error.InvalidKeyPassedException;
import org.apache.juddi.v3.error.InvalidValueException;
import org.apache.juddi.v3.error.UserMismatchException;
import org.apache.juddi.v3_service.JUDDIApiPortType;
import org.apache.juddi.validation.ValidateClerk;
import org.apache.juddi.validation.ValidateClientSubscriptionInfo;
import org.apache.juddi.validation.ValidateNode;
import org.apache.juddi.validation.ValidatePublish;
import org.apache.juddi.validation.ValidatePublisher;
import org.apache.juddi.validation.ValidateReplication;
import org.uddi.api_v3.AuthToken;
import org.uddi.api_v3.BusinessInfo;
import org.uddi.api_v3.BusinessInfos;
import org.uddi.api_v3.Contact;
import org.uddi.api_v3.DeleteTModel;
import org.uddi.api_v3.DispositionReport;
import org.uddi.api_v3.GetRegisteredInfo;
import org.uddi.api_v3.InfoSelection;
import org.uddi.api_v3.PersonName;
import org.uddi.api_v3.RegisteredInfo;
import org.uddi.api_v3.Result;
import org.uddi.api_v3.SaveBusiness;
import org.uddi.api_v3.SaveTModel;
import org.uddi.api_v3.TModelInfo;
import org.uddi.api_v3.TModelInfos;
import org.uddi.repl_v3.ChangeRecords;
import org.uddi.repl_v3.CommunicationGraph;
import org.uddi.repl_v3.Operator;
import org.uddi.repl_v3.OperatorStatusType;
import org.uddi.repl_v3.ReplicationConfiguration;
import org.uddi.sub_v3.GetSubscriptionResults;
import org.uddi.sub_v3.Subscription;
import org.uddi.sub_v3.SubscriptionResultsList;
import org.uddi.v3_service.DispositionReportFaultMessage;
import org.uddi.v3_service.UDDISubscriptionPortType;

@WebService(serviceName="JUDDIApiService", endpointInterface="org.apache.juddi.v3_service.JUDDIApiPortType", targetNamespace="urn:juddi-apache-org:v3_service")
public class JUDDIApiImpl
extends AuthenticatedService
implements JUDDIApiPortType {
    private Log log = LogFactory.getLog(this.getClass());
    private UDDIServiceCounter serviceCounter = ServiceCounterLifecycleResource.getServiceCounter(this.getClass());
    static UDDISubscriptionImpl sub = new UDDISubscriptionImpl();
    static UDDISecurityImpl sec = new UDDISecurityImpl();
    static UDDIPublicationImpl pub = new UDDIPublicationImpl();

    public PublisherDetail savePublisher(SavePublisher body) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidatePublish(publisher).validateSavePublisher(em, body);
            PublisherDetail result = new PublisherDetail();
            List apiPublisherList = body.getPublisher();
            for (org.apache.juddi.api_v3.Publisher apiPublisher : apiPublisherList) {
                Publisher modelPublisher = new Publisher();
                MappingApiToModel.mapPublisher(apiPublisher, modelPublisher);
                Object existingUddiEntity = em.find(modelPublisher.getClass(), (Object)modelPublisher.getAuthorizedName());
                if (existingUddiEntity != null) {
                    em.remove(existingUddiEntity);
                }
                em.persist((Object)modelPublisher);
                result.getPublisher().add(apiPublisher);
            }
            tx.commit();
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.SAVE_PUBLISHER, QueryStatus.SUCCESS, procTime);
            PublisherDetail publisherDetail = result;
            return publisherDetail;
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.SAVE_PUBLISHER, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    public void deletePublisher(DeletePublisher body) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidatePublish(publisher).validateDeletePublisher(em, body);
            List entityKeyList = body.getPublisherId();
            ArrayList<Publisher> deletedPubs = new ArrayList<Publisher>();
            for (String entityKey : entityKeyList) {
                Publisher obj = (Publisher)em.find(Publisher.class, (Object)entityKey);
                deletedPubs.add(obj);
                UDDISecurityImpl security = new UDDISecurityImpl();
                AuthToken authToken = security.getAuthToken(entityKey);
                GetRegisteredInfo r = new GetRegisteredInfo();
                r.setAuthInfo(authToken.getAuthInfo());
                r.setInfoSelection(InfoSelection.ALL);
                this.log.info((Object)("removing all businesses owned by publisher " + entityKey + "."));
                UDDIPublicationImpl publish = new UDDIPublicationImpl();
                RegisteredInfo registeredInfo = publish.getRegisteredInfo(r);
                BusinessInfos businessInfos = registeredInfo.getBusinessInfos();
                if (businessInfos != null && businessInfos.getBusinessInfo() != null) {
                    for (BusinessInfo businessInfo : businessInfos.getBusinessInfo()) {
                        Object business = em.find(BusinessEntity.class, (Object)businessInfo.getBusinessKey());
                        em.remove(business);
                    }
                }
                this.log.info((Object)("mark all tmodels for publisher " + entityKey + " as deleted."));
                TModelInfos tmodelInfos = registeredInfo.getTModelInfos();
                if (tmodelInfos != null && tmodelInfos.getTModelInfo() != null) {
                    for (TModelInfo tModelInfo : tmodelInfos.getTModelInfo()) {
                        Tmodel tmodel = (Tmodel)em.find(Tmodel.class, (Object)tModelInfo.getTModelKey());
                        tmodel.setDeleted(true);
                        em.persist((Object)tmodel);
                    }
                }
                this.log.info((Object)("remove all persisted AuthTokens for publisher " + entityKey + "."));
                Query q1 = em.createQuery("DELETE FROM AuthToken auth WHERE auth.authorizedName = ?1");
                q1.setParameter(1, (Object)entityKey);
                q1.executeUpdate();
                this.log.info((Object)("remove all subscriptions for publisher " + entityKey + "."));
                q1 = em.createQuery("DELETE FROM Subscription s WHERE s.authorizedName = ?1");
                q1.setParameter(1, (Object)entityKey);
                q1.executeUpdate();
                this.log.info((Object)("removing publisher " + entityKey + "."));
                em.remove((Object)obj);
            }
            tx.commit();
            for (Publisher p : deletedPubs) {
                USERFRIENDLYSMTPNotifier.notifyAccountDeleted(new TemporaryMailContainer(null, p, (Publisher)publisher));
            }
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.DELETE_PUBLISHER, QueryStatus.SUCCESS, procTime);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.DELETE_PUBLISHER, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    public PublisherDetail getPublisherDetail(GetPublisherDetail body) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        new ValidatePublisher(null).validateGetPublisherDetail(body);
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            this.getEntityPublisher(em, body.getAuthInfo());
            PublisherDetail result = new PublisherDetail();
            List publisherIdList = body.getPublisherId();
            for (String publisherId : publisherIdList) {
                Publisher modelPublisher = null;
                try {
                    modelPublisher = (Publisher)em.find(Publisher.class, (Object)publisherId);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                if (modelPublisher == null) {
                    throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.PublisherNotFound", publisherId));
                }
                org.apache.juddi.api_v3.Publisher apiPublisher = new org.apache.juddi.api_v3.Publisher();
                MappingModelToApi.mapPublisher(modelPublisher, apiPublisher);
                result.getPublisher().add(apiPublisher);
            }
            tx.commit();
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.GET_PUBLISHER_DETAIL, QueryStatus.SUCCESS, procTime);
            PublisherDetail publisherDetail = result;
            return publisherDetail;
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.GET_PUBLISHER_DETAIL, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    public PublisherDetail getAllPublisherDetail(GetAllPublisherDetail body) throws DispositionReportFaultMessage, RemoteException {
        long startTime = System.currentTimeMillis();
        new ValidatePublisher(null).validateGetAllPublisherDetail(body);
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            this.getEntityPublisher(em, body.getAuthInfo());
            PublisherDetail result = new PublisherDetail();
            Query query = em.createQuery("SELECT p from Publisher as p");
            List modelPublisherList = query.getResultList();
            for (Publisher modelPublisher : modelPublisherList) {
                org.apache.juddi.api_v3.Publisher apiPublisher = new org.apache.juddi.api_v3.Publisher();
                MappingModelToApi.mapPublisher(modelPublisher, apiPublisher);
                result.getPublisher().add(apiPublisher);
            }
            tx.commit();
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.GET_ALL_PUBLISHER_DETAIL, QueryStatus.SUCCESS, procTime);
            PublisherDetail publisherDetail = result;
            return publisherDetail;
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.GET_ALL_PUBLISHER_DETAIL, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    public void adminDeleteTModel(DeleteTModel body) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidatePublish(publisher).validateAdminDeleteTModel(em, body);
            ArrayList<ChangeRecord> changes = new ArrayList<ChangeRecord>();
            List entityKeyList = body.getTModelKey();
            for (String entityKey : entityKeyList) {
                Tmodel obj = (Tmodel)em.find(Tmodel.class, (Object)entityKey);
                if (obj == null) {
                    throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.TModelNotFound", entityKey));
                }
                if (!obj.getNodeId().equals(this.getNode())) {
                    throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.TModelNodeOwner", entityKey + " this node " + this.getNode() + " owning node " + obj.getNodeId()));
                }
                em.remove((Object)obj);
                changes.add(UDDIPublicationImpl.getChangeRecord_deleteTModelDelete(entityKey, this.getNode(), this.df));
            }
            tx.commit();
            for (ChangeRecord cr : changes) {
                ReplicationNotifier.enqueue(cr);
            }
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.ADMIN_DELETE_TMODEL, QueryStatus.SUCCESS, procTime);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.ADMIN_DELETE_TMODEL, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    public void deleteClientSubscriptionInfo(DeleteClientSubscriptionInfo body) throws DispositionReportFaultMessage, RemoteException {
        long startTime = System.currentTimeMillis();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidateClientSubscriptionInfo(publisher).validateDeleteClientSubscriptionInfo(em, body);
            List entityKeyList = body.getSubscriptionKey();
            for (String entityKey : entityKeyList) {
                Object obj = em.find(ClientSubscriptionInfo.class, (Object)entityKey);
                em.remove(obj);
            }
            tx.commit();
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.DELETE_CLIENT_SUB, QueryStatus.SUCCESS, procTime);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.DELETE_CLIENT_SUB, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    public ClientSubscriptionInfoDetail saveClientSubscriptionInfo(SaveClientSubscriptionInfo body) throws DispositionReportFaultMessage, RemoteException {
        long startTime = System.currentTimeMillis();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidateClientSubscriptionInfo(publisher).validateSaveClientSubscriptionInfo(em, body);
            ClientSubscriptionInfoDetail result = new ClientSubscriptionInfoDetail();
            List apiClientSubscriptionInfoList = body.getClientSubscriptionInfo();
            for (org.apache.juddi.api_v3.ClientSubscriptionInfo apiClientSubscriptionInfo : apiClientSubscriptionInfoList) {
                ClientSubscriptionInfo modelClientSubscriptionInfo = new ClientSubscriptionInfo();
                MappingApiToModel.mapClientSubscriptionInfo(apiClientSubscriptionInfo, modelClientSubscriptionInfo);
                Object existingUddiEntity = em.find(modelClientSubscriptionInfo.getClass(), (Object)modelClientSubscriptionInfo.getSubscriptionKey());
                if (existingUddiEntity != null) {
                    em.remove(existingUddiEntity);
                }
                em.persist((Object)modelClientSubscriptionInfo);
                result.getClientSubscriptionInfo().add(apiClientSubscriptionInfo);
            }
            tx.commit();
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.SAVE_CLIENT_SUB, QueryStatus.SUCCESS, procTime);
            ClientSubscriptionInfoDetail clientSubscriptionInfoDetail = result;
            return clientSubscriptionInfoDetail;
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.SAVE_CLIENT_SUB, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    public ClientSubscriptionInfoDetail getAllClientSubscriptionInfoDetail(GetAllClientSubscriptionInfoDetail body) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        new ValidateClientSubscriptionInfo(null).validateGetAllClientSubscriptionDetail(body);
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            this.getEntityPublisher(em, body.getAuthInfo());
            ClientSubscriptionInfoDetail result = new ClientSubscriptionInfoDetail();
            Query query = em.createQuery("SELECT cs from ClientSubscriptionInfo as cs");
            List modelClientSubscriptionInfoList = query.getResultList();
            for (ClientSubscriptionInfo modelClientSubscriptionInfo : modelClientSubscriptionInfoList) {
                org.apache.juddi.api_v3.ClientSubscriptionInfo apiClientSubscriptionInfo = new org.apache.juddi.api_v3.ClientSubscriptionInfo();
                MappingModelToApi.mapClientSubscriptionInfo(modelClientSubscriptionInfo, apiClientSubscriptionInfo, em);
                result.getClientSubscriptionInfo().add(apiClientSubscriptionInfo);
            }
            tx.commit();
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.GET_ALL_CLIENT_SUB, QueryStatus.SUCCESS, procTime);
            ClientSubscriptionInfoDetail clientSubscriptionInfoDetail = result;
            return clientSubscriptionInfoDetail;
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.GET_ALL_CLIENT_SUB, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    public ClientSubscriptionInfoDetail getClientSubscriptionInfoDetail(GetClientSubscriptionInfoDetail body) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        new ValidateClientSubscriptionInfo(null).validateGetClientSubscriptionInfoDetail(body);
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            this.getEntityPublisher(em, body.getAuthInfo());
            ClientSubscriptionInfoDetail result = new ClientSubscriptionInfoDetail();
            List subscriptionKeyList = body.getClientSubscriptionKey();
            for (String subscriptionKey : subscriptionKeyList) {
                ClientSubscriptionInfo modelClientSubscriptionInfo = null;
                try {
                    modelClientSubscriptionInfo = (ClientSubscriptionInfo)em.find(ClientSubscriptionInfo.class, (Object)subscriptionKey);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                if (modelClientSubscriptionInfo == null) {
                    throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.SubscripKeyNotFound", subscriptionKey));
                }
                org.apache.juddi.api_v3.ClientSubscriptionInfo apiClientSubscriptionInfo = new org.apache.juddi.api_v3.ClientSubscriptionInfo();
                MappingModelToApi.mapClientSubscriptionInfo(modelClientSubscriptionInfo, apiClientSubscriptionInfo, em);
                result.getClientSubscriptionInfo().add(apiClientSubscriptionInfo);
            }
            tx.commit();
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.GET_CLIENT_SUB, QueryStatus.SUCCESS, procTime);
            ClientSubscriptionInfoDetail clientSubscriptionInfoDetail = result;
            return clientSubscriptionInfoDetail;
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.GET_CLIENT_SUB, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    public ClerkDetail saveClerk(SaveClerk body) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidateClerk(publisher).validateSaveClerk(em, body);
            ClerkDetail result = new ClerkDetail();
            List apiClerkList = body.getClerk();
            for (org.apache.juddi.api_v3.Clerk apiClerk : apiClerkList) {
                Clerk modelClerk = new Clerk();
                MappingApiToModel.mapClerk(apiClerk, modelClerk);
                Node node2 = (Node)em.find(Node.class, (Object)apiClerk.getNode().getName());
                if (node2 == null) {
                    node2 = new Node();
                    MappingApiToModel.mapNode(apiClerk.getNode(), node2);
                    em.persist((Object)node2);
                }
                modelClerk.setNode(node2.getName());
                Object existingUddiEntity = em.find(modelClerk.getClass(), (Object)modelClerk.getClerkName());
                if (existingUddiEntity != null) {
                    em.merge((Object)modelClerk);
                } else {
                    em.persist((Object)modelClerk);
                }
                result.getClerk().add(apiClerk);
            }
            tx.commit();
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.SAVE_CLERK, QueryStatus.SUCCESS, procTime);
            ClerkDetail clerkDetail = result;
            return clerkDetail;
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.SAVE_CLERK, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    public NodeDetail saveNode(SaveNode body) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidateNode(publisher).validateSaveNode(em, body);
            NodeDetail result = new NodeDetail();
            List apiNodeList = body.getNode();
            for (org.apache.juddi.api_v3.Node apiNode : apiNodeList) {
                Node modelNode = new Node();
                MappingApiToModel.mapNode(apiNode, modelNode);
                Object existingUddiEntity = em.find(modelNode.getClass(), (Object)modelNode.getName());
                if (existingUddiEntity != null) {
                    em.merge((Object)modelNode);
                } else {
                    em.persist((Object)modelNode);
                }
                result.getNode().add(apiNode);
            }
            tx.commit();
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.SAVE_NODE, QueryStatus.SUCCESS, procTime);
            NodeDetail nodeDetail = result;
            return nodeDetail;
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.SAVE_NODE, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    public SyncSubscriptionDetail invokeSyncSubscription(SyncSubscription body) throws DispositionReportFaultMessage, RemoteException {
        String subscriptionKey;
        long startTime = System.currentTimeMillis();
        SyncSubscriptionDetail syncSubscriptionDetail = new SyncSubscriptionDetail();
        HashMap<String, org.apache.juddi.api_v3.ClientSubscriptionInfo> clientSubscriptionInfoMap = new HashMap<String, org.apache.juddi.api_v3.ClientSubscriptionInfo>();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            this.getEntityPublisher(em, body.getAuthInfo());
            for (GetSubscriptionResults getSubscriptionResult : body.getGetSubscriptionResultsList()) {
                subscriptionKey = getSubscriptionResult.getSubscriptionKey();
                ClientSubscriptionInfo modelClientSubscriptionInfo = null;
                try {
                    modelClientSubscriptionInfo = (ClientSubscriptionInfo)em.find(ClientSubscriptionInfo.class, (Object)subscriptionKey);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                if (modelClientSubscriptionInfo == null) {
                    throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.SubscripKeyNotFound", subscriptionKey));
                }
                org.apache.juddi.api_v3.ClientSubscriptionInfo apiClientSubscriptionInfo = new org.apache.juddi.api_v3.ClientSubscriptionInfo();
                MappingModelToApi.mapClientSubscriptionInfo(modelClientSubscriptionInfo, apiClientSubscriptionInfo, em);
                clientSubscriptionInfoMap.put(apiClientSubscriptionInfo.getSubscriptionKey(), apiClientSubscriptionInfo);
            }
            tx.commit();
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.INVOKE_SYNCSUB, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
        for (GetSubscriptionResults getSubscriptionResult : body.getGetSubscriptionResultsList()) {
            try {
                subscriptionKey = getSubscriptionResult.getSubscriptionKey();
                org.apache.juddi.api_v3.Clerk fromClerk = ((org.apache.juddi.api_v3.ClientSubscriptionInfo)clientSubscriptionInfoMap.get(subscriptionKey)).getFromClerk();
                org.apache.juddi.api_v3.Clerk toClerk = ((org.apache.juddi.api_v3.ClientSubscriptionInfo)clientSubscriptionInfoMap.get(subscriptionKey)).getToClerk();
                String clazz = fromClerk.getNode().getProxyTransport();
                Class<?> transportClass = ClassUtil.forName(clazz, this.getClass());
                Transport transport = (Transport)transportClass.getConstructor(String.class).newInstance(fromClerk.getNode().getName());
                UDDISubscriptionPortType subscriptionService = transport.getUDDISubscriptionService(fromClerk.getNode().getSubscriptionUrl());
                SubscriptionResultsList list = subscriptionService.getSubscriptionResults(getSubscriptionResult);
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{list.getClass()});
                Marshaller marshaller = context.createMarshaller();
                StringWriter sw = new StringWriter();
                marshaller.marshal((Object)list, (Writer)sw);
                this.log.info((Object)("Notification received by UDDISubscriptionListenerService : " + sw.toString()));
                NotificationList<String> nl = NotificationList.getInstance();
                nl.getNotifications().add((Object)sw.toString());
                XRegisterHelper.handle(fromClerk, toClerk, list);
                syncSubscriptionDetail.getSubscriptionResultsList().add(list);
            }
            catch (Exception ce) {
                this.log.error((Object)ce.getMessage(), (Throwable)ce);
                long procTime = System.currentTimeMillis() - startTime;
                this.serviceCounter.update(JUDDIQuery.SAVE_NODE, QueryStatus.FAILED, procTime);
                if (ce instanceof DispositionReportFaultMessage) {
                    throw (DispositionReportFaultMessage)((Object)ce);
                }
                if (!(ce instanceof RemoteException)) continue;
                FatalErrorException x = new FatalErrorException(new ErrorMessage("errors.subscriptionnotifier.client", ce.getMessage()));
                throw x;
            }
        }
        long procTime = System.currentTimeMillis() - startTime;
        this.serviceCounter.update(JUDDIQuery.INVOKE_SYNCSUB, QueryStatus.SUCCESS, procTime);
        return syncSubscriptionDetail;
    }

    public NodeList getAllNodes(String authInfo) throws DispositionReportFaultMessage, RemoteException {
        long startTime = System.currentTimeMillis();
        NodeList r = new NodeList();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, authInfo);
            new ValidatePublish(publisher).validateGetAllNodes();
            StringBuilder sql = new StringBuilder();
            sql.append("select distinct c from Node c ");
            sql.toString();
            Query qry = em.createQuery(sql.toString());
            List resultList = qry.getResultList();
            for (int i = 0; i < resultList.size(); ++i) {
                org.apache.juddi.api_v3.Node api = new org.apache.juddi.api_v3.Node();
                MappingModelToApi.mapNode((Node)resultList.get(i), api);
                r.getNode().add(api);
            }
            tx.commit();
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.GET_ALL_NODES, QueryStatus.SUCCESS, procTime);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.GET_ALL_NODES, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
        return r;
    }

    public ClerkList getAllClerks(String authInfo) throws DispositionReportFaultMessage, RemoteException {
        long startTime = System.currentTimeMillis();
        ClerkList ret = new ClerkList();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, authInfo);
            new ValidatePublish(publisher).validateGetAllNodes();
            StringBuilder sql = new StringBuilder();
            sql.append("select distinct c from Clerk c ");
            sql.toString();
            Query qry = em.createQuery(sql.toString());
            List resultList = qry.getResultList();
            for (int i = 0; i < resultList.size(); ++i) {
                org.apache.juddi.api_v3.Clerk api = new org.apache.juddi.api_v3.Clerk();
                MappingModelToApi.mapClerk((Clerk)resultList.get(i), api, em);
                ret.getClerk().add(api);
            }
            tx.commit();
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.GET_ALL_CLERKS, QueryStatus.SUCCESS, procTime);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.GET_ALL_CLERKS, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
        return ret;
    }

    public void deleteNode(DeleteNode req) throws DispositionReportFaultMessage, RemoteException {
        long startTime = System.currentTimeMillis();
        boolean found = false;
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, req.getAuthInfo());
            new ValidatePublish(publisher).validateDeleteNode(em, req, this.getReplicationNodes(req.getAuthInfo()));
            Node existingUddiEntity = (Node)em.find(Node.class, (Object)req.getNodeID());
            if (existingUddiEntity == null) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.deleteNode.NotFound"));
            }
            Query createQuery = em.createQuery("delete from Clerk c where c.node = :nodename");
            createQuery.setParameter("nodename", (Object)req.getNodeID());
            createQuery.executeUpdate();
            em.remove((Object)existingUddiEntity);
            found = true;
            tx.commit();
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.DELETE_NODE, QueryStatus.SUCCESS, procTime);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.DELETE_NODE, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
        if (!found) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.deleteNode.NotFound", req.getNodeID()));
        }
    }

    public void deleteClerk(DeleteClerk req) throws DispositionReportFaultMessage, RemoteException {
        long startTime = System.currentTimeMillis();
        boolean found = false;
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, req.getAuthInfo());
            new ValidatePublish(publisher).validateDeleteClerk(em, req);
            Clerk existingUddiEntity = (Clerk)em.find(Clerk.class, (Object)req.getClerkID());
            if (existingUddiEntity != null) {
                em.remove((Object)existingUddiEntity);
                found = true;
            }
            tx.commit();
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.DELETE_CLERK, QueryStatus.SUCCESS, procTime);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.DELETE_CLERK, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
        if (!found) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.deleteClerk.NotFound"));
        }
    }

    public void adminDeleteSubscription(String authInfo, List<String> subscriptionKey) throws DispositionReportFaultMessage, RemoteException {
        long startTime = System.currentTimeMillis();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher requestor = this.getEntityPublisher(em, authInfo);
            if (!((Publisher)requestor).isAdmin()) {
                throw new UserMismatchException(new ErrorMessage("errors.AdminReqd"));
            }
            ArrayList<TemporaryMailContainer> notifications = new ArrayList<TemporaryMailContainer>();
            List<String> subscriptionKeyList = subscriptionKey;
            for (String key : subscriptionKeyList) {
                if (key == null || key.length() <= 0) continue;
                org.apache.juddi.model.Subscription obj = (org.apache.juddi.model.Subscription)em.find(org.apache.juddi.model.Subscription.class, (Object)key);
                Publisher publisher = (Publisher)em.find(Publisher.class, (Object)obj.getAuthorizedName());
                notifications.add(new TemporaryMailContainer(obj, publisher, (Publisher)requestor));
                em.remove((Object)obj);
            }
            tx.commit();
            for (TemporaryMailContainer t : notifications) {
                USERFRIENDLYSMTPNotifier.notifySubscriptionDeleted(t);
            }
            notifications.clear();
            notifications = null;
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.ADMIN_DELETE_SUB, QueryStatus.SUCCESS, procTime);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.ADMIN_DELETE_SUB, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    public DispositionReport adminSaveBusiness(String authInfo, List<AdminSaveBusinessWrapper> values) throws DispositionReportFaultMessage, RemoteException {
        long startTime = System.currentTimeMillis();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher requestor = this.getEntityPublisher(em, authInfo);
            if (!((Publisher)requestor).isAdmin()) {
                throw new UserMismatchException(new ErrorMessage("errors.AdminReqd"));
            }
            for (int i = 0; i < values.size(); ++i) {
                AuthToken authToken = sec.getAuthToken(values.get(i).getPublisherID());
                SaveBusiness stm = new SaveBusiness();
                stm.setAuthInfo(authToken.getAuthInfo());
                stm.getBusinessEntity().addAll(values.get(i).getBusinessEntity());
                pub.saveBusiness(stm);
            }
            tx.commit();
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.ADMIN_SAVE_BUSINESS, QueryStatus.SUCCESS, procTime);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.ADMIN_SAVE_BUSINESS, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
        DispositionReport r = new DispositionReport();
        return r;
    }

    public DispositionReport adminSaveTModel(String authInfo, List<AdminSaveTModelWrapper> values) throws DispositionReportFaultMessage, RemoteException {
        long startTime = System.currentTimeMillis();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher requestor = this.getEntityPublisher(em, authInfo);
            if (!((Publisher)requestor).isAdmin()) {
                throw new UserMismatchException(new ErrorMessage("errors.AdminReqd"));
            }
            for (int i = 0; i < values.size(); ++i) {
                AuthToken authToken = sec.getAuthToken(values.get(i).getPublisherID());
                SaveTModel stm = new SaveTModel();
                stm.setAuthInfo(authToken.getAuthInfo());
                stm.getTModel().addAll(values.get(i).getTModel());
                pub.saveTModel(stm);
            }
            tx.commit();
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.ADMIN_SAVE_TMODEL, QueryStatus.SUCCESS, procTime);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.ADMIN_SAVE_TMODEL, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
        DispositionReport r = new DispositionReport();
        return r;
    }

    public List<SubscriptionWrapper> getAllClientSubscriptionInfo(String authInfo) throws DispositionReportFaultMessage, RemoteException {
        long startTime = System.currentTimeMillis();
        ArrayList<SubscriptionWrapper> r = new ArrayList<SubscriptionWrapper>();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, authInfo);
            if (!((Publisher)publisher).isAdmin()) {
                throw new UserMismatchException(new ErrorMessage("errors.AdminReqd"));
            }
            StringBuilder sql = new StringBuilder();
            sql.append("select distinct c from Subscription c ");
            Query qry = em.createQuery(sql.toString());
            List resultList = qry.getResultList();
            for (int i = 0; i < resultList.size(); ++i) {
                Subscription sub = new Subscription();
                MappingModelToApi.mapSubscription((org.apache.juddi.model.Subscription)resultList.get(i), sub);
                SubscriptionWrapper x = new SubscriptionWrapper();
                x.getSubscription().add(sub);
                x.setPublisherIdOrUsername(((org.apache.juddi.model.Subscription)resultList.get(i)).getAuthorizedName());
                r.add(x);
            }
            tx.commit();
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.GET_ALL_CLIENT_SUB, QueryStatus.SUCCESS, procTime);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.GET_ALL_CLIENT_SUB, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
        return r;
    }

    public synchronized DispositionReport setReplicationNodes(String authInfo, ReplicationConfiguration replicationConfiguration) throws DispositionReportFaultMessage, RemoteException {
        long startTime = System.currentTimeMillis();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            ReplicationConfiguration oldConfig = null;
            UddiEntityPublisher publisher = this.getEntityPublisher(em, authInfo);
            if (!((Publisher)publisher).isAdmin()) {
                throw new UserMismatchException(new ErrorMessage("errors.AdminReqd"));
            }
            new ValidateReplication(publisher).validateSetReplicationNodes(replicationConfiguration, em, this.getNode(), AppConfig.getConfiguration());
            org.apache.juddi.model.ReplicationConfiguration model = null;
            logger.info((Object)(publisher.getAuthorizedName() + " is setting the replication config from " + this.getRequestorsIPAddress()));
            try {
                model = (org.apache.juddi.model.ReplicationConfiguration)em.createQuery("select c FROM ReplicationConfiguration c order by c.serialNumber desc").getSingleResult();
            }
            catch (Exception exception) {
                // empty catch block
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddkkmmZ");
            if (model == null) {
                model = new org.apache.juddi.model.ReplicationConfiguration();
                MappingApiToModel.mapReplicationConfiguration(replicationConfiguration, model, em);
                model.setSerialNumber(System.currentTimeMillis());
                model.setTimeOfConfigurationUpdate(sdf.format(new Date()));
                em.persist((Object)model);
            } else {
                oldConfig = new ReplicationConfiguration();
                MappingModelToApi.mapReplicationConfiguration(model, oldConfig);
                org.apache.juddi.model.ReplicationConfiguration model2 = new org.apache.juddi.model.ReplicationConfiguration();
                MappingApiToModel.mapReplicationConfiguration(replicationConfiguration, model2, em);
                model2.setSerialNumber(System.currentTimeMillis());
                model2.setTimeOfConfigurationUpdate(sdf.format(new Date()));
                em.persist((Object)model2);
            }
            tx.commit();
            UDDIReplicationImpl.notifyConfigurationChange(oldConfig, replicationConfiguration, this);
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.SET_REPLICATION_NODES, QueryStatus.SUCCESS, procTime);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.SET_REPLICATION_NODES, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        catch (Exception ex) {
            logger.error((Object)ex, (Throwable)ex);
            throw new FatalErrorException(new ErrorMessage("E_fatalError", ex.getMessage()));
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
        DispositionReport d = new DispositionReport();
        Result res = new Result();
        d.getResult().add(res);
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ReplicationConfiguration getReplicationNodes(String authInfo) throws DispositionReportFaultMessage, RemoteException {
        long startTime = System.currentTimeMillis();
        ReplicationConfiguration r = new ReplicationConfiguration();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, authInfo);
            if (!((Publisher)publisher).isAdmin()) {
                throw new UserMismatchException(new ErrorMessage("errors.AdminReqd"));
            }
            StringBuilder sql = new StringBuilder();
            sql.append("select c from ReplicationConfiguration c order by c.serialNumber desc");
            Query qry = em.createQuery(sql.toString());
            qry.setMaxResults(1);
            org.apache.juddi.model.ReplicationConfiguration resultList = (org.apache.juddi.model.ReplicationConfiguration)qry.getSingleResult();
            MappingModelToApi.mapReplicationConfiguration(resultList, r);
            tx.commit();
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.GET_ALL_NODES, QueryStatus.SUCCESS, procTime);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.GET_ALL_NODES, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        catch (Exception ex) {
            logger.debug((Object)"Error caught, is there a replication config is avaiable? Returning a default config (no replication): ", (Throwable)ex);
            r.setCommunicationGraph(new CommunicationGraph());
            Operator op = new Operator();
            op.setOperatorNodeID(this.getNode());
            op.setSoapReplicationURL(this.baseUrlSSL + "replication/services/replication");
            op.getContact().add(new Contact());
            ((Contact)op.getContact().get(0)).getPersonName().add(new PersonName("Unknown", null));
            op.setOperatorStatus(OperatorStatusType.NORMAL);
            r.getOperator().add(op);
            r.getCommunicationGraph().getNode().add(this.getNode());
            r.getCommunicationGraph().getControlledMessage().add("*");
            long procTime = System.currentTimeMillis() - startTime;
            r.setSerialNumber(0L);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddkkmmZ");
            r.setTimeOfConfigurationUpdate(sdf.format(new Date()));
            r.setRegistryContact(new ReplicationConfiguration.RegistryContact());
            try {
                int i;
                BusinessEntity rootbiz;
                if (!tx.isActive()) {
                    tx = em.getTransaction();
                }
                if ((rootbiz = (BusinessEntity)em.find(BusinessEntity.class, (Object)AppConfig.getConfiguration().getString("juddi.root.businessId"))) != null && (i = 0) < rootbiz.getContacts().size()) {
                    Contact c = new Contact();
                    MappingModelToApi.mapContact(rootbiz.getContacts().get(i), c);
                    r.getRegistryContact().setContact(c);
                }
                tx.rollback();
            }
            catch (Exception ex1) {
                logger.warn((Object)"unexpected error", (Throwable)ex1);
            }
            if (r.getRegistryContact().getContact() == null) {
                r.getRegistryContact().setContact(new Contact());
                r.getRegistryContact().getContact().getPersonName().add(new PersonName("Unknown", null));
            }
            this.serviceCounter.update(JUDDIQuery.GET_REPLICATION_NODES, QueryStatus.SUCCESS, procTime);
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
        r.setMaximumTimeToGetChanges(BigInteger.ONE);
        r.setMaximumTimeToSyncRegistry(BigInteger.ONE);
        return r;
    }

    public void adminSaveSubscription(String authInfo, String publisherOrUsername, Holder<List<Subscription>> subscriptions) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher requestor = this.getEntityPublisher(em, authInfo);
            if (!((Publisher)requestor).isAdmin()) {
                throw new UserMismatchException(new ErrorMessage("errors.AdminReqd"));
            }
            AuthToken authToken = sec.getAuthToken(publisherOrUsername);
            sub.saveSubscription(authToken.getAuthInfo(), subscriptions);
            tx.commit();
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.ADMIN_SAVE_SUB, QueryStatus.SUCCESS, procTime);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.ADMIN_SAVE_SUB, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    public GetEntityHistoryMessageResponse getEntityHistory(GetEntityHistoryMessageRequest body) throws DispositionReportFaultMessage, RemoteException {
        long startTime = System.currentTimeMillis();
        if (body == null) {
            throw new InvalidValueException(new ErrorMessage("errors.NullInput"));
        }
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher requestor = this.getEntityPublisher(em, body.getAuthInfo());
            if (!((Publisher)requestor).isAdmin()) {
                throw new UserMismatchException(new ErrorMessage("errors.AdminReqd"));
            }
            if (body.getMaxRecords() <= 0L) {
                body.setMaxRecords(20L);
            }
            if (body.getOffset() < 0L) {
                body.setOffset(0L);
            }
            Query createQuery = em.createQuery("select m from ChangeRecord m where m.entityKey = :key order by m.id DESC");
            createQuery.setMaxResults((int)body.getMaxRecords());
            createQuery.setParameter("key", (Object)body.getEntityKey());
            createQuery.setFirstResult((int)body.getOffset());
            List resultList = createQuery.getResultList();
            GetEntityHistoryMessageResponse res = new GetEntityHistoryMessageResponse();
            res.setChangeRecords(new ChangeRecords());
            for (ChangeRecord cr : resultList) {
                res.getChangeRecords().getChangeRecord().add(MappingModelToApi.mapChangeRecord(cr));
            }
            tx.rollback();
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.ADMIN_GET_HISTORY, QueryStatus.SUCCESS, procTime);
            GetEntityHistoryMessageResponse getEntityHistoryMessageResponse = res;
            return getEntityHistoryMessageResponse;
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.ADMIN_GET_HISTORY, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    public GetFailedReplicationChangeRecordsMessageResponse getFailedReplicationChangeRecords(GetFailedReplicationChangeRecordsMessageRequest body) throws DispositionReportFaultMessage, RemoteException {
        long startTime = System.currentTimeMillis();
        if (body == null) {
            throw new InvalidValueException(new ErrorMessage("errors.NullInput"));
        }
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher requestor = this.getEntityPublisher(em, body.getAuthInfo());
            if (!((Publisher)requestor).isAdmin()) {
                throw new UserMismatchException(new ErrorMessage("errors.AdminReqd"));
            }
            if (body.getMaxRecords() <= 0L) {
                body.setMaxRecords(20L);
            }
            if (body.getOffset() < 0L) {
                body.setOffset(0L);
            }
            Query createQuery = em.createQuery("select m from ChangeRecord m where m.isAppliedLocally=false order by m.id DESC ");
            createQuery.setMaxResults((int)body.getMaxRecords());
            createQuery.setFirstResult((int)body.getOffset());
            List resultList = createQuery.getResultList();
            GetFailedReplicationChangeRecordsMessageResponse res = new GetFailedReplicationChangeRecordsMessageResponse();
            res.setChangeRecords(new ChangeRecords());
            for (ChangeRecord cr : resultList) {
                res.getChangeRecords().getChangeRecord().add(MappingModelToApi.mapChangeRecord(cr));
            }
            tx.rollback();
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.ADMIN_GET_FAILED_CRS, QueryStatus.SUCCESS, procTime);
            GetFailedReplicationChangeRecordsMessageResponse getFailedReplicationChangeRecordsMessageResponse = res;
            return getFailedReplicationChangeRecordsMessageResponse;
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(JUDDIQuery.ADMIN_GET_FAILED_CRS, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }
}

