/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.api.impl;

import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import javax.xml.bind.JAXB;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.ws.BindingProvider;
import org.apache.juddi.api.impl.AuthenticatedService;
import org.apache.juddi.api.impl.ServiceCounterLifecycleResource;
import org.apache.juddi.api.impl.UDDICustodyTransferImpl;
import org.apache.juddi.api.impl.UDDIPublicationImpl;
import org.apache.juddi.api.impl.UDDIServiceCounter;
import org.apache.juddi.api.util.QueryStatus;
import org.apache.juddi.api.util.ReplicationQuery;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.config.PersistenceManager;
import org.apache.juddi.mapping.MappingApiToModel;
import org.apache.juddi.mapping.MappingModelToApi;
import org.apache.juddi.model.BindingTemplate;
import org.apache.juddi.model.BusinessEntity;
import org.apache.juddi.model.BusinessService;
import org.apache.juddi.model.ChangeRecord;
import org.apache.juddi.model.Operator;
import org.apache.juddi.model.PublisherAssertion;
import org.apache.juddi.model.PublisherAssertionId;
import org.apache.juddi.model.ReplicationConfiguration;
import org.apache.juddi.model.Tmodel;
import org.apache.juddi.model.UddiEntity;
import org.apache.juddi.replication.ReplicationNotifier;
import org.apache.juddi.v3.client.UDDIService;
import org.apache.juddi.v3.client.cryptor.TransportSecurityHelper;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.FatalErrorException;
import org.apache.juddi.v3.error.TransferNotAllowedException;
import org.apache.juddi.validation.ValidateReplication;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.uddi.custody_v3.TransferEntities;
import org.uddi.repl_v3.ChangeRecordAcknowledgement;
import org.uddi.repl_v3.ChangeRecordIDType;
import org.uddi.repl_v3.ChangeRecords;
import org.uddi.repl_v3.CommunicationGraph;
import org.uddi.repl_v3.DoPing;
import org.uddi.repl_v3.GetChangeRecords;
import org.uddi.repl_v3.HighWaterMarkVectorType;
import org.uddi.repl_v3.NotifyChangeRecordsAvailable;
import org.uddi.repl_v3.TransferCustody;
import org.uddi.v3_service.DispositionReportFaultMessage;
import org.uddi.v3_service.UDDIReplicationPortType;
import org.w3._2000._09.xmldsig_.ObjectFactory;

@WebService(serviceName="UDDI_Replication_PortType", targetNamespace="urn:uddi-org:api_v3_portType", endpointInterface="org.uddi.v3_service.UDDIReplicationPortType")
@XmlSeeAlso(value={org.uddi.custody_v3.ObjectFactory.class, org.uddi.repl_v3.ObjectFactory.class, org.uddi.subr_v3.ObjectFactory.class, org.uddi.api_v3.ObjectFactory.class, org.uddi.vscache_v3.ObjectFactory.class, org.uddi.vs_v3.ObjectFactory.class, org.uddi.sub_v3.ObjectFactory.class, ObjectFactory.class, org.uddi.policy_v3.ObjectFactory.class, org.uddi.policy_v3_instanceparms.ObjectFactory.class})
public class UDDIReplicationImpl
extends AuthenticatedService
implements UDDIReplicationPortType {
    private UDDIServiceCounter serviceCounter;
    private static PullTimerTask timer = null;
    private long startBuffer;
    private long interval;
    private static UDDIPublicationImpl pub = null;
    private Map<String, UDDIReplicationPortType> cache = new HashMap<String, UDDIReplicationPortType>();
    private static Queue<NotifyChangeRecordsAvailable> queue = null;

    static void notifyConfigurationChange(org.uddi.repl_v3.ReplicationConfiguration oldConfig, org.uddi.repl_v3.ReplicationConfiguration newConfig, AuthenticatedService service) {
        Set<String> oldnodes = UDDIReplicationImpl.getNodes(oldConfig);
        Set<String> newNodes = UDDIReplicationImpl.getNodes(newConfig);
        Set<String> addedNodes = UDDIReplicationImpl.diffNodeList(oldnodes, newNodes);
        if (queue == null) {
            queue = new ConcurrentLinkedQueue<NotifyChangeRecordsAvailable>();
        }
        for (String s : addedNodes) {
            if (s.equals(service.getNode())) continue;
            logger.info((Object)("This node: " + service.getNode() + ". New replication node queue for synchronization: " + s));
            HighWaterMarkVectorType highWaterMarkVectorType = new HighWaterMarkVectorType();
            highWaterMarkVectorType.getHighWaterMark().add(new ChangeRecordIDType(s, Long.valueOf(0L)));
            queue.add(new NotifyChangeRecordsAvailable(s, highWaterMarkVectorType));
        }
    }

    private static Set<String> getNodes(org.uddi.repl_v3.ReplicationConfiguration oldConfig) {
        HashSet<String> ret = new HashSet<String>();
        if (oldConfig == null) {
            return ret;
        }
        for (org.uddi.repl_v3.Operator o : oldConfig.getOperator()) {
            ret.add(o.getOperatorNodeID());
        }
        if (oldConfig.getCommunicationGraph() != null) {
            ret.addAll(oldConfig.getCommunicationGraph().getNode());
        }
        return ret;
    }

    private static Set<String> diffNodeList(Set<String> oldnodes, Set<String> newNodes) {
        HashSet<String> diff = new HashSet<String>();
        for (String lhs : newNodes) {
            Iterator<String> iterator1 = oldnodes.iterator();
            boolean found = false;
            while (iterator1.hasNext()) {
                String rhs = iterator1.next();
                if (!rhs.equalsIgnoreCase(lhs)) continue;
                found = true;
                break;
            }
            if (found) continue;
            diff.add(lhs);
        }
        return diff;
    }

    public UDDIReplicationImpl() {
        try {
            this.interval = AppConfig.getConfiguration().getLong("juddi.replication.interval", 5000L);
            this.startBuffer = AppConfig.getConfiguration().getLong("juddi.replication.start.buffer", 5000L);
        }
        catch (Exception ex) {
            logger.warn((Object)"Config error!", (Throwable)ex);
        }
        this.serviceCounter = ServiceCounterLifecycleResource.getServiceCounter(UDDIReplicationImpl.class);
        this.init();
    }

    private synchronized void init() {
        if (pub == null) {
            pub = new UDDIPublicationImpl();
        }
        if (queue == null) {
            queue = new ConcurrentLinkedQueue<NotifyChangeRecordsAvailable>();
        }
        timer = new PullTimerTask();
    }

    private static void validateNodeIdMisMatches(UddiEntity ue, String node) throws Exception {
        if (ue == null) {
            return;
        }
        if (ue.getNodeId().equals(node)) {
            throw new Exception("Alert! attempt to alter locally owned entity " + ue.getEntityKey() + " owned by " + ue.getAuthorizedName() + "@" + ue.getNodeId());
        }
    }

    private void validateNodeIdMatches(String newNodeId, String currentOwningNode) throws Exception {
        if (newNodeId == null || currentOwningNode == null) {
            throw new Exception("either the local node ID is null or the inbound replication data's node id is null");
        }
        if (!newNodeId.equals(currentOwningNode)) {
            logger.info((Object)("AUDIT, custody transfer from node, " + currentOwningNode + " to " + newNodeId + " current node is " + this.getNode()));
        }
        if (newNodeId.equals(this.getNode())) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized UDDIReplicationPortType getReplicationClient(String node) {
        if (this.cache.containsKey(node)) {
            return this.cache.get(node);
        }
        UDDIService svc = new UDDIService();
        UDDIReplicationPortType replicationClient = svc.getUDDIReplicationPort();
        TransportSecurityHelper.applyTransportSecurity((BindingProvider)((BindingProvider)replicationClient));
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            StringBuilder sql = new StringBuilder();
            sql.append("select c from ReplicationConfiguration c order by c.serialNumber desc");
            Query qry = em.createQuery(sql.toString());
            qry.setMaxResults(1);
            ReplicationConfiguration resultList = (ReplicationConfiguration)qry.getSingleResult();
            for (Operator o : resultList.getOperator()) {
                if (!o.getOperatorNodeID().equalsIgnoreCase(node)) continue;
                ((BindingProvider)replicationClient).getRequestContext().put("javax.xml.ws.service.endpoint.address", o.getSoapReplicationURL());
                this.cache.put(node, replicationClient);
                UDDIReplicationPortType uDDIReplicationPortType = replicationClient;
                return uDDIReplicationPortType;
            }
            tx.rollback();
        }
        catch (Exception ex) {
            logger.fatal((Object)("Node not found!" + node), (Throwable)ex);
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
        return null;
    }

    public String doPing(DoPing body) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        long procTime = System.currentTimeMillis() - startTime;
        this.serviceCounter.update(ReplicationQuery.DO_PING, QueryStatus.SUCCESS, procTime);
        return this.getNode();
    }

    @SOAPBinding(parameterStyle=SOAPBinding.ParameterStyle.BARE)
    @WebResult(name="changeRecords", targetNamespace="urn:uddi-org:repl_v3", partName="body")
    public ChangeRecords getChangeRecords(@WebParam(partName="body", name="get_changeRecords", targetNamespace="urn:uddi-org:repl_v3") GetChangeRecords body) throws DispositionReportFaultMessage, RemoteException {
        long startTime = System.currentTimeMillis();
        String requestingNode = body.getRequestingNode();
        HighWaterMarkVectorType changesAlreadySeen = body.getChangesAlreadySeen();
        BigInteger responseLimitCount = body.getResponseLimitCount();
        HighWaterMarkVectorType responseLimitVector = body.getResponseLimitVector();
        new ValidateReplication(null).validateGetChangeRecords(requestingNode, changesAlreadySeen, responseLimitCount, responseLimitVector, ReplicationNotifier.FetchEdges(), this.ctx);
        ArrayList<org.uddi.repl_v3.ChangeRecord> ret = new ArrayList<org.uddi.repl_v3.ChangeRecord>();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            int maxrecords = AppConfig.getConfiguration().getInt("juddi.replication.getChangeRecordsMax", 100);
            if (responseLimitCount != null) {
                maxrecords = responseLimitCount.intValue();
            }
            tx.begin();
            Long firstrecord = 0L;
            Object lastrecord = null;
            Query createQuery = null;
            if (changesAlreadySeen != null) {
                for (int i = 0; i < changesAlreadySeen.getHighWaterMark().size(); ++i) {
                    firstrecord = ((ChangeRecordIDType)changesAlreadySeen.getHighWaterMark().get(i)).getOriginatingUSN();
                    if (firstrecord == null) {
                        firstrecord = 0L;
                    }
                    createQuery = ((ChangeRecordIDType)changesAlreadySeen.getHighWaterMark().get(i)).getNodeID().equals(this.getNode()) ? em.createQuery("select e from ChangeRecord e where (e.id > :inbound AND e.nodeID = :node) order by e.id ASC") : em.createQuery("select e from ChangeRecord e where e.originatingUSN > :inbound AND e.nodeID = :node order by e.originatingUSN ASC");
                    logger.info((Object)("Query db for replication changes, lower index is " + firstrecord + " last index " + lastrecord + " record limit " + maxrecords));
                    logger.info((Object)("This node is " + this.getNode() + ", request is for data originated from " + ((ChangeRecordIDType)changesAlreadySeen.getHighWaterMark().get(i)).getNodeID() + " and it's being sent back to " + requestingNode));
                    createQuery.setMaxResults(maxrecords);
                    createQuery.setParameter("inbound", (Object)firstrecord);
                    createQuery.setParameter("node", (Object)((ChangeRecordIDType)changesAlreadySeen.getHighWaterMark().get(i)).getNodeID());
                    List records = createQuery.getResultList();
                    logger.info((Object)(records.size() + " CR records returned from query"));
                    for (int x = 0; x < records.size(); ++x) {
                        org.uddi.repl_v3.ChangeRecord r = MappingModelToApi.mapChangeRecord((ChangeRecord)records.get(x));
                        ret.add(r);
                    }
                }
            } else {
                if (firstrecord == null) {
                    firstrecord = 0L;
                }
                logger.info((Object)("Query db for replication changes, lower index is " + firstrecord + " last index " + lastrecord + " record limit " + maxrecords));
                logger.info((Object)("This node is " + this.getNode() + " requesting node " + requestingNode));
                if (lastrecord != null) {
                    createQuery = em.createQuery("select e from ChangeRecord e where (e.id > :inbound AND e.nodeID = :node AND e.id < :lastrecord) order by e.id ASC");
                    createQuery.setParameter("lastrecord", lastrecord);
                } else {
                    createQuery = em.createQuery("select e from ChangeRecord e where (e.id > :inbound AND e.nodeID = :node) order by e.id ASC");
                }
                createQuery.setMaxResults(maxrecords);
                createQuery.setParameter("inbound", (Object)firstrecord);
                createQuery.setParameter("node", (Object)this.getNode());
                List records = createQuery.getResultList();
                logger.info((Object)(records.size() + " CR records returned from query"));
                for (int i = 0; i < records.size(); ++i) {
                    org.uddi.repl_v3.ChangeRecord r = MappingModelToApi.mapChangeRecord((ChangeRecord)records.get(i));
                    ret.add(r);
                }
            }
            tx.rollback();
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(ReplicationQuery.GET_CHANGERECORDS, QueryStatus.SUCCESS, procTime);
        }
        catch (Exception ex) {
            logger.fatal((Object)("Error, this node is: " + this.getNode()), (Throwable)ex);
            throw new FatalErrorException(new ErrorMessage("E_fatalError", ex.getMessage()));
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
        logger.info((Object)("Change records returned for " + requestingNode + ": " + ret.size()));
        ChangeRecords x = new ChangeRecords();
        x.getChangeRecord().addAll(ret);
        return x;
    }

    public List<ChangeRecordIDType> getHighWaterMarks() throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        ArrayList<ChangeRecordIDType> ret = new ArrayList<ChangeRecordIDType>();
        org.uddi.repl_v3.ReplicationConfiguration FetchEdges = ReplicationNotifier.FetchEdges();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        HashMap<String, Long> map = new HashMap<String, Long>();
        try {
            Long id;
            tx.begin();
            if (FetchEdges != null) {
                for (String nextNode : FetchEdges.getCommunicationGraph().getNode()) {
                    if (nextNode.equals(this.getNode()) || map.containsKey(nextNode)) continue;
                    Long id2 = 0L;
                    try {
                        id2 = (Long)em.createQuery("select e.originatingUSN from ChangeRecord e where e.nodeID = :node order by e.originatingUSN desc").setParameter("node", (Object)nextNode).setMaxResults(1).getSingleResult();
                    }
                    catch (Exception ex) {
                        logger.debug((Object)ex);
                    }
                    if (id2 == null) {
                        id2 = 0L;
                    }
                    map.put(nextNode, id2);
                }
            }
            if ((id = (Long)em.createQuery("select (e.id) from ChangeRecord e where e.nodeID = :node  order by e.id desc").setParameter("node", (Object)this.getNode()).setMaxResults(1).getSingleResult()) == null) {
                id = 0L;
            }
            ChangeRecordIDType x = new ChangeRecordIDType();
            x.setNodeID(this.getNode());
            x.setOriginatingUSN(id);
            ret.add(x);
            tx.rollback();
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(ReplicationQuery.GET_HIGHWATERMARKS, QueryStatus.SUCCESS, procTime);
        }
        catch (Exception drfm) {
            throw new FatalErrorException(new ErrorMessage("E_fatalError", drfm.getMessage()));
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
        for (Map.Entry next : map.entrySet()) {
            ret.add(new ChangeRecordIDType((String)next.getKey(), (Long)next.getValue()));
        }
        return ret;
    }

    public void notifyChangeRecordsAvailable(NotifyChangeRecordsAvailable body) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        new ValidateReplication(null).validateNotifyChangeRecordsAvailable(body, this.ctx);
        logger.info((Object)(body.getNotifyingNode() + " just told me that there are change records available, enqueuing...size is " + queue.size() + " this node is " + this.getNode()));
        queue.add(body);
        long procTime = System.currentTimeMillis() - startTime;
        this.serviceCounter.update(ReplicationQuery.NOTIFY_CHANGERECORDSAVAILABLE, QueryStatus.SUCCESS, procTime);
    }

    public void transferCustody(TransferCustody body) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        logger.info((Object)"Inbound transfer request (via replication api, node to node");
        try {
            tx.begin();
            boolean ok = false;
            org.uddi.repl_v3.ReplicationConfiguration FetchEdges = ReplicationNotifier.FetchEdges();
            if (FetchEdges != null) {
                for (int i = 0; i < FetchEdges.getOperator().size(); ++i) {
                    if (!((org.uddi.repl_v3.Operator)FetchEdges.getOperator().get(i)).getOperatorNodeID().equals(body.getTransferOperationalInfo().getNodeID())) continue;
                    ok = true;
                    break;
                }
            }
            if (!ok) {
                throw new TransferNotAllowedException(new ErrorMessage("E_transferNotAllowedUnknownNode"));
            }
            new ValidateReplication(null).validateTransfer(em, body);
            TransferEntities te = new TransferEntities();
            te.setKeyBag(body.getKeyBag());
            te.setTransferToken(body.getTransferToken());
            te.setAuthInfo(null);
            logger.debug((Object)"request validated, processing transfer");
            List<org.uddi.repl_v3.ChangeRecord> executeTransfer = new UDDICustodyTransferImpl().executeTransfer(te, em, body.getTransferOperationalInfo().getAuthorizedName(), body.getTransferOperationalInfo().getNodeID());
            for (org.uddi.repl_v3.ChangeRecord c : executeTransfer) {
                try {
                    c.setChangeID(new ChangeRecordIDType());
                    c.getChangeID().setNodeID(this.getNode());
                    c.getChangeID().setOriginatingUSN(null);
                    ReplicationNotifier.enqueue(MappingApiToModel.mapChangeRecord(c));
                }
                catch (UnsupportedEncodingException ex) {
                    logger.error((Object)"", (Throwable)ex);
                }
            }
            tx.commit();
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(ReplicationQuery.TRANSFER_CUSTODY, QueryStatus.SUCCESS, procTime);
        }
        catch (DispositionReportFaultMessage d) {
            logger.error((Object)"Unable to process node to node custody transfer ", (Throwable)d);
            throw d;
        }
        finally {
            if (em != null && em.isOpen()) {
                em.close();
            }
            if (tx.isActive()) {
                tx.rollback();
            }
        }
    }

    private class PullTimerTask
    extends TimerTask {
        private Timer timer = new Timer(true);
        boolean firstrun = true;

        public PullTimerTask() {
            this.timer.scheduleAtFixedRate((TimerTask)this, UDDIReplicationImpl.this.startBuffer, UDDIReplicationImpl.this.interval);
        }

        @Override
        public void run() {
            if (this.firstrun) {
                this.enqueueAllReceivingNodes();
                this.firstrun = false;
            }
            if (!queue.isEmpty()) {
                AuthenticatedService.logger.info((Object)("Replication change puller thread started. Queue size: " + queue.size()));
            }
            while (!queue.isEmpty()) {
                NotifyChangeRecordsAvailable poll = (NotifyChangeRecordsAvailable)queue.poll();
                if (poll != null && !poll.getNotifyingNode().equalsIgnoreCase(UDDIReplicationImpl.this.getNode())) {
                    UDDIReplicationPortType replicationClient = UDDIReplicationImpl.this.getReplicationClient(poll.getNotifyingNode());
                    if (replicationClient == null) {
                        AuthenticatedService.logger.fatal((Object)("unable to obtain a replication client to node " + poll));
                        continue;
                    }
                    try {
                        HashSet<String> nodesHitThisCycle = new HashSet<String>();
                        block3: for (int xx = 0; xx < poll.getChangesAvailable().getHighWaterMark().size(); ++xx) {
                            int recordsreturned = 21;
                            while (recordsreturned >= 20) {
                                if (nodesHitThisCycle.contains(((ChangeRecordIDType)poll.getChangesAvailable().getHighWaterMark().get(xx)).getNodeID())) {
                                    AuthenticatedService.logger.info((Object)("i've already hit the node " + ((ChangeRecordIDType)poll.getChangesAvailable().getHighWaterMark().get(xx)).getNodeID() + " this cycle, skipping"));
                                    continue block3;
                                }
                                if (((ChangeRecordIDType)poll.getChangesAvailable().getHighWaterMark().get(xx)).getNodeID().equalsIgnoreCase(UDDIReplicationImpl.this.getNode())) {
                                    AuthenticatedService.logger.info((Object)("ignoring updates that were generated here " + ((ChangeRecordIDType)poll.getChangesAvailable().getHighWaterMark().get(xx)).getOriginatingUSN() + " sent by " + poll.getNotifyingNode() + " this node is " + UDDIReplicationImpl.this.getNode()));
                                    continue block3;
                                }
                                nodesHitThisCycle.add(((ChangeRecordIDType)poll.getChangesAvailable().getHighWaterMark().get(xx)).getNodeID());
                                GetChangeRecords body = new GetChangeRecords();
                                body.setRequestingNode(UDDIReplicationImpl.this.getNode());
                                body.setResponseLimitCount(BigInteger.valueOf(100L));
                                body.setChangesAlreadySeen(this.getLastChangeRecordFrom(((ChangeRecordIDType)poll.getChangesAvailable().getHighWaterMark().get(xx)).getNodeID()));
                                AuthenticatedService.logger.info((Object)("fetching updates from " + poll.getNotifyingNode() + " since " + ((ChangeRecordIDType)body.getChangesAlreadySeen().getHighWaterMark().get(0)).getNodeID() + ":" + ((ChangeRecordIDType)body.getChangesAlreadySeen().getHighWaterMark().get(0)).getOriginatingUSN() + ", items still in the queue: " + queue.size()));
                                List records = replicationClient.getChangeRecords(body).getChangeRecord();
                                AuthenticatedService.logger.info((Object)("Change records retrieved from " + poll.getNotifyingNode() + ", " + records.size()));
                                for (int i = 0; i < records.size(); ++i) {
                                    AuthenticatedService.logger.info((Object)("Change records retrieved " + ((org.uddi.repl_v3.ChangeRecord)records.get(i)).getChangeID().getNodeID() + " USN " + ((org.uddi.repl_v3.ChangeRecord)records.get(i)).getChangeID().getOriginatingUSN()));
                                    this.persistChangeRecord((org.uddi.repl_v3.ChangeRecord)records.get(i));
                                }
                                recordsreturned = records.size();
                            }
                        }
                        continue;
                    }
                    catch (Exception ex) {
                        AuthenticatedService.logger.error((Object)("Error caught fetching replication changes from " + poll + " @" + ((BindingProvider)replicationClient).getRequestContext().get("javax.xml.ws.service.endpoint.address")), (Throwable)ex);
                        continue;
                    }
                }
                if (poll == null) {
                    AuthenticatedService.logger.warn((Object)"strange, popped a null object");
                    continue;
                }
                if (!poll.getNotifyingNode().equalsIgnoreCase(UDDIReplicationImpl.this.getNode())) continue;
                AuthenticatedService.logger.warn((Object)("strange, popped an object from the queue but it was from myself. This probably indicates a configuration error! ignoring...first record: " + ((ChangeRecordIDType)poll.getChangesAvailable().getHighWaterMark().get(0)).getNodeID() + ":" + ((ChangeRecordIDType)poll.getChangesAvailable().getHighWaterMark().get(0)).getOriginatingUSN()));
            }
        }

        @Override
        public boolean cancel() {
            this.timer.cancel();
            return super.cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void persistChangeRecord(org.uddi.repl_v3.ChangeRecord rec) {
            if (rec == null) {
                return;
            }
            AuthenticatedService.logger.debug((Object)("_______________________Remote change request " + rec.getChangeID().getNodeID() + ":" + rec.getChangeID().getOriginatingUSN()));
            if (rec.getChangeID().getNodeID().equalsIgnoreCase(UDDIReplicationImpl.this.getNode())) {
                AuthenticatedService.logger.info((Object)"Just received a change record that i created, ignoring....");
                return;
            }
            EntityManager em = PersistenceManager.getEntityManager();
            EntityTransaction tx = em.getTransaction();
            ChangeRecord mapChangeRecord = null;
            try {
                PersistenceCapable model;
                BusinessEntity find;
                BindingTemplate bt;
                UddiEntity model2;
                tx.begin();
                Query createQuery = em.createQuery("select c from ChangeRecord c where c.nodeID=:node and c.originatingUSN=:oid");
                createQuery.setParameter("node", (Object)rec.getChangeID().getNodeID());
                createQuery.setParameter("oid", (Object)rec.getChangeID().getOriginatingUSN());
                Object existingrecord = null;
                try {
                    existingrecord = createQuery.getSingleResult();
                }
                catch (Exception ex) {
                    AuthenticatedService.logger.debug((Object)"error checking to see if change record exists already (expected failure)", (Throwable)ex);
                }
                if (existingrecord != null) {
                    AuthenticatedService.logger.info((Object)("I've already processed change record " + rec.getChangeID().getNodeID() + " " + rec.getChangeID().getOriginatingUSN()));
                    return;
                }
                ReplicationNotifier.EnqueueRetransmit(rec);
                mapChangeRecord = MappingApiToModel.mapChangeRecord(rec);
                mapChangeRecord.setId(null);
                mapChangeRecord.setIsAppliedLocally(true);
                em.persist((Object)mapChangeRecord);
                tx.commit();
                AuthenticatedService.logger.info((Object)("Remote CR saved, it was from " + mapChangeRecord.getNodeID() + " USN:" + mapChangeRecord.getOriginatingUSN() + " Type:" + mapChangeRecord.getRecordType().name() + " Key:" + mapChangeRecord.getEntityKey() + " Local id from sender:" + mapChangeRecord.getId()));
                tx = em.getTransaction();
                tx.begin();
                if (rec.getChangeRecordDelete() != null) {
                    UddiEntity ue;
                    if (rec.getChangeRecordDelete() != null && rec.getChangeRecordDelete().getBindingKey() != null && !"".equalsIgnoreCase(rec.getChangeRecordDelete().getBindingKey())) {
                        ue = (UddiEntity)em.find(BindingTemplate.class, (Object)rec.getChangeRecordDelete().getBindingKey());
                        UDDIReplicationImpl.validateNodeIdMisMatches(ue, UDDIReplicationImpl.this.getNode());
                        pub.deleteBinding(rec.getChangeRecordDelete().getBindingKey(), em);
                    }
                    if (rec.getChangeRecordDelete() != null && rec.getChangeRecordDelete().getBusinessKey() != null && !"".equalsIgnoreCase(rec.getChangeRecordDelete().getBusinessKey())) {
                        ue = (UddiEntity)em.find(BusinessEntity.class, (Object)rec.getChangeRecordDelete().getBusinessKey());
                        UDDIReplicationImpl.validateNodeIdMisMatches(ue, UDDIReplicationImpl.this.getNode());
                        pub.deleteBusiness(rec.getChangeRecordDelete().getBusinessKey(), em);
                    }
                    if (rec.getChangeRecordDelete() != null && rec.getChangeRecordDelete().getServiceKey() != null && !"".equalsIgnoreCase(rec.getChangeRecordDelete().getServiceKey())) {
                        ue = (UddiEntity)em.find(BusinessService.class, (Object)rec.getChangeRecordDelete().getServiceKey());
                        UDDIReplicationImpl.validateNodeIdMisMatches(ue, UDDIReplicationImpl.this.getNode());
                        pub.deleteService(rec.getChangeRecordDelete().getServiceKey(), em);
                    }
                    if (rec.getChangeRecordDelete() != null && rec.getChangeRecordDelete().getTModelKey() != null && !"".equalsIgnoreCase(rec.getChangeRecordDelete().getTModelKey())) {
                        UddiEntity tm = (UddiEntity)em.find(Tmodel.class, (Object)rec.getChangeRecordDelete().getTModelKey());
                        if (tm != null) {
                            UDDIReplicationImpl.validateNodeIdMisMatches(tm, UDDIReplicationImpl.this.getNode());
                            em.remove((Object)tm);
                        } else {
                            AuthenticatedService.logger.error((Object)("failed to adminstratively delete tmodel because it doesn't exist. " + rec.getChangeRecordDelete().getTModelKey()));
                        }
                    }
                }
                if (rec.getChangeRecordDeleteAssertion() != null && rec.getChangeRecordDeleteAssertion().getPublisherAssertion() != null) {
                    pub.deletePublisherAssertion(rec.getChangeRecordDeleteAssertion(), em);
                }
                if (rec.getChangeRecordNewData() != null) {
                    if (rec.getChangeRecordNewData().getOperationalInfo() == null) {
                        AuthenticatedService.logger.warn((Object)"Inbound replication data does not have the required OperationalInfo element and is NOT spec compliant. Data will be ignored");
                    } else {
                        if (rec.getChangeRecordNewData().getOperationalInfo().getNodeID() == null) {
                            throw new Exception("Inbound replication data is missiong node id! Change will not be applied");
                        }
                        if (rec.getChangeRecordNewData().getOperationalInfo().getNodeID().equalsIgnoreCase(UDDIReplicationImpl.this.getNode())) {
                            AuthenticatedService.logger.warn((Object)"Inbound replication data is modifying locally owned data. This is not allowed, except for custody transfer");
                        }
                        if (rec.getChangeRecordNewData().getBindingTemplate() != null) {
                            model2 = (BusinessService)em.find(BusinessService.class, (Object)rec.getChangeRecordNewData().getBindingTemplate().getServiceKey());
                            if (model2 == null) {
                                AuthenticatedService.logger.error((Object)"Replication error, attempting to insert a binding where the service doesn't exist yet");
                            } else {
                                UDDIReplicationImpl.this.validateNodeIdMatches(rec.getChangeRecordNewData().getOperationalInfo().getNodeID(), model2.getNodeId());
                                bt = (BindingTemplate)em.find(BindingTemplate.class, (Object)rec.getChangeRecordNewData().getBindingTemplate().getBindingKey());
                                if (bt != null) {
                                    em.remove((Object)bt);
                                }
                                bt = new BindingTemplate();
                                MappingApiToModel.mapBindingTemplate(rec.getChangeRecordNewData().getBindingTemplate(), bt, (BusinessService)model2);
                                MappingApiToModel.mapOperationalInfo(bt, rec.getChangeRecordNewData().getOperationalInfo());
                                em.persist((Object)bt);
                            }
                        } else if (rec.getChangeRecordNewData().getBusinessEntity() != null) {
                            model2 = (BusinessEntity)em.find(BusinessEntity.class, (Object)rec.getChangeRecordNewData().getBusinessEntity().getBusinessKey());
                            if (model2 != null) {
                                if (rec.getChangeRecordNewData().getOperationalInfo().getNodeID().equals(UDDIReplicationImpl.this.getNode()) && !model2.getNodeId().equals(UDDIReplicationImpl.this.getNode())) {
                                    if (!model2.getIsTransferInProgress()) throw new Exception("Unexpected entity transfer to to node " + UDDIReplicationImpl.this.getNode() + " from " + rec.getChangeID().getNodeID());
                                    MappingApiToModel.mapBusinessEntity(rec.getChangeRecordNewData().getBusinessEntity(), (BusinessEntity)model2);
                                    MappingApiToModel.mapOperationalInfo(model2, rec.getChangeRecordNewData().getOperationalInfo());
                                    MappingApiToModel.mapOperationalInfoIncludingChildren((BusinessEntity)model2, rec.getChangeRecordNewData().getOperationalInfo());
                                    model2.setIsTransferInProgress(false);
                                    em.merge((Object)model2);
                                } else {
                                    if (rec.getChangeRecordNewData().getOperationalInfo().getNodeID().equals(UDDIReplicationImpl.this.getNode()) && model2.getNodeId().equals(UDDIReplicationImpl.this.getNode())) {
                                        throw new Exception("unexpected modification of records that this server owns, " + model2.getEntityKey());
                                    }
                                    if (!rec.getChangeRecordNewData().getOperationalInfo().getNodeID().equals(UDDIReplicationImpl.this.getNode()) && model2.getNodeId().equals(UDDIReplicationImpl.this.getNode())) {
                                        throw new Exception("unexpected transfer from this node to elsewhere, possible that the key in question exists at two places prior to replication sync, " + model2.getEntityKey());
                                    }
                                    if (!rec.getChangeRecordNewData().getOperationalInfo().getNodeID().equals(UDDIReplicationImpl.this.getNode()) && !model2.getNodeId().equals(UDDIReplicationImpl.this.getNode())) {
                                        MappingApiToModel.mapBusinessEntity(rec.getChangeRecordNewData().getBusinessEntity(), (BusinessEntity)model2);
                                        MappingApiToModel.mapOperationalInfoIncludingChildren((BusinessEntity)model2, rec.getChangeRecordNewData().getOperationalInfo());
                                        em.merge((Object)model2);
                                    }
                                }
                            } else {
                                model2 = new BusinessEntity();
                                MappingApiToModel.mapBusinessEntity(rec.getChangeRecordNewData().getBusinessEntity(), (BusinessEntity)model2);
                                MappingApiToModel.mapOperationalInfoIncludingChildren((BusinessEntity)model2, rec.getChangeRecordNewData().getOperationalInfo());
                                em.persist((Object)model2);
                            }
                        }
                        if (rec.getChangeRecordNewData().getBusinessService() != null) {
                            find = (BusinessEntity)em.find(BusinessEntity.class, (Object)rec.getChangeRecordNewData().getBusinessService().getBusinessKey());
                            if (find == null) {
                                AuthenticatedService.logger.error((Object)"Replication error, attempting to insert a service where the business doesn't exist yet");
                            } else {
                                model = null;
                                model = (BusinessService)em.find(BusinessService.class, (Object)rec.getChangeRecordNewData().getBusinessService().getServiceKey());
                                if (model != null) {
                                    UDDIReplicationImpl.this.validateNodeIdMatches(rec.getChangeRecordNewData().getOperationalInfo().getNodeID(), model.getNodeId());
                                    em.remove((Object)model);
                                }
                                model = new BusinessService();
                                MappingApiToModel.mapBusinessService(rec.getChangeRecordNewData().getBusinessService(), (BusinessService)model, find);
                                MappingApiToModel.mapOperationalInfo((UddiEntity)model, rec.getChangeRecordNewData().getOperationalInfo());
                                MappingApiToModel.mapOperationalInfoIncludingChildren((BusinessService)model, rec.getChangeRecordNewData().getOperationalInfo());
                                em.persist((Object)model);
                            }
                        } else if (rec.getChangeRecordNewData().getTModel() != null) {
                            model2 = (Tmodel)em.find(Tmodel.class, (Object)rec.getChangeRecordNewData().getTModel().getTModelKey());
                            if (model2 != null) {
                                if (rec.getChangeRecordNewData().getOperationalInfo().getNodeID().equals(UDDIReplicationImpl.this.getNode()) && !model2.getNodeId().equals(UDDIReplicationImpl.this.getNode())) {
                                    if (!model2.getIsTransferInProgress()) throw new Exception("Unexpected entity transfer to this node from " + rec.getChangeID().getNodeID());
                                    em.remove((Object)model2);
                                    model2 = new Tmodel();
                                    MappingApiToModel.mapTModel(rec.getChangeRecordNewData().getTModel(), (Tmodel)model2);
                                    MappingApiToModel.mapOperationalInfo(model2, rec.getChangeRecordNewData().getOperationalInfo());
                                    model2.setIsTransferInProgress(false);
                                    em.persist((Object)model2);
                                } else {
                                    if (rec.getChangeRecordNewData().getOperationalInfo().getNodeID().equals(UDDIReplicationImpl.this.getNode()) && model2.getNodeId().equals(UDDIReplicationImpl.this.getNode())) {
                                        throw new Exception("unexpected modification of records that this server owns, " + model2.getEntityKey());
                                    }
                                    if (!rec.getChangeRecordNewData().getOperationalInfo().getNodeID().equals(UDDIReplicationImpl.this.getNode()) && model2.getNodeId().equals(UDDIReplicationImpl.this.getNode())) {
                                        throw new Exception("unexpected transfer from this node to elsewhere, possible that the key in question exists at two places prior to replication sync, " + model2.getEntityKey());
                                    }
                                    if (!rec.getChangeRecordNewData().getOperationalInfo().getNodeID().equals(UDDIReplicationImpl.this.getNode()) && !model2.getNodeId().equals(UDDIReplicationImpl.this.getNode())) {
                                        em.remove((Object)model2);
                                        model2 = new Tmodel();
                                        MappingApiToModel.mapTModel(rec.getChangeRecordNewData().getTModel(), (Tmodel)model2);
                                        MappingApiToModel.mapOperationalInfo(model2, rec.getChangeRecordNewData().getOperationalInfo());
                                        em.persist((Object)model2);
                                    }
                                }
                            } else {
                                model2 = new Tmodel();
                                MappingApiToModel.mapTModel(rec.getChangeRecordNewData().getTModel(), (Tmodel)model2);
                                MappingApiToModel.mapOperationalInfo(model2, rec.getChangeRecordNewData().getOperationalInfo());
                                em.persist((Object)model2);
                            }
                        }
                    }
                }
                if (rec.getChangeRecordHide() != null) {
                    String key = rec.getChangeRecordHide().getTModelKey();
                    Tmodel existing = (Tmodel)em.find(Tmodel.class, (Object)key);
                    if (existing == null) {
                        AuthenticatedService.logger.error((Object)("Unexpected delete/hide tmodel message received for non existing key " + key));
                    } else {
                        UDDIReplicationImpl.validateNodeIdMisMatches(existing, UDDIReplicationImpl.this.getNode());
                        existing.setDeleted(true);
                        existing.setModified(rec.getChangeRecordHide().getModified().toGregorianCalendar().getTime());
                        existing.setModifiedIncludingChildren(rec.getChangeRecordHide().getModified().toGregorianCalendar().getTime());
                        em.persist((Object)existing);
                    }
                }
                if (rec.getChangeRecordPublisherAssertion() != null) {
                    AuthenticatedService.logger.info((Object)"Repl CR Publisher Assertion");
                    PublisherAssertionId paid = new PublisherAssertionId(rec.getChangeRecordPublisherAssertion().getPublisherAssertion().getFromKey(), rec.getChangeRecordPublisherAssertion().getPublisherAssertion().getToKey());
                    model = (PublisherAssertion)em.find(PublisherAssertion.class, (Object)paid);
                    if (model != null) {
                        AuthenticatedService.logger.info((Object)"Repl CR Publisher Assertion - Existing");
                        if (rec.getChangeRecordPublisherAssertion().isFromBusinessCheck()) {
                            model.setFromCheck("true");
                        } else {
                            model.setFromCheck("false");
                        }
                        if (rec.getChangeRecordPublisherAssertion().isToBusinessCheck()) {
                            model.setToCheck("true");
                        } else {
                            model.setToCheck("false");
                        }
                        model.setKeyName(rec.getChangeRecordPublisherAssertion().getPublisherAssertion().getKeyedReference().getKeyName());
                        model.setKeyValue(rec.getChangeRecordPublisherAssertion().getPublisherAssertion().getKeyedReference().getKeyValue());
                        model.setTmodelKey(rec.getChangeRecordPublisherAssertion().getPublisherAssertion().getKeyedReference().getTModelKey());
                        model.setModified(rec.getChangeRecordPublisherAssertion().getModified().toGregorianCalendar().getTime());
                        if ("false".equalsIgnoreCase(model.getFromCheck()) && "false".equalsIgnoreCase(model.getToCheck())) {
                            AuthenticatedService.logger.warn((Object)"!!!New publisher assertion is both false and false, strange. no need to save it then!");
                            em.remove((Object)model);
                        }
                        em.merge((Object)model);
                    } else {
                        AuthenticatedService.logger.info((Object)"Repl CR Publisher Assertion - new PA");
                        model = new PublisherAssertion();
                        MappingApiToModel.mapPublisherAssertion(rec.getChangeRecordPublisherAssertion().getPublisherAssertion(), (PublisherAssertion)model);
                        model.setBusinessEntityByFromKey(null);
                        model.setBusinessEntityByToKey(null);
                        model.setBusinessEntityByFromKey((BusinessEntity)em.find(BusinessEntity.class, (Object)rec.getChangeRecordPublisherAssertion().getPublisherAssertion().getFromKey()));
                        model.setBusinessEntityByToKey((BusinessEntity)em.find(BusinessEntity.class, (Object)rec.getChangeRecordPublisherAssertion().getPublisherAssertion().getToKey()));
                        if (rec.getChangeRecordPublisherAssertion().isFromBusinessCheck()) {
                            model.setFromCheck("true");
                        } else {
                            model.setFromCheck("false");
                        }
                        if (rec.getChangeRecordPublisherAssertion().isToBusinessCheck()) {
                            model.setToCheck("true");
                        } else {
                            model.setToCheck("false");
                        }
                        model.setModified(rec.getChangeRecordPublisherAssertion().getModified().toGregorianCalendar().getTime());
                        em.persist((Object)model);
                    }
                }
                if (rec.isAcknowledgementRequested()) {
                    org.uddi.repl_v3.ChangeRecord posack = new org.uddi.repl_v3.ChangeRecord();
                    posack.setChangeRecordAcknowledgement(new ChangeRecordAcknowledgement());
                    posack.getChangeRecordAcknowledgement().setAcknowledgedChange(rec.getChangeID());
                    posack.setAcknowledgementRequested(false);
                    ReplicationNotifier.enqueue(MappingApiToModel.mapChangeRecord(posack));
                }
                if (rec.getChangeRecordNewDataConditional() != null) {
                    if (rec.getChangeRecordNewDataConditional().getChangeRecordNewData().getOperationalInfo().getNodeID() == null) {
                        throw new Exception("Inbound replication data is missiong node id!");
                    }
                    if (rec.getChangeRecordNewDataConditional().getChangeRecordNewData().getOperationalInfo() == null) {
                        AuthenticatedService.logger.warn((Object)"Inbound replication data does not have the required OperationalInfo element and is NOT spec compliant. Data will be ignored");
                    } else {
                        if (rec.getChangeRecordNewDataConditional().getChangeRecordNewData().getBindingTemplate() != null) {
                            model2 = (BusinessService)em.find(BusinessService.class, (Object)rec.getChangeRecordNewDataConditional().getChangeRecordNewData().getBindingTemplate().getServiceKey());
                            if (model2 == null) {
                                AuthenticatedService.logger.error((Object)"Replication error, attempting to insert a binding where the service doesn't exist yet");
                            } else {
                                bt = (BindingTemplate)em.find(BindingTemplate.class, (Object)rec.getChangeRecordNewDataConditional().getChangeRecordNewData().getBindingTemplate().getBindingKey());
                                if (bt != null) {
                                    UDDIReplicationImpl.this.validateNodeIdMatches(rec.getChangeRecordNewDataConditional().getChangeRecordNewData().getOperationalInfo().getNodeID(), bt.getNodeId());
                                    em.remove((Object)bt);
                                }
                                bt = new BindingTemplate();
                                MappingApiToModel.mapBindingTemplate(rec.getChangeRecordNewDataConditional().getChangeRecordNewData().getBindingTemplate(), bt, (BusinessService)model2);
                                MappingApiToModel.mapOperationalInfo(bt, rec.getChangeRecordNewDataConditional().getChangeRecordNewData().getOperationalInfo());
                                em.persist((Object)bt);
                            }
                        } else if (rec.getChangeRecordNewDataConditional().getChangeRecordNewData().getBusinessEntity() != null) {
                            model2 = (BusinessEntity)em.find(BusinessEntity.class, (Object)rec.getChangeRecordNewDataConditional().getChangeRecordNewData().getBusinessEntity().getBusinessKey());
                            if (model2 != null) {
                                UDDIReplicationImpl.this.validateNodeIdMatches(rec.getChangeRecordNewDataConditional().getChangeRecordNewData().getOperationalInfo().getNodeID(), model2.getNodeId());
                                em.remove((Object)model2);
                            }
                            model2 = new BusinessEntity();
                            MappingApiToModel.mapBusinessEntity(rec.getChangeRecordNewDataConditional().getChangeRecordNewData().getBusinessEntity(), (BusinessEntity)model2);
                            MappingApiToModel.mapOperationalInfoIncludingChildren((BusinessEntity)model2, rec.getChangeRecordNewDataConditional().getChangeRecordNewData().getOperationalInfo());
                            AuthenticatedService.logger.warn((Object)("Name size on save is " + ((BusinessEntity)model2).getBusinessNames().size()));
                            em.persist((Object)model2);
                        }
                        if (rec.getChangeRecordNewDataConditional().getChangeRecordNewData().getBusinessService() != null) {
                            find = (BusinessEntity)em.find(BusinessEntity.class, (Object)rec.getChangeRecordNewDataConditional().getChangeRecordNewData().getBusinessService().getBusinessKey());
                            if (find == null) {
                                AuthenticatedService.logger.error((Object)"Replication error, attempting to insert a service where the business doesn't exist yet");
                            } else {
                                model = null;
                                model = (BusinessService)em.find(BusinessService.class, (Object)rec.getChangeRecordNewDataConditional().getChangeRecordNewData().getBusinessService().getServiceKey());
                                if (model != null) {
                                    UDDIReplicationImpl.this.validateNodeIdMatches(rec.getChangeRecordNewDataConditional().getChangeRecordNewData().getOperationalInfo().getNodeID(), model.getNodeId());
                                    em.remove((Object)model);
                                }
                                model = new BusinessService();
                                MappingApiToModel.mapBusinessService(rec.getChangeRecordNewDataConditional().getChangeRecordNewData().getBusinessService(), (BusinessService)model, find);
                                MappingApiToModel.mapOperationalInfo((UddiEntity)model, rec.getChangeRecordNewDataConditional().getChangeRecordNewData().getOperationalInfo());
                                MappingApiToModel.mapOperationalInfoIncludingChildren((BusinessService)model, rec.getChangeRecordNewDataConditional().getChangeRecordNewData().getOperationalInfo());
                                em.persist((Object)model);
                            }
                        } else if (rec.getChangeRecordNewDataConditional().getChangeRecordNewData().getTModel() != null) {
                            model2 = (Tmodel)em.find(Tmodel.class, (Object)rec.getChangeRecordNewDataConditional().getChangeRecordNewData().getTModel().getTModelKey());
                            if (model2 != null) {
                                UDDIReplicationImpl.this.validateNodeIdMatches(rec.getChangeRecordNewDataConditional().getChangeRecordNewData().getOperationalInfo().getNodeID(), model2.getNodeId());
                                em.remove((Object)model2);
                            }
                            model2 = new Tmodel();
                            MappingApiToModel.mapTModel(rec.getChangeRecordNewDataConditional().getChangeRecordNewData().getTModel(), (Tmodel)model2);
                            MappingApiToModel.mapOperationalInfo(model2, rec.getChangeRecordNewDataConditional().getChangeRecordNewData().getOperationalInfo());
                            em.persist((Object)model2);
                        }
                    }
                }
                if (rec.getChangeRecordNull() != null) {
                    // empty if block
                }
                if (rec.getChangeRecordCorrection() != null) {
                    // empty if block
                }
                if (rec.getChangeRecordConditionFailed() != null) {
                    // empty if block
                }
                tx.commit();
                return;
            }
            catch (Exception drfm) {
                AuthenticatedService.logger.warn((Object)"Error applying the change record! ", (Throwable)drfm);
                StringWriter sw = new StringWriter();
                JAXB.marshal((Object)rec, (Writer)sw);
                AuthenticatedService.logger.warn((Object)("This is the record that failed to persist: " + sw.toString()));
                if (tx.isActive()) {
                    tx.rollback();
                }
                if (mapChangeRecord != null) {
                    try {
                        tx = em.getTransaction();
                        tx.begin();
                        mapChangeRecord.setIsAppliedLocally(false);
                        em.merge((Object)mapChangeRecord);
                        tx.commit();
                        return;
                    }
                    catch (Exception e) {
                        AuthenticatedService.logger.error((Object)"error updating change record!!", (Throwable)e);
                        if (!tx.isActive()) return;
                        tx.rollback();
                    }
                    return;
                } else {
                    AuthenticatedService.logger.fatal((Object)"whoa! change record is null when saving a remote change record, this is unexpected and should be reported");
                }
                return;
            }
            finally {
                if (tx.isActive()) {
                    tx.rollback();
                }
                em.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private HighWaterMarkVectorType getLastChangeRecordFrom(String sourcenode) {
            HighWaterMarkVectorType ret = new HighWaterMarkVectorType();
            ChangeRecordIDType cid = new ChangeRecordIDType();
            cid.setNodeID(sourcenode);
            cid.setOriginatingUSN(Long.valueOf(0L));
            EntityManager em = PersistenceManager.getEntityManager();
            EntityTransaction tx = em.getTransaction();
            try {
                tx.begin();
                try {
                    cid.setOriginatingUSN((Long)em.createQuery("select MAX(e.originatingUSN) from ChangeRecord e where e.nodeID = :node").setParameter("node", (Object)sourcenode).getSingleResult());
                }
                catch (Exception ex) {
                    AuthenticatedService.logger.info((Object)("unexpected error searching for last record from " + sourcenode), (Throwable)ex);
                }
                tx.rollback();
            }
            catch (Exception drfm) {
                AuthenticatedService.logger.warn((Object)("error caught fetching newest record from node " + sourcenode), (Throwable)drfm);
            }
            finally {
                if (tx.isActive()) {
                    tx.rollback();
                }
                em.close();
            }
            AuthenticatedService.logger.info((Object)("Highest known record for " + sourcenode + " is " + cid.getOriginatingUSN()));
            ret.getHighWaterMark().add(cid);
            return ret;
        }

        private void enqueueAllReceivingNodes() {
            org.uddi.repl_v3.ReplicationConfiguration repcfg;
            if (queue == null) {
                queue = new ConcurrentLinkedQueue();
            }
            if ((repcfg = ReplicationNotifier.FetchEdges()) == null) {
                return;
            }
            HashSet<String> allnodes = new HashSet<String>();
            for (int i = 0; i < repcfg.getOperator().size(); ++i) {
                allnodes.add(((org.uddi.repl_v3.Operator)repcfg.getOperator().get(i)).getOperatorNodeID());
            }
            HashSet<String> receivers = new HashSet<String>();
            if (repcfg.getCommunicationGraph() == null || repcfg.getCommunicationGraph().getEdge().isEmpty()) {
                for (org.uddi.repl_v3.Operator o : repcfg.getOperator()) {
                    if (o.getOperatorNodeID().equalsIgnoreCase(UDDIReplicationImpl.this.getNode())) continue;
                    receivers.add(o.getOperatorNodeID());
                }
            } else {
                for (CommunicationGraph.Edge next : repcfg.getCommunicationGraph().getEdge()) {
                    if (!next.getMessageReceiver().equalsIgnoreCase(UDDIReplicationImpl.this.getNode())) continue;
                    receivers.add(next.getMessageSender());
                }
            }
            for (String s : receivers) {
                for (String nodeping : allnodes) {
                    queue.add(new NotifyChangeRecordsAvailable(s, this.getLastChangeRecordFrom(nodeping)));
                }
            }
        }
    }
}

