/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.api.impl;

import java.util.Date;
import java.util.UUID;
import javax.jws.WebService;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.xml.ws.WebServiceContext;
import org.apache.juddi.api.impl.AuthenticatedService;
import org.apache.juddi.api.impl.ServiceCounterLifecycleResource;
import org.apache.juddi.api.impl.UDDIServiceCounter;
import org.apache.juddi.api.util.QueryStatus;
import org.apache.juddi.api.util.SecurityQuery;
import org.apache.juddi.config.PersistenceManager;
import org.apache.juddi.mapping.MappingModelToApi;
import org.apache.juddi.model.Publisher;
import org.apache.juddi.v3.auth.Authenticator;
import org.apache.juddi.v3.auth.AuthenticatorFactory;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.UnknownUserException;
import org.uddi.api_v3.AuthToken;
import org.uddi.api_v3.DiscardAuthToken;
import org.uddi.api_v3.GetAuthToken;
import org.uddi.v3_service.DispositionReportFaultMessage;
import org.uddi.v3_service.UDDISecurityPortType;

@WebService(serviceName="UDDISecurityService", endpointInterface="org.uddi.v3_service.UDDISecurityPortType", targetNamespace="urn:uddi-org:api_v3_portType")
public class UDDISecurityImpl
extends AuthenticatedService
implements UDDISecurityPortType {
    public static final String AUTH_TOKEN_PREFIX = "authtoken:";
    private UDDIServiceCounter serviceCounter;

    public UDDISecurityImpl() {
        this.serviceCounter = ServiceCounterLifecycleResource.getServiceCounter(UDDISecurityImpl.class);
    }

    protected UDDISecurityImpl(WebServiceContext ctx) {
        this.ctx = ctx;
        this.serviceCounter = ServiceCounterLifecycleResource.getServiceCounter(UDDISecurityImpl.class);
    }

    public void discardAuthToken(DiscardAuthToken body) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            this.getEntityPublisher(em, body.getAuthInfo());
            org.apache.juddi.model.AuthToken modelAuthToken = (org.apache.juddi.model.AuthToken)em.find(org.apache.juddi.model.AuthToken.class, (Object)body.getAuthInfo());
            if (modelAuthToken != null) {
                modelAuthToken.setLastUsed(new Date());
                modelAuthToken.setNumberOfUses(modelAuthToken.getNumberOfUses() + 1);
                modelAuthToken.setTokenState(0);
                logger.info((Object)("AUDIT: AuthToken discarded for " + modelAuthToken.getAuthorizedName() + " from " + this.getRequestorsIPAddress()));
            }
            tx.commit();
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(SecurityQuery.DISCARD_AUTHTOKEN, QueryStatus.SUCCESS, procTime);
        }
        catch (DispositionReportFaultMessage drfm) {
            logger.info((Object)("AUDIT: AuthToken discard request aborted, issued from " + this.getRequestorsIPAddress()));
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(SecurityQuery.DISCARD_AUTHTOKEN, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    public AuthToken getAuthToken(GetAuthToken body) throws DispositionReportFaultMessage {
        logger.info((Object)("AUDIT: AuthToken request for " + body.getUserID() + " from " + this.getRequestorsIPAddress()));
        Authenticator authenticator = AuthenticatorFactory.getAuthenticator();
        String publisherId = authenticator.authenticate(body.getUserID(), body.getCred());
        return this.getAuthToken(publisherId);
    }

    public AuthToken getAuthToken(String publisherId) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        if (publisherId == null || publisherId.length() == 0) {
            throw new UnknownUserException(new ErrorMessage("errors.auth.InvalidCredentials", publisherId));
        }
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            Publisher publisher = (Publisher)em.find(Publisher.class, (Object)publisherId);
            if (publisher == null) {
                throw new UnknownUserException(new ErrorMessage("errors.auth.InvalidCredentials", publisherId));
            }
            String authInfo = AUTH_TOKEN_PREFIX + UUID.randomUUID();
            org.apache.juddi.model.AuthToken modelAuthToken = new org.apache.juddi.model.AuthToken();
            modelAuthToken.setAuthToken(authInfo);
            modelAuthToken.setCreated(new Date());
            modelAuthToken.setLastUsed(new Date());
            modelAuthToken.setAuthorizedName(publisherId);
            modelAuthToken.setNumberOfUses(0);
            modelAuthToken.setTokenState(1);
            modelAuthToken.setIPAddress(this.getRequestorsIPAddress());
            em.persist((Object)modelAuthToken);
            AuthToken apiAuthToken = new AuthToken();
            MappingModelToApi.mapAuthToken(modelAuthToken, apiAuthToken);
            tx.commit();
            logger.info((Object)("AUDIT: AuthToken issued for " + modelAuthToken.getAuthorizedName() + " from " + this.getRequestorsIPAddress()));
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(SecurityQuery.GET_AUTHTOKEN, QueryStatus.SUCCESS, procTime);
            AuthToken authToken = apiAuthToken;
            return authToken;
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(SecurityQuery.GET_AUTHTOKEN, QueryStatus.FAILED, procTime);
            logger.info((Object)("AUDIT: AuthToken issue FAILED " + publisherId + " from " + this.getRequestorsIPAddress()));
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }
}

