/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.api.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.jws.WebService;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.ws.Holder;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.api.impl.AuthenticatedService;
import org.apache.juddi.api.impl.InquiryHelper;
import org.apache.juddi.api.impl.ServiceCounterLifecycleResource;
import org.apache.juddi.api.impl.UDDIServiceCounter;
import org.apache.juddi.api.util.QueryStatus;
import org.apache.juddi.api.util.SubscriptionQuery;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.config.PersistenceManager;
import org.apache.juddi.jaxb.JAXBMarshaller;
import org.apache.juddi.mapping.MappingApiToModel;
import org.apache.juddi.mapping.MappingModelToApi;
import org.apache.juddi.model.BindingTemplate;
import org.apache.juddi.model.BusinessEntity;
import org.apache.juddi.model.BusinessService;
import org.apache.juddi.model.PublisherAssertion;
import org.apache.juddi.model.SubscriptionChunkToken;
import org.apache.juddi.model.SubscriptionMatch;
import org.apache.juddi.model.Tmodel;
import org.apache.juddi.model.UddiEntity;
import org.apache.juddi.model.UddiEntityPublisher;
import org.apache.juddi.query.FindBusinessByPublisherQuery;
import org.apache.juddi.query.FindPublisherAssertionByBusinessQuery;
import org.apache.juddi.query.FindSubscriptionByPublisherQuery;
import org.apache.juddi.query.util.FindQualifiers;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.FatalErrorException;
import org.apache.juddi.v3.error.InvalidValueException;
import org.apache.juddi.validation.ValidateSubscription;
import org.uddi.api_v3.AssertionStatusItem;
import org.uddi.api_v3.AssertionStatusReport;
import org.uddi.api_v3.BindingDetail;
import org.uddi.api_v3.BusinessDetail;
import org.uddi.api_v3.BusinessList;
import org.uddi.api_v3.FindBinding;
import org.uddi.api_v3.FindBusiness;
import org.uddi.api_v3.FindRelatedBusinesses;
import org.uddi.api_v3.FindService;
import org.uddi.api_v3.FindTModel;
import org.uddi.api_v3.GetAssertionStatusReport;
import org.uddi.api_v3.GetBindingDetail;
import org.uddi.api_v3.RelatedBusinessesList;
import org.uddi.api_v3.ServiceDetail;
import org.uddi.api_v3.ServiceList;
import org.uddi.api_v3.TModel;
import org.uddi.api_v3.TModelDetail;
import org.uddi.api_v3.TModelList;
import org.uddi.sub_v3.DeleteSubscription;
import org.uddi.sub_v3.GetSubscriptionResults;
import org.uddi.sub_v3.KeyBag;
import org.uddi.sub_v3.Subscription;
import org.uddi.sub_v3.SubscriptionFilter;
import org.uddi.sub_v3.SubscriptionResultsList;
import org.uddi.v3_service.DispositionReportFaultMessage;
import org.uddi.v3_service.UDDISubscriptionPortType;

@WebService(serviceName="UDDISubscriptionService", endpointInterface="org.uddi.v3_service.UDDISubscriptionPortType", targetNamespace="urn:uddi-org:api_v3_portType")
public class UDDISubscriptionImpl
extends AuthenticatedService
implements UDDISubscriptionPortType {
    private static Log logger = LogFactory.getLog(UDDISubscriptionImpl.class);
    public static final int DEFAULT_SUBSCRIPTIONEXPIRATION_DAYS = 30;
    public static final int DEFAULT_CHUNKEXPIRATION_MINUTES = 5;
    public static final String CHUNK_TOKEN_PREFIX = "chunktoken:";
    private UDDIServiceCounter serviceCounter = ServiceCounterLifecycleResource.getServiceCounter(this.getClass());

    public void deleteSubscription(DeleteSubscription body) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidateSubscription(publisher).validateDeleteSubscription(em, body);
            List subscriptionKeyList = body.getSubscriptionKey();
            for (String subscriptionKey : subscriptionKeyList) {
                Object obj = em.find(org.apache.juddi.model.Subscription.class, (Object)subscriptionKey);
                em.remove(obj);
            }
            tx.commit();
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(SubscriptionQuery.DELETE_SUBSCRIPTION, QueryStatus.SUCCESS, procTime);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(SubscriptionQuery.DELETE_SUBSCRIPTION, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    public SubscriptionResultsList getSubscriptionResults(GetSubscriptionResults body) throws DispositionReportFaultMessage {
        return this.getSubscriptionResults(body, null);
    }

    public SubscriptionResultsList getSubscriptionResults(GetSubscriptionResults body, UddiEntityPublisher publisher) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            int returnedRowCount;
            KeyBag resultsKeyBag;
            ArrayList<UddiEntity> existingList;
            KeyBag missingKeyBag;
            GetBindingDetail getDetail;
            Holder subscriptionStartIndex;
            Iterator<Object> findQualifiers;
            FindBinding fb;
            KeyBag resultsKeyBag2;
            KeyBag missingKeyBag2;
            List<String> missingKeys;
            List<?> currentMatchingKeys;
            Object chunkToken;
            tx.begin();
            if (publisher == null) {
                publisher = this.getEntityPublisher(em, body.getAuthInfo());
                new ValidateSubscription(publisher).validateGetSubscriptionResults(em, body);
            }
            org.apache.juddi.model.Subscription modelSubscription = (org.apache.juddi.model.Subscription)em.find(org.apache.juddi.model.Subscription.class, (Object)body.getSubscriptionKey());
            SubscriptionFilter subscriptionFilter = null;
            try {
                subscriptionFilter = (SubscriptionFilter)JAXBMarshaller.unmarshallFromString((String)modelSubscription.getSubscriptionFilter(), (String)"org.uddi.sub_v3");
            }
            catch (JAXBException e) {
                logger.error((Object)"JAXB Exception while unmarshalling subscription filter", (Throwable)e);
                throw new FatalErrorException(new ErrorMessage("errors.Unspecified"));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("filter=" + modelSubscription.getSubscriptionFilter()));
            }
            SubscriptionResultsList result = new SubscriptionResultsList();
            result.setChunkToken("0");
            result.setCoveragePeriod(body.getCoveragePeriod());
            Subscription apiSubscription = new Subscription();
            MappingModelToApi.mapSubscription(modelSubscription, apiSubscription);
            result.setSubscription(apiSubscription);
            Date startPointDate = new Date(body.getCoveragePeriod().getStartPoint().toGregorianCalendar().getTimeInMillis());
            Date endPointDate = new Date(body.getCoveragePeriod().getEndPoint().toGregorianCalendar().getTimeInMillis());
            Integer chunkData = null;
            if (body.getChunkToken() != null && body.getChunkToken().length() > 0) {
                chunkToken = (SubscriptionChunkToken)em.find(SubscriptionChunkToken.class, (Object)body.getChunkToken());
                if (chunkToken == null) {
                    throw new InvalidValueException(new ErrorMessage("errors.getsubscriptionresult.InvalidChunkToken", body.getChunkToken()));
                }
                if (!((SubscriptionChunkToken)chunkToken).getSubscriptionKey().equals(body.getSubscriptionKey())) {
                    throw new InvalidValueException(new ErrorMessage("errors.getsubscriptionresult.NonMatchingChunkToken", body.getChunkToken()));
                }
                if (((SubscriptionChunkToken)chunkToken).getStartPoint() != null && ((SubscriptionChunkToken)chunkToken).getStartPoint().getTime() != startPointDate.getTime()) {
                    throw new InvalidValueException(new ErrorMessage("errors.getsubscriptionresult.NonMatchingChunkToken", body.getChunkToken()));
                }
                if (((SubscriptionChunkToken)chunkToken).getEndPoint() != null && ((SubscriptionChunkToken)chunkToken).getEndPoint().getTime() != endPointDate.getTime()) {
                    throw new InvalidValueException(new ErrorMessage("errors.getsubscriptionresult.NonMatchingChunkToken", body.getChunkToken()));
                }
                if (((SubscriptionChunkToken)chunkToken).getExpiresAfter().before(new Date())) {
                    throw new InvalidValueException(new ErrorMessage("errors.getsubscriptionresult.ExpiredChunkToken", body.getChunkToken()));
                }
                chunkData = ((SubscriptionChunkToken)chunkToken).getData();
                em.remove(chunkToken);
            }
            if (subscriptionFilter.getFindBinding() != null) {
                currentMatchingKeys = this.getSubscriptionMatches(subscriptionFilter, em);
                missingKeys = this.getMissingKeys(currentMatchingKeys, modelSubscription.getSubscriptionMatches());
                if (missingKeys != null && missingKeys.size() > 0) {
                    missingKeyBag2 = new KeyBag();
                    missingKeyBag2.setDeleted(true);
                    for (String key : missingKeys) {
                        missingKeyBag2.getBindingKey().add(key);
                    }
                    result.getKeyBag().add(missingKeyBag2);
                }
                if (modelSubscription.isBrief().booleanValue()) {
                    resultsKeyBag2 = new KeyBag();
                    for (String key : currentMatchingKeys) {
                        resultsKeyBag2.getBindingKey().add(key);
                    }
                    result.getKeyBag().add(resultsKeyBag2);
                } else {
                    fb = subscriptionFilter.getFindBinding();
                    findQualifiers = new FindQualifiers();
                    ((FindQualifiers)((Object)findQualifiers)).mapApiFindQualifiers(fb.getFindQualifiers());
                    fb.setListHead(null);
                    fb.setMaxRows(null);
                    subscriptionStartIndex = new Holder((Object)chunkData);
                    BindingDetail bindingDetail = InquiryHelper.getBindingDetailFromKeys(fb, findQualifiers, em, currentMatchingKeys, startPointDate, endPointDate, (Holder<Integer>)subscriptionStartIndex, modelSubscription.getMaxEntities());
                    chunkData = (Integer)subscriptionStartIndex.value;
                    result.setBindingDetail(bindingDetail);
                }
            }
            if (subscriptionFilter.getFindBusiness() != null) {
                currentMatchingKeys = this.getSubscriptionMatches(subscriptionFilter, em);
                missingKeys = this.getMissingKeys(currentMatchingKeys, modelSubscription.getSubscriptionMatches());
                if (missingKeys != null && missingKeys.size() > 0) {
                    missingKeyBag2 = new KeyBag();
                    missingKeyBag2.setDeleted(true);
                    for (String key : missingKeys) {
                        missingKeyBag2.getBusinessKey().add(key);
                    }
                    result.getKeyBag().add(missingKeyBag2);
                }
                if (modelSubscription.isBrief().booleanValue()) {
                    resultsKeyBag2 = new KeyBag();
                    for (String key : currentMatchingKeys) {
                        resultsKeyBag2.getBusinessKey().add(key);
                    }
                    result.getKeyBag().add(resultsKeyBag2);
                } else {
                    fb = subscriptionFilter.getFindBusiness();
                    findQualifiers = new FindQualifiers();
                    ((FindQualifiers)((Object)findQualifiers)).mapApiFindQualifiers(fb.getFindQualifiers());
                    fb.setListHead(null);
                    fb.setMaxRows(null);
                    subscriptionStartIndex = new Holder((Object)chunkData);
                    BusinessList businessList = InquiryHelper.getBusinessListFromKeys((FindBusiness)fb, findQualifiers, em, currentMatchingKeys, startPointDate, endPointDate, (Holder<Integer>)subscriptionStartIndex, modelSubscription.getMaxEntities());
                    chunkData = (Integer)subscriptionStartIndex.value;
                    result.setBusinessList(businessList);
                }
            }
            if (subscriptionFilter.getFindService() != null) {
                currentMatchingKeys = this.getSubscriptionMatches(subscriptionFilter, em);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("current matching keys=" + currentMatchingKeys));
                }
                if ((missingKeys = this.getMissingKeys(currentMatchingKeys, modelSubscription.getSubscriptionMatches())) != null && missingKeys.size() > 0) {
                    missingKeyBag2 = new KeyBag();
                    missingKeyBag2.setDeleted(true);
                    for (String key : missingKeys) {
                        missingKeyBag2.getServiceKey().add(key);
                    }
                    result.getKeyBag().add(missingKeyBag2);
                }
                if (modelSubscription.isBrief().booleanValue()) {
                    resultsKeyBag2 = new KeyBag();
                    for (String key : currentMatchingKeys) {
                        resultsKeyBag2.getServiceKey().add(key);
                    }
                    result.getKeyBag().add(resultsKeyBag2);
                } else {
                    FindService fs = subscriptionFilter.getFindService();
                    findQualifiers = new FindQualifiers();
                    ((FindQualifiers)((Object)findQualifiers)).mapApiFindQualifiers(fs.getFindQualifiers());
                    fs.setListHead(null);
                    fs.setMaxRows(null);
                    subscriptionStartIndex = new Holder((Object)chunkData);
                    ServiceList serviceList = InquiryHelper.getServiceListFromKeys(fs, findQualifiers, em, currentMatchingKeys, startPointDate, endPointDate, (Holder<Integer>)subscriptionStartIndex, modelSubscription.getMaxEntities());
                    if (serviceList.getServiceInfos() == null || serviceList.getServiceInfos().getServiceInfo().size() == 0) {
                        serviceList = null;
                    }
                    chunkData = (Integer)subscriptionStartIndex.value;
                    result.setServiceList(serviceList);
                }
            }
            if (subscriptionFilter.getFindTModel() != null) {
                currentMatchingKeys = this.getSubscriptionMatches(subscriptionFilter, em);
                missingKeys = this.getMissingKeys(currentMatchingKeys, modelSubscription.getSubscriptionMatches());
                if (missingKeys != null && missingKeys.size() > 0) {
                    missingKeyBag2 = new KeyBag();
                    missingKeyBag2.setDeleted(true);
                    for (String key : missingKeys) {
                        missingKeyBag2.getTModelKey().add(key);
                    }
                    result.getKeyBag().add(missingKeyBag2);
                }
                if (modelSubscription.isBrief().booleanValue()) {
                    resultsKeyBag2 = new KeyBag();
                    for (String key : currentMatchingKeys) {
                        resultsKeyBag2.getTModelKey().add(key);
                    }
                    result.getKeyBag().add(resultsKeyBag2);
                } else {
                    FindTModel ft = subscriptionFilter.getFindTModel();
                    findQualifiers = new FindQualifiers();
                    ((FindQualifiers)((Object)findQualifiers)).mapApiFindQualifiers(ft.getFindQualifiers());
                    ft.setListHead(null);
                    ft.setMaxRows(null);
                    subscriptionStartIndex = new Holder((Object)chunkData);
                    TModelList tmodelList = InquiryHelper.getTModelListFromKeys(ft, findQualifiers, em, currentMatchingKeys, startPointDate, endPointDate, (Holder<Integer>)subscriptionStartIndex, modelSubscription.getMaxEntities());
                    chunkData = (Integer)subscriptionStartIndex.value;
                    result.setTModelList(tmodelList);
                }
            }
            if (subscriptionFilter.getFindRelatedBusinesses() != null) {
                FindRelatedBusinesses findRelatedBusiness = subscriptionFilter.getFindRelatedBusinesses();
                RelatedBusinessesList relatedBusinessList = InquiryHelper.getRelatedBusinessesList(findRelatedBusiness, em, startPointDate, endPointDate);
                result.setRelatedBusinessesList(relatedBusinessList);
            }
            if (subscriptionFilter.getGetBindingDetail() != null) {
                getDetail = subscriptionFilter.getGetBindingDetail();
                missingKeyBag = new KeyBag();
                missingKeyBag.setDeleted(true);
                existingList = new ArrayList<UddiEntity>(0);
                for (String key : getDetail.getBindingKey()) {
                    BindingTemplate modelBindingTemplate = (BindingTemplate)em.find(BindingTemplate.class, (Object)key);
                    if (modelBindingTemplate != null) {
                        existingList.add(modelBindingTemplate);
                        continue;
                    }
                    missingKeyBag.getBindingKey().add(key);
                }
                if (missingKeyBag.getBindingKey() != null && missingKeyBag.getBindingKey().size() > 0) {
                    result.getKeyBag().add(missingKeyBag);
                }
                resultsKeyBag = new KeyBag();
                BindingDetail bindingDetail = new BindingDetail();
                int currentIndex = 0;
                if (chunkData != null) {
                    currentIndex = chunkData;
                }
                returnedRowCount = 0;
                while (currentIndex < existingList.size()) {
                    BindingTemplate modelBindingTemplate = (BindingTemplate)existingList.get(currentIndex);
                    if (startPointDate.after(modelBindingTemplate.getModifiedIncludingChildren())) {
                        ++currentIndex;
                        continue;
                    }
                    if (endPointDate.before(modelBindingTemplate.getModifiedIncludingChildren())) {
                        ++currentIndex;
                        continue;
                    }
                    if (modelSubscription.isBrief().booleanValue()) {
                        resultsKeyBag.getBindingKey().add(modelBindingTemplate.getEntityKey());
                    } else {
                        org.uddi.api_v3.BindingTemplate apiBindingTemplate = new org.uddi.api_v3.BindingTemplate();
                        MappingModelToApi.mapBindingTemplate(modelBindingTemplate, apiBindingTemplate);
                        bindingDetail.getBindingTemplate().add(apiBindingTemplate);
                        ++returnedRowCount;
                    }
                    if (modelSubscription.getMaxEntities() != null && returnedRowCount == modelSubscription.getMaxEntities()) break;
                    ++currentIndex;
                }
                chunkData = currentIndex < existingList.size() - 1 ? Integer.valueOf(currentIndex + 1) : null;
                if (modelSubscription.isBrief().booleanValue()) {
                    result.getKeyBag().add(resultsKeyBag);
                } else {
                    result.setBindingDetail(bindingDetail);
                }
            }
            if (subscriptionFilter.getGetBusinessDetail() != null) {
                getDetail = subscriptionFilter.getGetBusinessDetail();
                missingKeyBag = new KeyBag();
                missingKeyBag.setDeleted(true);
                existingList = new ArrayList(0);
                for (String key : getDetail.getBusinessKey()) {
                    BusinessEntity modelBusinessEntity = (BusinessEntity)em.find(BusinessEntity.class, (Object)key);
                    if (modelBusinessEntity != null) {
                        existingList.add(modelBusinessEntity);
                        continue;
                    }
                    missingKeyBag.getBusinessKey().add(key);
                }
                if (missingKeyBag.getBusinessKey() != null && missingKeyBag.getBusinessKey().size() > 0) {
                    result.getKeyBag().add(missingKeyBag);
                }
                resultsKeyBag = new KeyBag();
                BusinessDetail businessDetail = new BusinessDetail();
                int currentIndex = 0;
                if (chunkData != null) {
                    currentIndex = chunkData;
                }
                returnedRowCount = 0;
                while (currentIndex < existingList.size()) {
                    BusinessEntity modelBusinessEntity = (BusinessEntity)existingList.get(currentIndex);
                    if (startPointDate.after(modelBusinessEntity.getModifiedIncludingChildren())) {
                        ++currentIndex;
                        continue;
                    }
                    if (endPointDate.before(modelBusinessEntity.getModifiedIncludingChildren())) {
                        ++currentIndex;
                        continue;
                    }
                    if (modelSubscription.isBrief().booleanValue()) {
                        resultsKeyBag.getBusinessKey().add(modelBusinessEntity.getEntityKey());
                    } else {
                        org.uddi.api_v3.BusinessEntity apiBusinessEntity = new org.uddi.api_v3.BusinessEntity();
                        MappingModelToApi.mapBusinessEntity(modelBusinessEntity, apiBusinessEntity);
                        businessDetail.getBusinessEntity().add(apiBusinessEntity);
                        ++returnedRowCount;
                    }
                    if (modelSubscription.getMaxEntities() != null && returnedRowCount == modelSubscription.getMaxEntities()) break;
                    ++currentIndex;
                }
                chunkData = currentIndex < existingList.size() - 1 ? Integer.valueOf(currentIndex + 1) : null;
                if (modelSubscription.isBrief().booleanValue()) {
                    result.getKeyBag().add(resultsKeyBag);
                } else {
                    result.setBusinessDetail(businessDetail);
                }
            }
            if (subscriptionFilter.getGetServiceDetail() != null) {
                getDetail = subscriptionFilter.getGetServiceDetail();
                missingKeyBag = new KeyBag();
                missingKeyBag.setDeleted(true);
                existingList = new ArrayList(0);
                for (String key : getDetail.getServiceKey()) {
                    BusinessService modelBusinessService = (BusinessService)em.find(BusinessService.class, (Object)key);
                    if (modelBusinessService != null) {
                        existingList.add(modelBusinessService);
                        continue;
                    }
                    missingKeyBag.getBusinessKey().add(key);
                }
                if (missingKeyBag.getServiceKey() != null && missingKeyBag.getServiceKey().size() > 0) {
                    result.getKeyBag().add(missingKeyBag);
                }
                resultsKeyBag = new KeyBag();
                ServiceDetail serviceDetail = new ServiceDetail();
                int currentIndex = 0;
                if (chunkData != null) {
                    currentIndex = chunkData;
                }
                returnedRowCount = 0;
                while (currentIndex < existingList.size()) {
                    BusinessService modelBusinessService = (BusinessService)existingList.get(currentIndex);
                    if (startPointDate.after(modelBusinessService.getModifiedIncludingChildren())) {
                        ++currentIndex;
                        continue;
                    }
                    if (endPointDate.before(modelBusinessService.getModifiedIncludingChildren())) {
                        ++currentIndex;
                        continue;
                    }
                    if (modelSubscription.isBrief().booleanValue()) {
                        resultsKeyBag.getServiceKey().add(modelBusinessService.getEntityKey());
                    } else {
                        org.uddi.api_v3.BusinessService apiBusinessService = new org.uddi.api_v3.BusinessService();
                        MappingModelToApi.mapBusinessService(modelBusinessService, apiBusinessService);
                        serviceDetail.getBusinessService().add(apiBusinessService);
                        ++returnedRowCount;
                    }
                    if (modelSubscription.getMaxEntities() != null && returnedRowCount == modelSubscription.getMaxEntities()) break;
                    ++currentIndex;
                }
                chunkData = currentIndex < existingList.size() - 1 ? Integer.valueOf(currentIndex + 1) : null;
                if (modelSubscription.isBrief().booleanValue()) {
                    result.getKeyBag().add(resultsKeyBag);
                } else {
                    result.setServiceDetail(serviceDetail);
                }
            }
            if (subscriptionFilter.getGetTModelDetail() != null) {
                getDetail = subscriptionFilter.getGetTModelDetail();
                missingKeyBag = new KeyBag();
                missingKeyBag.setDeleted(true);
                existingList = new ArrayList(0);
                for (String key : getDetail.getTModelKey()) {
                    Tmodel modelTModel = (Tmodel)em.find(Tmodel.class, (Object)key);
                    if (modelTModel != null) {
                        existingList.add(modelTModel);
                        continue;
                    }
                    missingKeyBag.getTModelKey().add(key);
                }
                if (missingKeyBag.getTModelKey() != null && missingKeyBag.getTModelKey().size() > 0) {
                    result.getKeyBag().add(missingKeyBag);
                }
                resultsKeyBag = new KeyBag();
                TModelDetail tmodelDetail = new TModelDetail();
                int currentIndex = 0;
                if (chunkData != null) {
                    currentIndex = chunkData;
                }
                returnedRowCount = 0;
                while (currentIndex < existingList.size()) {
                    Tmodel modelTModel = (Tmodel)existingList.get(currentIndex);
                    if (startPointDate.after(modelTModel.getModifiedIncludingChildren())) {
                        ++currentIndex;
                        continue;
                    }
                    if (endPointDate.before(modelTModel.getModifiedIncludingChildren())) {
                        ++currentIndex;
                        continue;
                    }
                    if (modelSubscription.isBrief().booleanValue()) {
                        resultsKeyBag.getTModelKey().add(modelTModel.getEntityKey());
                    } else {
                        TModel apiTModel = new TModel();
                        MappingModelToApi.mapTModel(modelTModel, apiTModel);
                        tmodelDetail.getTModel().add(apiTModel);
                        ++returnedRowCount;
                    }
                    if (modelSubscription.getMaxEntities() != null && returnedRowCount == modelSubscription.getMaxEntities()) break;
                    ++currentIndex;
                }
                chunkData = currentIndex < existingList.size() - 1 ? Integer.valueOf(currentIndex + 1) : null;
                if (modelSubscription.isBrief().booleanValue()) {
                    result.getKeyBag().add(resultsKeyBag);
                } else {
                    result.setTModelDetail(tmodelDetail);
                }
            }
            if (subscriptionFilter.getGetAssertionStatusReport() != null) {
                GetAssertionStatusReport getAssertionStatusReport = subscriptionFilter.getGetAssertionStatusReport();
                List<?> businessKeysFound = null;
                businessKeysFound = FindBusinessByPublisherQuery.select(em, null, publisher, businessKeysFound);
                AssertionStatusReport assertionStatusReport = new AssertionStatusReport();
                List<PublisherAssertion> pubAssertionList = FindPublisherAssertionByBusinessQuery.select(em, businessKeysFound, getAssertionStatusReport.getCompletionStatus());
                for (PublisherAssertion modelPubAssertion : pubAssertionList) {
                    if (startPointDate.after(modelPubAssertion.getModified()) || endPointDate.before(modelPubAssertion.getModified())) continue;
                    AssertionStatusItem apiAssertionStatusItem = new AssertionStatusItem();
                    MappingModelToApi.mapAssertionStatusItem(modelPubAssertion, apiAssertionStatusItem, businessKeysFound);
                    assertionStatusReport.getAssertionStatusItem().add(apiAssertionStatusItem);
                }
                result.setAssertionStatusReport(assertionStatusReport);
            }
            if (chunkData != null) {
                chunkToken = CHUNK_TOKEN_PREFIX + UUID.randomUUID();
                SubscriptionChunkToken newChunkToken = new SubscriptionChunkToken((String)chunkToken);
                newChunkToken.setSubscriptionKey(body.getSubscriptionKey());
                newChunkToken.setStartPoint(startPointDate);
                newChunkToken.setEndPoint(endPointDate);
                newChunkToken.setData(chunkData);
                int chunkExpirationMinutes = 5;
                try {
                    chunkExpirationMinutes = AppConfig.getConfiguration().getInt("juddi.subscription.chunkexpiration.minutes");
                }
                catch (ConfigurationException ce) {
                    throw new FatalErrorException(new ErrorMessage("errors.configuration.Retrieval"));
                }
                newChunkToken.setExpiresAfter(new Date(System.currentTimeMillis() + (long)chunkExpirationMinutes * 60L * 1000L));
                em.persist((Object)newChunkToken);
                result.setChunkToken((String)chunkToken);
            }
            tx.commit();
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(SubscriptionQuery.GET_SUBSCRIPTIONRESULTS, QueryStatus.SUCCESS, procTime);
            SubscriptionResultsList subscriptionResultsList = result;
            return subscriptionResultsList;
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(SubscriptionQuery.GET_SUBSCRIPTIONRESULTS, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    public List<Subscription> getSubscriptions(String authInfo) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, authInfo);
            ArrayList<Subscription> result = new ArrayList<Subscription>(0);
            List<org.apache.juddi.model.Subscription> modelSubscriptionList = FindSubscriptionByPublisherQuery.select(em, publisher.getAuthorizedName());
            if (modelSubscriptionList != null && modelSubscriptionList.size() > 0) {
                for (org.apache.juddi.model.Subscription modelSubscription : modelSubscriptionList) {
                    Subscription apiSubscription = new Subscription();
                    MappingModelToApi.mapSubscription(modelSubscription, apiSubscription);
                    result.add(apiSubscription);
                }
            }
            tx.commit();
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(SubscriptionQuery.GET_SUBSCRIPTIONS, QueryStatus.SUCCESS, procTime);
            ArrayList<Subscription> arrayList = result;
            return arrayList;
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(SubscriptionQuery.GET_SUBSCRIPTIONS, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    public void saveSubscription(String authInfo, Holder<List<Subscription>> subscription) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, authInfo);
            publisher.populateKeyGeneratorKeys(em);
            new ValidateSubscription(publisher).validateSubscriptions(em, (List)subscription.value, publisher);
            List apiSubscriptionList = (List)subscription.value;
            for (Subscription apiSubscription : apiSubscriptionList) {
                org.apache.juddi.model.Subscription modelSubscription = new org.apache.juddi.model.Subscription();
                Object existing = em.find(org.apache.juddi.model.Subscription.class, (Object)apiSubscription.getSubscriptionKey());
                if (existing != null) {
                    org.apache.juddi.model.Subscription existingEntity = (org.apache.juddi.model.Subscription)existing;
                    this.doRenewal(existingEntity, apiSubscription);
                    modelSubscription.setCreateDate(existingEntity.getCreateDate());
                    modelSubscription.setLastNotified(existingEntity.getLastNotified());
                    em.remove(existing);
                } else {
                    modelSubscription.setCreateDate(new Date());
                }
                this.doSubscriptionExpirationDate(apiSubscription);
                MappingApiToModel.mapSubscription(apiSubscription, modelSubscription);
                modelSubscription.setAuthorizedName(publisher.getAuthorizedName());
                List<?> keys = this.getSubscriptionMatches(apiSubscription.getSubscriptionFilter(), em);
                if (keys != null && keys.size() > 0) {
                    for (Object key : keys) {
                        SubscriptionMatch subMatch = new SubscriptionMatch(modelSubscription, (String)key);
                        modelSubscription.getSubscriptionMatches().add(subMatch);
                    }
                }
                em.persist((Object)modelSubscription);
            }
            tx.commit();
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(SubscriptionQuery.SAVE_SUBSCRIPTION, QueryStatus.SUCCESS, procTime);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(SubscriptionQuery.SAVE_SUBSCRIPTION, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    protected void doRenewal(org.apache.juddi.model.Subscription existingSubscription, Subscription apiSubscription) throws DispositionReportFaultMessage {
        if (apiSubscription.getSubscriptionFilter() == null) {
            String rawFilter = existingSubscription.getSubscriptionFilter();
            try {
                SubscriptionFilter existingFilter = (SubscriptionFilter)JAXBMarshaller.unmarshallFromString((String)rawFilter, (String)"org.uddi.sub_v3");
                apiSubscription.setSubscriptionFilter(existingFilter);
            }
            catch (JAXBException e) {
                logger.error((Object)"JAXB Exception while marshalling subscription filter", (Throwable)e);
                throw new FatalErrorException(new ErrorMessage("errors.Unspecified"));
            }
        }
    }

    protected void doSubscriptionExpirationDate(Subscription apiSubscription) throws DispositionReportFaultMessage {
        GregorianCalendar userExpiration;
        int subscriptionExpirationDays = 30;
        try {
            subscriptionExpirationDays = AppConfig.getConfiguration().getInt("juddi.subscription.expiration.days");
        }
        catch (ConfigurationException ce) {
            throw new FatalErrorException(new ErrorMessage("errors.configuration.Retrieval"));
        }
        GregorianCalendar expirationDate = new GregorianCalendar();
        expirationDate.add(5, subscriptionExpirationDays);
        if (apiSubscription.getExpiresAfter() != null && (userExpiration = apiSubscription.getExpiresAfter().toGregorianCalendar()).getTimeInMillis() < expirationDate.getTimeInMillis()) {
            expirationDate.setTimeInMillis(userExpiration.getTimeInMillis());
        }
        try {
            DatatypeFactory df = DatatypeFactory.newInstance();
            apiSubscription.setExpiresAfter(df.newXMLGregorianCalendar(expirationDate));
        }
        catch (DatatypeConfigurationException ce) {
            throw new FatalErrorException(new ErrorMessage("errors.Unspecified"));
        }
    }

    protected List<?> getSubscriptionMatches(SubscriptionFilter subscriptionFilter, EntityManager em) throws DispositionReportFaultMessage {
        FindQualifiers findQualifiers;
        List<Object> keys = null;
        if (subscriptionFilter.getFindBinding() != null) {
            findQualifiers = new FindQualifiers();
            findQualifiers.mapApiFindQualifiers(subscriptionFilter.getFindBinding().getFindQualifiers());
            keys = InquiryHelper.findBinding(subscriptionFilter.getFindBinding(), findQualifiers, em);
        }
        if (subscriptionFilter.getFindBusiness() != null) {
            findQualifiers = new FindQualifiers();
            findQualifiers.mapApiFindQualifiers(subscriptionFilter.getFindBusiness().getFindQualifiers());
            keys = InquiryHelper.findBusiness(subscriptionFilter.getFindBusiness(), findQualifiers, em);
        }
        if (subscriptionFilter.getFindService() != null) {
            findQualifiers = new FindQualifiers();
            findQualifiers.mapApiFindQualifiers(subscriptionFilter.getFindService().getFindQualifiers());
            keys = InquiryHelper.findService(subscriptionFilter.getFindService(), findQualifiers, em);
        }
        if (subscriptionFilter.getFindTModel() != null) {
            findQualifiers = new FindQualifiers();
            findQualifiers.mapApiFindQualifiers(subscriptionFilter.getFindTModel().getFindQualifiers());
            keys = InquiryHelper.findTModel(subscriptionFilter.getFindTModel(), findQualifiers, em);
        }
        if (subscriptionFilter.getFindRelatedBusinesses() != null) {
            // empty if block
        }
        if (subscriptionFilter.getGetBindingDetail() != null) {
            // empty if block
        }
        if (subscriptionFilter.getGetBusinessDetail() != null) {
            // empty if block
        }
        if (subscriptionFilter.getGetServiceDetail() != null) {
            // empty if block
        }
        if (subscriptionFilter.getGetTModelDetail() != null) {
            // empty if block
        }
        if (subscriptionFilter.getGetAssertionStatusReport() != null) {
            // empty if block
        }
        return keys;
    }

    private List<String> getMissingKeys(List<?> currentMatchingKeys, List<SubscriptionMatch> subscriptionMatches) {
        ArrayList<String> result = new ArrayList<String>(subscriptionMatches.size());
        for (SubscriptionMatch subMatch : subscriptionMatches) {
            result.add(subMatch.getEntityKey());
        }
        result.removeAll(currentMatchingKeys);
        return result;
    }
}

