/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.api.impl;

import java.util.HashSet;
import javax.jws.WebService;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.api.impl.UDDIInquiryImpl;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.v3.client.mapping.MapUDDIv2Tov3;
import org.apache.juddi.v3.client.mapping.MapUDDIv3Tov2;
import org.apache.juddi.validation.ValidateUDDIv2Inquiry;
import org.uddi.api_v2.BindingDetail;
import org.uddi.api_v2.BusinessDetail;
import org.uddi.api_v2.BusinessDetailExt;
import org.uddi.api_v2.FindBinding;
import org.uddi.api_v2.FindBusiness;
import org.uddi.api_v2.FindRelatedBusinesses;
import org.uddi.api_v2.FindService;
import org.uddi.api_v2.FindTModel;
import org.uddi.api_v2.GetBindingDetail;
import org.uddi.api_v2.GetBusinessDetail;
import org.uddi.api_v2.GetBusinessDetailExt;
import org.uddi.api_v2.GetServiceDetail;
import org.uddi.api_v2.GetTModelDetail;
import org.uddi.api_v2.ServiceDetail;
import org.uddi.api_v2.ServiceList;
import org.uddi.api_v2.TModelList;
import org.uddi.api_v3.BusinessList;
import org.uddi.api_v3.RelatedBusinessesList;
import org.uddi.api_v3.TModelDetail;
import org.uddi.v2_service.DispositionReport;
import org.uddi.v2_service.Inquire;
import org.uddi.v3_service.DispositionReportFaultMessage;

@WebService(serviceName="Inquire", targetNamespace="urn:uddi-org:inquiry_v2", endpointInterface="org.uddi.v2_service.Inquire")
public class UDDIv2InquiryImpl
implements Inquire {
    private static Log logger = LogFactory.getLog(UDDIv2InquiryImpl.class);
    static UDDIInquiryImpl inquiryService = new UDDIInquiryImpl();
    static String nodeId = null;

    public UDDIv2InquiryImpl() {
        logger.warn((Object)("This implementation of UDDIv2 Inquire service " + UDDIv2InquiryImpl.class.getCanonicalName() + " is considered BETA. Please report any issues to https://issues.apache.org/jira/browse/JUDDI"));
    }

    public static String getNodeID() {
        try {
            nodeId = AppConfig.getConfiguration().getString("juddi.nodeId");
        }
        catch (ConfigurationException ex) {
            logger.warn((Object)ex.getMessage());
            nodeId = "JUDDI_v3";
        }
        return nodeId;
    }

    public BindingDetail findBinding(FindBinding body) throws DispositionReport {
        ValidateUDDIv2Inquiry.validateFindBinding(body);
        try {
            return MapUDDIv3Tov2.MapBindingDetail((org.uddi.api_v3.BindingDetail)inquiryService.findBinding(MapUDDIv2Tov3.MapFindBinding((FindBinding)body)), (String)UDDIv2InquiryImpl.getNodeID());
        }
        catch (DispositionReportFaultMessage ex) {
            throw MapUDDIv3Tov2.MapException((DispositionReportFaultMessage)ex, (String)UDDIv2InquiryImpl.getNodeID());
        }
    }

    public org.uddi.api_v2.BusinessList findBusiness(FindBusiness body) throws DispositionReport {
        ValidateUDDIv2Inquiry.validateFindBusiness(body);
        try {
            return MapUDDIv3Tov2.MapBusinessListEntity((BusinessList)inquiryService.findBusiness(MapUDDIv2Tov3.MapFindBusiness((FindBusiness)body)), (String)UDDIv2InquiryImpl.getNodeID());
        }
        catch (DispositionReportFaultMessage ex) {
            throw MapUDDIv3Tov2.MapException((DispositionReportFaultMessage)ex, (String)UDDIv2InquiryImpl.getNodeID());
        }
    }

    public org.uddi.api_v2.RelatedBusinessesList findRelatedBusinesses(FindRelatedBusinesses body) throws DispositionReport {
        ValidateUDDIv2Inquiry.validateFindRelatedBusinesses(body);
        try {
            return MapUDDIv3Tov2.MapRelatedBusinessList((RelatedBusinessesList)inquiryService.findRelatedBusinesses(MapUDDIv2Tov3.MapFindRelatedBusiness((FindRelatedBusinesses)body)), (String)UDDIv2InquiryImpl.getNodeID());
        }
        catch (DispositionReportFaultMessage ex) {
            throw MapUDDIv3Tov2.MapException((DispositionReportFaultMessage)ex, (String)UDDIv2InquiryImpl.getNodeID());
        }
    }

    public ServiceList findService(FindService body) throws DispositionReport {
        ValidateUDDIv2Inquiry.validateFindService(body);
        try {
            return MapUDDIv3Tov2.MapServiceList((org.uddi.api_v3.ServiceList)inquiryService.findService(MapUDDIv2Tov3.MapFindService((FindService)body)), (String)UDDIv2InquiryImpl.getNodeID());
        }
        catch (DispositionReportFaultMessage ex) {
            throw MapUDDIv3Tov2.MapException((DispositionReportFaultMessage)ex, (String)UDDIv2InquiryImpl.getNodeID());
        }
    }

    public TModelList findTModel(FindTModel body) throws DispositionReport {
        ValidateUDDIv2Inquiry.validateFindTModel(body);
        try {
            return MapUDDIv3Tov2.MapTModelListElement((org.uddi.api_v3.TModelList)inquiryService.findTModel(MapUDDIv2Tov3.MapFindTModel((FindTModel)body)), (String)UDDIv2InquiryImpl.getNodeID());
        }
        catch (DispositionReportFaultMessage ex) {
            throw MapUDDIv3Tov2.MapException((DispositionReportFaultMessage)ex, (String)UDDIv2InquiryImpl.getNodeID());
        }
    }

    public BindingDetail getBindingDetail(GetBindingDetail body) throws DispositionReport {
        ValidateUDDIv2Inquiry.validateGetBindingDetail(body);
        try {
            return MapUDDIv3Tov2.MapBindingDetail((org.uddi.api_v3.BindingDetail)inquiryService.getBindingDetail(MapUDDIv2Tov3.MapGetBindingDetail((GetBindingDetail)body)), (String)UDDIv2InquiryImpl.getNodeID());
        }
        catch (DispositionReportFaultMessage ex) {
            throw MapUDDIv3Tov2.MapException((DispositionReportFaultMessage)ex, (String)UDDIv2InquiryImpl.getNodeID());
        }
    }

    public BusinessDetail getBusinessDetail(GetBusinessDetail body) throws DispositionReport {
        ValidateUDDIv2Inquiry.validateGetBusinessDetail(body);
        try {
            BusinessDetail MapBusinessDetail = MapUDDIv3Tov2.MapBusinessDetail((org.uddi.api_v3.BusinessDetail)inquiryService.getBusinessDetail(MapUDDIv2Tov3.MapGetBusinessDetail((GetBusinessDetail)body)), (String)UDDIv2InquiryImpl.getNodeID());
            return MapBusinessDetail;
        }
        catch (DispositionReportFaultMessage ex) {
            throw MapUDDIv3Tov2.MapException((DispositionReportFaultMessage)ex, (String)UDDIv2InquiryImpl.getNodeID());
        }
    }

    public BusinessDetailExt getBusinessDetailExt(GetBusinessDetailExt body) throws DispositionReport {
        ValidateUDDIv2Inquiry.validateBusinessDetailExt(body);
        try {
            return MapUDDIv3Tov2.MapBusinessDetailExt((org.uddi.api_v3.BusinessDetail)inquiryService.getBusinessDetail(MapUDDIv2Tov3.MapGetBusinessDetailExt((GetBusinessDetailExt)body)), (String)UDDIv2InquiryImpl.getNodeID());
        }
        catch (DispositionReportFaultMessage ex) {
            throw MapUDDIv3Tov2.MapException((DispositionReportFaultMessage)ex, (String)UDDIv2InquiryImpl.getNodeID());
        }
    }

    public ServiceDetail getServiceDetail(GetServiceDetail body) throws DispositionReport {
        ValidateUDDIv2Inquiry.validateGetServiceDetail(body);
        try {
            return MapUDDIv3Tov2.MapServiceDetail((org.uddi.api_v3.ServiceDetail)inquiryService.getServiceDetail(MapUDDIv2Tov3.MapGetServiceDetail((GetServiceDetail)body)), (String)UDDIv2InquiryImpl.getNodeID());
        }
        catch (DispositionReportFaultMessage ex) {
            throw MapUDDIv3Tov2.MapException((DispositionReportFaultMessage)ex, (String)UDDIv2InquiryImpl.getNodeID());
        }
    }

    public org.uddi.api_v2.TModelDetail getTModelDetail(GetTModelDetail body) throws DispositionReport {
        ValidateUDDIv2Inquiry.validateGetTModelDetail(body);
        try {
            HashSet keyList = new HashSet(body.getTModelKey());
            body.getTModelKey().clear();
            body.getTModelKey().addAll(keyList);
            return MapUDDIv3Tov2.MapTModelDetail((TModelDetail)inquiryService.getTModelDetail(MapUDDIv2Tov3.MapGetTModelDetail((GetTModelDetail)body)), (String)UDDIv2InquiryImpl.getNodeID());
        }
        catch (DispositionReportFaultMessage ex) {
            throw MapUDDIv3Tov2.MapException((DispositionReportFaultMessage)ex, (String)UDDIv2InquiryImpl.getNodeID());
        }
    }
}

