/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.api.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.api_v3.Clerk;
import org.apache.juddi.v3.client.config.UDDIClerk;
import org.apache.juddi.v3.client.config.XRegistration;
import org.uddi.api_v3.BindingDetail;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BusinessDetail;
import org.uddi.api_v3.BusinessEntity;
import org.uddi.api_v3.BusinessInfo;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.ServiceDetail;
import org.uddi.sub_v3.SubscriptionResultsList;

public class XRegisterHelper {
    private static Log log = LogFactory.getLog(XRegisterHelper.class);

    public static void handle(Clerk fromClerk, Clerk toClerk, SubscriptionResultsList list) {
        UDDIClerk uddiToClerk = new UDDIClerk(toClerk);
        UDDIClerk uddiFromClerk = new UDDIClerk(fromClerk);
        if (list.getServiceList() != null) {
            log.info((Object)("Subscription result for ServiceList with subscription key=" + list.getSubscription().getSubscriptionKey()));
            for (Object serviceInfo : list.getServiceList().getServiceInfos().getServiceInfo()) {
                BusinessEntity existingBusinessEntity = null;
                try {
                    if (existingBusinessEntity == null) {
                        existingBusinessEntity = uddiToClerk.findBusiness(serviceInfo.getBusinessKey(), toClerk.getNode());
                    }
                    if (existingBusinessEntity != null) {
                        log.debug((Object)("Found business with key " + existingBusinessEntity.getBusinessKey() + ". No need to add it again"));
                    } else {
                        log.info((Object)("Business was not found in the destination UDDI " + toClerk.getNode().getName() + ", going to add it in."));
                        new XRegistration(serviceInfo.getBusinessKey(), new UDDIClerk(fromClerk), new UDDIClerk(toClerk)).xRegisterBusiness();
                    }
                    new XRegistration(serviceInfo.getServiceKey(), new UDDIClerk(fromClerk), new UDDIClerk(toClerk)).xRegisterServiceAndBindings();
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        if (list.getServiceDetail() != null) {
            log.info((Object)("Subscription result for ServiceDetail with subscription key=" + list.getSubscription().getSubscriptionKey()));
            ServiceDetail serviceDetail = list.getServiceDetail();
            if (serviceDetail.isTruncated().booleanValue()) {
                log.info((Object)("The serviceDetail is truncated, the maxEntries must have been hit. The number of services is " + serviceDetail.getBusinessService().size()));
            }
            for (BusinessService service : serviceDetail.getBusinessService()) {
                BusinessEntity existingBusinessEntity = null;
                try {
                    if (existingBusinessEntity == null) {
                        existingBusinessEntity = uddiToClerk.findBusiness(service.getBusinessKey(), toClerk.getNode());
                    }
                    if (existingBusinessEntity != null) {
                        log.debug((Object)("Found business with key " + existingBusinessEntity.getBusinessKey() + ". No need to add it again"));
                    } else {
                        log.info((Object)("Business was not found in the destination UDDI " + toClerk.getNode().getName() + ", going to add it in."));
                        new XRegistration(service.getBusinessKey(), new UDDIClerk(fromClerk), new UDDIClerk(toClerk)).xRegisterBusiness();
                    }
                    new XRegistration(service.getServiceKey(), new UDDIClerk(fromClerk), new UDDIClerk(toClerk)).xRegisterServiceAndBindings();
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        if (list.getBusinessList() != null) {
            log.info((Object)("Subscription result for BusinessList with subscription key=" + list.getSubscription().getSubscriptionKey()));
            for (BusinessInfo businessInfo : list.getBusinessList().getBusinessInfos().getBusinessInfo()) {
                new XRegistration(businessInfo.getBusinessKey(), new UDDIClerk(fromClerk), new UDDIClerk(toClerk)).xRegisterBusinessAndServices();
            }
        }
        if (list.getBusinessDetail() != null) {
            log.info((Object)("Subscription result for BusinessDetail with subscription key=" + list.getSubscription().getSubscriptionKey()));
            BusinessDetail businessDetail = list.getBusinessDetail();
            if (businessDetail.isTruncated().booleanValue()) {
                log.info((Object)("The businessDetail is truncated, the maxEntries must have been hit. The number of businesses is " + businessDetail.getBusinessEntity().size()));
            }
            for (BusinessEntity businessEntity : businessDetail.getBusinessEntity()) {
                new XRegistration(businessEntity.getBusinessKey(), new UDDIClerk(fromClerk), new UDDIClerk(toClerk)).xRegisterBusinessAndServices();
            }
        }
        if (list.getKeyBag() != null) {
            log.info((Object)"Returning results when a 'brief' format is selected, please do not use 'brief' results when using the XRegistration functionality");
        }
        if (list.getBindingDetail() != null) {
            log.info((Object)("Subscription result for BindingDetail with subscription key=" + list.getSubscription().getSubscriptionKey()));
            BindingDetail bindingDetail = list.getBindingDetail();
            if (bindingDetail.isTruncated().booleanValue()) {
                log.info((Object)("The bindingDetail is truncated, the maxEntries must have been hit. The number of bindings is " + bindingDetail.getBindingTemplate().size()));
            }
            for (BindingTemplate bindingTemplate : bindingDetail.getBindingTemplate()) {
                try {
                    BusinessService existingToService = uddiToClerk.findService(bindingTemplate.getServiceKey(), toClerk.getNode());
                    if (existingToService != null) {
                        log.debug((Object)("Found service with key " + existingToService.getServiceKey() + ". No need to add it again"));
                    } else {
                        BusinessService fromService = uddiFromClerk.findService(bindingTemplate.getServiceKey(), fromClerk.getNode());
                        BusinessEntity existingBusinessEntity = uddiToClerk.findBusiness(fromService.getBusinessKey(), toClerk.getNode());
                        if (existingBusinessEntity != null) {
                            log.debug((Object)("Found business with key " + existingBusinessEntity.getBusinessKey() + ". No need to add it again"));
                        } else {
                            log.info((Object)("Business was not found in the destination UDDI " + toClerk.getNode().getName() + ", going to add it in."));
                            new XRegistration(fromService.getBusinessKey(), new UDDIClerk(fromClerk), new UDDIClerk(toClerk)).xRegisterBusiness();
                        }
                        log.info((Object)("Service was not found in the destination UDDI " + toClerk.getNode().getName() + ", going to add it in."));
                        new XRegistration(fromService.getServiceKey(), new UDDIClerk(fromClerk), new UDDIClerk(toClerk)).xRegisterService();
                    }
                    new XRegistration(bindingTemplate.getBindingKey(), new UDDIClerk(fromClerk), new UDDIClerk(toClerk)).xRegisterServiceBinding();
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        if (list.getRelatedBusinessesList() != null) {
            log.info((Object)("Subscription result for RelatedBusinesses with subscription key=" + list.getSubscription().getSubscriptionKey()));
            log.info((Object)"The jUDDI Listener is not doing anything with this subscription at this moment");
        }
        if (list.getAssertionStatusReport() != null) {
            log.info((Object)("Subscription result for AssertionStatusReport with subscription key=" + list.getSubscription().getSubscriptionKey()));
            log.info((Object)"The jUDDI Listener is not doing anything with this subscription at this moment");
        }
        if (list.getTModelList() != null) {
            log.info((Object)("Subscription result for tModelList with subscription key=" + list.getSubscription().getSubscriptionKey()));
            log.info((Object)"The jUDDI Listener is not doing anything with this subscription at this moment");
        }
    }
}

