/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.config;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.ClassUtil;
import org.apache.juddi.Registry;
import org.apache.juddi.config.Install;
import org.apache.juddi.config.PersistenceManager;
import org.apache.juddi.model.UddiEntityPublisher;

public class AppConfig {
    public static final String JUDDI_CONFIGURATION_FILE_SYSTEM_PROPERTY = "juddi.propertiesFile";
    public static final String JUDDI_PROPERTIES = "juddiv3.xml";
    private Log log = LogFactory.getLog(AppConfig.class);
    private Configuration config;
    private static AppConfig instance = null;
    private static URL loadedFrom = null;
    private static XMLConfiguration propConfig = null;

    public static URL getConfigFileURL() {
        return loadedFrom;
    }

    private AppConfig() throws ConfigurationException {
        this.loadConfiguration();
    }

    public static void setJuddiProperty(String key, Object val) throws ConfigurationException {
        if (instance == null) {
            instance = new AppConfig();
        }
        propConfig.setProperty(key, val);
        propConfig.save();
    }

    public static void saveConfiguration() throws ConfigurationException {
        AppConfig.getConfiguration();
        propConfig.save();
    }

    private void loadConfiguration() throws ConfigurationException {
        CompositeConfiguration compositeConfig = new CompositeConfiguration();
        compositeConfig.addConfiguration((Configuration)new SystemConfiguration());
        propConfig = null;
        String filename = System.getProperty(JUDDI_CONFIGURATION_FILE_SYSTEM_PROPERTY);
        if (filename != null) {
            propConfig = new XMLConfiguration(filename);
            try {
                loadedFrom = new File(filename).toURI().toURL();
            }
            catch (MalformedURLException ex) {
                try {
                    loadedFrom = new URL("file://" + filename);
                }
                catch (MalformedURLException ex1) {
                    this.log.warn((Object)("unable to get an absolute path to " + filename + ". This may be ignorable if everything works properly."), (Throwable)ex1);
                }
            }
        } else {
            propConfig = new XMLConfiguration(JUDDI_PROPERTIES);
            loadedFrom = ClassUtil.getResource(JUDDI_PROPERTIES, this.getClass());
        }
        propConfig.setAutoSave(true);
        this.log.info((Object)("Reading from jUDDI config file from:  " + loadedFrom));
        long refreshDelay = propConfig.getLong("juddi.configuration.reload.delay", 1000L);
        this.log.debug((Object)("Setting refreshDelay to " + refreshDelay));
        FileChangedReloadingStrategy fileChangedReloadingStrategy = new FileChangedReloadingStrategy();
        fileChangedReloadingStrategy.setRefreshDelay(refreshDelay);
        propConfig.setReloadingStrategy((ReloadingStrategy)fileChangedReloadingStrategy);
        compositeConfig.addConfiguration((Configuration)propConfig);
        Properties properties = new Properties();
        if ("Hibernate".equals(propConfig.getString("persistenceProvider"))) {
            if (propConfig.containsKey("hibernate.connection.datasource")) {
                properties.put("hibernate.connection.datasource", propConfig.getString("hibernate.connection.datasource"));
            }
            if (propConfig.containsKey("hibernate.hbm2ddl.auto")) {
                properties.put("hibernate.hbm2ddl.auto", propConfig.getString("hibernate.hbm2ddl.auto"));
            }
            if (propConfig.containsKey("hibernate.default_schema")) {
                properties.put("hibernate.default_schema", propConfig.getString("hibernate.default_schema"));
            }
            if (propConfig.containsKey("hibernate.dialect")) {
                properties.put("hibernate.dialect", propConfig.getString("hibernate.dialect"));
            }
        }
        PersistenceManager.initializeEntityManagerFactory(propConfig.getString("juddi.persistenceunit.name"), properties);
        MapConfiguration persistentConfig = new MapConfiguration(this.getPersistentConfiguration((Configuration)compositeConfig));
        compositeConfig.addConfiguration((Configuration)persistentConfig);
        this.config = compositeConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getPersistentConfiguration(Configuration config) throws ConfigurationException {
        Properties result = new Properties();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            boolean seedAlways = config.getBoolean("juddi.seed.always", false);
            if (seedAlways || !Install.alreadyInstalled(config)) {
                if (seedAlways) {
                    this.log.info((Object)"Installing UDDI seed data, loading...");
                } else {
                    this.log.info((Object)"The 'root' publisher was not found, loading...");
                }
                try {
                    Install.install(config);
                }
                catch (Exception e) {
                    throw new ConfigurationException((Throwable)e);
                }
                catch (Throwable t) {
                    throw new ConfigurationException(t);
                }
            }
            tx.begin();
            String rootPublisherStr = config.getString("juddi.root.publisher");
            UddiEntityPublisher rootPublisher = new UddiEntityPublisher(rootPublisherStr);
            rootPublisher.populateKeyGeneratorKeys(em);
            List<String> rootKeyGenList = rootPublisher.getKeyGeneratorKeys();
            if (rootKeyGenList == null || rootKeyGenList.size() == 0) {
                throw new ConfigurationException("The 'root' publisher key generator was not found.  Please make sure that the application is properly installed.");
            }
            String rootKeyGen = rootKeyGenList.iterator().next();
            rootKeyGen = rootKeyGen.substring(0, rootKeyGen.length() - ":keygenerator".length());
            this.log.debug((Object)("root partition:  " + rootKeyGen));
            result.setProperty("juddi.root.partition", rootKeyGen);
            String nodeId = config.getString("juddi.nodeId");
            if (nodeId == null) {
                this.log.fatal((Object)"Error! juddi.nodeId is not defined in the config!");
            } else {
                result.setProperty("juddi.nodeId", nodeId);
            }
            String rootbiz = config.getString("juddi.root.businessId");
            if (rootbiz == null) {
                this.log.fatal((Object)"Error! juddi.root.businessId is not defined in the config");
            } else {
                result.setProperty("juddi.root.businessId", rootbiz);
            }
            tx.commit();
            Properties properties = result;
            return properties;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    public static AppConfig getInstance() throws ConfigurationException {
        if (instance == null) {
            instance = new AppConfig();
        }
        return instance;
    }

    public static void reloadConfig() throws ConfigurationException {
        Registry.stop();
        AppConfig.getInstance().loadConfiguration();
        Registry.start();
    }

    public static void triggerReload() throws ConfigurationException {
        AppConfig.getInstance().loadConfiguration();
    }

    public static Configuration getConfiguration() throws ConfigurationException {
        return AppConfig.getInstance().config;
    }
}

