/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.config;

import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.config.AppConfig;

public class PersistenceManager {
    private static Log log = LogFactory.getLog(PersistenceManager.class);
    public static final String PERSISTENCE_UNIT_NAME = "juddiDatabase";
    private static EntityManagerFactory emf;

    public static EntityManager getEntityManager() {
        try {
            if (emf == null) {
                AppConfig.getInstance();
            }
        }
        catch (ConfigurationException e) {
            log.error((Object)"Error initializing config in PersistenceManager", (Throwable)e);
            throw new ExceptionInInitializerError(e);
        }
        return emf.createEntityManager();
    }

    public static void closeEntityManager() {
        if (emf.isOpen()) {
            emf.close();
        }
    }

    protected static void initializeEntityManagerFactory(String persistenceUnitName, Properties properties) {
        try {
            if (emf == null) {
                emf = properties == null || properties.size() == 0 ? Persistence.createEntityManagerFactory((String)persistenceUnitName) : Persistence.createEntityManagerFactory((String)persistenceUnitName, (Map)properties);
            }
        }
        catch (Throwable t) {
            log.error((Object)"entityManagerFactory creation failed", t);
            throw new ExceptionInInitializerError(t);
        }
    }
}

