/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.query;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.persistence.EntityManager;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.query.BindingTemplateQuery;
import org.apache.juddi.query.util.DynamicQuery;
import org.apache.juddi.query.util.FindQualifiers;
import org.uddi.api_v3.ListDescription;
import org.uddi.v3_service.DispositionReportFaultMessage;

public class FetchBindingTemplatesQuery
extends BindingTemplateQuery {
    private static final Log log = LogFactory.getLog(FetchBindingTemplatesQuery.class);
    protected static final String selectSQL;

    public static List<?> select(EntityManager em, FindQualifiers fq, List<?> keysIn, Integer maxRowsUser, Integer listHead, ListDescription listDesc, DynamicQuery.Parameter ... restrictions) throws DispositionReportFaultMessage {
        if (keysIn == null || keysIn.size() == 0) {
            return Collections.emptyList();
        }
        int maxRows = 1000;
        try {
            maxRows = AppConfig.getConfiguration().getInteger("juddi.maxRows", Integer.valueOf(1000));
        }
        catch (ConfigurationException ce) {
            log.error((Object)"Configuration exception occurred retrieving: juddi.maxRows");
        }
        DynamicQuery dynamicQry = new DynamicQuery(selectSQL);
        if (keysIn.size() > maxRows) {
            UUID uuid = UUID.randomUUID();
            FetchBindingTemplatesQuery.storeIntermediateKeySetResults(em, uuid.toString(), keysIn);
            FetchBindingTemplatesQuery.appendTempTable(dynamicQry);
            FetchBindingTemplatesQuery.appendSortTables(dynamicQry);
            FetchBindingTemplatesQuery.appendTempJoin(dynamicQry, uuid.toString());
        } else {
            FetchBindingTemplatesQuery.appendSortTables(dynamicQry);
            dynamicQry.appendInListWithAnd("bt.entityKey", keysIn);
        }
        if (restrictions != null && restrictions.length > 0) {
            dynamicQry.AND().pad().appendGroupedAnd(restrictions);
        }
        FetchBindingTemplatesQuery.appendSortCriteria(dynamicQry, fq);
        log.debug((Object)dynamicQry);
        return FetchBindingTemplatesQuery.getPagedResult(em, dynamicQry, maxRowsUser, listHead, listDesc);
    }

    private static void appendTempTable(DynamicQuery qry) {
        qry.comma().append("TempKey tk");
    }

    private static void appendTempJoin(DynamicQuery qry, String uuid) {
        qry.pad().AND().pad().append("tk.pk.entityKey").append("=");
        qry.pad().append("bt.entityKey");
        qry.pad().AND().pad().append("tk.pk.txId").append("=");
        qry.append("'" + uuid + "'").pad();
    }

    private static void appendSortTables(DynamicQuery qry) {
        qry.WHERE().pad().append("1=1").pad();
    }

    private static void appendSortCriteria(DynamicQuery qry, FindQualifiers fq) {
        qry.ORDERBY().pad();
        if (fq.isSortByDateAsc()) {
            qry.append("bt.modified").pad().append("asc");
        } else {
            qry.append("bt.modified").pad().append("desc");
        }
        qry.pad();
    }

    static {
        StringBuilder sql = new StringBuilder(200);
        sql.append("select bt from BindingTemplate bt ");
        selectSQL = sql.toString();
    }
}

