/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.query;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.persistence.EntityManager;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.query.BusinessEntityQuery;
import org.apache.juddi.query.util.DynamicQuery;
import org.apache.juddi.query.util.FindQualifiers;
import org.uddi.api_v3.ListDescription;
import org.uddi.v3_service.DispositionReportFaultMessage;

public class FetchBusinessEntitiesQuery
extends BusinessEntityQuery {
    private static final Log log = LogFactory.getLog(FetchBusinessEntitiesQuery.class);
    protected static final String selectSQL;

    public static List<?> select(EntityManager em, FindQualifiers fq, List<?> keysIn, Integer maxRowsUser, Integer listHead, ListDescription listDesc, DynamicQuery.Parameter ... restrictions) throws DispositionReportFaultMessage {
        if (keysIn == null || keysIn.size() == 0) {
            return Collections.emptyList();
        }
        int maxRows = 1000;
        try {
            maxRows = AppConfig.getConfiguration().getInteger("juddi.maxRows", Integer.valueOf(1000));
        }
        catch (ConfigurationException ce) {
            log.error((Object)"Configuration exception occurred retrieving: juddi.maxRows");
        }
        DynamicQuery dynamicQry = new DynamicQuery(selectSQL);
        if (keysIn.size() > maxRows) {
            UUID uuid = UUID.randomUUID();
            FetchBusinessEntitiesQuery.storeIntermediateKeySetResults(em, uuid.toString(), keysIn);
            FetchBusinessEntitiesQuery.appendTempTable(dynamicQry);
            FetchBusinessEntitiesQuery.appendSortTables(dynamicQry);
            FetchBusinessEntitiesQuery.appendTempJoin(dynamicQry, uuid.toString());
        } else {
            FetchBusinessEntitiesQuery.appendSortTables(dynamicQry);
            dynamicQry.appendInListWithAnd("be.entityKey", keysIn);
        }
        if (restrictions != null && restrictions.length > 0) {
            dynamicQry.AND().pad().appendGroupedAnd(restrictions);
        }
        FetchBusinessEntitiesQuery.appendSortCriteria(dynamicQry, fq);
        log.debug((Object)dynamicQry);
        return FetchBusinessEntitiesQuery.getPagedResult(em, dynamicQry, maxRowsUser, listHead, listDesc);
    }

    private static void appendTempTable(DynamicQuery qry) {
        qry.comma().append("TempKey tk");
    }

    private static void appendTempJoin(DynamicQuery qry, String uuid) {
        qry.pad().AND().pad().append("tk.pk.entityKey").append("=");
        qry.pad().append("be.entityKey");
        qry.pad().AND().pad().append("tk.pk.txId").append("=");
        qry.append("'" + uuid + "'").pad();
    }

    private static void appendSortTables(DynamicQuery qry) {
        qry.pad().comma().pad().append("BusinessName").pad().append(FetchBusinessEntitiesQuery.buildAlias("BusinessName")).pad();
        qry.WHERE().pad().append("be.entityKey").pad();
        qry.append("=").pad();
        qry.append(FetchBusinessEntitiesQuery.buildAlias("BusinessName") + "." + "businessEntity" + "." + "entityKey").pad();
    }

    private static void appendSortCriteria(DynamicQuery qry, FindQualifiers fq) {
        String nameTerm = FetchBusinessEntitiesQuery.buildAlias("BusinessName") + ".name";
        if (fq.isCaseInsensitiveSort()) {
            log.info((Object)"jUDDI does not support caseInsensitive sort, as JPA does not support sortBy with UPPER or LOWER, see https://issues.apache.org/jira/browse/OPENJPA-1817. A work around is to do a caseInsentive Match.");
        }
        String dateTerm = "be.modified";
        String orderClause = nameTerm + " " + "asc" + ", " + dateTerm + " " + "desc";
        if (fq.isSortByNameAsc()) {
            if (fq.isSortByDateAsc()) {
                orderClause = nameTerm + " " + "asc" + ", " + dateTerm + " " + "asc";
            }
        } else if (fq.isSortByNameDesc()) {
            orderClause = fq.isSortByDateAsc() ? nameTerm + " " + "desc" + ", " + dateTerm + " " + "asc" : nameTerm + " " + "desc" + ", " + dateTerm + " " + "desc";
        } else if (fq.isSortByDateAsc()) {
            orderClause = dateTerm + " " + "asc" + ", " + nameTerm + " " + "asc";
        } else if (fq.isSortByDateDesc()) {
            orderClause = dateTerm + " " + "desc" + ", " + nameTerm + " " + "asc";
        }
        qry.ORDERBY().pad();
        qry.append(orderClause);
        qry.pad();
    }

    static {
        StringBuilder sql = new StringBuilder(200);
        sql.append("select be from BusinessEntity be ");
        selectSQL = sql.toString();
    }
}

