/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.query.EntityQuery;
import org.apache.juddi.query.util.DynamicQuery;
import org.apache.juddi.query.util.FindQualifiers;
import org.apache.juddi.query.util.KeyedRefGroupTModelComparator;
import org.uddi.api_v3.CategoryBag;
import org.uddi.api_v3.KeyedReference;
import org.uddi.api_v3.KeyedReferenceGroup;

public class FindEntityByCategoryGroupQuery
extends EntityQuery {
    private static final Log log = LogFactory.getLog(FindEntityByCategoryGroupQuery.class);
    private static final String ENTITY_KEYEDREFERENCEGROUP = "KeyedReferenceGroup";
    private static final String ALIAS_KEYEDREFERENCEGROUP = "krg";
    private static final String FIELD_CATEGORYBAG = "categoryBag";
    private static final String ENTITY_KEYEDREFERENCE = "KeyedReference";
    private static final String ALIAS_KEYEDREFERENCE = FindEntityByCategoryGroupQuery.buildAlias("KeyedReference");
    private static final String FIELD_KEYEDREFERENCEGROUP = "keyedReferenceGroup";
    private final String entityName;
    private final String entityAlias;
    private final String keyName;
    private final String entityField;
    private final String entityNameChild;
    private final String entityAliasChild;
    private final String selectSQL;
    private String signaturePresent;

    public FindEntityByCategoryGroupQuery(String entityName, String entityAlias, String keyName, String entityField, String entityNameChild, String signaturePresent) {
        this.entityName = entityName;
        this.entityAlias = entityAlias;
        this.keyName = keyName;
        this.entityField = entityField;
        this.entityNameChild = entityNameChild;
        this.entityAliasChild = FindEntityByCategoryGroupQuery.buildAlias(entityNameChild);
        this.signaturePresent = signaturePresent;
        StringBuffer sql = new StringBuffer(200);
        sql.append("select distinct " + entityAlias + "." + keyName + " from " + entityName + " " + entityAlias + " , " + entityNameChild + " " + this.entityAliasChild + " , " + ENTITY_KEYEDREFERENCEGROUP + " " + ALIAS_KEYEDREFERENCEGROUP + " ");
        this.selectSQL = sql.toString();
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getEntityAlias() {
        return this.entityAlias;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public String getEntityField() {
        return this.entityField;
    }

    public String getEntityNameChild() {
        return this.entityNameChild;
    }

    public String getEntityAliasChild() {
        return this.entityAliasChild;
    }

    public String getSelectSQL() {
        return this.selectSQL;
    }

    public String getSignaturePresent() {
        return this.signaturePresent;
    }

    public void setSignaturePresent(String signaturePresent) {
        this.signaturePresent = signaturePresent;
    }

    public List<Object> select(EntityManager em, FindQualifiers fq, CategoryBag categoryBag, List<Object> keysIn, DynamicQuery.Parameter ... restrictions) {
        if (keysIn != null && keysIn.size() == 0) {
            return keysIn;
        }
        if (categoryBag == null) {
            return keysIn;
        }
        List categories = categoryBag.getKeyedReferenceGroup();
        if (categories == null || categories.size() == 0) {
            return keysIn;
        }
        ArrayList<KeyedReferenceGroup> keyedRefGroups = new ArrayList<KeyedReferenceGroup>(0);
        for (KeyedReferenceGroup elem : categories) {
            if (!(elem instanceof KeyedReferenceGroup)) continue;
            keyedRefGroups.add(elem);
        }
        if (keyedRefGroups.size() == 0) {
            return keysIn;
        }
        Collections.sort(keyedRefGroups, new KeyedRefGroupTModelComparator());
        int count = 0;
        String prevTModelKey = null;
        HashSet<Object> orResults = new HashSet<Object>(0);
        List<Object> restrictionList = keysIn;
        List<Object> curResult = null;
        for (KeyedReferenceGroup keyedRefGroup : keyedRefGroups) {
            String curTModelKey = keyedRefGroup.getTModelKey();
            DynamicQuery dynamicQry = new DynamicQuery(this.selectSQL);
            this.appendConditions(dynamicQry, fq, keyedRefGroup);
            if (restrictions != null && restrictions.length > 0) {
                dynamicQry.AND().pad().appendGroupedAnd(restrictions);
            }
            if (fq.isOrLikeKeys()) {
                if (!curTModelKey.equals(prevTModelKey) && count != 0) {
                    restrictionList = new ArrayList<Object>(orResults);
                    orResults.clear();
                }
            } else if (!fq.isOrAllKeys() && count != 0) {
                restrictionList = curResult;
            }
            if (restrictionList != null && restrictionList.size() == 0) break;
            curResult = FindEntityByCategoryGroupQuery.getQueryResult(em, dynamicQry, restrictionList, this.entityAlias + "." + this.keyName);
            if (fq.isOrAllKeys() || fq.isOrLikeKeys()) {
                orResults.addAll(curResult);
            }
            prevTModelKey = curTModelKey;
            ++count;
        }
        ArrayList<Object> result = null;
        if (fq.isOrAllKeys() || fq.isOrLikeKeys()) {
            result = new ArrayList<Object>(0);
            result.addAll(orResults);
        } else {
            result = curResult;
        }
        return result;
    }

    public void appendConditions(DynamicQuery qry, FindQualifiers fq, KeyedReferenceGroup keyedRefGroup) {
        this.appendJoinTables(qry, fq, keyedRefGroup);
        qry.AND().pad().appendGroupedAnd(new DynamicQuery.Parameter("krg.tmodelKey", keyedRefGroup.getTModelKey(), "="));
        List keyedRefs = keyedRefGroup.getKeyedReference();
        if (keyedRefs != null && keyedRefs.size() > 0) {
            qry.AND().pad().openParen().pad();
            String predicate = "=";
            if (fq.isApproximateMatch()) {
                predicate = "like";
            }
            int count = 0;
            int tblCount = -1;
            for (KeyedReference keyedRef : keyedRefs) {
                String tmodelKey = keyedRef.getTModelKey();
                String keyValue = keyedRef.getKeyValue();
                String keyName = keyedRef.getKeyName();
                if (fq.isApproximateMatch()) {
                    // empty if block
                }
                String keyValueTerm = ALIAS_KEYEDREFERENCE + ++tblCount + ".keyValue";
                String keyNameTerm = ALIAS_KEYEDREFERENCE + tblCount + ".keyName";
                String tmodelKeyTerm = ALIAS_KEYEDREFERENCE + tblCount + ".tmodelKeyRef";
                if (fq.isCaseInsensitiveMatch()) {
                    keyValueTerm = "upper(" + keyValueTerm + ")";
                    keyValue = keyValue.toUpperCase();
                    keyNameTerm = "upper(" + keyNameTerm + ")";
                    keyName = keyName.toUpperCase();
                }
                if ("uddi:uddi.org:categorization:general_keywords".equalsIgnoreCase(tmodelKey)) {
                    qry.appendGroupedAnd(new DynamicQuery.Parameter(tmodelKeyTerm, tmodelKey, "="), new DynamicQuery.Parameter(keyValueTerm, keyValue, predicate), new DynamicQuery.Parameter(keyNameTerm, keyName, predicate));
                } else {
                    qry.appendGroupedAnd(new DynamicQuery.Parameter(tmodelKeyTerm, tmodelKey, "="), new DynamicQuery.Parameter(keyValueTerm, keyValue, predicate));
                }
                if (count + 1 < keyedRefs.size()) {
                    qry.AND().pad();
                }
                ++count;
            }
            qry.closeParen().pad();
        }
    }

    public void appendJoinTables(DynamicQuery qry, FindQualifiers fq, KeyedReferenceGroup keyedRefGroup) {
        if (keyedRefGroup != null) {
            List keyedRefs = keyedRefGroup.getKeyedReference();
            StringBuffer thetaJoins = new StringBuffer(200);
            if (keyedRefs != null && keyedRefs.size() > 0) {
                int tblCount = 0;
                for (int count = 0; count < keyedRefs.size(); ++count) {
                    if (count != 0) {
                        qry.comma().pad().append("KeyedReference " + ALIAS_KEYEDREFERENCE + ++tblCount).pad();
                        thetaJoins.append(ALIAS_KEYEDREFERENCE + (tblCount - 1) + "." + FIELD_KEYEDREFERENCEGROUP + ".id = " + ALIAS_KEYEDREFERENCE + tblCount + "." + FIELD_KEYEDREFERENCEGROUP + ".id ");
                        thetaJoins.append("and ");
                        continue;
                    }
                    qry.comma().pad().append("KeyedReference " + ALIAS_KEYEDREFERENCE + tblCount).pad();
                    thetaJoins.append("krg.id = " + ALIAS_KEYEDREFERENCE + tblCount + "." + FIELD_KEYEDREFERENCEGROUP + ".id ");
                    thetaJoins.append("and ");
                }
            }
            qry.WHERE().pad().openParen().pad();
            qry.append(this.entityAlias + "." + this.keyName + " = " + this.entityAliasChild + "." + this.entityField + "." + "entityKey").pad();
            qry.AND().pad();
            qry.append(this.entityAliasChild + ".id = " + ALIAS_KEYEDREFERENCEGROUP + "." + FIELD_CATEGORYBAG + ".id").pad();
            String thetaJoinsStr = thetaJoins.toString();
            if (thetaJoinsStr != null && thetaJoinsStr.length() > 0) {
                qry.AND().pad();
            }
            if (thetaJoinsStr.endsWith("and ")) {
                thetaJoinsStr = thetaJoinsStr.substring(0, thetaJoinsStr.length() - "and ".length());
            }
            qry.append(thetaJoinsStr);
            qry.closeParen().pad();
            if (fq != null && fq.isSignaturePresent()) {
                qry.AND().pad().openParen().pad().append(this.getSignaturePresent()).pad().closeParen().pad();
            }
        }
    }
}

