/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.query.EntityQuery;
import org.apache.juddi.query.util.DynamicQuery;
import org.apache.juddi.query.util.FindQualifiers;
import org.apache.juddi.query.util.KeyedRefTModelComparator;
import org.uddi.api_v3.CategoryBag;
import org.uddi.api_v3.KeyedReference;

public class FindEntityByCategoryQuery
extends EntityQuery {
    private static final Log log = LogFactory.getLog(FindEntityByCategoryQuery.class);
    private static final String ENTITY_KEYEDREFERENCE = "KeyedReference";
    private static final String ALIAS_KEYEDREFERENCE = FindEntityByCategoryQuery.buildAlias("KeyedReference");
    private static final String FIELD_CATEGORYBAG = "categoryBag";
    protected String entityName;
    protected String entityAlias;
    protected String keyName;
    protected String entityField;
    protected String entityNameChild;
    protected String entityAliasChild;
    protected String selectSQL;
    protected String signaturePresent;

    public FindEntityByCategoryQuery(String entityName, String entityAlias, String keyName, String entityField, String entityNameChild, String signaturePresent) {
        this.entityName = entityName;
        this.entityAlias = entityAlias;
        this.keyName = keyName;
        this.entityField = entityField;
        this.entityNameChild = entityNameChild;
        this.entityAliasChild = FindEntityByCategoryQuery.buildAlias(entityNameChild);
        this.signaturePresent = signaturePresent;
        StringBuffer sql = new StringBuffer(200);
        sql.append("select distinct " + entityAlias + "." + keyName + " from " + entityName + " " + entityAlias + " , " + entityNameChild + " " + this.entityAliasChild + " ");
        this.selectSQL = sql.toString();
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getEntityAlias() {
        return this.entityAlias;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public String getEntityField() {
        return this.entityField;
    }

    public String getEntityNameChild() {
        return this.entityNameChild;
    }

    public String getEntityAliasChild() {
        return this.entityAliasChild;
    }

    public String getSelectSQL() {
        return this.selectSQL;
    }

    public String getSignaturePresent() {
        return this.signaturePresent;
    }

    public void setSignaturePresent(String signaturePresent) {
        this.signaturePresent = signaturePresent;
    }

    public List<Object> select(EntityManager em, FindQualifiers fq, CategoryBag categoryBag, List<Object> keysIn, DynamicQuery.Parameter ... restrictions) {
        if (keysIn != null && keysIn.size() == 0) {
            return keysIn;
        }
        if (categoryBag == null) {
            return keysIn;
        }
        List categories = categoryBag.getKeyedReference();
        if (categories == null || categories.size() == 0) {
            return keysIn;
        }
        ArrayList<KeyedReference> keyedRefs = new ArrayList<KeyedReference>(0);
        for (KeyedReference elem : categories) {
            if (!(elem instanceof KeyedReference)) continue;
            keyedRefs.add(elem);
        }
        if (keyedRefs.isEmpty()) {
            return keysIn;
        }
        DynamicQuery dynamicQry = new DynamicQuery(this.selectSQL);
        this.appendConditions(dynamicQry, fq, keyedRefs);
        if (restrictions != null && restrictions.length > 0) {
            dynamicQry.AND().pad().appendGroupedAnd(restrictions);
        }
        return FindEntityByCategoryQuery.getQueryResult(em, dynamicQry, keysIn, this.entityAlias + "." + this.keyName);
    }

    public void appendConditions(DynamicQuery qry, FindQualifiers fq, List<KeyedReference> keyedRefs) {
        this.appendJoinTables(qry, fq, keyedRefs);
        qry.AND().pad().openParen().pad();
        String predicate = "=";
        if (fq.isApproximateMatch()) {
            predicate = "like";
        }
        Collections.sort(keyedRefs, new KeyedRefTModelComparator());
        String prevTModelKey = null;
        int count = 0;
        int tblCount = -1;
        for (KeyedReference keyedRef : keyedRefs) {
            String tmodelKey = keyedRef.getTModelKey();
            String keyValue = keyedRef.getKeyValue();
            String keyName = keyedRef.getKeyName();
            if (fq.isApproximateMatch()) {
                // empty if block
            }
            if (fq.isOrLikeKeys()) {
                if (count == 0) {
                    qry.openParen().pad();
                    ++tblCount;
                } else if (!tmodelKey.equals(prevTModelKey)) {
                    qry.closeParen().pad().AND().pad().openParen().pad();
                    ++tblCount;
                } else {
                    qry.OR().pad();
                }
            } else {
                ++tblCount;
            }
            String keyValueTerm = (fq.isOrAllKeys() ? ALIAS_KEYEDREFERENCE + "0" : ALIAS_KEYEDREFERENCE + tblCount) + ".keyValue";
            String keyNameTerm = (fq.isOrAllKeys() ? ALIAS_KEYEDREFERENCE + "0" : ALIAS_KEYEDREFERENCE + tblCount) + ".keyName";
            String tmodelKeyTerm = (fq.isOrAllKeys() ? ALIAS_KEYEDREFERENCE + "0" : ALIAS_KEYEDREFERENCE + tblCount) + ".tmodelKeyRef";
            if (fq.isCaseInsensitiveMatch()) {
                keyValueTerm = "upper(" + keyValueTerm + ")";
                keyValue = keyValue.toUpperCase();
                keyNameTerm = "upper(" + keyNameTerm + ")";
                keyName = keyName.toUpperCase();
            }
            if ("uddi:uddi.org:categorization:general_keywords".equalsIgnoreCase(tmodelKey)) {
                qry.appendGroupedAnd(new DynamicQuery.Parameter(tmodelKeyTerm, tmodelKey, "="), new DynamicQuery.Parameter(keyValueTerm, keyValue, predicate), new DynamicQuery.Parameter(keyNameTerm, keyName, predicate));
            } else {
                qry.appendGroupedAnd(new DynamicQuery.Parameter(tmodelKeyTerm, tmodelKey, "="), new DynamicQuery.Parameter(keyValueTerm, keyValue, predicate));
            }
            if (count + 1 < keyedRefs.size()) {
                if (fq.isOrAllKeys()) {
                    qry.OR().pad();
                } else if (!fq.isOrLikeKeys()) {
                    qry.AND().pad();
                }
            }
            if (fq.isOrLikeKeys() && count + 1 == keyedRefs.size()) {
                qry.closeParen().pad();
            }
            prevTModelKey = tmodelKey;
            ++count;
        }
        qry.closeParen().pad();
    }

    public void appendJoinTables(DynamicQuery qry, FindQualifiers fq, List<KeyedReference> keyedRefs) {
        if (keyedRefs != null && keyedRefs.size() > 0) {
            Collections.sort(keyedRefs, new KeyedRefTModelComparator());
            StringBuffer thetaJoins = new StringBuffer(200);
            int tblCount = 0;
            int count = 0;
            String curTModelKey = null;
            String prevTModelKey = null;
            for (KeyedReference kr : keyedRefs) {
                curTModelKey = kr.getTModelKey();
                if (count != 0) {
                    if (!(fq.isOrAllKeys() || fq.isOrLikeKeys() && curTModelKey.equals(prevTModelKey))) {
                        qry.comma().pad().append("KeyedReference " + ALIAS_KEYEDREFERENCE + ++tblCount).pad();
                        thetaJoins.append(ALIAS_KEYEDREFERENCE + (tblCount - 1) + "." + FIELD_CATEGORYBAG + ".id = " + ALIAS_KEYEDREFERENCE + tblCount + "." + FIELD_CATEGORYBAG + ".id ");
                        thetaJoins.append("and ");
                    }
                } else {
                    qry.comma().pad().append("KeyedReference " + ALIAS_KEYEDREFERENCE + tblCount).pad();
                    thetaJoins.append(this.entityAliasChild + ".id = " + ALIAS_KEYEDREFERENCE + tblCount + "." + FIELD_CATEGORYBAG + ".id ");
                    thetaJoins.append("and ");
                }
                prevTModelKey = curTModelKey;
                ++count;
            }
            qry.WHERE().pad().openParen().pad();
            qry.append(this.entityAlias + "." + this.keyName + " = " + this.entityAliasChild + "." + this.entityField + "." + "entityKey").pad();
            qry.AND().pad();
            String thetaJoinsStr = thetaJoins.toString();
            if (thetaJoinsStr.endsWith("and ")) {
                thetaJoinsStr = thetaJoinsStr.substring(0, thetaJoinsStr.length() - "and ".length());
            }
            qry.append(thetaJoinsStr);
            qry.closeParen().pad();
            if (fq != null && fq.isSignaturePresent()) {
                qry.AND().pad().openParen().pad().append(this.getSignaturePresent()).pad().closeParen().pad();
            }
        }
    }
}

