/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.query;

import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.query.EntityQuery;
import org.apache.juddi.query.util.DynamicQuery;
import org.apache.juddi.query.util.FindQualifiers;
import org.apache.juddi.query.util.KeyedRefTModelComparator;
import org.uddi.api_v3.IdentifierBag;
import org.uddi.api_v3.KeyedReference;

public class FindEntityByIdentifierQuery
extends EntityQuery {
    private static final Log log = LogFactory.getLog(FindEntityByIdentifierQuery.class);
    private final String entityName;
    private final String entityAlias;
    private final String keyName;
    private final String entityField;
    private final String entityNameChild;
    private final String entityAliasChild;
    private final String selectSQL;
    private String signaturePresent;

    public FindEntityByIdentifierQuery(String entityName, String entityAlias, String keyName, String entityField, String entityNameChild, String signaturePresent) {
        this.entityName = entityName;
        this.entityAlias = entityAlias;
        this.keyName = keyName;
        this.entityField = entityField;
        this.entityNameChild = entityNameChild;
        this.entityAliasChild = FindEntityByIdentifierQuery.buildAlias(entityNameChild);
        this.signaturePresent = signaturePresent;
        StringBuilder sql = new StringBuilder(200);
        sql.append("select distinct ").append(entityAlias).append(".").append(keyName).append(" from ").append(entityName).append(" ").append(entityAlias).append(" ");
        this.selectSQL = sql.toString();
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getEntityAlias() {
        return this.entityAlias;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public String getEntityField() {
        return this.entityField;
    }

    public String getEntityNameChild() {
        return this.entityNameChild;
    }

    public String getEntityAliasChild() {
        return this.entityAliasChild;
    }

    public String getSelectSQL() {
        return this.selectSQL;
    }

    public String getSignaturePresent() {
        return this.signaturePresent;
    }

    public void setSignaturePresent(String signaturePresent) {
        this.signaturePresent = signaturePresent;
    }

    public List<Object> select(EntityManager em, FindQualifiers fq, IdentifierBag identifiers, List<Object> keysIn, DynamicQuery.Parameter ... restrictions) {
        if (keysIn != null && keysIn.size() == 0) {
            return keysIn;
        }
        if (identifiers == null) {
            return keysIn;
        }
        List keyedRefs = identifiers.getKeyedReference();
        if (keyedRefs == null || keyedRefs.size() == 0) {
            return keysIn;
        }
        DynamicQuery dynamicQry = new DynamicQuery(this.selectSQL);
        this.appendConditions(dynamicQry, fq, keyedRefs);
        if (restrictions != null && restrictions.length > 0) {
            dynamicQry.AND().pad().appendGroupedAnd(restrictions);
        }
        return FindEntityByIdentifierQuery.getQueryResult(em, dynamicQry, keysIn, this.entityAlias + "." + this.keyName);
    }

    public void appendConditions(DynamicQuery qry, FindQualifiers fq, List<KeyedReference> keyedRefs) {
        this.appendJoinTables(qry, fq, keyedRefs);
        qry.AND().pad().openParen().pad();
        String predicate = "=";
        if (fq.isApproximateMatch()) {
            predicate = "like";
        }
        Collections.sort(keyedRefs, new KeyedRefTModelComparator());
        String prevTModelKey = null;
        int count = 0;
        int tblCount = -1;
        for (KeyedReference keyedRef : keyedRefs) {
            String tmodelKey = keyedRef.getTModelKey();
            String keyValue = keyedRef.getKeyValue();
            String keyName = keyedRef.getKeyName();
            if (fq.isApproximateMatch()) {
                // empty if block
            }
            if (fq.isOrLikeKeys()) {
                if (count == 0) {
                    qry.openParen().pad();
                    ++tblCount;
                } else if (!tmodelKey.equals(prevTModelKey)) {
                    qry.closeParen().pad().AND().pad().openParen().pad();
                    ++tblCount;
                } else {
                    qry.OR().pad();
                }
            } else {
                ++tblCount;
            }
            String keyValueTerm = (fq.isAndAllKeys() || fq.isOrLikeKeys() ? this.entityAliasChild + tblCount : this.entityAliasChild + "0") + ".keyValue";
            String keyNameTerm = (fq.isAndAllKeys() || fq.isOrLikeKeys() ? this.entityAliasChild + tblCount : this.entityAliasChild + "0") + ".keyName";
            String tmodelKeyTerm = (fq.isAndAllKeys() || fq.isOrLikeKeys() ? this.entityAliasChild + tblCount : this.entityAliasChild + "0") + ".tmodelKeyRef";
            if (fq.isCaseInsensitiveMatch()) {
                keyValueTerm = "upper(" + keyValueTerm + ")";
                keyValue = keyValue.toUpperCase();
                keyNameTerm = "upper(" + keyNameTerm + ")";
                keyName = keyName.toUpperCase();
            }
            if ("uddi:uddi.org:categorization:general_keywords".equalsIgnoreCase(tmodelKey)) {
                qry.appendGroupedAnd(new DynamicQuery.Parameter(tmodelKeyTerm, tmodelKey, "="), new DynamicQuery.Parameter(keyValueTerm, keyValue, predicate), new DynamicQuery.Parameter(keyNameTerm, keyName, predicate));
            } else {
                qry.appendGroupedAnd(new DynamicQuery.Parameter(tmodelKeyTerm, tmodelKey, "="), new DynamicQuery.Parameter(keyValueTerm, keyValue, predicate));
            }
            if (count + 1 < keyedRefs.size()) {
                if (fq.isAndAllKeys()) {
                    qry.AND().pad();
                } else if (!fq.isOrLikeKeys()) {
                    qry.OR().pad();
                }
            }
            if (fq.isOrLikeKeys() && count + 1 == keyedRefs.size()) {
                qry.closeParen().pad();
            }
            prevTModelKey = tmodelKey;
            ++count;
        }
        qry.closeParen().pad();
    }

    public void appendJoinTables(DynamicQuery qry, FindQualifiers fq, List<KeyedReference> keyedRefs) {
        if (keyedRefs != null && keyedRefs.size() > 0) {
            Collections.sort(keyedRefs, new KeyedRefTModelComparator());
            StringBuffer thetaJoins = new StringBuffer(200);
            int tblCount = 0;
            int count = 0;
            String curTModelKey = null;
            String prevTModelKey = null;
            for (KeyedReference kr : keyedRefs) {
                curTModelKey = kr.getTModelKey();
                if (count != 0) {
                    if (!fq.isOrLikeKeys() || !curTModelKey.equals(prevTModelKey)) {
                        qry.comma().pad().append(this.entityNameChild + " " + this.entityAliasChild + ++tblCount).pad();
                        thetaJoins.append(this.entityAliasChild + (tblCount - 1) + "." + this.entityField + "." + this.keyName + " = " + this.entityAliasChild + tblCount + "." + this.entityField + "." + this.keyName + " ");
                        thetaJoins.append("and ");
                    }
                } else {
                    qry.comma().pad().append(this.entityNameChild + " " + this.entityAliasChild + tblCount).pad();
                    thetaJoins.append(this.entityAlias + "." + this.keyName + " = " + this.entityAliasChild + tblCount + "." + this.entityField + "." + this.keyName + " ");
                    thetaJoins.append("and ");
                }
                prevTModelKey = curTModelKey;
                ++count;
            }
            qry.WHERE().pad().openParen().pad();
            String thetaJoinsStr = thetaJoins.toString();
            if (thetaJoinsStr.endsWith("and ")) {
                thetaJoinsStr = thetaJoinsStr.substring(0, thetaJoinsStr.length() - "and ".length());
            }
            qry.append(thetaJoinsStr);
            qry.closeParen().pad();
            if (fq != null && fq.isSignaturePresent()) {
                qry.AND().pad().openParen().pad().append(this.getSignaturePresent()).pad().closeParen().pad();
            }
        }
    }
}

