/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.replication;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import javax.xml.ws.BindingProvider;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.api_v3.Node;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.config.PersistenceManager;
import org.apache.juddi.mapping.MappingApiToModel;
import org.apache.juddi.mapping.MappingModelToApi;
import org.apache.juddi.model.ChangeRecord;
import org.apache.juddi.model.ReplicationConfiguration;
import org.apache.juddi.v3.client.UDDIService;
import org.apache.juddi.v3.client.cryptor.TransportSecurityHelper;
import org.uddi.repl_v3.ChangeRecordIDType;
import org.uddi.repl_v3.CommunicationGraph;
import org.uddi.repl_v3.HighWaterMarkVectorType;
import org.uddi.repl_v3.NotifyChangeRecordsAvailable;
import org.uddi.repl_v3.Operator;
import org.uddi.v3_service.UDDIReplicationPortType;

public class ReplicationNotifier
extends TimerTask {
    private static Log log = LogFactory.getLog(ReplicationNotifier.class);
    private Timer timer = null;
    private long startBuffer = 5000L;
    private long interval = 5000L;
    private static String node = null;
    private static UDDIService uddiService = new UDDIService();
    static Queue<ChangeRecord> queue;
    static Queue<org.uddi.repl_v3.ChangeRecord> queue2;

    public ReplicationNotifier() throws ConfigurationException {
        this.init();
    }

    private synchronized void init() throws ConfigurationException {
        this.timer = new Timer(true);
        this.startBuffer = AppConfig.getConfiguration().getLong("juddi.replication.start.buffer", 5000L);
        this.interval = AppConfig.getConfiguration().getLong("juddi.replication.interval", 5000L);
        this.timer.scheduleAtFixedRate((TimerTask)this, this.startBuffer, this.interval);
        if (queue == null) {
            queue = new ConcurrentLinkedQueue<ChangeRecord>();
        }
        node = AppConfig.getConfiguration().getString("juddi.nodeId", "UNDEFINED_NODE_NAME");
    }

    @Override
    public boolean cancel() {
        this.timer.cancel();
        return super.cancel();
    }

    public static synchronized void enqueue(ChangeRecord change) {
        if (queue == null) {
            queue = new ConcurrentLinkedQueue<ChangeRecord>();
        }
        queue.add(change);
    }

    public static synchronized void EnqueueRetransmit(org.uddi.repl_v3.ChangeRecord change) {
        if (queue2 == null) {
            queue2 = new ConcurrentLinkedQueue<org.uddi.repl_v3.ChangeRecord>();
        }
        queue2.add(change);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ProcessChangeRecord(ChangeRecord j) {
        EntityTransaction tx = null;
        try (EntityManager em = PersistenceManager.getEntityManager();){
            tx = em.getTransaction();
            tx.begin();
            j.setIsAppliedLocally(true);
            em.persist((Object)j);
            j.setOriginatingUSN(j.getId());
            em.merge((Object)j);
            log.info((Object)("CR saved locally, it was from " + j.getNodeID() + " USN:" + j.getOriginatingUSN() + " Type:" + j.getRecordType().name() + " Key:" + j.getEntityKey() + " Local id:" + j.getId()));
            tx.commit();
        }
        log.debug((Object)("ChangeRecord: " + j.getId() + "," + j.getEntityKey() + "," + j.getNodeID() + "," + j.getOriginatingUSN() + "," + j.getRecordType().toString()));
        this.SendNotifications(j.getId(), j.getNodeID(), false);
    }

    private void SendNotifications(Long id, String origin_node, boolean isRetrans) {
        org.uddi.repl_v3.ReplicationConfiguration repcfg = ReplicationNotifier.FetchEdges();
        if (repcfg == null) {
            log.debug((Object)"No replication configuration is defined!");
            return;
        }
        if (id == null || origin_node == null) {
            log.fatal((Object)"Either the id is null or the origin_node is null. I can't send out this alert!!");
            return;
        }
        HashSet<Object> destinationUrls = new HashSet<Object>();
        if (repcfg.getCommunicationGraph() == null || repcfg.getCommunicationGraph().getEdge().isEmpty() && !isRetrans) {
            for (Operator o : repcfg.getOperator()) {
                if (o.getOperatorNodeID().equalsIgnoreCase(node) || o.getOperatorNodeID().equalsIgnoreCase(origin_node)) continue;
                destinationUrls.add(o.getSoapReplicationURL());
            }
        } else {
            for (CommunicationGraph.Edge next : repcfg.getCommunicationGraph().getEdge()) {
                if (!next.getMessageSender().equalsIgnoreCase(node)) continue;
                String string = next.getMessageReceiver();
                PrimaryAlternate container = new PrimaryAlternate();
                if (!string.equalsIgnoreCase(node) && !string.equalsIgnoreCase(origin_node)) {
                    for (int x = 0; x < repcfg.getOperator().size(); ++x) {
                        if (!((Operator)repcfg.getOperator().get(x)).getOperatorNodeID().equalsIgnoreCase(string)) continue;
                        container.primaryUrl = ((Operator)repcfg.getOperator().get(x)).getSoapReplicationURL();
                    }
                    for (int y = 0; y < next.getMessageReceiverAlternate().size(); ++y) {
                        for (int x = 0; x < repcfg.getOperator().size(); ++x) {
                            if (!((Operator)repcfg.getOperator().get(x)).getOperatorNodeID().equalsIgnoreCase((String)next.getMessageReceiverAlternate().get(y))) continue;
                            container.alternateUrls.add(((Operator)repcfg.getOperator().get(x)).getSoapReplicationURL());
                        }
                    }
                }
                if (container.primaryUrl != null) {
                    destinationUrls.add(container);
                    continue;
                }
                log.warn((Object)("Unable to find primary url for directed edge graph replication from this node " + node + " to destination node " + next.getMessageReceiver() + " it will be ignored!"));
            }
        }
        if (destinationUrls.isEmpty()) {
            log.debug((Object)"Something is bizarre with the replication config. I should have had at least one node to notify, but I have none!");
            return;
        }
        UDDIReplicationPortType x = uddiService.getUDDIReplicationPort();
        TransportSecurityHelper.applyTransportSecurity((BindingProvider)((BindingProvider)x));
        for (Object e : destinationUrls) {
            NotifyChangeRecordsAvailable req = new NotifyChangeRecordsAvailable();
            req.setNotifyingNode(node);
            HighWaterMarkVectorType highWaterMarkVectorType = new HighWaterMarkVectorType();
            highWaterMarkVectorType.getHighWaterMark().add(new ChangeRecordIDType(origin_node, id));
            req.setChangesAvailable(highWaterMarkVectorType);
            if (e instanceof String) {
                this.SendNotification(x, (String)e, req);
                continue;
            }
            if (!(e instanceof PrimaryAlternate)) continue;
            PrimaryAlternate pa = (PrimaryAlternate)e;
            if (this.SendNotification(x, pa.primaryUrl, req)) continue;
            for (String url : pa.alternateUrls) {
                if (this.SendNotification(x, url, req)) break;
            }
        }
    }

    private boolean SendNotification(UDDIReplicationPortType x, String s, NotifyChangeRecordsAvailable req) {
        ((BindingProvider)x).getRequestContext().put("javax.xml.ws.service.endpoint.address", s);
        try {
            x.notifyChangeRecordsAvailable(req);
            log.info((Object)("Successfully sent change record available message to " + s + " this node: " + node));
            return true;
        }
        catch (Exception ex) {
            log.warn((Object)("Unable to send change notification to " + s + " this node: " + node + " reason: " + ex.getMessage()));
            log.debug((Object)("Unable to send change notification to " + s), (Throwable)ex);
            return false;
        }
    }

    @Override
    public synchronized void run() {
        ChangeRecord j;
        log.debug((Object)"Replication thread triggered");
        if (queue == null) {
            queue = new ConcurrentLinkedQueue<ChangeRecord>();
        }
        if (queue2 == null) {
            queue2 = new ConcurrentLinkedQueue<org.uddi.repl_v3.ChangeRecord>();
        }
        if (!queue.isEmpty()) {
            log.info((Object)("Replication, Notifying nodes of new change records. " + queue.size() + " queued"));
        }
        while (!queue.isEmpty()) {
            j = queue.poll();
            this.ProcessChangeRecord(j);
        }
        while (!queue2.isEmpty()) {
            j = queue2.poll();
            ChangeRecord model = new ChangeRecord();
            try {
                model = MappingApiToModel.mapChangeRecord((org.uddi.repl_v3.ChangeRecord)j);
            }
            catch (UnsupportedEncodingException ex) {
                Logger.getLogger(ReplicationNotifier.class.getName()).log(Level.SEVERE, null, ex);
            }
            log.info((Object)("retransmitting CR notificationm entity owner: " + j.getChangeID().getNodeID() + " CR: " + j.getChangeID().getOriginatingUSN() + " key:" + model.getEntityKey() + " " + model.getRecordType().name() + " accepted locally:" + model.getIsAppliedLocally()));
            this.SendNotifications(j.getChangeID().getOriginatingUSN(), j.getChangeID().getNodeID(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static org.uddi.repl_v3.ReplicationConfiguration FetchEdges() {
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = null;
        org.uddi.repl_v3.ReplicationConfiguration item = new org.uddi.repl_v3.ReplicationConfiguration();
        try {
            tx = em.getTransaction();
            tx.begin();
            Query q = em.createQuery("SELECT item FROM ReplicationConfiguration item order by item.serialNumber DESC");
            q.setMaxResults(1);
            ReplicationConfiguration results = (ReplicationConfiguration)q.getSingleResult();
            if (results != null) {
                MappingModelToApi.mapReplicationConfiguration(results, item);
            }
            tx.commit();
            org.uddi.repl_v3.ReplicationConfiguration replicationConfiguration = item;
            return replicationConfiguration;
        }
        catch (Exception ex) {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
        }
        finally {
            em.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private Node getNode(String messageSender) {
        EntityTransaction tx = null;
        try (EntityManager em = PersistenceManager.getEntityManager();){
            tx = em.getTransaction();
            tx.begin();
            Node api = new Node();
            org.apache.juddi.model.Node find = (org.apache.juddi.model.Node)em.find(org.apache.juddi.model.Node.class, (Object)messageSender);
            if (find != null) {
                MappingModelToApi.mapNode(find, api);
            }
            tx.commit();
            Node node = api;
            return node;
        }
        return null;
    }

    private static class PrimaryAlternate {
        String primaryUrl = null;
        List<String> alternateUrls = new ArrayList<String>();

        private PrimaryAlternate() {
        }
    }
}

