/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.subscription;

import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.api.impl.ServiceCounterLifecycleResource;
import org.apache.juddi.api.impl.UDDIPublicationImpl;
import org.apache.juddi.api.impl.UDDISecurityImpl;
import org.apache.juddi.api.impl.UDDIServiceCounter;
import org.apache.juddi.api.impl.UDDISubscriptionImpl;
import org.apache.juddi.api_v3.AccessPointType;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.config.PersistenceManager;
import org.apache.juddi.model.BindingTemplate;
import org.apache.juddi.model.Subscription;
import org.apache.juddi.model.UddiEntityPublisher;
import org.apache.juddi.subscription.TypeConvertor;
import org.apache.juddi.subscription.notify.Notifier;
import org.apache.juddi.subscription.notify.NotifierFactory;
import org.uddi.api_v3.AuthToken;
import org.uddi.sub_v3.CoveragePeriod;
import org.uddi.sub_v3.GetSubscriptionResults;
import org.uddi.sub_v3.SubscriptionResultsList;
import org.uddi.subr_v3.NotifySubscriptionListener;
import org.uddi.v3_service.DispositionReportFaultMessage;

public class SubscriptionNotifier
extends TimerTask {
    private static final Log log = LogFactory.getLog(SubscriptionNotifier.class);
    private Timer timer = null;
    private final long startBuffer = AppConfig.getConfiguration().getLong("juddi.notification.start.buffer", 20000L);
    private final long interval = AppConfig.getConfiguration().getLong("juddi.notification.interval", 300000L);
    private final long acceptableLagTime = AppConfig.getConfiguration().getLong("juddi.notification.acceptableLagtime", 1000L);
    private final int maxTries = AppConfig.getConfiguration().getInt("juddi.notification.maxTries", 3);
    private final long badListResetInterval = AppConfig.getConfiguration().getLong("juddi.notification.maxTriesResetInterval", 3600000L);
    private final boolean sendToken = AppConfig.getConfiguration().getBoolean("juddi.notification.sendAuthTokenWithResultList", false);
    private final UDDISubscriptionImpl subscriptionImpl = new UDDISubscriptionImpl();
    private final Boolean alwaysNotify = false;
    private Date desiredDate = null;
    private int lastUpdateCounter;
    private final UDDIServiceCounter serviceCounter = ServiceCounterLifecycleResource.getServiceCounter(UDDIPublicationImpl.class);
    private final String[] attributes = new String[]{"save_business", "save_service", "save_binding", "save_tmodel", "delete_business", "delete_service", "delete_binding", "delete_tmodel", "add_publisherassertions", "set_publisherassertions", "delete_publisherassertions"};
    private static Map<String, Integer> badNotifications = new ConcurrentHashMap<String, Integer>();
    private static Date lastBadNotificationReset = new Date();

    public SubscriptionNotifier() throws ConfigurationException {
        this.timer = new Timer(true);
        this.timer.scheduleAtFixedRate((TimerTask)this, this.startBuffer, this.interval);
    }

    @Override
    public boolean cancel() {
        this.timer.cancel();
        return super.cancel();
    }

    protected boolean registryMayContainUpdates() {
        boolean isUpdated = false;
        int updateCounter = 0;
        if (this.desiredDate != null && new Date().getTime() > this.desiredDate.getTime()) {
            return true;
        }
        try {
            for (String attribute : this.attributes) {
                String counter = this.serviceCounter.getAttribute(attribute + " successful queries").toString();
                updateCounter += Integer.valueOf(counter).intValue();
            }
            if (updateCounter != this.lastUpdateCounter) {
                this.lastUpdateCounter = updateCounter;
                isUpdated = true;
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return isUpdated;
    }

    @Override
    public synchronized void run() {
        if (this.badListResetInterval > 0L && new Date().getTime() > lastBadNotificationReset.getTime() + this.badListResetInterval) {
            badNotifications = new ConcurrentHashMap<String, Integer>();
            lastBadNotificationReset = new Date();
            log.debug((Object)"badNotificationList was reset");
        }
        if ((this.firedOnTime(this.scheduledExecutionTime()) || this.alwaysNotify.booleanValue()) && this.registryMayContainUpdates()) {
            long startTime = System.currentTimeMillis();
            this.desiredDate = null;
            log.info((Object)"Start Notification background task; checking if subscription notifications need to be send out..");
            Collection<Subscription> subscriptions = this.getAllAsyncSubscriptions();
            for (Subscription subscription : subscriptions) {
                if (subscription.getExpiresAfter() == null || subscription.getExpiresAfter().getTime() > startTime || !this.isTemporarilyDisabled(subscription.getSubscriptionKey())) {
                    try {
                        Date notificationDate = new Date(this.scheduledExecutionTime());
                        GetSubscriptionResults getSubscriptionResults = this.buildGetSubscriptionResults(subscription, notificationDate);
                        if (getSubscriptionResults == null) continue;
                        getSubscriptionResults.setSubscriptionKey(subscription.getSubscriptionKey());
                        UddiEntityPublisher publisher = new UddiEntityPublisher();
                        publisher.setAuthorizedName(subscription.getAuthorizedName());
                        SubscriptionResultsList resultList = this.subscriptionImpl.getSubscriptionResults(getSubscriptionResults, publisher);
                        String token = resultList.getChunkToken();
                        if (this.resultListContainsChanges(resultList)) {
                            log.info((Object)("We have a change and need to notify " + subscription.getSubscriptionKey()));
                            resultList.setChunkToken(null);
                            this.notify(getSubscriptionResults, resultList, notificationDate);
                        } else {
                            log.info((Object)"No changes where recorded, no need to notify.");
                        }
                        while (!token.equalsIgnoreCase("0")) {
                            resultList = this.subscriptionImpl.getSubscriptionResults(getSubscriptionResults, publisher);
                            if (this.resultListContainsChanges(resultList)) {
                                log.info((Object)("We have a change and need to notify " + subscription.getSubscriptionKey()));
                                resultList.setChunkToken(null);
                                this.notify(getSubscriptionResults, resultList, notificationDate);
                                continue;
                            }
                            log.info((Object)"No changes where recorded, no need to notify.");
                        }
                        continue;
                    }
                    catch (Exception e) {
                        log.error((Object)("Could not obtain subscriptionResult for subscriptionKey " + subscription.getSubscriptionKey() + ". " + e.getMessage()), (Throwable)e);
                        continue;
                    }
                }
                log.info((Object)("Subcription with key " + subscription.getSubscriptionKey() + " expired " + subscription.getExpiresAfter()));
                this.deleteSubscription(subscription);
            }
            long endTime = System.currentTimeMillis();
            if (endTime - startTime > this.interval) {
                log.info((Object)("Notification background task duration exceeds the JUDDI_NOTIFICATION_INTERVAL of " + this.interval + ". Notification background task took " + (endTime - startTime) + " milliseconds."));
            } else {
                log.info((Object)("Notification background task took " + (endTime - startTime) + " milliseconds."));
            }
        } else {
            log.debug((Object)"Skipping current notification cycle because lagtime is too great.");
        }
    }

    private boolean firedOnTime(long scheduleExecutionTime) {
        long lagTime = System.currentTimeMillis() - scheduleExecutionTime;
        if (lagTime <= this.acceptableLagTime || this.acceptableLagTime < 0L) {
            return true;
        }
        log.debug((Object)("NotificationTimer is lagging " + lagTime + " milli seconds behind. A lag time which exceeds an acceptable lagtime of " + this.acceptableLagTime + "ms indicates that the registry server is under load or was in sleep mode. We are therefore skipping this notification cycle."));
        return false;
    }

    protected GetSubscriptionResults buildGetSubscriptionResults(Subscription subscription, Date endPoint) throws DispositionReportFaultMessage, DatatypeConfigurationException {
        GetSubscriptionResults getSubscriptionResults = null;
        Duration duration = TypeConvertor.convertStringToDuration(subscription.getNotificationInterval());
        Date startPoint = subscription.getLastNotified();
        Date nextDesiredNotificationDate = null;
        if (startPoint == null) {
            startPoint = subscription.getCreateDate();
        }
        nextDesiredNotificationDate = new Date(startPoint.getTime());
        duration.addTo(nextDesiredNotificationDate);
        if (subscription.getLastNotified() == null || nextDesiredNotificationDate.after(startPoint) && nextDesiredNotificationDate.before(endPoint)) {
            getSubscriptionResults = new GetSubscriptionResults();
            CoveragePeriod period = new CoveragePeriod();
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTimeInMillis(startPoint.getTime());
            period.setStartPoint(DatatypeFactory.newInstance().newXMLGregorianCalendar(calendar));
            calendar.setTimeInMillis(endPoint.getTime());
            period.setEndPoint(DatatypeFactory.newInstance().newXMLGregorianCalendar(calendar));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Period " + period.getStartPoint() + " " + period.getEndPoint()));
            }
            getSubscriptionResults.setCoveragePeriod(period);
        } else {
            log.info((Object)("Client does not yet want a notification. The next desidered notification Date " + nextDesiredNotificationDate + ". The current interval [" + startPoint + " , " + endPoint + "] therefore skipping this notification cycle."));
            if (this.desiredDate == null || nextDesiredNotificationDate.getTime() < this.desiredDate.getTime()) {
                this.desiredDate = nextDesiredNotificationDate;
            }
        }
        return getSubscriptionResults;
    }

    protected boolean resultListContainsChanges(SubscriptionResultsList resultList) {
        if (resultList == null) {
            return false;
        }
        if (resultList.getBindingDetail() != null || resultList.getBusinessDetail() != null || resultList.getBusinessList() != null || resultList.getServiceDetail() != null || resultList.getServiceList() != null || resultList.getTModelDetail() != null || resultList.getTModelList() != null || resultList.getRelatedBusinessesList() != null || resultList.getAssertionStatusReport() != null) {
            return true;
        }
        return resultList.getKeyBag() != null && resultList.getKeyBag().size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<Subscription> getAllAsyncSubscriptions() {
        List subscriptions = null;
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            Query query = em.createQuery("SELECT s FROM Subscription s WHERE s.bindingKey IS NOT NULL");
            subscriptions = query.getResultList();
            tx.commit();
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
        return subscriptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteSubscription(Subscription subscription) {
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            em.remove((Object)subscription);
            tx.commit();
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notify(GetSubscriptionResults getSubscriptionResults, SubscriptionResultsList resultList, Date notificationDate) {
        block16: {
            EntityManager em = PersistenceManager.getEntityManager();
            EntityTransaction tx = em.getTransaction();
            try {
                String subscriptionKey = resultList.getSubscription().getSubscriptionKey();
                Subscription modelSubscription = (Subscription)em.find(Subscription.class, (Object)subscriptionKey);
                Date lastNotifiedDate = modelSubscription.getLastNotified();
                tx.begin();
                modelSubscription.setLastNotified(notificationDate);
                em.persist((Object)modelSubscription);
                tx.commit();
                BindingTemplate bindingTemplate = (BindingTemplate)em.find(BindingTemplate.class, (Object)modelSubscription.getBindingKey());
                NotifySubscriptionListener body = new NotifySubscriptionListener();
                body.setSubscriptionResultsList(resultList);
                if (this.sendToken) {
                    String authorizedName = modelSubscription.getAuthorizedName();
                    UDDISecurityImpl security = new UDDISecurityImpl();
                    if (authorizedName != null) {
                        try {
                            AuthToken token = security.getAuthToken(authorizedName);
                            body.setAuthInfo(token.getAuthInfo());
                        }
                        catch (DispositionReportFaultMessage e) {
                            body.setAuthInfo("Failed to generate token, please contact UDDI admin");
                            log.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                }
                if (bindingTemplate != null) {
                    if (AccessPointType.END_POINT.toString().equalsIgnoreCase(bindingTemplate.getAccessPointType()) || AccessPointType.WSDL_DEPLOYMENT.toString().equalsIgnoreCase(bindingTemplate.getAccessPointType())) {
                        try {
                            Notifier notifier = new NotifierFactory().getNotifier(bindingTemplate);
                            if (notifier == null) break block16;
                            log.info((Object)("Sending out notification to " + bindingTemplate.getAccessPointUrl()));
                            notifier.notifySubscriptionListener(body);
                            String chunkToken = body.getSubscriptionResultsList().getChunkToken();
                            while (chunkToken != null) {
                                UddiEntityPublisher publisher = new UddiEntityPublisher();
                                publisher.setAuthorizedName(modelSubscription.getAuthorizedName());
                                log.debug((Object)("Sending out next chunk: " + chunkToken + " to " + bindingTemplate.getAccessPointUrl()));
                                getSubscriptionResults.setChunkToken(chunkToken);
                                resultList = this.subscriptionImpl.getSubscriptionResults(getSubscriptionResults, publisher);
                                body.setSubscriptionResultsList(resultList);
                                if (this.resultListContainsChanges(resultList)) {
                                    notifier.notifySubscriptionListener(body);
                                }
                                chunkToken = body.getSubscriptionResultsList().getChunkToken();
                            }
                            if (badNotifications.containsKey(resultList.getSubscription().getSubscriptionKey())) {
                                badNotifications.remove(resultList.getSubscription().getSubscriptionKey());
                            }
                            break block16;
                        }
                        catch (Exception e) {
                            if (e.getCause() instanceof IOException) {
                                this.addBadNotificationToList(subscriptionKey, bindingTemplate.getAccessPointUrl());
                                modelSubscription.setLastNotified(lastNotifiedDate);
                                tx.begin();
                                em.persist((Object)modelSubscription);
                                tx.commit();
                            }
                            log.error((Object)("Unexpected notification exception:" + e.getClass().getCanonicalName() + " " + e.getMessage() + " " + e.getCause()));
                            log.debug((Object)("Unexpected notification exception:" + e.getClass().getCanonicalName() + " " + e.getMessage() + " " + e.getCause()), (Throwable)e);
                        }
                        break block16;
                    }
                    log.info((Object)("Binding " + bindingTemplate.getEntityKey() + " has an unsupported binding type of " + bindingTemplate.getAccessPointType() + ". Only " + AccessPointType.END_POINT.toString() + " and " + AccessPointType.WSDL_DEPLOYMENT.toString() + " are supported."));
                    this.addBadNotificationToList(subscriptionKey, bindingTemplate.getAccessPointType() + " not supported");
                    break block16;
                }
                log.info((Object)("There is no valid binding template defined for this subscription: " + modelSubscription.getBindingKey()));
                this.addBadNotificationToList(subscriptionKey, modelSubscription.getBindingKey() + " not found");
            }
            finally {
                if (tx.isActive()) {
                    tx.rollback();
                }
                em.close();
            }
        }
    }

    protected UDDISubscriptionImpl getSubscriptionImpl() {
        return this.subscriptionImpl;
    }

    private boolean isTemporarilyDisabled(String subscriptionKey) {
        if (this.maxTries > 0 && badNotifications.containsKey(subscriptionKey) && badNotifications.get(subscriptionKey) > this.maxTries) {
            log.debug((Object)("Subscription " + subscriptionKey + " is temperarily disabled. The notification endpoint could not be reached more then " + this.maxTries + " times"));
            return true;
        }
        return false;
    }

    private int addBadNotificationToList(String subscriptionKey, String endPoint) {
        Integer numberOfBadNotifications = 0;
        if (badNotifications.containsKey(subscriptionKey)) {
            numberOfBadNotifications = badNotifications.get(subscriptionKey);
        }
        numberOfBadNotifications = numberOfBadNotifications + 1;
        badNotifications.put(subscriptionKey, numberOfBadNotifications);
        log.debug((Object)("bad notification number " + numberOfBadNotifications + " for subscription " + subscriptionKey + " " + endPoint));
        return numberOfBadNotifications;
    }
}

