/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.subscription.notify;

import java.net.URISyntaxException;
import java.rmi.RemoteException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.api_v3.AccessPointType;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.config.ResourceConfig;
import org.apache.juddi.cryptor.CryptorFactory;
import org.apache.juddi.jaxb.JAXBMarshaller;
import org.apache.juddi.model.BindingTemplate;
import org.apache.juddi.subscription.notify.Notifier;
import org.uddi.api_v3.DispositionReport;
import org.uddi.api_v3.Result;
import org.uddi.subr_v3.NotifySubscriptionListener;
import org.uddi.v3_service.DispositionReportFaultMessage;

public class SMTPNotifier
implements Notifier {
    protected static final Log log = LogFactory.getLog(SMTPNotifier.class);
    protected String notificationEmailAddress = null;
    protected Session session = null;
    protected Properties properties = null;
    protected static final String[] mailProps = new String[]{"mail.smtp.from", "mail.smtp.host", "mail.smtp.port", "mail.smtp.socketFactory.class", "mail.smtp.socketFactory.fallback", "mail.smtp.starttls.enable", "mail.smtp.socketFactory.port", "mail.smtp.auth", "mail.smtp.user", "mail.smtp.password", "mail.debug"};

    protected final Properties getEMailProperties() throws ConfigurationException {
        if (this.properties == null || this.properties.isEmpty()) {
            this.properties = new Properties();
            String mailPrefix = AppConfig.getConfiguration().getString("juddi.mail.smtp.prefix", "juddi.");
            if (!mailPrefix.endsWith(".")) {
                mailPrefix = mailPrefix + ".";
            }
            for (String key : mailProps) {
                if (AppConfig.getConfiguration().containsKey(mailPrefix + key)) {
                    this.properties.put(key, AppConfig.getConfiguration().getProperty(mailPrefix + key));
                    continue;
                }
                if (System.getProperty(mailPrefix + key) == null) continue;
                this.properties.put(key, System.getProperty(mailPrefix + key));
            }
        }
        return this.properties;
    }

    public SMTPNotifier(BindingTemplate bindingTemplate) throws URISyntaxException, Exception {
        String accessPointUrl;
        if (!AccessPointType.END_POINT.toString().equalsIgnoreCase(bindingTemplate.getAccessPointType())) {
            log.error((Object)("smtp enpoints only support AccessPointType " + AccessPointType.END_POINT));
        }
        if (!(accessPointUrl = bindingTemplate.getAccessPointUrl().toLowerCase()).startsWith("mailto:")) {
            log.warn((Object)("smtp accessPointUrl for bindingTemplate " + bindingTemplate.getEntityKey() + " should start with 'mailto'"));
        } else {
            this.notificationEmailAddress = accessPointUrl.substring(accessPointUrl.indexOf(":") + 1);
            boolean auth = this.getEMailProperties().getProperty("mail.smtp.auth", "false").equalsIgnoreCase("true");
            if (auth) {
                final String username = this.getEMailProperties().getProperty("mail.smtp.user");
                String pwd = this.getEMailProperties().getProperty("mail.smtp.password");
                if (this.getEMailProperties().getProperty("mail.smtp.password[@encrypted]", "false").equalsIgnoreCase("true")) {
                    try {
                        pwd = CryptorFactory.getCryptor().decrypt(pwd);
                    }
                    catch (NoSuchPaddingException ex) {
                        log.error((Object)"Unable to decrypt settings", (Throwable)ex);
                    }
                    catch (NoSuchAlgorithmException ex) {
                        log.error((Object)"Unable to decrypt settings", (Throwable)ex);
                    }
                    catch (InvalidAlgorithmParameterException ex) {
                        log.error((Object)"Unable to decrypt settings", (Throwable)ex);
                    }
                    catch (InvalidKeyException ex) {
                        log.error((Object)"Unable to decrypt settings", (Throwable)ex);
                    }
                    catch (IllegalBlockSizeException ex) {
                        log.error((Object)"Unable to decrypt settings", (Throwable)ex);
                    }
                    catch (BadPaddingException ex) {
                        log.error((Object)"Unable to decrypt settings", (Throwable)ex);
                    }
                }
                final String password = pwd;
                log.debug((Object)("SMTP username = " + username + " from address = " + this.notificationEmailAddress));
                Properties eMailProperties = this.getEMailProperties();
                eMailProperties.remove("mail.smtp.user");
                eMailProperties.remove("mail.smtp.password");
                this.session = Session.getInstance((Properties)this.getEMailProperties(), (Authenticator)new Authenticator(){

                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(username, password);
                    }
                });
            } else {
                Properties eMailProperties = this.getEMailProperties();
                eMailProperties.remove("mail.smtp.user");
                eMailProperties.remove("mail.smtp.password");
                this.session = Session.getInstance((Properties)eMailProperties);
            }
        }
    }

    @Override
    public DispositionReport notifySubscriptionListener(NotifySubscriptionListener body) throws DispositionReportFaultMessage, RemoteException {
        try {
            log.info((Object)("Sending notification email to " + this.notificationEmailAddress + " from " + this.getEMailProperties().getProperty("mail.smtp.from", "jUDDI")));
            if (this.session == null || this.notificationEmailAddress == null) {
                throw new DispositionReportFaultMessage("Session is null!", null);
            }
            MimeMessage message = new MimeMessage(this.session);
            InternetAddress address = new InternetAddress(this.notificationEmailAddress);
            Address[] to = new Address[]{address};
            message.setRecipients(Message.RecipientType.TO, to);
            message.setFrom((Address)new InternetAddress(this.getEMailProperties().getProperty("mail.smtp.from", "jUDDI")));
            String subscriptionResultXML = JAXBMarshaller.marshallToString((Object)body, (String)"org.uddi.subr_v3");
            message.setText(subscriptionResultXML, "UTF-8");
            message.setSubject(ResourceConfig.getGlobalMessage("notifications.smtp.default.subject") + " " + StringEscapeUtils.escapeHtml((String)body.getSubscriptionResultsList().getSubscription().getSubscriptionKey()));
            Transport.send((Message)message);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new DispositionReportFaultMessage(e.getMessage(), null);
        }
        DispositionReport dr = new DispositionReport();
        Result res = new Result();
        dr.getResult().add(res);
        return dr;
    }
}

