/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.subscription.notify;

import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.rmi.RemoteException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.xml.bind.JAXB;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.config.ResourceConfig;
import org.apache.juddi.cryptor.CryptorFactory;
import org.apache.juddi.jaxb.JAXBMarshaller;
import org.apache.juddi.mapping.MappingModelToApi;
import org.apache.juddi.model.BindingTemplate;
import org.apache.juddi.model.Publisher;
import org.apache.juddi.subscription.notify.SMTPNotifier;
import org.apache.juddi.subscription.notify.TemporaryMailContainer;
import org.uddi.api_v3.DispositionReport;
import org.uddi.api_v3.Result;
import org.uddi.sub_v3.Subscription;
import org.uddi.sub_v3.SubscriptionFilter;
import org.uddi.sub_v3.SubscriptionResultsList;
import org.uddi.subr_v3.NotifySubscriptionListener;
import org.uddi.v3_service.DispositionReportFaultMessage;

public class USERFRIENDLYSMTPNotifier
extends SMTPNotifier {
    String publisherName;

    public static void notifySubscriptionDeleted(TemporaryMailContainer container) {
        try {
            Publisher publisher = container.getPublisher();
            Publisher deletedBy = container.getDeletedBy();
            org.apache.juddi.model.Subscription obj = container.getObj();
            String emailaddress = publisher.getEmailAddress();
            if (emailaddress == null || emailaddress.trim().equals("")) {
                return;
            }
            Properties properties = new Properties();
            Session session = null;
            String mailPrefix = AppConfig.getConfiguration().getString("juddi.mail.smtp.prefix", "juddi.");
            if (!mailPrefix.endsWith(".")) {
                mailPrefix = mailPrefix + ".";
            }
            for (String key : mailProps) {
                if (AppConfig.getConfiguration().containsKey(mailPrefix + key)) {
                    properties.put(key, AppConfig.getConfiguration().getProperty(mailPrefix + key));
                    continue;
                }
                if (System.getProperty(mailPrefix + key) == null) continue;
                properties.put(key, System.getProperty(mailPrefix + key));
            }
            boolean auth = properties.getProperty("mail.smtp.auth", "false").equalsIgnoreCase("true");
            if (auth) {
                final String username = properties.getProperty("mail.smtp.user");
                String pwd = properties.getProperty("mail.smtp.password");
                if (properties.getProperty("mail.smtp.password[@encrypted]", "false").equalsIgnoreCase("true")) {
                    try {
                        pwd = CryptorFactory.getCryptor().decrypt(pwd);
                    }
                    catch (NoSuchPaddingException ex) {
                        log.error((Object)"Unable to decrypt settings", (Throwable)ex);
                    }
                    catch (NoSuchAlgorithmException ex) {
                        log.error((Object)"Unable to decrypt settings", (Throwable)ex);
                    }
                    catch (InvalidAlgorithmParameterException ex) {
                        log.error((Object)"Unable to decrypt settings", (Throwable)ex);
                    }
                    catch (InvalidKeyException ex) {
                        log.error((Object)"Unable to decrypt settings", (Throwable)ex);
                    }
                    catch (IllegalBlockSizeException ex) {
                        log.error((Object)"Unable to decrypt settings", (Throwable)ex);
                    }
                    catch (BadPaddingException ex) {
                        log.error((Object)"Unable to decrypt settings", (Throwable)ex);
                    }
                }
                final String password = pwd;
                log.debug((Object)("SMTP username = " + username + " from address = " + emailaddress));
                Properties eMailProperties = properties;
                eMailProperties.remove("mail.smtp.user");
                eMailProperties.remove("mail.smtp.password");
                session = Session.getInstance((Properties)properties, (Authenticator)new Authenticator(){

                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(username, password);
                    }
                });
            } else {
                Properties eMailProperties = properties;
                eMailProperties.remove("mail.smtp.user");
                eMailProperties.remove("mail.smtp.password");
                session = Session.getInstance((Properties)eMailProperties);
            }
            MimeMessage message = new MimeMessage(session);
            InternetAddress address = new InternetAddress(emailaddress);
            Address[] to = new Address[]{address};
            message.setRecipients(Message.RecipientType.TO, to);
            message.setFrom((Address)new InternetAddress(properties.getProperty("mail.smtp.from", "jUDDI")));
            Subscription api = new Subscription();
            MappingModelToApi.mapSubscription(obj, api);
            String subscriptionResultXML = JAXBMarshaller.marshallToString((Object)api, (String)"org.uddi.subr_v3");
            MimeMultipart mp = new MimeMultipart();
            MimeBodyPart content = new MimeBodyPart();
            String msg_content = ResourceConfig.getGlobalMessage("notifications.smtp.subscriptionDeleted");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd kk:mm:ssZ");
            msg_content = String.format(msg_content, StringEscapeUtils.escapeHtml((String)publisher.getPublisherName()), StringEscapeUtils.escapeHtml((String)publisher.getAuthorizedName()), StringEscapeUtils.escapeHtml((String)deletedBy.getPublisherName()), StringEscapeUtils.escapeHtml((String)deletedBy.getAuthorizedName()), StringEscapeUtils.escapeHtml((String)sdf.format(new Date())), StringEscapeUtils.escapeHtml((String)AppConfig.getConfiguration().getString("juddi.nodeId", "(unknown node id!)")), AppConfig.getConfiguration().getString("juddi.server.baseurl", "(unknown url)"), AppConfig.getConfiguration().getString("juddi.server.baseurlsecure", "(unknown url)"));
            content.setContent((Object)msg_content, "text/html; charset=UTF-8;");
            mp.addBodyPart((BodyPart)content);
            MimeBodyPart attachment = new MimeBodyPart();
            attachment.setContent((Object)subscriptionResultXML, "text/xml; charset=UTF-8;");
            attachment.setFileName("uddiNotification.xml");
            mp.addBodyPart((BodyPart)attachment);
            message.setContent((Multipart)mp);
            message.setSubject(ResourceConfig.getGlobalMessage("notifications.smtp.userfriendly.subject") + " " + StringEscapeUtils.escapeHtml((String)obj.getSubscriptionKey()));
            Transport.send((Message)message);
        }
        catch (Throwable t) {
            log.warn((Object)("Error sending email!" + t.getMessage()));
            log.debug((Object)("Error sending email!" + t.getMessage()), t);
        }
    }

    public static void notifyAccountDeleted(TemporaryMailContainer container) {
        try {
            Publisher publisher = container.getPublisher();
            Publisher deletedBy = container.getDeletedBy();
            String emailaddress = publisher.getEmailAddress();
            if (emailaddress == null || emailaddress.trim().equals("")) {
                return;
            }
            Properties properties = new Properties();
            Session session = null;
            String mailPrefix = AppConfig.getConfiguration().getString("juddi.mail.smtp.prefix", "juddi.");
            if (!mailPrefix.endsWith(".")) {
                mailPrefix = mailPrefix + ".";
            }
            for (String key : mailProps) {
                if (AppConfig.getConfiguration().containsKey(mailPrefix + key)) {
                    properties.put(key, AppConfig.getConfiguration().getProperty(mailPrefix + key));
                    continue;
                }
                if (System.getProperty(mailPrefix + key) == null) continue;
                properties.put(key, System.getProperty(mailPrefix + key));
            }
            boolean auth = properties.getProperty("mail.smtp.auth", "false").equalsIgnoreCase("true");
            if (auth) {
                final String username = properties.getProperty("mail.smtp.user");
                String pwd = properties.getProperty("mail.smtp.password");
                if (properties.getProperty("mail.smtp.password[@encrypted]", "false").equalsIgnoreCase("true")) {
                    try {
                        pwd = CryptorFactory.getCryptor().decrypt(pwd);
                    }
                    catch (NoSuchPaddingException ex) {
                        log.error((Object)"Unable to decrypt settings", (Throwable)ex);
                    }
                    catch (NoSuchAlgorithmException ex) {
                        log.error((Object)"Unable to decrypt settings", (Throwable)ex);
                    }
                    catch (InvalidAlgorithmParameterException ex) {
                        log.error((Object)"Unable to decrypt settings", (Throwable)ex);
                    }
                    catch (InvalidKeyException ex) {
                        log.error((Object)"Unable to decrypt settings", (Throwable)ex);
                    }
                    catch (IllegalBlockSizeException ex) {
                        log.error((Object)"Unable to decrypt settings", (Throwable)ex);
                    }
                    catch (BadPaddingException ex) {
                        log.error((Object)"Unable to decrypt settings", (Throwable)ex);
                    }
                }
                final String password = pwd;
                log.debug((Object)("SMTP username = " + username + " from address = " + emailaddress));
                Properties eMailProperties = properties;
                eMailProperties.remove("mail.smtp.user");
                eMailProperties.remove("mail.smtp.password");
                session = Session.getInstance((Properties)properties, (Authenticator)new Authenticator(){

                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(username, password);
                    }
                });
            } else {
                Properties eMailProperties = properties;
                eMailProperties.remove("mail.smtp.user");
                eMailProperties.remove("mail.smtp.password");
                session = Session.getInstance((Properties)eMailProperties);
            }
            MimeMessage message = new MimeMessage(session);
            InternetAddress address = new InternetAddress(emailaddress);
            Address[] to = new Address[]{address};
            message.setRecipients(Message.RecipientType.TO, to);
            message.setFrom((Address)new InternetAddress(properties.getProperty("mail.smtp.from", "jUDDI")));
            MimeMultipart mp = new MimeMultipart();
            MimeBodyPart content = new MimeBodyPart();
            String msg_content = ResourceConfig.getGlobalMessage("notifications.smtp.accountDeleted");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd kk:mm:ssZ");
            msg_content = String.format(msg_content, StringEscapeUtils.escapeHtml((String)publisher.getPublisherName()), StringEscapeUtils.escapeHtml((String)publisher.getAuthorizedName()), StringEscapeUtils.escapeHtml((String)deletedBy.getPublisherName()), StringEscapeUtils.escapeHtml((String)deletedBy.getAuthorizedName()), StringEscapeUtils.escapeHtml((String)sdf.format(new Date())), StringEscapeUtils.escapeHtml((String)AppConfig.getConfiguration().getString("juddi.nodeId", "(unknown node id!)")), AppConfig.getConfiguration().getString("juddi.server.baseurl", "(unknown url)"), AppConfig.getConfiguration().getString("juddi.server.baseurlsecure", "(unknown url)"));
            content.setContent((Object)msg_content, "text/html; charset=UTF-8;");
            mp.addBodyPart((BodyPart)content);
            message.setContent((Multipart)mp);
            message.setSubject(ResourceConfig.getGlobalMessage("notifications.smtp.accountDeleted.subject"));
            Transport.send((Message)message);
        }
        catch (Throwable t) {
            log.warn((Object)("Error sending email!" + t.getMessage()));
            log.debug((Object)("Error sending email!" + t.getMessage()), t);
        }
    }

    public USERFRIENDLYSMTPNotifier(BindingTemplate bindingTemplate) throws URISyntaxException, Exception {
        super(bindingTemplate);
        this.publisherName = bindingTemplate.getAuthorizedName();
    }

    @Override
    public DispositionReport notifySubscriptionListener(NotifySubscriptionListener body) throws DispositionReportFaultMessage, RemoteException {
        try {
            log.info((Object)("Sending notification email to " + this.notificationEmailAddress + " from " + this.getEMailProperties().getProperty("mail.smtp.from", "jUDDI")));
            if (this.session == null || this.notificationEmailAddress == null) {
                throw new DispositionReportFaultMessage("Session is null!", null);
            }
            MimeMessage message = new MimeMessage(this.session);
            InternetAddress address = new InternetAddress(this.notificationEmailAddress);
            Address[] to = new Address[]{address};
            message.setRecipients(Message.RecipientType.TO, to);
            message.setFrom((Address)new InternetAddress(this.getEMailProperties().getProperty("mail.smtp.from", "jUDDI")));
            String subscriptionResultXML = JAXBMarshaller.marshallToString((Object)body, (String)"org.uddi.subr_v3");
            MimeMultipart mp = new MimeMultipart();
            MimeBodyPart content = new MimeBodyPart();
            String msg_content = ResourceConfig.getGlobalMessage("notifications.smtp.userfriendly.body");
            msg_content = String.format(msg_content, StringEscapeUtils.escapeHtml((String)this.publisherName), StringEscapeUtils.escapeHtml((String)AppConfig.getConfiguration().getString("juddi.nodeId", "(unknown node id!)")), USERFRIENDLYSMTPNotifier.GetSubscriptionType(body), USERFRIENDLYSMTPNotifier.GetChangeSummary(body));
            content.setContent((Object)msg_content, "text/html; charset=UTF-8;");
            mp.addBodyPart((BodyPart)content);
            MimeBodyPart attachment = new MimeBodyPart();
            attachment.setContent((Object)subscriptionResultXML, "text/xml; charset=UTF-8;");
            attachment.setFileName("uddiNotification.xml");
            mp.addBodyPart((BodyPart)attachment);
            message.setContent((Multipart)mp);
            message.setSubject(ResourceConfig.getGlobalMessage("notifications.smtp.userfriendly.subject") + " " + body.getSubscriptionResultsList().getSubscription().getSubscriptionKey());
            Transport.send((Message)message);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new DispositionReportFaultMessage(e.getMessage(), null);
        }
        DispositionReport dr = new DispositionReport();
        Result res = new Result();
        dr.getResult().add(res);
        return dr;
    }

    static String GetChangeSummary(NotifySubscriptionListener body) {
        SubscriptionResultsList r = body.getSubscriptionResultsList();
        StringWriter sw = new StringWriter();
        if (r.getAssertionStatusReport() != null) {
            JAXB.marshal((Object)r.getAssertionStatusReport(), (Writer)sw);
        } else if (r.getBindingDetail() != null) {
            JAXB.marshal((Object)r.getBindingDetail(), (Writer)sw);
        } else if (r.getBusinessDetail() != null) {
            JAXB.marshal((Object)r.getBusinessDetail(), (Writer)sw);
        } else if (r.getBusinessList() != null) {
            JAXB.marshal((Object)r.getBusinessList(), (Writer)sw);
        } else if (r.getRelatedBusinessesList() != null) {
            JAXB.marshal((Object)r.getRelatedBusinessesList(), (Writer)sw);
        } else if (r.getServiceDetail() != null) {
            JAXB.marshal((Object)r.getServiceDetail(), (Writer)sw);
        } else if (r.getServiceList() != null) {
            JAXB.marshal((Object)r.getServiceList(), (Writer)sw);
        } else if (r.getTModelDetail() != null) {
            JAXB.marshal((Object)r.getTModelDetail(), (Writer)sw);
        } else if (r.getTModelList() != null) {
            JAXB.marshal((Object)r.getTModelList(), (Writer)sw);
        }
        return "<pre>" + StringEscapeUtils.escapeHtml((String)sw.toString()) + "</pre>";
    }

    static String GetSubscriptionType(NotifySubscriptionListener body) {
        if (body != null && body.getSubscriptionResultsList() != null && body.getSubscriptionResultsList().getSubscription() != null && body.getSubscriptionResultsList().getSubscription().getSubscriptionFilter() != null) {
            SubscriptionFilter sub = body.getSubscriptionResultsList().getSubscription().getSubscriptionFilter();
            if (sub.getFindBinding() != null) {
                return " binding search results";
            }
            if (sub.getFindBusiness() != null) {
                return " business search results";
            }
            if (sub.getFindRelatedBusinesses() != null) {
                return " related business search results";
            }
            if (sub.getFindService() != null) {
                return " service search results";
            }
            if (sub.getFindTModel() != null) {
                return " tModel search results";
            }
            if (sub.getGetAssertionStatusReport() != null) {
                return " assertion status report";
            }
            if (sub.getGetBindingDetail() != null) {
                return " details on a specific binding";
            }
            if (sub.getGetBusinessDetail() != null) {
                return " details on a specific business";
            }
            if (sub.getGetServiceDetail() != null) {
                return " details on a specific service";
            }
            if (sub.getGetTModelDetail() != null) {
                return " details on a specific tModel";
            }
        }
        return " (unable to determine what the subscription type is)";
    }
}

