/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.auth;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.ClassUtil;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.v3.auth.Authenticator;

public class AuthenticatorFactory {
    private static Log log = LogFactory.getLog(AuthenticatorFactory.class);
    private static final String DEFAULT_IMPL = "org.apache.juddi.v3.auth.JUDDIAuthenticator";
    private static Authenticator auth = null;

    public static synchronized Authenticator getAuthenticator() {
        if (auth == null) {
            auth = AuthenticatorFactory.createAuthenticator();
        }
        return auth;
    }

    private static synchronized Authenticator createAuthenticator() {
        if (auth != null) {
            return auth;
        }
        String className = DEFAULT_IMPL;
        try {
            className = AppConfig.getConfiguration().getString("juddi.auth.authenticator.class", DEFAULT_IMPL);
        }
        catch (ConfigurationException ce) {
            log.error((Object)"Configuration exception occurred retrieving: juddi.auth.authenticator.class");
        }
        log.debug((Object)("Authenticator Implementation = " + className));
        Class<?> authClass = null;
        try {
            authClass = ClassUtil.forName(className, AuthenticatorFactory.class);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("The specified Authenticator class '" + className + "' was not found in classpath."));
            log.error((Object)e);
        }
        try {
            if (authClass != null) {
                auth = (Authenticator)authClass.newInstance();
            } else {
                log.error((Object)("Could not load " + className + " authClass is null"));
            }
        }
        catch (Exception e) {
            log.error((Object)("Exception while attempting to instantiate the implementation of Authenticator: " + className + "\n" + e.getMessage()));
            log.error((Object)e);
        }
        return auth;
    }
}

