/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.auth;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.xml.ws.WebServiceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.config.PersistenceManager;
import org.apache.juddi.model.Publisher;
import org.apache.juddi.model.UddiEntityPublisher;
import org.apache.juddi.v3.auth.Authenticator;
import org.apache.juddi.v3.error.AuthenticationException;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.UnknownUserException;

public class JUDDIAuthenticator
implements Authenticator {
    private Log log = LogFactory.getLog(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String authenticate(String authorizedName, String credential) throws AuthenticationException {
        if (authorizedName == null || "".equals(authorizedName)) {
            throw new UnknownUserException(new ErrorMessage("errors.auth.NoPublisher", authorizedName));
        }
        this.log.warn((Object)"DO NOT USE JUDDI AUTHENTICATOR FOR PRODUCTION SYSTEMS - DOES NOT VALIDATE PASSWORDS, AT ALL!");
        int MaxBindingsPerService = -1;
        int MaxServicesPerBusiness = -1;
        int MaxTmodels = -1;
        int MaxBusinesses = -1;
        try {
            MaxBindingsPerService = AppConfig.getConfiguration().getInt("juddi.maxBindingsPerService", -1);
            MaxServicesPerBusiness = AppConfig.getConfiguration().getInt("juddi.maxServicesPerBusiness", -1);
            MaxTmodels = AppConfig.getConfiguration().getInt("juddi.maxTModelsPerPublisher", -1);
            MaxBusinesses = AppConfig.getConfiguration().getInt("juddi.maxBusinessesPerPublisher", -1);
        }
        catch (Exception ex) {
            MaxBindingsPerService = -1;
            MaxServicesPerBusiness = -1;
            MaxTmodels = -1;
            MaxBusinesses = -1;
            this.log.error((Object)("config exception! " + authorizedName), (Throwable)ex);
        }
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            Publisher publisher = (Publisher)em.find(Publisher.class, (Object)authorizedName);
            if (publisher == null) {
                this.log.warn((Object)("Publisher \"" + authorizedName + "\" was not found, adding the publisher in on the fly."));
                publisher = new Publisher();
                publisher.setAuthorizedName(authorizedName);
                publisher.setIsAdmin("false");
                publisher.setIsEnabled("true");
                publisher.setMaxBindingsPerService(MaxBindingsPerService);
                publisher.setMaxBusinesses(MaxBusinesses);
                publisher.setMaxServicesPerBusiness(MaxServicesPerBusiness);
                publisher.setMaxTmodels(MaxTmodels);
                publisher.setPublisherName("Unknown");
                em.persist((Object)publisher);
                tx.commit();
            }
            String string = authorizedName;
            return string;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UddiEntityPublisher identify(String authInfo, String authorizedName, WebServiceContext ctx) throws AuthenticationException {
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            Publisher publisher = (Publisher)em.find(Publisher.class, (Object)authorizedName);
            if (publisher == null) {
                throw new UnknownUserException(new ErrorMessage("errors.auth.NoPublisher", authorizedName));
            }
            Publisher publisher2 = publisher;
            return publisher2;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }
}

