/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.auth;

import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.xml.ws.WebServiceContext;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.config.PersistenceManager;
import org.apache.juddi.model.Publisher;
import org.apache.juddi.model.UddiEntityPublisher;
import org.apache.juddi.v3.auth.Authenticator;
import org.apache.juddi.v3.error.AuthenticationException;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.FatalErrorException;
import org.apache.juddi.v3.error.UnknownUserException;

public class LdapExpandedAuthenticator
implements Authenticator {
    private Log logger = LogFactory.getLog(this.getClass());
    private LdapContext ctx = null;
    private Hashtable<String, String> env = null;
    private String url = null;
    private static final String DEFAULT_URL = "ldap://localhost:389";

    public LdapExpandedAuthenticator() throws NamingException, ConfigurationException {
        String authURL = null;
        try {
            authURL = AppConfig.getConfiguration().getString("juddi.auth.authenticator.url", DEFAULT_URL);
        }
        catch (ConfigurationException ce) {
            this.logger.error((Object)"Configuration exception occurred retrieving: juddi.auth.authenticator.url");
            throw new NamingException("juddi.auth.authenticator.url missing from config or config is not available.");
        }
        this.init(authURL);
    }

    public LdapExpandedAuthenticator(String url) throws NamingException, ConfigurationException {
        this.init(url);
    }

    public void init(String url) throws NamingException, ConfigurationException {
        this.env = new Hashtable();
        this.env.put("java.naming.factory.initial", AppConfig.getConfiguration().getString("juddi.auth.authenticator.initialcontext", "com.sun.jndi.ldap.LdapCtxFactory"));
        this.env.put("java.naming.security.authentication", AppConfig.getConfiguration().getString("juddi.auth.authenticator.style", "simple"));
        this.env.put("java.naming.provider.url", url);
        this.url = url;
        try {
            this.ctx = new InitialLdapContext(this.env, null);
        }
        catch (NamingException e) {
            this.logger.error((Object)("Naming exception " + e));
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String authenticate(String authorizedName, String cred) throws AuthenticationException, FatalErrorException {
        if (authorizedName == null || "".equals(authorizedName)) {
            throw new UnknownUserException(new ErrorMessage("errors.auth.NoPublisher", authorizedName));
        }
        boolean isLdapUser = false;
        int MaxBindingsPerService = -1;
        int MaxServicesPerBusiness = -1;
        int MaxTmodels = -1;
        int MaxBusinesses = -1;
        try {
            MaxBindingsPerService = AppConfig.getConfiguration().getInt("juddi.maxBindingsPerService", -1);
            MaxServicesPerBusiness = AppConfig.getConfiguration().getInt("juddi.maxServicesPerBusiness", -1);
            MaxTmodels = AppConfig.getConfiguration().getInt("juddi.maxTModelsPerPublisher", -1);
            MaxBusinesses = AppConfig.getConfiguration().getInt("juddi.maxBusinessesPerPublisher", -1);
        }
        catch (Exception ex) {
            MaxBindingsPerService = -1;
            MaxServicesPerBusiness = -1;
            MaxTmodels = -1;
            MaxBusinesses = -1;
            this.logger.error((Object)("config exception! " + authorizedName), (Throwable)ex);
        }
        try {
            this.env = new Hashtable();
            this.env.put("java.naming.factory.initial", AppConfig.getConfiguration().getString("juddi.auth.authenticator.initialcontext", "com.sun.jndi.ldap.LdapCtxFactory"));
            this.env.put("java.naming.security.authentication", AppConfig.getConfiguration().getString("juddi.auth.authenticator.style", "simple"));
            this.env.put("java.naming.provider.url", this.url);
            String format = String.format(AppConfig.getConfiguration().getString("juddi.auth.authenticator.ldapexp"), authorizedName);
            this.env.put("java.naming.security.principal", format);
            this.env.put("java.naming.security.credentials", cred);
            this.ctx = new InitialLdapContext(this.env, null);
            isLdapUser = true;
            this.logger.info((Object)(authorizedName + " is authenticated"));
        }
        catch (ConfigurationException e) {
            this.logger.error((Object)(authorizedName + " is not authenticated"), (Throwable)e);
            throw new UnknownUserException(new ErrorMessage("errors.auth.NoPublisher", authorizedName));
        }
        catch (NamingException e) {
            this.logger.error((Object)(authorizedName + " is not authenticated"));
            throw new UnknownUserException(new ErrorMessage("errors.auth.NoPublisher", authorizedName));
        }
        finally {
            try {
                this.ctx.close();
            }
            catch (NamingException e) {
                this.logger.error((Object)("Context close failure " + e));
            }
        }
        if (!isLdapUser) throw new UnknownUserException(new ErrorMessage("errors.auth.NoPublisher", authorizedName));
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            Publisher publisher = (Publisher)em.find(Publisher.class, (Object)authorizedName);
            if (publisher != null) return authorizedName;
            this.logger.warn((Object)"Publisher was not found in the database, adding the publisher in on the fly.");
            publisher = new Publisher();
            publisher.setAuthorizedName(authorizedName);
            publisher.setIsAdmin("false");
            publisher.setIsEnabled("true");
            publisher.setMaxBindingsPerService(MaxBindingsPerService);
            publisher.setMaxBusinesses(MaxBusinesses);
            publisher.setMaxServicesPerBusiness(MaxServicesPerBusiness);
            publisher.setMaxTmodels(MaxTmodels);
            publisher.setPublisherName("Unknown");
            em.persist((Object)publisher);
            tx.commit();
            return authorizedName;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UddiEntityPublisher identify(String authInfo, String authorizedName, WebServiceContext ctx) throws AuthenticationException, FatalErrorException {
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            Publisher publisher = (Publisher)em.find(Publisher.class, (Object)authorizedName);
            if (publisher == null) {
                throw new UnknownUserException(new ErrorMessage("errors.auth.NoPublisher", authorizedName));
            }
            Publisher publisher2 = publisher;
            return publisher2;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }
}

