/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.auth;

import java.io.IOException;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.xml.bind.JAXBException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.config.PersistenceManager;
import org.apache.juddi.model.Publisher;
import org.apache.juddi.v3.auth.User;
import org.apache.juddi.v3.auth.XMLDocAuthenticator;
import org.apache.juddi.v3.error.AuthenticationException;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.FatalErrorException;
import org.apache.juddi.v3.error.UnknownUserException;

public class MD5XMLDocAuthenticator
extends XMLDocAuthenticator {
    private Log logger = LogFactory.getLog(this.getClass());

    public MD5XMLDocAuthenticator() throws JAXBException, IOException, ConfigurationException {
    }

    private MD5XMLDocAuthenticator(boolean x) {
        super(x);
    }

    @Override
    protected String getFilename() throws ConfigurationException {
        return AppConfig.getConfiguration().getString("juddi.auth.usersfile", "juddi-users-hashed.xml");
    }

    @Override
    public String authenticate(String userID, String credential) throws AuthenticationException, FatalErrorException {
        this.preProcess(userID, credential);
        String encryptedCredential = this.hash(credential);
        return this.postProcess(userID, encryptedCredential);
    }

    private String hash(String str) throws FatalErrorException {
        try {
            return DigestUtils.md5Hex((String)str);
        }
        catch (Exception e) {
            this.logger.error((Object)"Exception caught hashing password", (Throwable)e);
            throw new FatalErrorException(new ErrorMessage("errors.auth.cryptor.InvalidKey", e.getMessage()));
        }
    }

    private void preProcess(String userID, String credential) throws AuthenticationException {
        if (userID == null) {
            throw new UnknownUserException(new ErrorMessage("errors.auth.InvalidUserId"));
        }
        if (credential == null) {
            throw new UnknownUserException(new ErrorMessage("errors.auth.InvalidCredentials"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String postProcess(String userID, String encryptedCredential) throws AuthenticationException {
        if (this.userTable.containsKey(userID)) {
            User user = (User)this.userTable.get(userID);
            if (user.getPassword() == null || !encryptedCredential.equals(user.getPassword())) {
                throw new UnknownUserException(new ErrorMessage("errors.auth.InvalidCredentials", userID));
            }
        } else {
            throw new UnknownUserException(new ErrorMessage("errors.auth.InvalidUserId", userID));
        }
        int MaxBindingsPerService = -1;
        int MaxServicesPerBusiness = -1;
        int MaxTmodels = -1;
        int MaxBusinesses = -1;
        try {
            MaxBindingsPerService = AppConfig.getConfiguration().getInt("juddi.maxBindingsPerService", -1);
            MaxServicesPerBusiness = AppConfig.getConfiguration().getInt("juddi.maxServicesPerBusiness", -1);
            MaxTmodels = AppConfig.getConfiguration().getInt("juddi.maxTModelsPerPublisher", -1);
            MaxBusinesses = AppConfig.getConfiguration().getInt("juddi.maxBusinessesPerPublisher", -1);
        }
        catch (Exception ex) {
            MaxBindingsPerService = -1;
            MaxServicesPerBusiness = -1;
            MaxTmodels = -1;
            MaxBusinesses = -1;
            log.error((Object)("config exception! " + userID), (Throwable)ex);
        }
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            Publisher publisher = (Publisher)em.find(Publisher.class, (Object)userID);
            if (publisher == null) {
                log.warn((Object)("Publisher \"" + userID + "\" was not found in the database, adding the publisher in on the fly."));
                publisher = new Publisher();
                publisher.setAuthorizedName(userID);
                publisher.setIsAdmin("false");
                publisher.setIsEnabled("true");
                publisher.setMaxBindingsPerService(MaxBindingsPerService);
                publisher.setMaxBusinesses(MaxBusinesses);
                publisher.setMaxServicesPerBusiness(MaxServicesPerBusiness);
                publisher.setMaxTmodels(MaxTmodels);
                publisher.setPublisherName("Unknown");
                em.persist((Object)publisher);
                tx.commit();
            }
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
        return userID;
    }

    public static void main(String[] args) throws Exception {
        System.out.print("Password: ");
        char[] readPassword = System.console().readPassword();
        System.out.println("Cipher: " + new MD5XMLDocAuthenticator(true).hash(new String(readPassword)));
    }
}

