/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.validation;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.juddi.model.BusinessEntity;
import org.apache.juddi.model.Tmodel;
import org.apache.juddi.model.TransferToken;
import org.apache.juddi.model.TransferTokenKey;
import org.apache.juddi.model.UddiEntity;
import org.apache.juddi.model.UddiEntityPublisher;
import org.apache.juddi.query.util.DynamicQuery;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.FatalErrorException;
import org.apache.juddi.v3.error.InvalidKeyPassedException;
import org.apache.juddi.v3.error.InvalidValueException;
import org.apache.juddi.v3.error.TokenAlreadyExistsException;
import org.apache.juddi.v3.error.TransferNotAllowedException;
import org.apache.juddi.v3.error.UserMismatchException;
import org.apache.juddi.v3.error.ValueNotAllowedException;
import org.apache.juddi.validation.ValidateUDDIApi;
import org.uddi.custody_v3.DiscardTransferToken;
import org.uddi.custody_v3.KeyBag;
import org.uddi.custody_v3.TransferEntities;
import org.uddi.v3_service.DispositionReportFaultMessage;

public class ValidateCustodyTransfer
extends ValidateUDDIApi {
    public ValidateCustodyTransfer(UddiEntityPublisher publisher) {
        super(publisher);
    }

    public void validateDiscardTransferToken(EntityManager em, DiscardTransferToken body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        KeyBag keyBag = body.getKeyBag();
        if (body.getTransferToken() == null && keyBag == null) {
            throw new FatalErrorException(new ErrorMessage("errors.discardtransfertoken.NoInput"));
        }
        if (keyBag != null) {
            List keyList = keyBag.getKey();
            if (keyList == null || keyList.size() == 0) {
                throw new ValueNotAllowedException(new ErrorMessage("errors.keybag.NoInput"));
            }
            int i = 0;
            for (String key : keyList) {
                key = key.toLowerCase();
                keyList.set(i, key);
                UddiEntity uddiEntity = (UddiEntity)em.find(UddiEntity.class, (Object)key);
                if (uddiEntity != null && !this.publisher.isOwner(uddiEntity)) {
                    throw new UserMismatchException(new ErrorMessage("errors.usermismatch.InvalidOwner", key));
                }
                ++i;
            }
        }
    }

    public void validateGetTransferToken(EntityManager em, KeyBag keyBag) throws DispositionReportFaultMessage {
        if (keyBag == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List keyList = keyBag.getKey();
        if (keyList == null || keyList.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.keybag.NoInput"));
        }
        Vector<DynamicQuery.Parameter> params = new Vector<DynamicQuery.Parameter>(0);
        int i = 0;
        for (String key : keyList) {
            key = key.toLowerCase();
            keyList.set(i, key);
            UddiEntity uddiEntity = (UddiEntity)em.find(UddiEntity.class, (Object)key);
            if (uddiEntity == null) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.EntityNotFound", key));
            }
            if (!(uddiEntity instanceof BusinessEntity) && !(uddiEntity instanceof Tmodel)) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.gettransfertoken.InvalidEntity", key));
            }
            if (!this.publisher.isOwner(uddiEntity)) {
                throw new UserMismatchException(new ErrorMessage("errors.usermismatch.InvalidOwner", key));
            }
            DynamicQuery.Parameter param = new DynamicQuery.Parameter("UPPER(ttk.entityKey)", key.toUpperCase(), "=");
            params.add(param);
        }
        DynamicQuery checkKeysQry = new DynamicQuery();
        checkKeysQry.append("select ttk.entityKey from TransferTokenKey ttk ");
        checkKeysQry.WHERE().pad().appendGroupedOr(params.toArray(new DynamicQuery.Parameter[0]));
        Query qry = checkKeysQry.buildJPAQuery(em);
        List obj = qry.getResultList();
        if (obj != null && obj.size() > 0) {
            throw new TokenAlreadyExistsException(new ErrorMessage("errors.gettransfertoken.KeyExists", (String)obj.get(0)));
        }
    }

    public void validateTransferLocalEntities(EntityManager em, String transferTokenId, List<String> apiKeyList) throws DispositionReportFaultMessage {
        TransferToken modelTransferToken = (TransferToken)em.find(TransferToken.class, (Object)transferTokenId);
        if (modelTransferToken == null) {
            throw new TransferNotAllowedException(new ErrorMessage("errors.transferentities.TokenNotFound", transferTokenId));
        }
        Date now = new Date();
        if (now.after(modelTransferToken.getExpirationDate())) {
            throw new TransferNotAllowedException(new ErrorMessage("errors.transferentities.TokenExpired", transferTokenId));
        }
        List<TransferTokenKey> transferKeyList = modelTransferToken.getTransferKeys();
        ArrayList<String> modelKeyList = new ArrayList<String>(0);
        if (transferKeyList != null && transferKeyList.size() > 0) {
            for (TransferTokenKey ttk : transferKeyList) {
                modelKeyList.add(ttk.getEntityKey());
            }
        }
        Collections.sort(apiKeyList);
        Collections.sort(modelKeyList);
        int count = 0;
        if (modelKeyList.size() != apiKeyList.size()) {
            throw new TransferNotAllowedException(new ErrorMessage("errors.transferentities.KeySizeMismatch"));
        }
        for (String key : apiKeyList) {
            key = key.toLowerCase();
            apiKeyList.set(count, key);
            if (!key.equalsIgnoreCase((String)modelKeyList.get(count))) {
                throw new TransferNotAllowedException(new ErrorMessage("errors.transferentities.KeyMismatch", key + " & " + (String)modelKeyList.get(count)));
            }
            UddiEntity uddiEntity = (UddiEntity)em.find(UddiEntity.class, (Object)key);
            if (uddiEntity == null) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.EntityNotFound", key));
            }
            ++count;
        }
    }

    public boolean validateTransferEntities(EntityManager em, TransferEntities body) throws DispositionReportFaultMessage {
        boolean ret = true;
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        org.uddi.custody_v3.TransferToken apiTransferToken = body.getTransferToken();
        if (apiTransferToken == null) {
            throw new FatalErrorException(new ErrorMessage("errors.transfertoken.NullInput"));
        }
        KeyBag keyBag = body.getKeyBag();
        if (keyBag == null) {
            throw new FatalErrorException(new ErrorMessage("errors.keybag.NullInput"));
        }
        List apiKeyList = keyBag.getKey();
        if (apiKeyList == null || apiKeyList.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.keybag.NoInput"));
        }
        String transferTokenId = null;
        try {
            transferTokenId = new String(apiTransferToken.getOpaqueToken(), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new InvalidValueException(new ErrorMessage("errors.stringEncoding"));
        }
        if (!this.nodeID.equals(apiTransferToken.getNodeID())) {
            return false;
        }
        this.validateTransferLocalEntities(em, transferTokenId, apiKeyList);
        return ret;
    }
}

