/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.validation;

import java.util.List;
import java.util.StringTokenizer;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.InvalidKeyPassedException;
import org.apache.juddi.v3.error.ValueNotAllowedException;
import org.uddi.api_v3.CategoryBag;
import org.uddi.api_v3.KeyedReference;
import org.uddi.api_v3.TModel;
import org.uddi.v3_service.DispositionReportFaultMessage;

public class ValidateUDDIKey {
    public static void validateUDDIv3Key(String key) throws DispositionReportFaultMessage {
        if (key == null) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.NullKey"));
        }
        if (key.toLowerCase().startsWith("uuid:")) {
            return;
        }
        if (!key.contains(":")) {
            return;
        }
        String keyToTest = key.trim();
        if (keyToTest.endsWith(":")) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.MalformedKey", key));
        }
        StringTokenizer tokenizer = new StringTokenizer(key.toLowerCase(), ":");
        int count = 0;
        while (tokenizer.hasMoreTokens()) {
            String nextToken = tokenizer.nextToken();
            if (count == 0 ? !ValidateUDDIKey.isValidUDDIScheme(nextToken) : (count == 1 ? !ValidateUDDIKey.isValidDomainKey(nextToken) : !ValidateUDDIKey.isValidKSS(nextToken))) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.MalformedKey", key));
            }
            ++count;
        }
    }

    public static void validateUDDIv3KeyGeneratorKey(String key) throws DispositionReportFaultMessage {
        if (key == null) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.NullKeys"));
        }
        if (!key.toUpperCase().endsWith("keygenerator".toUpperCase())) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.KeyGenSuffix", key));
        }
        ValidateUDDIKey.validateUDDIv3Key(key.substring(0, key.lastIndexOf(":")));
    }

    public static void validateUDDIv3KeyGeneratorTModel(TModel tModel) throws DispositionReportFaultMessage {
        String keyedValue;
        KeyedReference elem;
        List elems;
        if (tModel == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.tmodel.NullInput"));
        }
        ValidateUDDIKey.validateUDDIv3KeyGeneratorKey(tModel.getTModelKey());
        CategoryBag categories = tModel.getCategoryBag();
        if (categories != null && (elems = categories.getKeyedReference()) != null && elems.size() == 1 && (elem = (KeyedReference)elems.get(0)) != null && elem instanceof KeyedReference && (keyedValue = elem.getKeyValue()) != null && keyedValue.equalsIgnoreCase("keygenerator")) {
            return;
        }
        throw new ValueNotAllowedException(new ErrorMessage("errors.tmodel.keygenerator.BadCategory"));
    }

    public static boolean isValidUDDIScheme(String token) {
        if (token == null) {
            return false;
        }
        return "uddi".equalsIgnoreCase(token);
    }

    public static boolean isValidDomainKey(String token) {
        if (token.indexOf("..") != -1) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(token, ".");
        int tokensCount = tokenizer.countTokens();
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String domainPart = tokenizer.nextToken();
            if (i == tokensCount - 1 ? !ValidateUDDIKey.isValidTopLabel(domainPart) : !ValidateUDDIKey.isValidDomainLabel(domainPart)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isValidDomainLabel(String token) {
        char[] chars = token.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '-' || Character.isLetterOrDigit(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidTopLabel(String token) {
        return Character.isLetter(token.charAt(0)) && (token.length() == 1 || ValidateUDDIKey.isValidDomainLabel(token.substring(1)));
    }

    public static boolean isValidKSS(String token) {
        if (token.length() == 0) {
            return false;
        }
        return !token.equalsIgnoreCase("keygenerator");
    }
}

