/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.validation.vsv;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.InvalidValueException;
import org.apache.juddi.validation.vsv.ValueSetValidator;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BusinessEntity;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.KeyedReference;
import org.uddi.api_v3.KeyedReferenceGroup;
import org.uddi.api_v3.PublisherAssertion;
import org.uddi.api_v3.TModel;
import org.uddi.api_v3.TModelInstanceInfo;
import org.uddi.v3_service.DispositionReportFaultMessage;

public class Uddiuddiorgcategorizationtypes
implements ValueSetValidator {
    public static final String key = "uddi:uddi.org:categorization:types";
    private static Map<String, Boolean> NotAllowedOnBindings;
    private static Map<String, Boolean> NotAllowedOnTModels;

    @Override
    public void validateValuesBindingTemplate(List<BindingTemplate> items, String xpath) throws DispositionReportFaultMessage {
        if (items == null) {
            return;
        }
        for (int i = 0; i < items.size(); ++i) {
            int k;
            if (items.get(i).getCategoryBag() != null) {
                for (k = 0; k < items.get(i).getCategoryBag().getKeyedReference().size(); ++k) {
                    if (((KeyedReference)items.get(i).getCategoryBag().getKeyedReference().get(k)).getTModelKey() == null || !NotAllowedOnBindings.containsKey(((KeyedReference)items.get(i).getCategoryBag().getKeyedReference().get(k)).getTModelKey().toLowerCase())) continue;
                    throw new InvalidValueException(new ErrorMessage("errors.valuesetvalidation.invalidcontent", xpath + "(" + i + ").catbag.keyedReferences(" + k + ").tModelKey Value [" + ((KeyedReference)items.get(i).getCategoryBag().getKeyedReference().get(k)).getTModelKey() + "] not allowed on bindingtemplates for key " + key));
                }
                for (k = 0; k < items.get(i).getCategoryBag().getKeyedReferenceGroup().size(); ++k) {
                    if (((KeyedReferenceGroup)items.get(i).getCategoryBag().getKeyedReferenceGroup().get(k)).getTModelKey() == null) continue;
                    if (NotAllowedOnBindings.containsKey(((KeyedReferenceGroup)items.get(i).getCategoryBag().getKeyedReferenceGroup().get(k)).getTModelKey().toLowerCase())) {
                        throw new InvalidValueException(new ErrorMessage("errors.valuesetvalidation.invalidcontent", xpath + "(" + i + ").catbag.keyedReferenceGroup(" + k + ").tModelKey Value [" + ((KeyedReferenceGroup)items.get(i).getCategoryBag().getKeyedReferenceGroup().get(k)).getTModelKey() + "] not allowed on bindingtemplates for key " + key));
                    }
                    for (int j = 0; j < ((KeyedReferenceGroup)items.get(i).getCategoryBag().getKeyedReferenceGroup().get(k)).getKeyedReference().size(); ++j) {
                        if (((KeyedReference)((KeyedReferenceGroup)items.get(i).getCategoryBag().getKeyedReferenceGroup().get(k)).getKeyedReference().get(j)).getTModelKey() == null || !NotAllowedOnBindings.containsKey(((KeyedReference)((KeyedReferenceGroup)items.get(i).getCategoryBag().getKeyedReferenceGroup().get(k)).getKeyedReference().get(j)).getTModelKey().toLowerCase())) continue;
                        throw new InvalidValueException(new ErrorMessage("errors.valuesetvalidation.invalidcontent", xpath + "(" + i + ").catbag.keyedReferenceGroup(" + k + ").keyedReference(" + j + ").tModel Value [" + ((KeyedReference)((KeyedReferenceGroup)items.get(i).getCategoryBag().getKeyedReferenceGroup().get(k)).getKeyedReference().get(j)).getTModelKey() + "] not allowed on bindingtemplates for key " + key));
                    }
                }
            }
            if (items.get(i).getTModelInstanceDetails() == null) continue;
            for (k = 0; k < items.get(i).getTModelInstanceDetails().getTModelInstanceInfo().size(); ++k) {
                if (items.get(i).getTModelInstanceDetails().getTModelInstanceInfo().get(k) == null || !key.equalsIgnoreCase(((TModelInstanceInfo)items.get(i).getTModelInstanceDetails().getTModelInstanceInfo().get(k)).getTModelKey())) continue;
                throw new InvalidValueException(new ErrorMessage("errors.valuesetvalidation.invalidcontent", xpath + "tModelInstanceDetails(" + k + ").tModelKey " + key + " is not allowed on tModelInstanceInfos"));
            }
        }
    }

    @Override
    public void validateValuesBusinessEntity(List<BusinessEntity> items) throws DispositionReportFaultMessage {
        if (items == null) {
            return;
        }
        for (int i = 0; i < items.size(); ++i) {
            if (items.get(i).getBusinessServices() == null) continue;
            this.validateValuesBusinessService(items.get(i).getBusinessServices().getBusinessService(), "businessEntity(" + i + ").");
        }
    }

    @Override
    public void validateValuesBusinessService(List<BusinessService> items, String xpath) throws DispositionReportFaultMessage {
        if (items == null) {
            return;
        }
        for (int i = 0; i < items.size(); ++i) {
            if (items.get(i).getCategoryBag() != null) {
                // empty if block
            }
            if (items.get(i).getBindingTemplates() == null) continue;
            this.validateValuesBindingTemplate(items.get(i).getBindingTemplates().getBindingTemplate(), xpath + "businessService(" + i + ").bindingTemplates.");
        }
    }

    @Override
    public void validateValuesPublisherAssertion(List<PublisherAssertion> items) throws DispositionReportFaultMessage {
        if (items == null) {
            return;
        }
    }

    @Override
    public void validateTmodelInstanceDetails(List<TModelInstanceInfo> tModelInstanceInfo, String xpath) throws DispositionReportFaultMessage {
    }

    @Override
    public List<String> getValidValues() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(NotAllowedOnBindings.keySet());
        ret.addAll(NotAllowedOnTModels.keySet());
        return ret;
    }

    @Override
    public void validateValuesTModel(List<TModel> items) throws DispositionReportFaultMessage {
        if (items == null) {
            return;
        }
        for (int i = 0; i < items.size(); ++i) {
            int k;
            if (items.get(i).getCategoryBag() != null) {
                for (k = 0; k < items.get(i).getCategoryBag().getKeyedReference().size(); ++k) {
                    if (((KeyedReference)items.get(i).getCategoryBag().getKeyedReference().get(k)).getTModelKey() == null || !key.equalsIgnoreCase(((KeyedReference)items.get(i).getCategoryBag().getKeyedReference().get(k)).getTModelKey()) || ((KeyedReference)items.get(i).getCategoryBag().getKeyedReference().get(k)).getKeyValue() == null || !NotAllowedOnTModels.containsKey(((KeyedReference)items.get(i).getCategoryBag().getKeyedReference().get(k)).getKeyValue().toLowerCase())) continue;
                    throw new InvalidValueException(new ErrorMessage("errors.valuesetvalidation.invalidcontent", "Value [" + ((KeyedReference)items.get(i).getCategoryBag().getKeyedReference().get(k)).getTModelKey() + "] not allowed on tModels for key " + key));
                }
                for (k = 0; k < items.get(i).getCategoryBag().getKeyedReferenceGroup().size(); ++k) {
                    if (((KeyedReferenceGroup)items.get(i).getCategoryBag().getKeyedReferenceGroup().get(k)).getTModelKey() == null) continue;
                    for (int j = 0; j < ((KeyedReferenceGroup)items.get(i).getCategoryBag().getKeyedReferenceGroup().get(k)).getKeyedReference().size(); ++j) {
                        if (((KeyedReference)((KeyedReferenceGroup)items.get(i).getCategoryBag().getKeyedReferenceGroup().get(k)).getKeyedReference().get(j)).getTModelKey() == null || !key.equalsIgnoreCase(((KeyedReference)((KeyedReferenceGroup)items.get(i).getCategoryBag().getKeyedReferenceGroup().get(k)).getKeyedReference().get(j)).getTModelKey()) || ((KeyedReference)((KeyedReferenceGroup)items.get(i).getCategoryBag().getKeyedReferenceGroup().get(k)).getKeyedReference().get(j)).getKeyValue() == null || !NotAllowedOnTModels.containsKey(((KeyedReference)((KeyedReferenceGroup)items.get(i).getCategoryBag().getKeyedReferenceGroup().get(k)).getKeyedReference().get(j)).getKeyValue().toLowerCase())) continue;
                        throw new InvalidValueException(new ErrorMessage("errors.valuesetvalidation.invalidcontent", "Value [" + ((KeyedReference)((KeyedReferenceGroup)items.get(i).getCategoryBag().getKeyedReferenceGroup().get(k)).getKeyedReference().get(j)).getTModelKey() + "] not allowed on tModels for key " + key));
                    }
                }
            }
            if (items.get(i).getIdentifierBag() == null) continue;
            for (k = 0; k < items.get(i).getCategoryBag().getKeyedReference().size(); ++k) {
                if (((KeyedReference)items.get(i).getCategoryBag().getKeyedReference().get(k)).getTModelKey() == null || !NotAllowedOnTModels.containsKey(((KeyedReference)items.get(i).getCategoryBag().getKeyedReference().get(k)).getTModelKey().toLowerCase())) continue;
                throw new InvalidValueException(new ErrorMessage("errors.valuesetvalidation.invalidcontent", "Value [" + ((KeyedReference)items.get(i).getCategoryBag().getKeyedReference().get(k)).getTModelKey() + "] not allowed on tModels for key " + key));
            }
        }
    }

    static {
        NotAllowedOnTModels = new HashMap<String, Boolean>();
        NotAllowedOnTModels.put("wsdlDeployment".toLowerCase(), true);
        NotAllowedOnBindings = new HashMap<String, Boolean>();
        NotAllowedOnBindings.put("valueSet".toLowerCase(), true);
        NotAllowedOnBindings.put("identifier".toLowerCase(), true);
        NotAllowedOnBindings.put("namespace".toLowerCase(), true);
        NotAllowedOnBindings.put("categorization".toLowerCase(), true);
        NotAllowedOnBindings.put("postalAddress".toLowerCase(), true);
        NotAllowedOnBindings.put("categorizationGroup".toLowerCase(), true);
        NotAllowedOnBindings.put("relationship".toLowerCase(), true);
        NotAllowedOnBindings.put("specification".toLowerCase(), true);
        NotAllowedOnBindings.put("xmlSpec".toLowerCase(), true);
        NotAllowedOnBindings.put("soapSpec".toLowerCase(), true);
        NotAllowedOnBindings.put("wsdlSpec".toLowerCase(), true);
        NotAllowedOnBindings.put("protocol".toLowerCase(), true);
        NotAllowedOnBindings.put("transport".toLowerCase(), true);
        NotAllowedOnBindings.put("signatureComponent".toLowerCase(), true);
        NotAllowedOnBindings.put("unvalidatable".toLowerCase(), true);
        NotAllowedOnBindings.put("checked".toLowerCase(), true);
        NotAllowedOnBindings.put("unchecked".toLowerCase(), true);
        NotAllowedOnBindings.put("cacheable".toLowerCase(), true);
        NotAllowedOnBindings.put("uncacheable".toLowerCase(), true);
        NotAllowedOnBindings.put("keyGenerator".toLowerCase(), true);
        NotAllowedOnBindings.put("findQualifier".toLowerCase(), true);
        NotAllowedOnBindings.put("sortOrder".toLowerCase(), true);
        NotAllowedOnBindings.put("useTypeDesignator".toLowerCase(), true);
    }
}

