/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.cryptor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;

public class XmlUtils {
    private static final Log log = LogFactory.getLog(XmlUtils.class);

    public static Object unmarshal(Reader reader, Class ... clazz) {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            spf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            spf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            spf.setNamespaceAware(true);
            SAXSource xmlSource = new SAXSource(spf.newSAXParser().getXMLReader(), new InputSource(reader));
            JAXBContext jc = JAXBContext.newInstance((Class[])clazz);
            Unmarshaller um = jc.createUnmarshaller();
            return um.unmarshal((Source)xmlSource);
        }
        catch (Exception ex) {
            log.warn((Object)("Failed to unmarshall object. Increase logging to debug for additional information. 1" + ex.getMessage()));
            log.debug((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static Object unmarshal(InputStream reader, Class clazz) {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            spf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            spf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            spf.setNamespaceAware(true);
            SAXSource xmlSource = new SAXSource(spf.newSAXParser().getXMLReader(), new InputSource(reader));
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Unmarshaller um = jc.createUnmarshaller();
            return um.unmarshal((Source)xmlSource);
        }
        catch (Exception ex) {
            log.warn((Object)("Failed to unmarshall object. Increase logging to debug for additional information. 2" + ex.getMessage()));
            log.debug((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static Object unmarshal(Reader reader, String packageName) {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            spf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            spf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            spf.setNamespaceAware(true);
            SAXSource xmlSource = new SAXSource(spf.newSAXParser().getXMLReader(), new InputSource(reader));
            JAXBContext jc = JAXBContext.newInstance((String)packageName);
            Unmarshaller um = jc.createUnmarshaller();
            return ((JAXBElement)um.unmarshal((Source)xmlSource)).getValue();
        }
        catch (Exception ex) {
            log.warn((Object)("Failed to unmarshall object. Increase logging to debug for additional information. 3" + ex.getMessage()));
            log.debug((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object unmarshal(URL url, Class clazz) {
        InputStream openStream = null;
        Object obj = null;
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            spf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            spf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            spf.setNamespaceAware(true);
            openStream = url.openStream();
            SAXSource xmlSource = new SAXSource(spf.newSAXParser().getXMLReader(), new InputSource(openStream));
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Unmarshaller um = jc.createUnmarshaller();
            obj = um.unmarshal((Source)xmlSource);
        }
        catch (Exception ex) {
            log.warn((Object)("Failed to unmarshall object. Increase logging to debug for additional information. 4" + ex.getMessage()));
            log.debug((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            if (openStream != null) {
                try {
                    openStream.close();
                }
                catch (IOException ex) {
                    log.debug((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
        return obj;
    }

    public static Object unmarshal(File file, Class clazz) {
        try {
            return XmlUtils.unmarshal(file.toURI().toURL(), clazz);
        }
        catch (Exception ex) {
            log.warn((Object)("Failed to unmarshall object. Increase logging to debug for additional information. 5" + ex.getMessage()));
            log.debug((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }
}

