/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.transport.wrapper;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.rmi.Remote;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.juddi.v3.client.ClassUtil;
import org.apache.juddi.v3.client.config.UDDIClient;
import org.apache.juddi.v3.client.config.UDDIClientContainer;
import org.apache.juddi.v3.client.transport.Transport;
import org.apache.juddi.v3.client.transport.wrapper.Handler;
import org.apache.juddi.v3.client.transport.wrapper.RequestHandler;
import org.uddi.api_v3.FindBinding;
import org.uddi.api_v3.FindBusiness;
import org.uddi.api_v3.FindRelatedBusinesses;
import org.uddi.api_v3.FindService;
import org.uddi.api_v3.FindTModel;
import org.uddi.api_v3.GetBindingDetail;
import org.uddi.api_v3.GetBusinessDetail;
import org.uddi.api_v3.GetOperationalInfo;
import org.uddi.api_v3.GetServiceDetail;
import org.uddi.api_v3.GetTModelDetail;
import org.uddi.v3_service.UDDIInquiryPortType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UDDIInquiryService {
    private static final String DEFAULT_NODE_NAME = "default";
    private String clientName = System.getProperty("org.apache.juddi.v3.client.name");
    private String nodeName = System.getProperty("org.apache.juddi.v3.client.node.name", "default");
    private HashMap<String, Handler> operations = new HashMap();

    public UDDIInquiryService() {
        this.operations.put("find_business", new Handler("findBusiness", FindBusiness.class));
        this.operations.put("find_service", new Handler("findService", FindService.class));
        this.operations.put("find_binding", new Handler("findBinding", FindBinding.class));
        this.operations.put("find_tModel", new Handler("findTModel", FindTModel.class));
        this.operations.put("find_relatedBusinesses", new Handler("findRelatedBusinesses", FindRelatedBusinesses.class));
        this.operations.put("get_businessDetail", new Handler("getBusinessDetail", GetBusinessDetail.class));
        this.operations.put("get_serviceDetail", new Handler("getServiceDetail", GetServiceDetail.class));
        this.operations.put("get_bindingDetail", new Handler("getBindingDetail", GetBindingDetail.class));
        this.operations.put("get_tModelDetail", new Handler("getTModelDetail", GetTModelDetail.class));
        this.operations.put("get_operationalInfo", new Handler("getOperationalInfo", GetOperationalInfo.class));
    }

    public void validateRequest(String operation) throws UnsupportedOperationException {
        if (operation == null || operation.trim().length() == 0) {
            throw new UnsupportedOperationException("operation " + operation + " not supported");
        }
    }

    public Node inquire(Element uddiReq) throws Exception {
        return this.inquire(uddiReq, this.nodeName, this.clientName);
    }

    public Node inquire(Element uddiReq, String nodeName, String clientName) throws Exception {
        UDDIClient client = UDDIClientContainer.getUDDIClient(clientName);
        String clazz = client.getClientConfig().getUDDINode(nodeName).getProxyTransport();
        Class<?> transportClass = ClassUtil.forName(clazz, this.getClass());
        Transport transport = (Transport)transportClass.getConstructor(String.class, String.class).newInstance(clientName, nodeName);
        UDDIInquiryPortType inquiry = transport.getUDDIInquiryService();
        RequestHandler requestHandler = new RequestHandler();
        requestHandler.setPortType((Remote)inquiry);
        String operation = requestHandler.getOperation(uddiReq);
        Handler opHandler = this.operations.get(operation);
        if (opHandler == null) {
            throw new IllegalArgumentException("Operation not found: " + operation);
        }
        requestHandler.setMethodName(opHandler.getMethodName());
        requestHandler.setOperationClass(opHandler.getParameter());
        String version = requestHandler.getVersion(uddiReq, operation);
        this.validateRequest(operation);
        return requestHandler.invoke(uddiReq);
    }

    public String inquire(UDDIInquiryPortType inquiry, String request) throws Exception {
        ByteArrayInputStream sbis = new ByteArrayInputStream(request.getBytes());
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        dbf.setNamespaceAware(true);
        dbf.setValidating(false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(sbis);
        Element reqElem = doc.getDocumentElement();
        RequestHandler requestHandler = new RequestHandler();
        requestHandler.setPortType((Remote)inquiry);
        String operation = reqElem.getTagName().toString();
        Handler opHandler = this.operations.get(operation);
        if (opHandler == null) {
            throw new IllegalArgumentException("Operation not found: " + operation);
        }
        requestHandler.setMethodName(opHandler.getMethodName());
        requestHandler.setOperationClass(opHandler.getParameter());
        Node n = requestHandler.invoke(reqElem);
        StringWriter sw = new StringWriter();
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer t = factory.newTransformer();
        t.transform(new DOMSource(n), new StreamResult(sw));
        return sw.toString();
    }
}

