/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.api.impl.rest;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.wsdl.Definition;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.jaxrs.model.wadl.Description;
import org.apache.juddi.api.impl.UDDIInquiryImpl;
import org.apache.juddi.api_v3.AccessPointType;
import org.apache.juddi.api_v3.rest.UriContainer;
import org.apache.juddi.v3.client.mapping.URLLocalizer;
import org.apache.juddi.v3.client.mapping.URLLocalizerDefaultImpl;
import org.apache.juddi.v3.client.mapping.wsdl.ReadWSDL;
import org.apache.juddi.v3.client.mapping.wsdl.WSDL2UDDI;
import org.apache.juddi.v3.error.UDDIErrorHelper;
import org.uddi.api_v3.BindingDetail;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BusinessDetail;
import org.uddi.api_v3.BusinessEntity;
import org.uddi.api_v3.BusinessInfo;
import org.uddi.api_v3.BusinessList;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.BusinessServices;
import org.uddi.api_v3.FindBusiness;
import org.uddi.api_v3.FindQualifiers;
import org.uddi.api_v3.FindService;
import org.uddi.api_v3.FindTModel;
import org.uddi.api_v3.GetBindingDetail;
import org.uddi.api_v3.GetBusinessDetail;
import org.uddi.api_v3.GetOperationalInfo;
import org.uddi.api_v3.GetServiceDetail;
import org.uddi.api_v3.GetTModelDetail;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.OperationalInfo;
import org.uddi.api_v3.OperationalInfos;
import org.uddi.api_v3.ServiceDetail;
import org.uddi.api_v3.ServiceInfo;
import org.uddi.api_v3.ServiceList;
import org.uddi.api_v3.TModel;
import org.uddi.api_v3.TModelDetail;
import org.uddi.api_v3.TModelInfo;
import org.uddi.api_v3.TModelList;
import org.uddi.sub_v3.KeyBag;
import org.uddi.v3_service.DispositionReportFaultMessage;

@Path(value="/")
@Produces(value={"application/xml", "application/json", "text/html"})
@Description(value="This service provides access to UDDIv3 data via a REST interface, including the recommendation specified in the UDDIv3 spec titled, HTTP GET, as well as a number of methods above and beyond.")
public class UDDIInquiryJAXRS {
    private static UDDIInquiryImpl inquiry = new UDDIInquiryImpl();
    private static final Log log = LogFactory.getLog(UDDIInquiryJAXRS.class);
    private final int MAX_ROWS = 100;

    @GET
    @Path(value="/JSON/businessKey/{id}")
    @Produces(value={"application/json"})
    @Description(value="Returns the details of a business entity in JSON")
    public BusinessEntity getBusinessDetailJSON(@PathParam(value="id") String id) throws WebApplicationException {
        return this.getBusinessDetail(id);
    }

    @GET
    @Path(value="/XML/businessKey/{id}")
    @Produces(value={"application/xml"})
    @Description(value="Returns the details of a business entity in XML")
    public BusinessEntity getBusinessDetailXML(@PathParam(value="id") String id) throws WebApplicationException {
        return this.getBusinessDetail(id);
    }

    private BusinessEntity getBusinessDetail(String id) {
        GetBusinessDetail gbd = new GetBusinessDetail();
        gbd.getBusinessKey().add(id);
        try {
            BusinessDetail businessDetail = inquiry.getBusinessDetail(gbd);
            return (BusinessEntity)businessDetail.getBusinessEntity().get(0);
        }
        catch (DispositionReportFaultMessage ex) {
            UDDIInquiryJAXRS.HandleException((Exception)((Object)ex));
            return null;
        }
    }

    @GET
    @Path(value="/XML/tModelKey/{id}")
    @Produces(value={"application/xml"})
    @Description(value="Returns the details of a tModel entity in XML")
    public TModel getTModelDetailXML(@PathParam(value="id") String id) throws WebApplicationException {
        return this.getTModelDetail(id);
    }

    @GET
    @Path(value="/JSON/tModelKey/{id}")
    @Produces(value={"application/json"})
    @Description(value="Returns the details of a tModel entity in JSON")
    public TModel getTModelDetailJSON(@PathParam(value="id") String id) throws WebApplicationException {
        return this.getTModelDetail(id);
    }

    private TModel getTModelDetail(String id) {
        GetTModelDetail gbd = new GetTModelDetail();
        gbd.getTModelKey().add(id);
        try {
            TModelDetail tModelDetail = inquiry.getTModelDetail(gbd);
            return (TModel)tModelDetail.getTModel().get(0);
        }
        catch (DispositionReportFaultMessage ex) {
            UDDIInquiryJAXRS.HandleException((Exception)((Object)ex));
            return null;
        }
    }

    @GET
    @Path(value="/JSON/serviceKey/{id}")
    @Produces(value={"application/json"})
    @Description(value="Returns the details of a service entity in JSON")
    public BusinessService getServiceDetailJSON(@PathParam(value="id") String id) throws WebApplicationException {
        return this.getServiceDetail(id);
    }

    @GET
    @Path(value="/JSON/getDetail")
    @Produces(value={"application/json"})
    @Description(value="Returns the details of a UDDI entity in JSON, use query parametersserviceKey,businessKey,tModelKey, bindingKey")
    public Object getDetailJSON(@QueryParam(value="serviceKey") String serviceKey, @QueryParam(value="businessKey") String businessKey, @QueryParam(value="tModelKey") String tModelKey, @QueryParam(value="bindingKey") String bindingKey) throws WebApplicationException {
        int params = 0;
        if (businessKey != null) {
            ++params;
        }
        if (tModelKey != null) {
            ++params;
        }
        if (bindingKey != null) {
            ++params;
        }
        if (serviceKey != null) {
            ++params;
        }
        if (params != 1) {
            throw new WebApplicationException(400);
        }
        if (businessKey != null) {
            return this.getBusinessDetail(businessKey);
        }
        if (tModelKey != null) {
            return this.getTModelDetail(tModelKey);
        }
        if (bindingKey != null) {
            return this.getBindingDetail(bindingKey);
        }
        if (serviceKey != null) {
            return this.getServiceDetail(serviceKey);
        }
        throw new WebApplicationException(400);
    }

    @GET
    @Path(value="/XML/getDetail")
    @Produces(value={"application/xml"})
    @Description(value="This method implements the UDDIv3 spec for HTTP GET Inquiry services. Returns the details of a UDDI entity in XML, use query parametersserviceKey,businessKey,tModelKey, bindingKey")
    public Object getDetailXML(@QueryParam(value="serviceKey") String serviceKey, @QueryParam(value="businessKey") String businessKey, @QueryParam(value="tModelKey") String tModelKey, @QueryParam(value="bindingKey") String bindingKey) throws WebApplicationException {
        int params = 0;
        if (businessKey != null) {
            ++params;
        }
        if (tModelKey != null) {
            ++params;
        }
        if (bindingKey != null) {
            ++params;
        }
        if (serviceKey != null) {
            ++params;
        }
        if (params != 1) {
            throw new WebApplicationException(400);
        }
        if (businessKey != null) {
            return this.getBusinessDetail(businessKey);
        }
        if (tModelKey != null) {
            return this.getTModelDetail(tModelKey);
        }
        if (bindingKey != null) {
            return this.getBindingDetail(bindingKey);
        }
        if (serviceKey != null) {
            return this.getServiceDetail(serviceKey);
        }
        throw new WebApplicationException(400);
    }

    @GET
    @Path(value="/XML/serviceKey/{id}")
    @Produces(value={"application/xml"})
    @Description(value="Returns the details of a service entity in XML")
    public BusinessService getServiceDetailXML(@PathParam(value="id") String id) throws WebApplicationException {
        return this.getServiceDetail(id);
    }

    private BusinessService getServiceDetail(String id) {
        GetServiceDetail gbd = new GetServiceDetail();
        gbd.getServiceKey().add(id);
        try {
            ServiceDetail serviceDetail = inquiry.getServiceDetail(gbd);
            return (BusinessService)serviceDetail.getBusinessService().get(0);
        }
        catch (DispositionReportFaultMessage ex) {
            UDDIInquiryJAXRS.HandleException((Exception)((Object)ex));
            return null;
        }
    }

    @GET
    @Path(value="/JSON/opInfo/{id}")
    @Produces(value={"application/json"})
    @Description(value="Returns the operational details of a given entity in JSON")
    public OperationalInfo getOpInfoJSON(@PathParam(value="id") String id) throws WebApplicationException {
        return this.getOpInfoDetail(id);
    }

    @GET
    @Path(value="/XML/opInfo/{id}")
    @Produces(value={"application/xml"})
    @Description(value="Returns the operational details of a given entity in XML")
    public OperationalInfo getOpInfoXML(@PathParam(value="id") String id) throws WebApplicationException {
        return this.getOpInfoDetail(id);
    }

    private OperationalInfo getOpInfoDetail(String id) {
        GetOperationalInfo req = new GetOperationalInfo();
        req.getEntityKey().add(id);
        try {
            OperationalInfos operationalInfo = inquiry.getOperationalInfo(req);
            return (OperationalInfo)operationalInfo.getOperationalInfo().get(0);
        }
        catch (DispositionReportFaultMessage ex) {
            UDDIInquiryJAXRS.HandleException((Exception)((Object)ex));
            return null;
        }
    }

    @GET
    @Path(value="/JSON/bindingKey/{id}")
    @Produces(value={"application/json"})
    @Description(value="Returns the binding details of a given entity in JSON")
    public BindingTemplate getBindingDetailJSON(@PathParam(value="id") String id) throws WebApplicationException {
        return this.getBindingDetail(id);
    }

    @GET
    @Path(value="/XML/bindingKey/{id}")
    @Produces(value={"application/xml"})
    @Description(value="Returns the binding details of a given entity in XML")
    public BindingTemplate getBindingDetailXML(@PathParam(value="id") String id) throws WebApplicationException {
        return this.getBindingDetail(id);
    }

    private BindingTemplate getBindingDetail(String id) {
        GetBindingDetail req = new GetBindingDetail();
        req.getBindingKey().add(id);
        try {
            BindingDetail bindingDetail = inquiry.getBindingDetail(req);
            return (BindingTemplate)bindingDetail.getBindingTemplate().get(0);
        }
        catch (DispositionReportFaultMessage ex) {
            UDDIInquiryJAXRS.HandleException((Exception)((Object)ex));
            return null;
        }
    }

    @GET
    @Path(value="/JSON/endpointsByService/{id}")
    @Produces(value={"application/json"})
    @Description(value="Returns the service access points of a given service in JSON")
    public UriContainer geEndpointsByServiceJSON(@PathParam(value="id") String id) throws WebApplicationException {
        return this.getEndpointsByService(id);
    }

    @GET
    @Path(value="/XML/endpointsByService/{id}")
    @Produces(value={"application/xml"})
    @Description(value="Returns the service access points of a given service in XML")
    public UriContainer getEndpointsByServiceXML(@PathParam(value="id") String id) throws WebApplicationException {
        return this.getEndpointsByService(id);
    }

    @GET
    @Path(value="/XML/businessList")
    @Produces(value={"application/xml"})
    @Description(value="Returns the business keys of the first 100 registered businesses in XML")
    public KeyBag getBusinessListXML() throws WebApplicationException {
        return this.getBusinessListData();
    }

    @GET
    @Path(value="/JSON/businessList")
    @Produces(value={"application/json"})
    @Description(value="Returns the business keys of the first 100 registered businesses in JSON")
    public KeyBag getBusinessListJSON() throws WebApplicationException {
        return this.getBusinessListData();
    }

    @GET
    @Path(value="/XML/serviceList")
    @Produces(value={"application/xml"})
    @Description(value="Returns the Service keys of the first 100 registered services in XML")
    public KeyBag getServiceListXML() throws WebApplicationException {
        return this.getServiceListData();
    }

    @GET
    @Path(value="/JSON/serviceList")
    @Produces(value={"application/json"})
    @Description(value="Returns the Service keys of the first 100 registered services in JSON")
    public KeyBag getServiceListJSON() throws WebApplicationException {
        return this.getServiceListData();
    }

    @GET
    @Path(value="/XML/tModelList")
    @Produces(value={"application/xml"})
    @Description(value="Returns the tModel keys of the first 100 registered services in XML")
    public KeyBag getTModelListXML() throws WebApplicationException {
        return this.getTmodelListData();
    }

    @GET
    @Path(value="/XML/businessSearch")
    @Produces(value={"application/xml"})
    @Description(value="Returns the search results for registered businesses in XML")
    public BusinessList getBusinessSearchXML(@QueryParam(value="name") String name, @QueryParam(value="lang") String lang, @QueryParam(value="findQualifiers") String findQualifiers, @QueryParam(value="maxrows") Integer maxrows, @QueryParam(value="offset") Integer offset) throws WebApplicationException {
        return this.getBusinessSearch(name, lang, findQualifiers, maxrows, offset);
    }

    @GET
    @Path(value="/JSON/businessSearch")
    @Produces(value={"application/json"})
    @Description(value="Returns the search results for registered businesses in JSON")
    public BusinessList getBusinessSearchJSON(@QueryParam(value="name") String name, @QueryParam(value="lang") String lang, @QueryParam(value="findQualifiers") String findQualifiers, @QueryParam(value="maxrows") Integer maxrows, @QueryParam(value="offset") Integer offset) throws WebApplicationException {
        return this.getBusinessSearch(name, lang, findQualifiers, maxrows, offset);
    }

    @GET
    @Path(value="/JSON/serviceSearch")
    @Produces(value={"application/json"})
    @Description(value="Returns the search results for registered services in JSON")
    public ServiceList getServiceSearchJSON(@QueryParam(value="name") String name, @QueryParam(value="lang") String lang, @QueryParam(value="findQualifiers") String findQualifiers, @QueryParam(value="maxrows") Integer maxrows, @QueryParam(value="offset") Integer offset) throws WebApplicationException {
        return this.getServiceSearch(name, lang, findQualifiers, maxrows, offset);
    }

    @GET
    @Path(value="/XML/serviceSearch")
    @Produces(value={"application/json"})
    @Description(value="Returns the search results for registered services in XML")
    public ServiceList getServiceSearchXML(@QueryParam(value="name") String name, @QueryParam(value="lang") String lang, @QueryParam(value="findQualifiers") String findQualifiers, @QueryParam(value="maxrows") Integer maxrows, @QueryParam(value="offset") Integer offset) throws WebApplicationException {
        return this.getServiceSearch(name, lang, findQualifiers, maxrows, offset);
    }

    @GET
    @Path(value="/JSON/tModelList")
    @Produces(value={"application/json"})
    @Description(value="Returns the tModel keys of the first 100 registered services in JSON")
    public KeyBag getTModelListJSON() throws WebApplicationException {
        return this.getTmodelListData();
    }

    @GET
    @Path(value="/JSON/searchTModel")
    @Produces(value={"application/json"})
    @Description(value="Returns the search results for registered tModel in JSON")
    public TModelList getTModelSearchJSON(@QueryParam(value="name") String name, @QueryParam(value="lang") String lang, @QueryParam(value="findQualifiers") String findQualifiers, @QueryParam(value="maxrows") Integer maxrows, @QueryParam(value="offset") Integer offset) throws WebApplicationException {
        return this.getTModelSearch(name, lang, findQualifiers, maxrows, offset);
    }

    @GET
    @Path(value="/XML/searchTModel")
    @Produces(value={"application/json"})
    @Description(value="Returns the search results for registered tModel in XML")
    public TModelList getTModelSearchXML(@QueryParam(value="name") String name, @QueryParam(value="lang") String lang, @QueryParam(value="findQualifiers") String findQualifiers, @QueryParam(value="maxrows") Integer maxrows, @QueryParam(value="offset") Integer offset) throws WebApplicationException {
        return this.getTModelSearch(name, lang, findQualifiers, maxrows, offset);
    }

    private UriContainer getEndpointsByService(String id) throws WebApplicationException {
        UriContainer c = new UriContainer();
        ArrayList<String> ret = new ArrayList<String>();
        GetServiceDetail fs = new GetServiceDetail();
        fs.getServiceKey().add(id);
        try {
            ServiceDetail serviceDetail = inquiry.getServiceDetail(fs);
            if (serviceDetail == null || serviceDetail.getBusinessService().isEmpty()) {
                throw new WebApplicationException(400);
            }
            List<String> endpoints = this.GetEndpoints(serviceDetail, null);
            ret.addAll(endpoints);
        }
        catch (DispositionReportFaultMessage ex) {
            UDDIInquiryJAXRS.HandleException((Exception)((Object)ex));
        }
        c.setUriList(ret);
        return c;
    }

    private List<String> GetEndpoints(ServiceDetail serviceDetail, String authInfo) throws DispositionReportFaultMessage {
        ArrayList<String> items = new ArrayList<String>();
        if (serviceDetail == null) {
            return items;
        }
        for (int i = 0; i < serviceDetail.getBusinessService().size(); ++i) {
            if (((BusinessService)serviceDetail.getBusinessService().get(i)).getBindingTemplates() == null) continue;
            for (int k = 0; k < ((BusinessService)serviceDetail.getBusinessService().get(i)).getBindingTemplates().getBindingTemplate().size(); ++k) {
                items.addAll(this.ParseBinding((BindingTemplate)((BusinessService)serviceDetail.getBusinessService().get(i)).getBindingTemplates().getBindingTemplate().get(k), authInfo));
            }
        }
        return items;
    }

    private List<String> GetBindingInfo(String value, String cred) throws DispositionReportFaultMessage {
        ArrayList<String> items = new ArrayList<String>();
        if (value == null) {
            return items;
        }
        GetBindingDetail b = new GetBindingDetail();
        b.setAuthInfo(cred);
        b.getBindingKey().add(value);
        BindingDetail bindingDetail = inquiry.getBindingDetail(b);
        for (int i = 0; i < bindingDetail.getBindingTemplate().size(); ++i) {
            items.addAll(this.ParseBinding((BindingTemplate)bindingDetail.getBindingTemplate().get(i), cred));
        }
        return items;
    }

    private List<String> FetchWSDL(String value) {
        ArrayList<String> items = new ArrayList<String>();
        if (value.startsWith("http://") || value.startsWith("https://")) {
            ReadWSDL r = new ReadWSDL();
            r.setIgnoreSSLErrors(true);
            try {
                Definition wsdlDefinition = r.readWSDL(new URL(value));
                Properties properties = new Properties();
                properties.put("keyDomain", "domain");
                properties.put("businessName", "biz");
                properties.put("serverName", "localhost");
                properties.put("serverPort", "80");
                WSDL2UDDI wsdl2UDDI = new WSDL2UDDI(null, (URLLocalizer)new URLLocalizerDefaultImpl(), properties);
                BusinessServices businessServices = wsdl2UDDI.createBusinessServices(wsdlDefinition);
                for (int i = 0; i < businessServices.getBusinessService().size(); ++i) {
                    if (((BusinessService)businessServices.getBusinessService().get(i)).getBindingTemplates() == null) continue;
                    for (int k = 0; k < ((BusinessService)businessServices.getBusinessService().get(i)).getBindingTemplates().getBindingTemplate().size(); ++k) {
                        items.addAll(this.ParseBinding((BindingTemplate)((BusinessService)businessServices.getBusinessService().get(i)).getBindingTemplates().getBindingTemplate().get(k), null));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return items;
    }

    private List<String> ParseBinding(BindingTemplate get, String authInfo) throws DispositionReportFaultMessage {
        ArrayList<String> items = new ArrayList<String>();
        if (get == null || get.getAccessPoint() == null) {
            return items;
        }
        if (get.getHostingRedirector() != null) {
            items.addAll(this.GetBindingInfo(get.getHostingRedirector().getBindingKey(), authInfo));
        }
        if (get.getAccessPoint() != null) {
            String usetype = get.getAccessPoint().getUseType();
            if (usetype == null) {
                items.add(get.getAccessPoint().getValue());
            } else if (usetype.equalsIgnoreCase(AccessPointType.BINDING_TEMPLATE.toString())) {
                items.addAll(this.GetBindingInfo(get.getAccessPoint().getValue(), authInfo));
            } else if (usetype.equalsIgnoreCase(AccessPointType.HOSTING_REDIRECTOR.toString())) {
                items.addAll(this.GetBindingInfo(get.getAccessPoint().getValue(), authInfo));
            } else if (usetype.equalsIgnoreCase(AccessPointType.WSDL_DEPLOYMENT.toString())) {
                items.addAll(this.FetchWSDL(get.getAccessPoint().getValue()));
            } else if (usetype.equalsIgnoreCase(AccessPointType.END_POINT.toString())) {
                items.add(get.getAccessPoint().getValue());
            } else {
                items.add(get.getAccessPoint().getValue());
            }
        }
        return items;
    }

    private static void HandleException(Exception ex) throws WebApplicationException {
        if (ex == null) {
            throw new WebApplicationException(500);
        }
        log.error((Object)ex.getMessage());
        log.debug((Object)ex);
        if (ex instanceof DispositionReportFaultMessage) {
            DispositionReportFaultMessage dr = (DispositionReportFaultMessage)((Object)ex);
            if (dr.getFaultInfo() == null) {
                throw new WebApplicationException(500);
            }
            if (dr.getFaultInfo().countainsErrorCode(UDDIErrorHelper.lookupErrCode((int)10110))) {
                throw new WebApplicationException((Throwable)ex, 401);
            }
            if (dr.getFaultInfo().countainsErrorCode(UDDIErrorHelper.lookupErrCode((int)10120))) {
                throw new WebApplicationException((Throwable)ex, 401);
            }
            if (dr.getFaultInfo().countainsErrorCode(UDDIErrorHelper.lookupErrCode((int)10500))) {
                throw new WebApplicationException((Throwable)ex, 500);
            }
        }
        throw new WebApplicationException((Throwable)ex, 400);
    }

    private KeyBag getBusinessListData() {
        FindBusiness fb = new FindBusiness();
        fb.getName().add(new Name("%", null));
        fb.setFindQualifiers(new FindQualifiers());
        fb.getFindQualifiers().getFindQualifier().add("approximateMatch");
        fb.setMaxRows(Integer.valueOf(100));
        BusinessList findBusiness = null;
        try {
            findBusiness = inquiry.findBusiness(fb);
        }
        catch (Exception ex) {
            UDDIInquiryJAXRS.HandleException(ex);
        }
        KeyBag kb = new KeyBag();
        if (findBusiness != null && findBusiness.getBusinessInfos() != null) {
            for (int i = 0; i < findBusiness.getBusinessInfos().getBusinessInfo().size(); ++i) {
                kb.getBusinessKey().add(((BusinessInfo)findBusiness.getBusinessInfos().getBusinessInfo().get(i)).getBusinessKey());
            }
        }
        return kb;
    }

    private KeyBag getServiceListData() {
        FindService fb = new FindService();
        fb.getName().add(new Name("%", null));
        fb.setFindQualifiers(new FindQualifiers());
        fb.getFindQualifiers().getFindQualifier().add("approximateMatch");
        fb.setMaxRows(Integer.valueOf(100));
        ServiceList findBusiness = null;
        try {
            findBusiness = inquiry.findService(fb);
        }
        catch (Exception ex) {
            UDDIInquiryJAXRS.HandleException(ex);
        }
        KeyBag kb = new KeyBag();
        if (findBusiness != null && findBusiness.getServiceInfos() != null) {
            for (int i = 0; i < findBusiness.getServiceInfos().getServiceInfo().size(); ++i) {
                kb.getServiceKey().add(((ServiceInfo)findBusiness.getServiceInfos().getServiceInfo().get(i)).getServiceKey());
            }
        }
        return kb;
    }

    private KeyBag getTmodelListData() {
        FindTModel fb = new FindTModel();
        fb.setName(new Name("%", null));
        fb.setFindQualifiers(new FindQualifiers());
        fb.getFindQualifiers().getFindQualifier().add("approximateMatch");
        fb.setMaxRows(Integer.valueOf(100));
        TModelList findBusiness = null;
        try {
            findBusiness = inquiry.findTModel(fb);
        }
        catch (Exception ex) {
            UDDIInquiryJAXRS.HandleException(ex);
        }
        KeyBag kb = new KeyBag();
        if (findBusiness != null && findBusiness.getTModelInfos() != null) {
            for (int i = 0; i < findBusiness.getTModelInfos().getTModelInfo().size(); ++i) {
                kb.getTModelKey().add(((TModelInfo)findBusiness.getTModelInfos().getTModelInfo().get(i)).getTModelKey());
            }
        }
        return kb;
    }

    private BusinessList getBusinessSearch(String name, String lang, String findQualifiers, Integer maxrows, Integer offset) {
        FindBusiness fb = new FindBusiness();
        fb.getName().add(new Name("%", null));
        if (name != null) {
            ((Name)fb.getName().get(0)).setValue(name);
        }
        if (lang != null) {
            ((Name)fb.getName().get(0)).setValue(lang);
        }
        fb.setFindQualifiers(new FindQualifiers());
        if (findQualifiers == null) {
            fb.getFindQualifiers().getFindQualifier().add("approximateMatch");
        } else {
            String[] fqs = findQualifiers.split(",");
            fb.getFindQualifiers().getFindQualifier().addAll(Arrays.asList(fqs));
        }
        fb.setMaxRows(Integer.valueOf(100));
        if (maxrows != null) {
            fb.setMaxRows(maxrows);
        }
        fb.setListHead(Integer.valueOf(0));
        if (offset != null) {
            fb.setListHead(offset);
        }
        BusinessList findBusiness = null;
        try {
            findBusiness = inquiry.findBusiness(fb);
        }
        catch (Exception ex) {
            UDDIInquiryJAXRS.HandleException(ex);
        }
        return findBusiness;
    }

    private ServiceList getServiceSearch(String name, String lang, String findQualifiers, Integer maxrows, Integer offset) {
        FindService fb = new FindService();
        fb.getName().add(new Name("%", null));
        if (name != null) {
            ((Name)fb.getName().get(0)).setValue(name);
        }
        if (lang != null) {
            ((Name)fb.getName().get(0)).setValue(lang);
        }
        fb.setFindQualifiers(new FindQualifiers());
        if (findQualifiers == null) {
            fb.getFindQualifiers().getFindQualifier().add("approximateMatch");
        } else {
            String[] fqs = findQualifiers.split(",");
            fb.getFindQualifiers().getFindQualifier().addAll(Arrays.asList(fqs));
        }
        fb.setMaxRows(Integer.valueOf(100));
        if (maxrows != null) {
            fb.setMaxRows(maxrows);
        }
        fb.setListHead(Integer.valueOf(0));
        if (offset != null) {
            fb.setListHead(offset);
        }
        ServiceList findBusiness = null;
        try {
            findBusiness = inquiry.findService(fb);
        }
        catch (Exception ex) {
            UDDIInquiryJAXRS.HandleException(ex);
        }
        return findBusiness;
    }

    private TModelList getTModelSearch(String name, String lang, String findQualifiers, Integer maxrows, Integer offset) {
        FindTModel fb = new FindTModel();
        fb.setName(new Name("%", null));
        if (name != null) {
            fb.getName().setValue(name);
        }
        if (lang != null) {
            fb.getName().setValue(lang);
        }
        fb.setFindQualifiers(new FindQualifiers());
        if (findQualifiers == null) {
            fb.getFindQualifiers().getFindQualifier().add("approximateMatch");
        } else {
            String[] fqs = findQualifiers.split(",");
            fb.getFindQualifiers().getFindQualifier().addAll(Arrays.asList(fqs));
        }
        fb.setMaxRows(Integer.valueOf(100));
        if (maxrows != null) {
            fb.setMaxRows(maxrows);
        }
        fb.setListHead(Integer.valueOf(0));
        if (offset != null) {
            fb.setListHead(offset);
        }
        TModelList findBusiness = null;
        try {
            findBusiness = inquiry.findTModel(fb);
        }
        catch (Exception ex) {
            UDDIInquiryJAXRS.HandleException(ex);
        }
        return findBusiness;
    }
}

