/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.api.impl;

import java.util.Date;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.model.AuthToken;
import org.apache.juddi.model.UddiEntityPublisher;
import org.apache.juddi.v3.auth.Authenticator;
import org.apache.juddi.v3.auth.AuthenticatorFactory;
import org.apache.juddi.v3.error.AuthTokenExpiredException;
import org.apache.juddi.v3.error.AuthTokenRequiredException;
import org.apache.juddi.v3.error.ErrorMessage;
import org.uddi.v3_service.DispositionReportFaultMessage;

public abstract class AuthenticatedService {
    public static final String UTF8 = "UTF-8";
    public static final int AUTHTOKEN_ACTIVE = 1;
    public static final int AUTHTOKEN_RETIRED = 0;
    static final Log logger = LogFactory.getLog(AuthenticatedService.class);
    private String node = "UNDEFINED_NODE_NAME";
    protected String baseUrlSSL = "UNDEFINED";
    protected String baseUrl = "UNDEFINED";
    protected DatatypeFactory df = null;
    @Resource
    protected WebServiceContext ctx;

    public String getNode() {
        return this.node;
    }

    public AuthenticatedService() {
        try {
            this.node = AppConfig.getConfiguration().getString("juddi.nodeId", "UNDEFINED_NODE_NAME");
            this.node = this.node.trim();
            this.baseUrlSSL = AppConfig.getConfiguration().getString("juddi.server.baseurlsecure", "https://localhost:8443/juddiv3");
            this.baseUrlSSL = this.baseUrlSSL.trim();
        }
        catch (ConfigurationException ex) {
            logger.fatal(null, (Throwable)ex);
        }
        this.init();
    }

    public void setContext(WebServiceContext ctx) {
        this.ctx = ctx;
    }

    private synchronized void init() {
        try {
            this.df = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException ex) {
            logger.fatal(null, (Throwable)ex);
        }
    }

    public UddiEntityPublisher getEntityPublisher(EntityManager em, String authInfo) throws DispositionReportFaultMessage {
        boolean useAuthInfo = true;
        try {
            useAuthInfo = AppConfig.getConfiguration().getBoolean("juddi.auth.authenticator[@useAuthToken]", true);
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        if (useAuthInfo) {
            Authenticator authenticator;
            UddiEntityPublisher entityPublisher;
            if (authInfo == null || authInfo.length() == 0) {
                throw new AuthTokenRequiredException(new ErrorMessage("errors.auth.AuthRequired"));
            }
            AuthToken modelAuthToken = (AuthToken)em.find(AuthToken.class, (Object)authInfo);
            if (modelAuthToken == null) {
                throw new AuthTokenRequiredException(new ErrorMessage("errors.auth.AuthInvalid"));
            }
            int allowedMinutesOfInactivity = 0;
            try {
                allowedMinutesOfInactivity = AppConfig.getConfiguration().getInt("juddi.auth.token.Timeout", 0);
            }
            catch (ConfigurationException ce) {
                logger.error((Object)("Error reading property juddi.auth.token.Expiration from the application's configuration. No automatic timeout token invalidation will occur. " + ce.getMessage()), (Throwable)ce);
            }
            int maxMinutesOfAge = 0;
            try {
                maxMinutesOfAge = AppConfig.getConfiguration().getInt("juddi.auth.token.Expiration", 0);
            }
            catch (ConfigurationException ce) {
                logger.error((Object)("Error reading property juddi.auth.token.Expiration from the application's configuration. No automatic timeout token invalidation will occur. " + ce.getMessage()), (Throwable)ce);
            }
            Date now = new Date();
            if (allowedMinutesOfInactivity > 0 && now.getTime() > modelAuthToken.getLastUsed().getTime() + (long)allowedMinutesOfInactivity * 60000L) {
                logger.info((Object)("AUDIT: FAILTURE Token " + modelAuthToken.getAuthToken() + " expired due to inactivity " + this.getRequestorsIPAddress()));
                modelAuthToken.setTokenState(0);
            }
            if (maxMinutesOfAge > 0 && now.getTime() > modelAuthToken.getCreated().getTime() + (long)maxMinutesOfAge * 60000L) {
                logger.info((Object)("AUDIT: FAILURE - Token " + modelAuthToken.getAuthorizedName() + " expired due to old age " + this.getRequestorsIPAddress()));
                modelAuthToken.setTokenState(0);
            }
            if (modelAuthToken.getTokenState() == 0) {
                throw new AuthTokenExpiredException(new ErrorMessage("errors.auth.AuthTokenExpired"));
            }
            if (this.ctx != null) {
                try {
                    boolean check = true;
                    try {
                        check = AppConfig.getConfiguration().getBoolean("juddi.auth.token.enforceSameIPRule", true);
                    }
                    catch (ConfigurationException ex) {
                        logger.warn((Object)"Error loading config property juddi.auth.token.enforceSameIPRule Enforcing Same IP for Auth Tokens will be enabled by default", (Throwable)ex);
                    }
                    if (check) {
                        MessageContext mc = this.ctx.getMessageContext();
                        HttpServletRequest req = null;
                        if (mc != null) {
                            req = (HttpServletRequest)mc.get((Object)"javax.xml.ws.servlet.request");
                        }
                        if (req != null && req.getRemoteAddr() != null && modelAuthToken.getIPAddress() != null && !modelAuthToken.getIPAddress().equalsIgnoreCase(req.getRemoteAddr())) {
                            modelAuthToken.setTokenState(0);
                            logger.error((Object)("AUDIT FAILURE - Security Alert - Attempt to use issued auth token from a different IP address, user " + modelAuthToken.getAuthorizedName() + ", issued IP " + modelAuthToken.getIPAddress() + ", attempted use from " + req.getRemoteAddr() + ", forcing reauthentication."));
                            throw new AuthTokenRequiredException(new ErrorMessage("errors.auth.AuthInvalid"));
                        }
                    }
                }
                catch (Exception ex) {
                    if (ex instanceof AuthTokenRequiredException) {
                        throw (AuthTokenRequiredException)((Object)ex);
                    }
                    logger.error((Object)"unexpected error caught looking up requestor's ip address", (Throwable)ex);
                }
            }
            if ((entityPublisher = (authenticator = AuthenticatorFactory.getAuthenticator()).identify(authInfo, modelAuthToken.getAuthorizedName(), this.ctx)) == null) {
                logger.warn((Object)("AUDIT FAILURE - Auth token invalid, publisher does not exist " + this.getRequestorsIPAddress()));
                throw new AuthTokenRequiredException(new ErrorMessage("errors.auth.AuthInvalid"));
            }
            if (entityPublisher.getAuthorizedName() == null) {
                logger.warn((Object)("AUDIT FAILURE - Auth token invalid, username does exist" + this.getRequestorsIPAddress()));
                throw new AuthTokenRequiredException(new ErrorMessage("errors.auth.AuthInvalid"));
            }
            modelAuthToken.setLastUsed(new Date());
            modelAuthToken.setNumberOfUses(modelAuthToken.getNumberOfUses() + 1);
            return entityPublisher;
        }
        Authenticator authenticator = AuthenticatorFactory.getAuthenticator();
        UddiEntityPublisher entityPublisher = authenticator.identify(null, null, this.ctx);
        if (entityPublisher == null) {
            logger.warn((Object)("AUDIT FAILURE - Auth token invalid, publisher does not exist " + this.getRequestorsIPAddress()));
            throw new AuthTokenRequiredException(new ErrorMessage("errors.auth.AuthInvalid"));
        }
        if (entityPublisher.getAuthorizedName() == null) {
            logger.warn((Object)("AUDIT FAILURE - Auth token invalid, username does exist" + this.getRequestorsIPAddress()));
            throw new AuthTokenRequiredException(new ErrorMessage("errors.auth.AuthInvalid"));
        }
        return entityPublisher;
    }

    public String getRequestorsIPAddress() {
        try {
            MessageContext mc = this.ctx.getMessageContext();
            HttpServletRequest req = null;
            if (mc != null) {
                req = (HttpServletRequest)mc.get((Object)"javax.xml.ws.servlet.request");
            }
            if (req != null) {
                return req.getRemoteAddr();
            }
        }
        catch (Exception ex) {
            logger.debug((Object)"Error caught looking up the requestor's ip address", (Throwable)ex);
        }
        return null;
    }
}

