/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.api.impl;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jws.WebService;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.api.impl.AuthenticatedService;
import org.apache.juddi.api.impl.ServiceCounterLifecycleResource;
import org.apache.juddi.api.impl.UDDIServiceCounter;
import org.apache.juddi.api.util.CustodyTransferQuery;
import org.apache.juddi.api.util.QueryStatus;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.config.PersistenceManager;
import org.apache.juddi.mapping.MappingApiToModel;
import org.apache.juddi.mapping.MappingModelToApi;
import org.apache.juddi.model.BindingTemplate;
import org.apache.juddi.model.BusinessEntity;
import org.apache.juddi.model.BusinessService;
import org.apache.juddi.model.Operator;
import org.apache.juddi.model.ReplicationConfiguration;
import org.apache.juddi.model.Tmodel;
import org.apache.juddi.model.TransferTokenKey;
import org.apache.juddi.model.UddiEntity;
import org.apache.juddi.model.UddiEntityPublisher;
import org.apache.juddi.query.util.DynamicQuery;
import org.apache.juddi.replication.ReplicationNotifier;
import org.apache.juddi.v3.client.UDDIService;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.FatalErrorException;
import org.apache.juddi.v3.error.InvalidValueException;
import org.apache.juddi.v3.error.TransferNotAllowedException;
import org.apache.juddi.validation.ValidateCustodyTransfer;
import org.uddi.api_v3.OperationalInfo;
import org.uddi.api_v3.TModel;
import org.uddi.custody_v3.DiscardTransferToken;
import org.uddi.custody_v3.KeyBag;
import org.uddi.custody_v3.TransferEntities;
import org.uddi.custody_v3.TransferOperationalInfo;
import org.uddi.custody_v3.TransferToken;
import org.uddi.repl_v3.ChangeRecord;
import org.uddi.repl_v3.ChangeRecordIDType;
import org.uddi.repl_v3.ChangeRecordNewData;
import org.uddi.repl_v3.TransferCustody;
import org.uddi.v3_service.DispositionReportFaultMessage;
import org.uddi.v3_service.UDDICustodyTransferPortType;
import org.uddi.v3_service.UDDIReplicationPortType;

@WebService(serviceName="UDDICustodyTransferService", endpointInterface="org.uddi.v3_service.UDDICustodyTransferPortType", targetNamespace="urn:uddi-org:v3_service")
public class UDDICustodyTransferImpl
extends AuthenticatedService
implements UDDICustodyTransferPortType {
    public static final String TRANSFER_TOKEN_PREFIX = "transfertoken:";
    public static final int DEFAULT_TRANSFEREXPIRATION_DAYS = 3;
    private static Log logger = LogFactory.getLog(UDDICustodyTransferImpl.class);
    private static DatatypeFactory df = null;
    private UDDIServiceCounter serviceCounter = ServiceCounterLifecycleResource.getServiceCounter(this.getClass());

    public UDDICustodyTransferImpl() {
        UDDICustodyTransferImpl.init();
    }

    private static synchronized void init() {
        if (df == null) {
            try {
                df = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException ex) {
                Logger.getLogger(UDDICustodyTransferImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discardTransferToken(DiscardTransferToken body) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            KeyBag keyBag;
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidateCustodyTransfer(publisher).validateDiscardTransferToken(em, body);
            TransferToken apiTransferToken = body.getTransferToken();
            if (apiTransferToken != null) {
                String transferTokenId;
                try {
                    transferTokenId = new String(apiTransferToken.getOpaqueToken(), "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    throw new InvalidValueException(new ErrorMessage("errors.stringEncoding"));
                }
                org.apache.juddi.model.TransferToken modelTransferToken = (org.apache.juddi.model.TransferToken)em.find(org.apache.juddi.model.TransferToken.class, (Object)transferTokenId);
                if (modelTransferToken != null) {
                    em.remove((Object)modelTransferToken);
                }
            }
            if ((keyBag = body.getKeyBag()) != null) {
                List keyList = keyBag.getKey();
                Vector<DynamicQuery.Parameter> params = new Vector<DynamicQuery.Parameter>(0);
                for (String key : keyList) {
                    DynamicQuery.Parameter param = new DynamicQuery.Parameter("UPPER(ttk.entityKey)", key.toUpperCase(), "=");
                    params.add(param);
                }
                DynamicQuery getTokensQry = new DynamicQuery();
                getTokensQry.append("select distinct ttk.transferToken from TransferTokenKey ttk").pad();
                getTokensQry.WHERE().pad().appendGroupedOr(params.toArray(new DynamicQuery.Parameter[0]));
                Query qry = getTokensQry.buildJPAQuery(em);
                List tokensToDelete = qry.getResultList();
                if (tokensToDelete != null && tokensToDelete.size() > 0) {
                    for (org.apache.juddi.model.TransferToken tt : tokensToDelete) {
                        em.remove((Object)tt);
                    }
                }
            }
            tx.commit();
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(CustodyTransferQuery.DISCARD_TRANSFERTOKEN, QueryStatus.SUCCESS, procTime);
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getTransferToken(String authInfo, KeyBag keyBag, Holder<String> nodeID, Holder<XMLGregorianCalendar> expirationTime, Holder<byte[]> opaqueToken) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, authInfo);
            new ValidateCustodyTransfer(publisher).validateGetTransferToken(em, keyBag);
            int transferExpirationDays = 3;
            try {
                transferExpirationDays = AppConfig.getConfiguration().getInt("juddi.transfer.expiration.days");
                nodeID.value = AppConfig.getConfiguration().getString("juddi.nodeId");
            }
            catch (ConfigurationException ce) {
                throw new FatalErrorException(new ErrorMessage("errors.configuration.Retrieval"));
            }
            String transferKey = TRANSFER_TOKEN_PREFIX + UUID.randomUUID();
            org.apache.juddi.model.TransferToken transferToken = new org.apache.juddi.model.TransferToken();
            transferToken.setTransferToken(transferKey);
            try {
                opaqueToken.value = transferKey.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new InvalidValueException(new ErrorMessage("errors.stringEncoding"));
            }
            GregorianCalendar gc = new GregorianCalendar();
            gc.add(5, transferExpirationDays);
            transferToken.setExpirationDate(gc.getTime());
            try {
                DatatypeFactory df = DatatypeFactory.newInstance();
                expirationTime.value = df.newXMLGregorianCalendar(gc);
            }
            catch (DatatypeConfigurationException ce) {
                throw new FatalErrorException(new ErrorMessage("errors.Unspecified"));
            }
            List keyList = keyBag.getKey();
            for (String key : keyList) {
                TransferTokenKey tokenKey = new TransferTokenKey(transferToken, key);
                transferToken.getTransferKeys().add(tokenKey);
            }
            em.persist((Object)transferToken);
            tx.commit();
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(CustodyTransferQuery.GET_TRANSFERTOKEN, QueryStatus.SUCCESS, procTime);
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferEntities(TransferEntities body) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        ArrayList<ChangeRecord> changes = new ArrayList<ChangeRecord>();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            ValidateCustodyTransfer verifier = new ValidateCustodyTransfer(publisher);
            if (!verifier.validateTransferEntities(em, body)) {
                Object sourceNode = null;
                try {
                    KeyBag keyBag = body.getKeyBag();
                    List keyList = keyBag.getKey();
                    for (String key : keyList) {
                        UddiEntity uddiEntity = (UddiEntity)em.find(UddiEntity.class, (Object)key);
                        if (uddiEntity != null) {
                            uddiEntity.setIsTransferInProgress(true);
                            sourceNode = uddiEntity.getNodeId();
                            em.merge((Object)uddiEntity);
                            continue;
                        }
                        logger.warn((Object)("couldn't find a record for key " + key));
                    }
                    if (sourceNode == null) {
                        logger.warn((Object)"unable to process transfer, could not locate the source node, perhaps it hasn't been replicated to this node yet?");
                        throw new Exception("unable to process transfer, could not locate the source node for any of the specific keys, perhaps it hasn't been replicated to this node yet?");
                    }
                    UDDIReplicationPortType replicationClient = this.getReplicationClient((String)sourceNode);
                    if (replicationClient == null) {
                        throw new Exception("Unknown node. is it in the replication graph?" + sourceNode);
                    }
                    TransferCustody transferCustody = new TransferCustody();
                    transferCustody.setTransferToken(body.getTransferToken());
                    transferCustody.setKeyBag(body.getKeyBag());
                    transferCustody.setTransferOperationalInfo(new TransferOperationalInfo());
                    transferCustody.getTransferOperationalInfo().setAuthorizedName(publisher.getAuthorizedName());
                    transferCustody.getTransferOperationalInfo().setNodeID(this.getNode());
                    logger.info((Object)("AUDIT, transfering " + transferCustody.getKeyBag().getKey().size() + " entities to " + publisher.getAuthorizedName() + " at node " + this.getNode() + " from source " + (String)sourceNode));
                    replicationClient.transferCustody(transferCustody);
                }
                catch (DispositionReportFaultMessage df) {
                    logger.error((Object)("Unable to transfer entities from " + sourceNode + " to node " + this.getNode() + " to user " + publisher.getAuthorizedName()), (Throwable)df);
                    throw new TransferNotAllowedException(new ErrorMessage("E_transferBlocked", df.getMessage()));
                }
                catch (Exception ex) {
                    logger.error((Object)("Unable to transfer entities from " + sourceNode + " to node " + this.getNode() + " to user " + publisher.getAuthorizedName()), (Throwable)ex);
                    throw new TransferNotAllowedException(new ErrorMessage("E_transferBlocked", ex.getMessage()));
                }
            } else {
                changes.addAll(this.executeTransfer(body, em, publisher.getAuthorizedName(), this.getNode()));
            }
            tx.commit();
            for (ChangeRecord c : changes) {
                try {
                    c.setChangeID(new ChangeRecordIDType());
                    c.getChangeID().setNodeID(this.getNode());
                    c.getChangeID().setOriginatingUSN(null);
                    ReplicationNotifier.enqueue(MappingApiToModel.mapChangeRecord(c));
                }
                catch (UnsupportedEncodingException ex) {
                    logger.error((Object)"", (Throwable)ex);
                }
            }
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(CustodyTransferQuery.TRANSFER_ENTITIES, QueryStatus.SUCCESS, procTime);
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized UDDIReplicationPortType getReplicationClient(String node) {
        UDDIService svc = new UDDIService();
        UDDIReplicationPortType replicationClient = svc.getUDDIReplicationPort();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            StringBuilder sql = new StringBuilder();
            sql.append("select c from ReplicationConfiguration c order by c.serialNumber desc");
            sql.toString();
            Query qry = em.createQuery(sql.toString());
            qry.setMaxResults(1);
            ReplicationConfiguration resultList = (ReplicationConfiguration)qry.getSingleResult();
            for (Operator o : resultList.getOperator()) {
                if (!o.getOperatorNodeID().equalsIgnoreCase(node)) continue;
                ((BindingProvider)replicationClient).getRequestContext().put("javax.xml.ws.service.endpoint.address", o.getSoapReplicationURL());
                UDDIReplicationPortType uDDIReplicationPortType = replicationClient;
                return uDDIReplicationPortType;
            }
            tx.rollback();
        }
        catch (Exception ex) {
            logger.fatal((Object)("Node not found (or there isn't a replication config)!" + node), (Throwable)ex);
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
        return null;
    }

    protected List<ChangeRecord> executeTransfer(TransferEntities body, EntityManager em, String transferToPublisher, String transferToNode) throws DispositionReportFaultMessage {
        String transferTokenId;
        ArrayList<ChangeRecord> changes = new ArrayList<ChangeRecord>();
        KeyBag keyBag = body.getKeyBag();
        List keyList = keyBag.getKey();
        for (String key : keyList) {
            UddiEntity uddiEntity = (UddiEntity)em.find(UddiEntity.class, (Object)key);
            uddiEntity.setAuthorizedName(transferToPublisher);
            uddiEntity.setNodeId(transferToNode);
            Date now = new Date();
            uddiEntity.setModified(now);
            uddiEntity.setModifiedIncludingChildren(now);
            if (uddiEntity instanceof BusinessEntity) {
                BusinessEntity be = (BusinessEntity)uddiEntity;
                List<BusinessService> bsList = be.getBusinessServices();
                for (BusinessService bs : bsList) {
                    bs.setAuthorizedName(transferToPublisher);
                    bs.setNodeId(transferToNode);
                    bs.setModified(now);
                    bs.setModifiedIncludingChildren(now);
                    List<BindingTemplate> btList = bs.getBindingTemplates();
                    for (BindingTemplate bt : btList) {
                        bt.setAuthorizedName(transferToPublisher);
                        bt.setNodeId(transferToNode);
                        bt.setModified(now);
                        bt.setModifiedIncludingChildren(now);
                    }
                }
            }
            ChangeRecord cr = new ChangeRecord();
            cr.setChangeRecordNewData(new ChangeRecordNewData());
            cr.getChangeRecordNewData().setOperationalInfo(new OperationalInfo());
            cr.getChangeRecordNewData().getOperationalInfo().setAuthorizedName(transferToPublisher);
            cr.getChangeRecordNewData().getOperationalInfo().setEntityKey(uddiEntity.getEntityKey());
            cr.getChangeRecordNewData().getOperationalInfo().setNodeID(transferToNode);
            GregorianCalendar gcal = new GregorianCalendar();
            gcal.setTime(uddiEntity.getCreated());
            cr.getChangeRecordNewData().getOperationalInfo().setCreated(df.newXMLGregorianCalendar(gcal));
            gcal = new GregorianCalendar();
            gcal.setTime(now);
            cr.getChangeRecordNewData().getOperationalInfo().setModified(df.newXMLGregorianCalendar(gcal));
            cr.getChangeRecordNewData().getOperationalInfo().setModifiedIncludingChildren(df.newXMLGregorianCalendar(gcal));
            cr.getChangeRecordNewData().getOperationalInfo().setEntityKey(uddiEntity.getEntityKey());
            if (uddiEntity instanceof BusinessEntity) {
                cr.getChangeRecordNewData().setBusinessEntity(new org.uddi.api_v3.BusinessEntity());
                MappingModelToApi.mapBusinessEntity((BusinessEntity)uddiEntity, cr.getChangeRecordNewData().getBusinessEntity());
            }
            if (uddiEntity instanceof Tmodel) {
                cr.getChangeRecordNewData().setTModel(new TModel());
                MappingModelToApi.mapTModel((Tmodel)uddiEntity, cr.getChangeRecordNewData().getTModel());
            }
            changes.add(cr);
            em.persist((Object)uddiEntity);
        }
        TransferToken apiTransferToken = body.getTransferToken();
        try {
            transferTokenId = new String(apiTransferToken.getOpaqueToken(), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new InvalidValueException(new ErrorMessage("errors.stringEncoding"));
        }
        org.apache.juddi.model.TransferToken modelTransferToken = (org.apache.juddi.model.TransferToken)em.find(org.apache.juddi.model.TransferToken.class, (Object)transferTokenId);
        em.remove((Object)modelTransferToken);
        return changes;
    }
}

