/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.api.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import javax.jws.WebService;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.xml.bind.JAXB;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.api.impl.AuthenticatedService;
import org.apache.juddi.api.impl.InquiryHelper;
import org.apache.juddi.api.impl.ServiceCounterLifecycleResource;
import org.apache.juddi.api.impl.UDDIServiceCounter;
import org.apache.juddi.api.util.InquiryQuery;
import org.apache.juddi.api.util.QueryStatus;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.config.PersistenceManager;
import org.apache.juddi.mapping.MappingModelToApi;
import org.apache.juddi.model.BindingTemplate;
import org.apache.juddi.model.BusinessEntity;
import org.apache.juddi.model.BusinessService;
import org.apache.juddi.model.Tmodel;
import org.apache.juddi.model.UddiEntity;
import org.apache.juddi.query.util.FindQualifiers;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.InvalidKeyPassedException;
import org.apache.juddi.validation.ValidateInquiry;
import org.uddi.api_v3.BindingDetail;
import org.uddi.api_v3.BusinessDetail;
import org.uddi.api_v3.BusinessList;
import org.uddi.api_v3.FindBinding;
import org.uddi.api_v3.FindBusiness;
import org.uddi.api_v3.FindRelatedBusinesses;
import org.uddi.api_v3.FindService;
import org.uddi.api_v3.FindTModel;
import org.uddi.api_v3.GetBindingDetail;
import org.uddi.api_v3.GetBusinessDetail;
import org.uddi.api_v3.GetOperationalInfo;
import org.uddi.api_v3.GetServiceDetail;
import org.uddi.api_v3.GetTModelDetail;
import org.uddi.api_v3.OperationalInfo;
import org.uddi.api_v3.OperationalInfos;
import org.uddi.api_v3.RelatedBusinessesList;
import org.uddi.api_v3.ServiceDetail;
import org.uddi.api_v3.ServiceList;
import org.uddi.api_v3.TModel;
import org.uddi.api_v3.TModelDetail;
import org.uddi.api_v3.TModelList;
import org.uddi.v3_service.DispositionReportFaultMessage;
import org.uddi.v3_service.UDDIInquiryPortType;

@WebService(serviceName="UDDIInquiryService", endpointInterface="org.uddi.v3_service.UDDIInquiryPortType", targetNamespace="urn:uddi-org:api_v3_portType")
public class UDDIInquiryImpl
extends AuthenticatedService
implements UDDIInquiryPortType {
    private static Log log = LogFactory.getLog(UDDIInquiryImpl.class);
    private UDDIServiceCounter serviceCounter = ServiceCounterLifecycleResource.getServiceCounter(UDDIInquiryImpl.class);

    private static boolean isLogRequestPayloads() {
        boolean result = false;
        try {
            result = AppConfig.getConfiguration().getBoolean("juddi.logging.logInquirySearchPayloads", false);
        }
        catch (ConfigurationException e) {
            log.error((Object)"Configuration exception occurred retrieving: juddi.logging.logInquirySearchPayloads", (Throwable)e);
        }
        return result;
    }

    private static void LogFindRelatedBusinessRequest(FindRelatedBusinesses request) {
        request.setAuthInfo(null);
        UDDIInquiryImpl.LogRequest(request);
    }

    private static void LogFindBindingRequest(FindBinding request) {
        request.setAuthInfo(null);
        UDDIInquiryImpl.LogRequest(request);
    }

    private static void LogFindTModelRequest(FindTModel request) {
        request.setAuthInfo(null);
        UDDIInquiryImpl.LogRequest(request);
    }

    private static void LogFindServiceRequest(FindService request) {
        request.setAuthInfo(null);
        UDDIInquiryImpl.LogRequest(request);
    }

    private static void LogFindBusinessRequest(FindBusiness request) {
        request.setAuthInfo(null);
        UDDIInquiryImpl.LogRequest(request);
    }

    private static synchronized void LogRequest(Object request) {
        if (UDDIInquiryImpl.isLogRequestPayloads()) {
            try {
                File f = new File(System.currentTimeMillis() + ".xml");
                FileOutputStream fos = new FileOutputStream(f);
                JAXB.marshal((Object)request, (OutputStream)fos);
                fos.close();
                f = null;
            }
            catch (Exception ex) {
                logger.warn((Object)"Unable to log request payload", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BindingDetail findBinding(FindBinding body) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        try {
            new ValidateInquiry(null).validateFindBinding(body);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(InquiryQuery.FIND_BINDING, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            if (this.isAuthenticated()) {
                this.getEntityPublisher(em, body.getAuthInfo());
            }
            UDDIInquiryImpl.LogFindBindingRequest(body);
            if (body.getServiceKey() != null && body.getServiceKey().length() > 0) {
                String serviceKey = body.getServiceKey();
                BusinessService modelBusinessService = null;
                try {
                    modelBusinessService = (BusinessService)em.find(BusinessService.class, (Object)serviceKey);
                }
                catch (Exception e) {
                    log.debug((Object)e.getMessage(), (Throwable)e);
                }
                if (modelBusinessService == null) {
                    throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.ServiceNotFound", serviceKey));
                }
            }
            FindQualifiers findQualifiers = new FindQualifiers();
            findQualifiers.mapApiFindQualifiers(body.getFindQualifiers());
            List<Object> keysFound = InquiryHelper.findBinding(body, findQualifiers, em);
            BindingDetail result = InquiryHelper.getBindingDetailFromKeys(body, findQualifiers, em, keysFound);
            tx.rollback();
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(InquiryQuery.FIND_BINDING, QueryStatus.SUCCESS, procTime);
            BindingDetail bindingDetail = result;
            return bindingDetail;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BusinessList findBusiness(FindBusiness body) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        try {
            new ValidateInquiry(null).validateFindBusiness(body);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(InquiryQuery.FIND_BUSINESS, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            try {
                logger.info((Object)("FindBusiness with tModel bag filtering is enabled: " + AppConfig.getConfiguration().getBoolean("juddi.preformance.enableFindBusinessTModelBagFiltering", true) + " loaded from " + AppConfig.getConfigFileURL()));
            }
            catch (ConfigurationException ex) {
                ex.printStackTrace();
            }
            tx.begin();
            if (this.isAuthenticated()) {
                this.getEntityPublisher(em, body.getAuthInfo());
            }
            UDDIInquiryImpl.LogFindBusinessRequest(body);
            FindQualifiers findQualifiers = new FindQualifiers();
            findQualifiers.mapApiFindQualifiers(body.getFindQualifiers());
            List<Object> keysFound = InquiryHelper.findBusiness(body, findQualifiers, em);
            BusinessList result = InquiryHelper.getBusinessListFromKeys(body, findQualifiers, em, keysFound);
            tx.rollback();
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(InquiryQuery.FIND_BUSINESS, QueryStatus.SUCCESS, procTime);
            BusinessList businessList = result;
            return businessList;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelatedBusinessesList findRelatedBusinesses(FindRelatedBusinesses body) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        try {
            new ValidateInquiry(null).validateFindRelatedBusinesses(body, false);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(InquiryQuery.FIND_RELATEDBUSINESSES, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            if (this.isAuthenticated()) {
                this.getEntityPublisher(em, body.getAuthInfo());
            }
            UDDIInquiryImpl.LogFindRelatedBusinessRequest(body);
            FindQualifiers findQualifiers = new FindQualifiers();
            findQualifiers.mapApiFindQualifiers(body.getFindQualifiers());
            RelatedBusinessesList result = InquiryHelper.getRelatedBusinessesList(body, em);
            tx.rollback();
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(InquiryQuery.FIND_RELATEDBUSINESSES, QueryStatus.SUCCESS, procTime);
            RelatedBusinessesList relatedBusinessesList = result;
            return relatedBusinessesList;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceList findService(FindService body) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        try {
            new ValidateInquiry(null).validateFindService(body);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(InquiryQuery.FIND_SERVICE, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            if (this.isAuthenticated()) {
                this.getEntityPublisher(em, body.getAuthInfo());
            }
            UDDIInquiryImpl.LogFindServiceRequest(body);
            FindQualifiers findQualifiers = new FindQualifiers();
            findQualifiers.mapApiFindQualifiers(body.getFindQualifiers());
            List<?> keysFound = InquiryHelper.findService(body, findQualifiers, em);
            if (keysFound.size() == 0 && body.getBusinessKey() != null) {
                String businessKey = body.getBusinessKey();
                BusinessEntity modelBusinessEntity = null;
                try {
                    modelBusinessEntity = (BusinessEntity)em.find(BusinessEntity.class, (Object)businessKey);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                if (modelBusinessEntity == null) {
                    throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.BusinessNotFound", businessKey));
                }
            }
            ServiceList result = InquiryHelper.getServiceListFromKeys(body, findQualifiers, em, keysFound);
            tx.rollback();
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(InquiryQuery.FIND_SERVICE, QueryStatus.SUCCESS, procTime);
            ServiceList serviceList = result;
            return serviceList;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TModelList findTModel(FindTModel body) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        try {
            new ValidateInquiry(null).validateFindTModel(body, false);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(InquiryQuery.FIND_TMODEL, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            if (this.isAuthenticated()) {
                this.getEntityPublisher(em, body.getAuthInfo());
            }
            UDDIInquiryImpl.LogFindTModelRequest(body);
            FindQualifiers findQualifiers = new FindQualifiers();
            findQualifiers.mapApiFindQualifiers(body.getFindQualifiers());
            List<Object> keysFound = InquiryHelper.findTModel(body, findQualifiers, em);
            TModelList result = InquiryHelper.getTModelListFromKeys(body, findQualifiers, em, keysFound);
            tx.rollback();
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(InquiryQuery.FIND_TMODEL, QueryStatus.SUCCESS, procTime);
            TModelList tModelList = result;
            return tModelList;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BindingDetail getBindingDetail(GetBindingDetail body) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        try {
            new ValidateInquiry(null).validateGetBindingDetail(body);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(InquiryQuery.FIND_TMODEL, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            if (this.isAuthenticated()) {
                this.getEntityPublisher(em, body.getAuthInfo());
            }
            BindingDetail result = new BindingDetail();
            List bindingKeyList = body.getBindingKey();
            for (String bindingKey : bindingKeyList) {
                BindingTemplate modelBindingTemplate = null;
                try {
                    modelBindingTemplate = (BindingTemplate)em.find(BindingTemplate.class, (Object)bindingKey);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                if (modelBindingTemplate == null) {
                    throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.BindingTemplateNotFound", bindingKey));
                }
                org.uddi.api_v3.BindingTemplate apiBindingTemplate = new org.uddi.api_v3.BindingTemplate();
                MappingModelToApi.mapBindingTemplate(modelBindingTemplate, apiBindingTemplate);
                result.getBindingTemplate().add(apiBindingTemplate);
            }
            tx.commit();
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(InquiryQuery.GET_BINDINGDETAIL, QueryStatus.SUCCESS, procTime);
            BindingDetail bindingDetail = result;
            return bindingDetail;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BusinessDetail getBusinessDetail(GetBusinessDetail body) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        try {
            new ValidateInquiry(null).validateGetBusinessDetail(body);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(InquiryQuery.GET_BUSINESSDETAIL, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            if (this.isAuthenticated()) {
                this.getEntityPublisher(em, body.getAuthInfo());
            }
            BusinessDetail result = new BusinessDetail();
            List businessKeyList = body.getBusinessKey();
            for (String businessKey : businessKeyList) {
                BusinessEntity modelBusinessEntity = null;
                try {
                    modelBusinessEntity = (BusinessEntity)em.find(BusinessEntity.class, (Object)businessKey);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                if (modelBusinessEntity == null) {
                    throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.BusinessNotFound", businessKey));
                }
                org.uddi.api_v3.BusinessEntity apiBusinessEntity = new org.uddi.api_v3.BusinessEntity();
                MappingModelToApi.mapBusinessEntity(modelBusinessEntity, apiBusinessEntity);
                result.getBusinessEntity().add(apiBusinessEntity);
            }
            tx.commit();
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(InquiryQuery.GET_BUSINESSDETAIL, QueryStatus.SUCCESS, procTime);
            BusinessDetail businessDetail = result;
            return businessDetail;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationalInfos getOperationalInfo(GetOperationalInfo body) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        try {
            new ValidateInquiry(null).validateGetOperationalInfo(body);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(InquiryQuery.GET_OPERATIONALINFO, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            if (this.isAuthenticated()) {
                this.getEntityPublisher(em, body.getAuthInfo());
            }
            OperationalInfos result = new OperationalInfos();
            List entityKeyList = body.getEntityKey();
            for (String entityKey : entityKeyList) {
                UddiEntity modelUddiEntity = null;
                try {
                    modelUddiEntity = (UddiEntity)em.find(UddiEntity.class, (Object)entityKey);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                if (modelUddiEntity == null) {
                    throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.EntityNotFound", entityKey));
                }
                OperationalInfo apiOperationalInfo = new OperationalInfo();
                MappingModelToApi.mapOperationalInfo(modelUddiEntity, apiOperationalInfo);
                result.getOperationalInfo().add(apiOperationalInfo);
            }
            tx.commit();
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(InquiryQuery.GET_OPERATIONALINFO, QueryStatus.SUCCESS, procTime);
            OperationalInfos operationalInfos = result;
            return operationalInfos;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceDetail getServiceDetail(GetServiceDetail body) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        try {
            new ValidateInquiry(null).validateGetServiceDetail(body);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(InquiryQuery.GET_SERVICEDETAIL, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            if (this.isAuthenticated()) {
                this.getEntityPublisher(em, body.getAuthInfo());
            }
            ServiceDetail result = new ServiceDetail();
            List serviceKeyList = body.getServiceKey();
            for (String serviceKey : serviceKeyList) {
                BusinessService modelBusinessService = null;
                try {
                    modelBusinessService = (BusinessService)em.find(BusinessService.class, (Object)serviceKey);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                if (modelBusinessService == null) {
                    throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.ServiceNotFound", serviceKey));
                }
                org.uddi.api_v3.BusinessService apiBusinessService = new org.uddi.api_v3.BusinessService();
                MappingModelToApi.mapBusinessService(modelBusinessService, apiBusinessService);
                result.getBusinessService().add(apiBusinessService);
            }
            tx.commit();
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(InquiryQuery.GET_SERVICEDETAIL, QueryStatus.SUCCESS, procTime);
            ServiceDetail serviceDetail = result;
            return serviceDetail;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TModelDetail getTModelDetail(GetTModelDetail body) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        try {
            new ValidateInquiry(null).validateGetTModelDetail(body);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(InquiryQuery.GET_TMODELDETAIL, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            if (this.isAuthenticated()) {
                this.getEntityPublisher(em, body.getAuthInfo());
            }
            TModelDetail result = new TModelDetail();
            List tmodelKeyList = body.getTModelKey();
            for (String tmodelKey : tmodelKeyList) {
                Tmodel modelTModel = null;
                try {
                    modelTModel = (Tmodel)em.find(Tmodel.class, (Object)tmodelKey);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                if (modelTModel == null) {
                    throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.TModelNotFound", tmodelKey));
                }
                TModel apiTModel = new TModel();
                MappingModelToApi.mapTModel(modelTModel, apiTModel);
                result.getTModel().add(apiTModel);
            }
            tx.commit();
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(InquiryQuery.GET_TMODELDETAIL, QueryStatus.SUCCESS, procTime);
            TModelDetail tModelDetail = result;
            return tModelDetail;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    private boolean isAuthenticated() {
        boolean result = false;
        try {
            result = AppConfig.getConfiguration().getBoolean("juddi.auth.Inquiry");
        }
        catch (ConfigurationException e) {
            log.error((Object)"Configuration exception occurred retrieving: juddi.auth.Inquiry", (Throwable)e);
        }
        return result;
    }
}

