/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.api.impl;

import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.jws.WebService;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import javax.xml.bind.JAXB;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.ws.Holder;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.api.impl.AuthenticatedService;
import org.apache.juddi.api.impl.PublicationHelper;
import org.apache.juddi.api.impl.ServiceCounterLifecycleResource;
import org.apache.juddi.api.impl.UDDIInquiryImpl;
import org.apache.juddi.api.impl.UDDIServiceCounter;
import org.apache.juddi.api.util.PublicationQuery;
import org.apache.juddi.api.util.QueryStatus;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.config.PersistenceManager;
import org.apache.juddi.mapping.MappingApiToModel;
import org.apache.juddi.mapping.MappingModelToApi;
import org.apache.juddi.model.BusinessService;
import org.apache.juddi.model.ChangeRecord;
import org.apache.juddi.model.Signature;
import org.apache.juddi.model.Tmodel;
import org.apache.juddi.model.UddiEntity;
import org.apache.juddi.model.UddiEntityPublisher;
import org.apache.juddi.query.FetchBusinessEntitiesQuery;
import org.apache.juddi.query.FetchTModelsQuery;
import org.apache.juddi.query.FindBusinessByPublisherQuery;
import org.apache.juddi.query.FindPublisherAssertionByBusinessQuery;
import org.apache.juddi.query.FindTModelByPublisherQuery;
import org.apache.juddi.query.util.DynamicQuery;
import org.apache.juddi.query.util.FindQualifiers;
import org.apache.juddi.replication.ReplicationNotifier;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.FatalErrorException;
import org.apache.juddi.v3.error.InvalidValueException;
import org.apache.juddi.validation.ValidatePublish;
import org.uddi.api_v3.AddPublisherAssertions;
import org.uddi.api_v3.AssertionStatusItem;
import org.uddi.api_v3.BindingDetail;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BusinessDetail;
import org.uddi.api_v3.BusinessEntity;
import org.uddi.api_v3.BusinessInfo;
import org.uddi.api_v3.BusinessInfos;
import org.uddi.api_v3.CompletionStatus;
import org.uddi.api_v3.DeleteBinding;
import org.uddi.api_v3.DeleteBusiness;
import org.uddi.api_v3.DeletePublisherAssertions;
import org.uddi.api_v3.DeleteService;
import org.uddi.api_v3.DeleteTModel;
import org.uddi.api_v3.GetRegisteredInfo;
import org.uddi.api_v3.InfoSelection;
import org.uddi.api_v3.ListDescription;
import org.uddi.api_v3.OperationalInfo;
import org.uddi.api_v3.PublisherAssertion;
import org.uddi.api_v3.RegisteredInfo;
import org.uddi.api_v3.SaveBinding;
import org.uddi.api_v3.SaveBusiness;
import org.uddi.api_v3.SaveService;
import org.uddi.api_v3.SaveTModel;
import org.uddi.api_v3.ServiceDetail;
import org.uddi.api_v3.TModel;
import org.uddi.api_v3.TModelDetail;
import org.uddi.api_v3.TModelInfo;
import org.uddi.api_v3.TModelInfos;
import org.uddi.repl_v3.ChangeRecord;
import org.uddi.repl_v3.ChangeRecordDelete;
import org.uddi.repl_v3.ChangeRecordDeleteAssertion;
import org.uddi.repl_v3.ChangeRecordHide;
import org.uddi.repl_v3.ChangeRecordIDType;
import org.uddi.repl_v3.ChangeRecordNewData;
import org.uddi.repl_v3.ChangeRecordNewDataConditional;
import org.uddi.repl_v3.ChangeRecordPublisherAssertion;
import org.uddi.v3_service.DispositionReportFaultMessage;
import org.uddi.v3_service.UDDIPublicationPortType;

@WebService(serviceName="UDDIPublicationService", endpointInterface="org.uddi.v3_service.UDDIPublicationPortType", targetNamespace="urn:uddi-org:api_v3_portType")
public class UDDIPublicationImpl
extends AuthenticatedService
implements UDDIPublicationPortType {
    private static Log log = LogFactory.getLog(UDDIInquiryImpl.class);
    private UDDIServiceCounter serviceCounter = ServiceCounterLifecycleResource.getServiceCounter(UDDIPublicationImpl.class);

    public void addPublisherAssertions(AddPublisherAssertions body) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidatePublish(publisher).validateAddPublisherAssertions(em, body);
            List apiPubAssertionList = body.getPublisherAssertion();
            ArrayList<org.apache.juddi.model.ChangeRecord> changes = new ArrayList<org.apache.juddi.model.ChangeRecord>();
            for (PublisherAssertion apiPubAssertion : apiPubAssertionList) {
                org.apache.juddi.model.PublisherAssertion modelPubAssertion = new org.apache.juddi.model.PublisherAssertion();
                MappingApiToModel.mapPublisherAssertion(apiPubAssertion, modelPubAssertion);
                org.apache.juddi.model.PublisherAssertion existingPubAssertion = (org.apache.juddi.model.PublisherAssertion)em.find(modelPubAssertion.getClass(), (Object)modelPubAssertion.getId());
                boolean persistNewAssertion = true;
                if (existingPubAssertion != null) {
                    if (modelPubAssertion.getTmodelKey().equalsIgnoreCase(existingPubAssertion.getTmodelKey()) && modelPubAssertion.getKeyName().equalsIgnoreCase(existingPubAssertion.getKeyName()) && modelPubAssertion.getKeyValue().equalsIgnoreCase(existingPubAssertion.getKeyValue())) {
                        if (publisher.isOwner(existingPubAssertion.getBusinessEntityByFromKey())) {
                            existingPubAssertion.setFromCheck("true");
                        }
                        if (publisher.isOwner(existingPubAssertion.getBusinessEntityByToKey())) {
                            existingPubAssertion.setToCheck("true");
                        }
                        this.removeExistingPublisherAssertionSignatures(existingPubAssertion.getBusinessEntityByFromKey().getEntityKey(), existingPubAssertion.getBusinessEntityByToKey().getEntityKey(), em);
                        this.savePushliserAssertionSignatures(existingPubAssertion.getBusinessEntityByFromKey().getEntityKey(), existingPubAssertion.getBusinessEntityByToKey().getEntityKey(), modelPubAssertion.getSignatures(), em);
                        em.merge((Object)existingPubAssertion);
                        persistNewAssertion = false;
                        changes.add(this.getChangeRecord_deletePublisherAssertion(apiPubAssertion, this.getNode(), existingPubAssertion.getToCheck().equalsIgnoreCase("false"), existingPubAssertion.getFromCheck().equalsIgnoreCase("false"), System.currentTimeMillis()));
                    } else {
                        this.removeExistingPublisherAssertionSignatures(existingPubAssertion.getBusinessEntityByFromKey().getEntityKey(), existingPubAssertion.getBusinessEntityByToKey().getEntityKey(), em);
                        em.remove((Object)existingPubAssertion);
                        changes.add(this.getChangeRecord_deletePublisherAssertion(apiPubAssertion, this.getNode(), true, true, System.currentTimeMillis()));
                    }
                }
                if (!persistNewAssertion) continue;
                org.apache.juddi.model.BusinessEntity beFrom = (org.apache.juddi.model.BusinessEntity)em.find(org.apache.juddi.model.BusinessEntity.class, (Object)modelPubAssertion.getId().getFromKey());
                org.apache.juddi.model.BusinessEntity beTo = (org.apache.juddi.model.BusinessEntity)em.find(org.apache.juddi.model.BusinessEntity.class, (Object)modelPubAssertion.getId().getToKey());
                modelPubAssertion.setBusinessEntityByFromKey(beFrom);
                modelPubAssertion.setBusinessEntityByToKey(beTo);
                modelPubAssertion.setFromCheck("false");
                modelPubAssertion.setToCheck("false");
                if (publisher.isOwner(modelPubAssertion.getBusinessEntityByFromKey())) {
                    modelPubAssertion.setFromCheck("true");
                }
                if (publisher.isOwner(modelPubAssertion.getBusinessEntityByToKey())) {
                    modelPubAssertion.setToCheck("true");
                }
                modelPubAssertion.setModified(new Date());
                this.savePushliserAssertionSignatures(modelPubAssertion.getBusinessEntityByFromKey().getEntityKey(), modelPubAssertion.getBusinessEntityByToKey().getEntityKey(), modelPubAssertion.getSignatures(), em);
                em.persist((Object)modelPubAssertion);
                changes.add(this.getChangeRecord_NewAssertion(apiPubAssertion, modelPubAssertion, this.getNode()));
            }
            tx.commit();
            for (int i = 0; i < changes.size(); ++i) {
                ReplicationNotifier.enqueue((org.apache.juddi.model.ChangeRecord)changes.get(i));
            }
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(PublicationQuery.ADD_PUBLISHERASSERTIONS, QueryStatus.SUCCESS, procTime);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(PublicationQuery.ADD_PUBLISHERASSERTIONS, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    public void deleteBinding(DeleteBinding body) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidatePublish(publisher).validateDeleteBinding(em, body);
            List entityKeyList = body.getBindingKey();
            ArrayList<org.apache.juddi.model.ChangeRecord> changes = new ArrayList<org.apache.juddi.model.ChangeRecord>();
            for (String entityKey : entityKeyList) {
                this.deleteBinding(entityKey, em);
                changes.add(this.getChangeRecord_deleteBinding(entityKey, this.getNode()));
            }
            tx.commit();
            for (int i = 0; i < changes.size(); ++i) {
                ReplicationNotifier.enqueue((org.apache.juddi.model.ChangeRecord)changes.get(i));
            }
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(PublicationQuery.DELETE_BINDING, QueryStatus.SUCCESS, procTime);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(PublicationQuery.DELETE_BINDING, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    protected void deleteBinding(String entityKey, EntityManager em) throws DispositionReportFaultMessage {
        Object obj = em.find(org.apache.juddi.model.BindingTemplate.class, (Object)entityKey);
        ((org.apache.juddi.model.BindingTemplate)obj).getBusinessService().setModifiedIncludingChildren(new Date());
        ((org.apache.juddi.model.BindingTemplate)obj).getBusinessService().getBusinessEntity().setModifiedIncludingChildren(new Date());
        em.remove(obj);
    }

    public void deleteBusiness(DeleteBusiness body) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidatePublish(publisher).validateDeleteBusiness(em, body);
            List entityKeyList = body.getBusinessKey();
            ArrayList<org.apache.juddi.model.ChangeRecord> changes = new ArrayList<org.apache.juddi.model.ChangeRecord>();
            for (String entityKey : entityKeyList) {
                this.deleteBusiness(entityKey, em);
                changes.add(this.getChangeRecord_deleteBusiness(entityKey, this.getNode()));
            }
            tx.commit();
            for (int i = 0; i < changes.size(); ++i) {
                ReplicationNotifier.enqueue((org.apache.juddi.model.ChangeRecord)changes.get(i));
            }
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(PublicationQuery.DELETE_BUSINESS, QueryStatus.SUCCESS, procTime);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(PublicationQuery.DELETE_BUSINESS, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    protected void deleteBusiness(String key, EntityManager em) throws DispositionReportFaultMessage {
        Object obj = em.find(org.apache.juddi.model.BusinessEntity.class, (Object)key);
        em.remove(obj);
    }

    public void deletePublisherAssertions(DeletePublisherAssertions body) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidatePublish(publisher).validateDeletePublisherAssertions(em, body);
            List entityList = body.getPublisherAssertion();
            ArrayList<org.apache.juddi.model.ChangeRecord> changes = new ArrayList<org.apache.juddi.model.ChangeRecord>();
            for (PublisherAssertion entity : entityList) {
                org.apache.juddi.model.PublisherAssertion modelPubAssertion = new org.apache.juddi.model.PublisherAssertion();
                MappingApiToModel.mapPublisherAssertion(entity, modelPubAssertion);
                org.apache.juddi.model.PublisherAssertion existingPubAssertion = (org.apache.juddi.model.PublisherAssertion)em.find(org.apache.juddi.model.PublisherAssertion.class, (Object)modelPubAssertion.getId());
                if (existingPubAssertion == null) {
                    throw new InvalidValueException(new ErrorMessage("E_assertionNotFound"));
                }
                boolean fromkey = publisher.isOwner((UddiEntity)em.find(org.apache.juddi.model.BusinessEntity.class, (Object)entity.getFromKey()));
                boolean tokey = publisher.isOwner((UddiEntity)em.find(org.apache.juddi.model.BusinessEntity.class, (Object)entity.getToKey()));
                if (fromkey) {
                    existingPubAssertion.setFromCheck("false");
                }
                if (tokey) {
                    existingPubAssertion.setToCheck("false");
                }
                if ("false".equalsIgnoreCase(existingPubAssertion.getToCheck()) && "false".equalsIgnoreCase(existingPubAssertion.getFromCheck())) {
                    logger.info((Object)"Publisher assertion updated database via replication");
                    this.removeExistingPublisherAssertionSignatures(existingPubAssertion.getBusinessEntityByFromKey().getEntityKey(), existingPubAssertion.getBusinessEntityByToKey().getEntityKey(), em);
                    em.remove((Object)existingPubAssertion);
                } else {
                    existingPubAssertion.setModified(new Date());
                    logger.info((Object)"Publisher assertion updated database via replication");
                    this.removeExistingPublisherAssertionSignatures(existingPubAssertion.getBusinessEntityByFromKey().getEntityKey(), existingPubAssertion.getBusinessEntityByToKey().getEntityKey(), em);
                    this.savePushliserAssertionSignatures(existingPubAssertion.getBusinessEntityByFromKey().getEntityKey(), existingPubAssertion.getBusinessEntityByToKey().getEntityKey(), modelPubAssertion.getSignatures(), em);
                    em.persist((Object)existingPubAssertion);
                }
                changes.add(this.getChangeRecord_deletePublisherAssertion(entity, this.getNode(), tokey, fromkey, existingPubAssertion.getModified().getTime()));
            }
            tx.commit();
            for (int i = 0; i < changes.size(); ++i) {
                ReplicationNotifier.enqueue((org.apache.juddi.model.ChangeRecord)changes.get(i));
            }
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(PublicationQuery.DELETE_PUBLISHERASSERTIONS, QueryStatus.SUCCESS, procTime);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(PublicationQuery.DELETE_PUBLISHERASSERTIONS, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    protected void deletePublisherAssertion(ChangeRecordDeleteAssertion entity, EntityManager em) throws DispositionReportFaultMessage {
        org.apache.juddi.model.PublisherAssertion modelPubAssertion = new org.apache.juddi.model.PublisherAssertion();
        MappingApiToModel.mapPublisherAssertion(entity.getPublisherAssertion(), modelPubAssertion);
        org.apache.juddi.model.PublisherAssertion existingPubAssertion = (org.apache.juddi.model.PublisherAssertion)em.find(org.apache.juddi.model.PublisherAssertion.class, (Object)modelPubAssertion.getId());
        if (existingPubAssertion == null) {
            throw new FatalErrorException(new ErrorMessage("E_assertionNotFound"));
        }
        boolean fromkey = entity.isFromBusinessCheck();
        boolean tokey = entity.isToBusinessCheck();
        if (fromkey) {
            existingPubAssertion.setFromCheck("false");
        }
        if (tokey) {
            existingPubAssertion.setToCheck("false");
        }
        if ("false".equalsIgnoreCase(existingPubAssertion.getToCheck()) && "false".equalsIgnoreCase(existingPubAssertion.getFromCheck())) {
            logger.info((Object)"Deletion of publisher assertion from database via replication");
            this.removeExistingPublisherAssertionSignatures(existingPubAssertion.getBusinessEntityByFromKey().getEntityKey(), existingPubAssertion.getBusinessEntityByToKey().getEntityKey(), em);
            em.remove((Object)existingPubAssertion);
        } else {
            existingPubAssertion.setModified(new Date());
            logger.info((Object)"Publisher assertion updated database via replication");
            this.removeExistingPublisherAssertionSignatures(existingPubAssertion.getBusinessEntityByFromKey().getEntityKey(), existingPubAssertion.getBusinessEntityByToKey().getEntityKey(), em);
            this.savePushliserAssertionSignatures(existingPubAssertion.getBusinessEntityByFromKey().getEntityKey(), existingPubAssertion.getBusinessEntityByToKey().getEntityKey(), modelPubAssertion.getSignatures(), em);
            em.persist((Object)existingPubAssertion);
        }
    }

    public void deleteService(DeleteService body) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidatePublish(publisher).validateDeleteService(em, body);
            List entityKeyList = body.getServiceKey();
            ArrayList<org.apache.juddi.model.ChangeRecord> changes = new ArrayList<org.apache.juddi.model.ChangeRecord>();
            for (String entityKey : entityKeyList) {
                this.deleteService(entityKey, em);
                changes.add(this.getChangeRecord_deleteService(entityKey, this.getNode()));
            }
            tx.commit();
            for (int i = 0; i < changes.size(); ++i) {
                ReplicationNotifier.enqueue((org.apache.juddi.model.ChangeRecord)changes.get(i));
            }
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(PublicationQuery.DELETE_SERVICE, QueryStatus.SUCCESS, procTime);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(PublicationQuery.DELETE_SERVICE, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    protected void deleteService(String key, EntityManager em) throws DispositionReportFaultMessage {
        Object obj = em.find(BusinessService.class, (Object)key);
        if (obj != null) {
            em.remove(obj);
        } else {
            logger.warn((Object)("Unable to remove service with the key '" + key + "', it doesn't exist in the database"));
        }
    }

    public void deleteTModel(DeleteTModel body) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidatePublish(publisher).validateDeleteTModel(em, body);
            List entityKeyList = body.getTModelKey();
            ArrayList<org.apache.juddi.model.ChangeRecord> changes = new ArrayList<org.apache.juddi.model.ChangeRecord>();
            for (String entityKey : entityKeyList) {
                this.deleteTModel(entityKey, em);
                changes.add(this.getChangeRecord_deleteTModelHide(entityKey, this.getNode()));
            }
            tx.commit();
            for (int i = 0; i < changes.size(); ++i) {
                ReplicationNotifier.enqueue((org.apache.juddi.model.ChangeRecord)changes.get(i));
            }
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(PublicationQuery.DELETE_TMODEL, QueryStatus.SUCCESS, procTime);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(PublicationQuery.DELETE_TMODEL, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    protected void deleteTModel(String key, EntityManager em) {
        Object obj = em.find(Tmodel.class, (Object)key);
        ((Tmodel)obj).setDeleted(true);
    }

    public List<AssertionStatusItem> getAssertionStatusReport(String authInfo, CompletionStatus completionStatus) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, authInfo);
            List<AssertionStatusItem> result = PublicationHelper.getAssertionStatusItemList(publisher, completionStatus, em);
            tx.commit();
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(PublicationQuery.GET_ASSERTIONSTATUSREPORT, QueryStatus.SUCCESS, procTime);
            List<AssertionStatusItem> list = result;
            return list;
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(PublicationQuery.GET_ASSERTIONSTATUSREPORT, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    public List<PublisherAssertion> getPublisherAssertions(String authInfo) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, authInfo);
            ArrayList<PublisherAssertion> result = new ArrayList<PublisherAssertion>(0);
            List<?> businessKeysFound = null;
            businessKeysFound = FindBusinessByPublisherQuery.select(em, null, publisher, businessKeysFound);
            List<org.apache.juddi.model.PublisherAssertion> pubAssertionList = FindPublisherAssertionByBusinessQuery.select(em, businessKeysFound, null);
            if (pubAssertionList != null) {
                for (org.apache.juddi.model.PublisherAssertion modelPubAssertion : pubAssertionList) {
                    PublisherAssertion apiPubAssertion = new PublisherAssertion();
                    MappingModelToApi.mapPublisherAssertion(modelPubAssertion, apiPubAssertion);
                    result.add(apiPubAssertion);
                }
            }
            tx.commit();
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(PublicationQuery.GET_PUBLISHERASSERTIONS, QueryStatus.SUCCESS, procTime);
            ArrayList<PublisherAssertion> arrayList = result;
            return arrayList;
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(PublicationQuery.GET_PUBLISHERASSERTIONS, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    public RegisteredInfo getRegisteredInfo(GetRegisteredInfo body) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidatePublish(publisher).validateRegisteredInfo(body);
            List<?> businessKeysFound = null;
            businessKeysFound = FindBusinessByPublisherQuery.select(em, null, publisher, businessKeysFound);
            List<?> tmodelKeysFound = null;
            tmodelKeysFound = body.getInfoSelection().equals((Object)InfoSelection.HIDDEN) ? FindTModelByPublisherQuery.select(em, null, publisher, tmodelKeysFound, new DynamicQuery.Parameter("t.deleted", Boolean.TRUE, "=")) : (body.getInfoSelection().equals((Object)InfoSelection.VISIBLE) ? FindTModelByPublisherQuery.select(em, null, publisher, tmodelKeysFound, new DynamicQuery.Parameter("t.deleted", Boolean.FALSE, "=")) : FindTModelByPublisherQuery.select(em, null, publisher, tmodelKeysFound, new DynamicQuery.Parameter[0]));
            RegisteredInfo result = new RegisteredInfo();
            List<?> queryResults = FetchBusinessEntitiesQuery.select(em, new FindQualifiers(), businessKeysFound, null, null, null, new DynamicQuery.Parameter[0]);
            if (queryResults.size() > 0) {
                result.setBusinessInfos(new BusinessInfos());
                for (Object item : queryResults) {
                    org.apache.juddi.model.BusinessEntity modelBusinessEntity = (org.apache.juddi.model.BusinessEntity)item;
                    BusinessInfo apiBusinessInfo = new BusinessInfo();
                    MappingModelToApi.mapBusinessInfo(modelBusinessEntity, apiBusinessInfo);
                    result.getBusinessInfos().getBusinessInfo().add(apiBusinessInfo);
                }
            }
            if ((queryResults = FetchTModelsQuery.select(em, new FindQualifiers(), tmodelKeysFound, null, null, null, new DynamicQuery.Parameter[0])).size() > 0) {
                result.setTModelInfos(new TModelInfos());
                for (Object item : queryResults) {
                    Tmodel modelTModel = (Tmodel)item;
                    TModelInfo apiTModelInfo = new TModelInfo();
                    MappingModelToApi.mapTModelInfo(modelTModel, apiTModelInfo);
                    result.getTModelInfos().getTModelInfo().add(apiTModelInfo);
                }
            }
            tx.commit();
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(PublicationQuery.GET_REGISTEREDINFO, QueryStatus.SUCCESS, procTime);
            RegisteredInfo registeredInfo = result;
            return registeredInfo;
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(PublicationQuery.GET_REGISTEREDINFO, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    public BindingDetail saveBinding(SaveBinding body) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            publisher.populateKeyGeneratorKeys(em);
            ValidatePublish validator = new ValidatePublish(publisher);
            validator.validateSaveBinding(em, body, null, publisher);
            BindingDetail result = new BindingDetail();
            result.setListDescription(new ListDescription());
            List apiBindingTemplateList = body.getBindingTemplate();
            ArrayList<org.apache.juddi.model.ChangeRecord> changes = new ArrayList<org.apache.juddi.model.ChangeRecord>();
            for (BindingTemplate apiBindingTemplate : apiBindingTemplateList) {
                org.apache.juddi.model.BindingTemplate modelBindingTemplate = new org.apache.juddi.model.BindingTemplate();
                BusinessService modelBusinessService = new BusinessService();
                modelBusinessService.setEntityKey(apiBindingTemplate.getServiceKey());
                MappingApiToModel.mapBindingTemplate(apiBindingTemplate, modelBindingTemplate, modelBusinessService);
                this.setOperationalInfo(em, modelBindingTemplate, publisher, true);
                em.persist((Object)modelBindingTemplate);
                result.getBindingTemplate().add(apiBindingTemplate);
                result.getListDescription().setActualCount(result.getListDescription().getActualCount() + 1);
                result.getListDescription().setIncludeCount(result.getListDescription().getIncludeCount() + 1);
                validator.validateSaveBindingMax(em, modelBindingTemplate.getBusinessService().getEntityKey());
                changes.add(UDDIPublicationImpl.getChangeRecord(modelBindingTemplate, apiBindingTemplate, this.getNode()));
            }
            tx.commit();
            for (int i = 0; i < changes.size(); ++i) {
                ReplicationNotifier.enqueue((org.apache.juddi.model.ChangeRecord)changes.get(i));
            }
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(PublicationQuery.SAVE_BINDING, QueryStatus.SUCCESS, procTime);
            BindingDetail bindingDetail = result;
            return bindingDetail;
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(PublicationQuery.SAVE_BINDING, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    public BusinessDetail saveBusiness(SaveBusiness body) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            publisher.populateKeyGeneratorKeys(em);
            ValidatePublish validator = new ValidatePublish(publisher);
            validator.validateSaveBusiness(em, body, null, publisher);
            BusinessDetail result = new BusinessDetail();
            List apiBusinessEntityList = body.getBusinessEntity();
            ArrayList<org.apache.juddi.model.ChangeRecord> changes = new ArrayList<org.apache.juddi.model.ChangeRecord>();
            for (BusinessEntity apiBusinessEntity : apiBusinessEntityList) {
                org.apache.juddi.model.BusinessEntity modelBusinessEntity = new org.apache.juddi.model.BusinessEntity();
                MappingApiToModel.mapBusinessEntity(apiBusinessEntity, modelBusinessEntity);
                this.setOperationalInfo(em, modelBusinessEntity, publisher);
                log.debug((Object)("Saving business " + modelBusinessEntity.getEntityKey()));
                em.persist((Object)modelBusinessEntity);
                changes.add(UDDIPublicationImpl.getChangeRecord(modelBusinessEntity, apiBusinessEntity, this.getNode()));
                result.getBusinessEntity().add(apiBusinessEntity);
            }
            validator.validateSaveBusinessMax(em);
            tx.commit();
            for (int i = 0; i < changes.size(); ++i) {
                ReplicationNotifier.enqueue((org.apache.juddi.model.ChangeRecord)changes.get(i));
            }
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(PublicationQuery.SAVE_BUSINESS, QueryStatus.SUCCESS, procTime);
            BusinessDetail businessDetail = result;
            return businessDetail;
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(PublicationQuery.SAVE_BUSINESS, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        catch (Exception ex) {
            StringWriter sw = new StringWriter();
            if (body != null) {
                JAXB.marshal((Object)body, (Writer)sw);
            }
            log.fatal((Object)("unexpected error!" + sw.toString()), (Throwable)ex);
            throw new FatalErrorException(new ErrorMessage("E_fatalError", ex.getMessage()));
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    public ServiceDetail saveService(SaveService body) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            publisher.populateKeyGeneratorKeys(em);
            ValidatePublish validator = new ValidatePublish(publisher);
            validator.validateSaveService(em, body, null, publisher);
            ServiceDetail result = new ServiceDetail();
            List apiBusinessServiceList = body.getBusinessService();
            ArrayList<org.apache.juddi.model.ChangeRecord> changes = new ArrayList<org.apache.juddi.model.ChangeRecord>();
            for (org.uddi.api_v3.BusinessService apiBusinessService : apiBusinessServiceList) {
                BusinessService modelBusinessService = new BusinessService();
                org.apache.juddi.model.BusinessEntity modelBusinessEntity = new org.apache.juddi.model.BusinessEntity();
                modelBusinessEntity.setEntityKey(apiBusinessService.getBusinessKey());
                MappingApiToModel.mapBusinessService(apiBusinessService, modelBusinessService, modelBusinessEntity);
                this.setOperationalInfo(em, modelBusinessService, publisher, false);
                em.persist((Object)modelBusinessService);
                result.getBusinessService().add(apiBusinessService);
                validator.validateSaveServiceMax(em, modelBusinessService.getBusinessEntity().getEntityKey());
                changes.add(UDDIPublicationImpl.getChangeRecord(modelBusinessService, apiBusinessService, this.getNode()));
            }
            tx.commit();
            for (int i = 0; i < changes.size(); ++i) {
                ReplicationNotifier.enqueue((org.apache.juddi.model.ChangeRecord)changes.get(i));
            }
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(PublicationQuery.SAVE_SERVICE, QueryStatus.SUCCESS, procTime);
            ServiceDetail serviceDetail = result;
            return serviceDetail;
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(PublicationQuery.SAVE_SERVICE, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    public TModelDetail saveTModel(SaveTModel body) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            publisher.populateKeyGeneratorKeys(em);
            new ValidatePublish(publisher).validateSaveTModel(em, body, null, publisher);
            TModelDetail result = new TModelDetail();
            List apiTModelList = body.getTModel();
            ArrayList<org.apache.juddi.model.ChangeRecord> changes = new ArrayList<org.apache.juddi.model.ChangeRecord>();
            for (TModel apiTModel : apiTModelList) {
                Tmodel modelTModel = new Tmodel();
                MappingApiToModel.mapTModel(apiTModel, modelTModel);
                this.setOperationalInfo(em, modelTModel, publisher);
                em.persist((Object)modelTModel);
                result.getTModel().add(apiTModel);
                changes.add(UDDIPublicationImpl.getChangeRecord(modelTModel, apiTModel, this.getNode()));
            }
            tx.commit();
            for (int i = 0; i < changes.size(); ++i) {
                ReplicationNotifier.enqueue((org.apache.juddi.model.ChangeRecord)changes.get(i));
            }
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(PublicationQuery.SAVE_TMODEL, QueryStatus.SUCCESS, procTime);
            TModelDetail tModelDetail = result;
            return tModelDetail;
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(PublicationQuery.SAVE_TMODEL, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    public void setPublisherAssertions(String authInfo, Holder<List<PublisherAssertion>> publisherAssertion) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        ArrayList<org.apache.juddi.model.ChangeRecord> changes = new ArrayList<org.apache.juddi.model.ChangeRecord>();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, authInfo);
            new ValidatePublish(publisher).validateSetPublisherAssertions(em, publisherAssertion);
            List<?> businessKeysFound = null;
            businessKeysFound = FindBusinessByPublisherQuery.select(em, null, publisher, businessKeysFound);
            List<org.apache.juddi.model.PublisherAssertion> existingAssertions = FindPublisherAssertionByBusinessQuery.select(em, businessKeysFound, null);
            logger.debug((Object)(">>>> Existing assertions " + existingAssertions.size() + ", inbound set " + ((List)publisherAssertion.value).size()));
            List<org.apache.juddi.model.PublisherAssertion> deleteMe = this.diff((List)publisherAssertion.value, existingAssertions);
            logger.debug((Object)(">>>> DIFF size is " + deleteMe.size()));
            for (org.apache.juddi.model.PublisherAssertion del : deleteMe) {
                logger.debug((Object)(">>>> PROCESSING " + del.getBusinessEntityByFromKey().getEntityKey() + " " + del.getBusinessEntityByToKey().getEntityKey()));
                boolean from = false;
                if (del.getFromCheck() != null) {
                    del.getFromCheck().equalsIgnoreCase("true");
                }
                boolean to = false;
                if (del.getToCheck() != null) {
                    del.getToCheck().equalsIgnoreCase("true");
                }
                if (publisher.isOwner(del.getBusinessEntityByFromKey())) {
                    from = false;
                }
                if (publisher.isOwner(del.getBusinessEntityByToKey())) {
                    to = false;
                }
                PublisherAssertion api = new PublisherAssertion();
                MappingModelToApi.mapPublisherAssertion(del, api);
                if (!to && !from) {
                    logger.debug((Object)(">>>> DELETE ME " + del.getBusinessEntityByFromKey().getEntityKey() + " " + del.getBusinessEntityByToKey().getEntityKey()));
                    em.remove((Object)del);
                } else {
                    logger.debug((Object)(">>>> MERGING ME " + del.getBusinessEntityByFromKey().getEntityKey() + " " + del.getBusinessEntityByToKey().getEntityKey()));
                    del.setFromCheck(from ? "true" : "false");
                    del.setToCheck(to ? "true" : "false");
                    del.setModified(new Date());
                    em.merge((Object)del);
                }
                changes.add(this.getChangeRecord_deletePublisherAssertion(api, this.getNode(), to, from, System.currentTimeMillis()));
            }
            tx.commit();
            if (!((List)publisherAssertion.value).isEmpty()) {
                AddPublisherAssertions addPublisherAssertions = new AddPublisherAssertions();
                addPublisherAssertions.setAuthInfo(authInfo);
                addPublisherAssertions.getPublisherAssertion().addAll((Collection)publisherAssertion.value);
                this.addPublisherAssertions(addPublisherAssertions);
            }
            for (int i = 0; i < changes.size(); ++i) {
                ReplicationNotifier.enqueue((org.apache.juddi.model.ChangeRecord)changes.get(i));
            }
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(PublicationQuery.SET_PUBLISHERASSERTIONS, QueryStatus.SUCCESS, procTime);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(PublicationQuery.SET_PUBLISHERASSERTIONS, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    private void setOperationalInfo(EntityManager em, org.apache.juddi.model.BusinessEntity uddiEntity, UddiEntityPublisher publisher) throws DispositionReportFaultMessage {
        uddiEntity.setAuthorizedName(publisher.getAuthorizedName());
        Date now = new Date();
        uddiEntity.setModified(now);
        uddiEntity.setModifiedIncludingChildren(now);
        String nodeId = "";
        try {
            nodeId = AppConfig.getConfiguration().getString("juddi.nodeId");
        }
        catch (ConfigurationException ce) {
            throw new FatalErrorException(new ErrorMessage("errors.configuration.Retrieval", "juddi.nodeId"));
        }
        uddiEntity.setNodeId(nodeId);
        org.apache.juddi.model.BusinessEntity existingUddiEntity = (org.apache.juddi.model.BusinessEntity)em.find(uddiEntity.getClass(), (Object)uddiEntity.getEntityKey());
        if (existingUddiEntity != null) {
            uddiEntity.setCreated(existingUddiEntity.getCreated());
        } else {
            uddiEntity.setCreated(now);
        }
        List<BusinessService> serviceList = uddiEntity.getBusinessServices();
        for (BusinessService service : serviceList) {
            this.setOperationalInfo(em, service, publisher, true);
        }
        if (existingUddiEntity != null) {
            em.remove((Object)existingUddiEntity);
        }
    }

    private void setOperationalInfo(EntityManager em, BusinessService uddiEntity, UddiEntityPublisher publisher, boolean isChild) throws DispositionReportFaultMessage {
        uddiEntity.setAuthorizedName(publisher.getAuthorizedName());
        Date now = new Date();
        uddiEntity.setModified(now);
        uddiEntity.setModifiedIncludingChildren(now);
        if (!isChild) {
            org.apache.juddi.model.BusinessEntity parent = (org.apache.juddi.model.BusinessEntity)em.find(org.apache.juddi.model.BusinessEntity.class, (Object)uddiEntity.getBusinessEntity().getEntityKey());
            parent.setModifiedIncludingChildren(now);
            em.persist((Object)parent);
        }
        String nodeId = "";
        try {
            nodeId = AppConfig.getConfiguration().getString("juddi.nodeId");
        }
        catch (ConfigurationException ce) {
            throw new FatalErrorException(new ErrorMessage("errors.configuration.Retrieval", "juddi.nodeId"));
        }
        uddiEntity.setNodeId(nodeId);
        BusinessService existingUddiEntity = (BusinessService)em.find(uddiEntity.getClass(), (Object)uddiEntity.getEntityKey());
        if (existingUddiEntity != null) {
            uddiEntity.setCreated(existingUddiEntity.getCreated());
        } else {
            uddiEntity.setCreated(now);
        }
        List<org.apache.juddi.model.BindingTemplate> bindingList = uddiEntity.getBindingTemplates();
        for (org.apache.juddi.model.BindingTemplate binding : bindingList) {
            this.setOperationalInfo(em, binding, publisher, true);
        }
        if (existingUddiEntity != null) {
            em.remove((Object)existingUddiEntity);
        }
    }

    private void setOperationalInfo(EntityManager em, org.apache.juddi.model.BindingTemplate uddiEntity, UddiEntityPublisher publisher, boolean isChild) throws DispositionReportFaultMessage {
        uddiEntity.setAuthorizedName(publisher.getAuthorizedName());
        Date now = new Date();
        uddiEntity.setModified(now);
        uddiEntity.setModifiedIncludingChildren(now);
        BusinessService parent = (BusinessService)em.find(BusinessService.class, (Object)uddiEntity.getBusinessService().getEntityKey());
        if (parent != null) {
            parent.setModifiedIncludingChildren(now);
            em.persist((Object)parent);
            org.apache.juddi.model.BusinessEntity businessParent = (org.apache.juddi.model.BusinessEntity)em.find(org.apache.juddi.model.BusinessEntity.class, (Object)parent.getBusinessEntity().getEntityKey());
            if (businessParent != null) {
                businessParent.setModifiedIncludingChildren(now);
                em.persist((Object)businessParent);
            } else {
                logger.debug((Object)"Parent business is null for saved binding template!");
            }
        } else {
            logger.debug((Object)"Parent service is null for saved binding template!");
        }
        String nodeId = "";
        try {
            nodeId = AppConfig.getConfiguration().getString("juddi.nodeId");
        }
        catch (ConfigurationException ce) {
            throw new FatalErrorException(new ErrorMessage("errors.configuration.Retrieval", "juddi.nodeId"));
        }
        uddiEntity.setNodeId(nodeId);
        org.apache.juddi.model.BindingTemplate existingUddiEntity = (org.apache.juddi.model.BindingTemplate)em.find(uddiEntity.getClass(), (Object)uddiEntity.getEntityKey());
        if (existingUddiEntity != null) {
            uddiEntity.setCreated(existingUddiEntity.getCreated());
        } else {
            uddiEntity.setCreated(now);
        }
        if (existingUddiEntity != null) {
            em.remove((Object)existingUddiEntity);
        }
    }

    private void setOperationalInfo(EntityManager em, Tmodel uddiEntity, UddiEntityPublisher publisher) throws DispositionReportFaultMessage {
        uddiEntity.setAuthorizedName(publisher.getAuthorizedName());
        Date now = new Date();
        uddiEntity.setModified(now);
        uddiEntity.setModifiedIncludingChildren(now);
        String nodeId = "";
        try {
            nodeId = AppConfig.getConfiguration().getString("juddi.nodeId");
        }
        catch (ConfigurationException ce) {
            throw new FatalErrorException(new ErrorMessage("errors.configuration.Retrieval", "juddi.nodeId"));
        }
        uddiEntity.setNodeId(nodeId);
        Tmodel existingUddiEntity = (Tmodel)em.find(uddiEntity.getClass(), (Object)uddiEntity.getEntityKey());
        if (existingUddiEntity != null) {
            uddiEntity.setCreated(existingUddiEntity.getCreated());
        } else {
            uddiEntity.setCreated(now);
        }
        if (existingUddiEntity != null) {
            em.remove((Object)existingUddiEntity);
        }
    }

    public static org.apache.juddi.model.ChangeRecord getChangeRecord(org.apache.juddi.model.BindingTemplate modelBindingTemplate, BindingTemplate api, String node) throws DispositionReportFaultMessage {
        org.apache.juddi.model.ChangeRecord cr = new org.apache.juddi.model.ChangeRecord();
        cr.setEntityKey(modelBindingTemplate.getEntityKey());
        cr.setNodeID(node);
        cr.setRecordType(ChangeRecord.RecordType.ChangeRecordNewData);
        ChangeRecord crapi = new ChangeRecord();
        crapi.setChangeID(new ChangeRecordIDType(node, Long.valueOf(-1L)));
        crapi.setChangeRecordNewData(new ChangeRecordNewData());
        crapi.getChangeRecordNewData().setBindingTemplate(api);
        crapi.getChangeRecordNewData().setOperationalInfo(new OperationalInfo());
        MappingModelToApi.mapOperationalInfo(modelBindingTemplate, crapi.getChangeRecordNewData().getOperationalInfo());
        StringWriter sw = new StringWriter();
        JAXB.marshal((Object)crapi, (Writer)sw);
        try {
            cr.setContents(sw.toString().getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException ex) {
            logger.error((Object)ex);
        }
        return cr;
    }

    public static org.apache.juddi.model.ChangeRecord getChangeRecord(BusinessService model, org.uddi.api_v3.BusinessService api, String node) throws DispositionReportFaultMessage {
        org.apache.juddi.model.ChangeRecord cr = new org.apache.juddi.model.ChangeRecord();
        cr.setEntityKey(model.getEntityKey());
        cr.setNodeID(node);
        cr.setRecordType(ChangeRecord.RecordType.ChangeRecordNewData);
        ChangeRecord crapi = new ChangeRecord();
        crapi.setChangeID(new ChangeRecordIDType(node, Long.valueOf(-1L)));
        crapi.setChangeRecordNewData(new ChangeRecordNewData());
        crapi.getChangeRecordNewData().setBusinessService(api);
        crapi.getChangeRecordNewData().setOperationalInfo(new OperationalInfo());
        MappingModelToApi.mapOperationalInfo(model, crapi.getChangeRecordNewData().getOperationalInfo());
        StringWriter sw = new StringWriter();
        JAXB.marshal((Object)crapi, (Writer)sw);
        try {
            cr.setContents(sw.toString().getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException ex) {
            logger.error((Object)ex);
        }
        return cr;
    }

    public org.apache.juddi.model.ChangeRecord getChangeRecord_deleteBusiness(String entityKey, String node) {
        org.apache.juddi.model.ChangeRecord cr = new org.apache.juddi.model.ChangeRecord();
        cr.setEntityKey(entityKey);
        cr.setNodeID(node);
        cr.setRecordType(ChangeRecord.RecordType.ChangeRecordDelete);
        ChangeRecord crapi = new ChangeRecord();
        crapi.setChangeID(new ChangeRecordIDType(node, Long.valueOf(-1L)));
        crapi.setChangeRecordDelete(new ChangeRecordDelete());
        crapi.getChangeRecordDelete().setBusinessKey(entityKey);
        crapi.getChangeRecordDelete().setModified(this.df.newXMLGregorianCalendar(new GregorianCalendar()));
        StringWriter sw = new StringWriter();
        JAXB.marshal((Object)crapi, (Writer)sw);
        try {
            cr.setContents(sw.toString().getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException ex) {
            logger.error((Object)ex);
        }
        return cr;
    }

    public org.apache.juddi.model.ChangeRecord getChangeRecord_deleteService(String entityKey, String node) {
        org.apache.juddi.model.ChangeRecord cr = new org.apache.juddi.model.ChangeRecord();
        cr.setEntityKey(entityKey);
        cr.setNodeID(node);
        cr.setRecordType(ChangeRecord.RecordType.ChangeRecordDelete);
        ChangeRecord crapi = new ChangeRecord();
        crapi.setChangeID(new ChangeRecordIDType(node, Long.valueOf(-1L)));
        crapi.setChangeRecordDelete(new ChangeRecordDelete());
        crapi.getChangeRecordDelete().setServiceKey(entityKey);
        crapi.getChangeRecordDelete().setModified(this.df.newXMLGregorianCalendar(new GregorianCalendar()));
        StringWriter sw = new StringWriter();
        JAXB.marshal((Object)crapi, (Writer)sw);
        try {
            cr.setContents(sw.toString().getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException ex) {
            logger.error((Object)ex);
        }
        return cr;
    }

    public org.apache.juddi.model.ChangeRecord getChangeRecord_deleteTModelHide(String entityKey, String node) {
        org.apache.juddi.model.ChangeRecord cr = new org.apache.juddi.model.ChangeRecord();
        cr.setEntityKey(entityKey);
        cr.setNodeID(node);
        cr.setRecordType(ChangeRecord.RecordType.ChangeRecordHide);
        ChangeRecord crapi = new ChangeRecord();
        crapi.setChangeID(new ChangeRecordIDType(node, Long.valueOf(-1L)));
        crapi.setChangeRecordHide(new ChangeRecordHide());
        crapi.getChangeRecordHide().setTModelKey(entityKey);
        crapi.getChangeRecordHide().setModified(this.df.newXMLGregorianCalendar(new GregorianCalendar()));
        StringWriter sw = new StringWriter();
        JAXB.marshal((Object)crapi, (Writer)sw);
        try {
            cr.setContents(sw.toString().getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException ex) {
            logger.error((Object)ex);
        }
        return cr;
    }

    public static org.apache.juddi.model.ChangeRecord getChangeRecord_deleteTModelDelete(String entityKey, String node, DatatypeFactory df) {
        org.apache.juddi.model.ChangeRecord cr = new org.apache.juddi.model.ChangeRecord();
        cr.setEntityKey(entityKey);
        cr.setNodeID(node);
        cr.setRecordType(ChangeRecord.RecordType.ChangeRecordDelete);
        ChangeRecord crapi = new ChangeRecord();
        crapi.setChangeID(new ChangeRecordIDType(node, Long.valueOf(-1L)));
        crapi.setChangeRecordDelete(new ChangeRecordDelete());
        crapi.getChangeRecordDelete().setTModelKey(entityKey);
        crapi.getChangeRecordDelete().setModified(df.newXMLGregorianCalendar(new GregorianCalendar()));
        StringWriter sw = new StringWriter();
        JAXB.marshal((Object)crapi, (Writer)sw);
        try {
            cr.setContents(sw.toString().getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException ex) {
            logger.error((Object)ex);
        }
        return cr;
    }

    public static org.apache.juddi.model.ChangeRecord getChangeRecord(org.apache.juddi.model.BusinessEntity modelBusinessEntity, BusinessEntity apiBusinessEntity, String node) throws DispositionReportFaultMessage {
        org.apache.juddi.model.ChangeRecord cr = new org.apache.juddi.model.ChangeRecord();
        cr.setEntityKey(modelBusinessEntity.getEntityKey());
        cr.setNodeID(node);
        cr.setRecordType(ChangeRecord.RecordType.ChangeRecordNewData);
        ChangeRecord crapi = new ChangeRecord();
        crapi.setChangeID(new ChangeRecordIDType(node, Long.valueOf(-1L)));
        crapi.setChangeRecordNewData(new ChangeRecordNewData());
        crapi.getChangeRecordNewData().setBusinessEntity(apiBusinessEntity);
        crapi.getChangeRecordNewData().setOperationalInfo(new OperationalInfo());
        MappingModelToApi.mapOperationalInfo(modelBusinessEntity, crapi.getChangeRecordNewData().getOperationalInfo());
        StringWriter sw = new StringWriter();
        JAXB.marshal((Object)crapi, (Writer)sw);
        try {
            cr.setContents(sw.toString().getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException ex) {
            logger.error((Object)ex);
        }
        return cr;
    }

    public static org.apache.juddi.model.ChangeRecord getChangeRecord(Tmodel modelBusinessEntity, TModel apiBusinessEntity, String node) throws DispositionReportFaultMessage {
        org.apache.juddi.model.ChangeRecord cr = new org.apache.juddi.model.ChangeRecord();
        if (!apiBusinessEntity.getTModelKey().equals(modelBusinessEntity.getEntityKey())) {
            throw new FatalErrorException(new ErrorMessage("E_fatalError", "the model and api keys do not match when saving a tmodel!"));
        }
        cr.setEntityKey(modelBusinessEntity.getEntityKey());
        cr.setNodeID(node);
        cr.setRecordType(ChangeRecord.RecordType.ChangeRecordNewData);
        ChangeRecord crapi = new ChangeRecord();
        crapi.setChangeID(new ChangeRecordIDType(node, Long.valueOf(-1L)));
        crapi.setChangeRecordNewData(new ChangeRecordNewData());
        crapi.getChangeRecordNewData().setTModel(apiBusinessEntity);
        crapi.getChangeRecordNewData().getTModel().setTModelKey(modelBusinessEntity.getEntityKey());
        crapi.getChangeRecordNewData().setOperationalInfo(new OperationalInfo());
        MappingModelToApi.mapOperationalInfo(modelBusinessEntity, crapi.getChangeRecordNewData().getOperationalInfo());
        StringWriter sw = new StringWriter();
        JAXB.marshal((Object)crapi, (Writer)sw);
        try {
            cr.setContents(sw.toString().getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException ex) {
            logger.error((Object)ex);
        }
        return cr;
    }

    public org.apache.juddi.model.ChangeRecord getChangeRecord_deleteBinding(String entityKey, String node) {
        org.apache.juddi.model.ChangeRecord cr = new org.apache.juddi.model.ChangeRecord();
        cr.setEntityKey(entityKey);
        cr.setNodeID(node);
        cr.setRecordType(ChangeRecord.RecordType.ChangeRecordDelete);
        ChangeRecord crapi = new ChangeRecord();
        crapi.setChangeID(new ChangeRecordIDType(node, Long.valueOf(-1L)));
        crapi.setChangeRecordDelete(new ChangeRecordDelete());
        crapi.getChangeRecordDelete().setBindingKey(entityKey);
        crapi.getChangeRecordDelete().setModified(this.df.newXMLGregorianCalendar(new GregorianCalendar()));
        StringWriter sw = new StringWriter();
        JAXB.marshal((Object)crapi, (Writer)sw);
        try {
            cr.setContents(sw.toString().getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException ex) {
            logger.error((Object)ex);
        }
        return cr;
    }

    public org.apache.juddi.model.ChangeRecord getChangeRecord_deletePublisherAssertion(PublisherAssertion entity, String node, boolean ToBusinessDelete, boolean FromBusinessDelete, long timestamp) {
        org.apache.juddi.model.ChangeRecord cr = new org.apache.juddi.model.ChangeRecord();
        cr.setNodeID(node);
        cr.setRecordType(ChangeRecord.RecordType.ChangeRecordDeleteAssertion);
        ChangeRecord crapi = new ChangeRecord();
        crapi.setChangeID(new ChangeRecordIDType(node, Long.valueOf(-1L)));
        crapi.setChangeRecordDeleteAssertion(new ChangeRecordDeleteAssertion());
        crapi.getChangeRecordDeleteAssertion().setPublisherAssertion(entity);
        crapi.getChangeRecordDeleteAssertion().setToBusinessCheck(ToBusinessDelete);
        crapi.getChangeRecordDeleteAssertion().setFromBusinessCheck(FromBusinessDelete);
        GregorianCalendar gcal = new GregorianCalendar();
        gcal.setTimeInMillis(timestamp);
        crapi.getChangeRecordDeleteAssertion().setModified(this.df.newXMLGregorianCalendar(gcal));
        StringWriter sw = new StringWriter();
        JAXB.marshal((Object)crapi, (Writer)sw);
        try {
            cr.setContents(sw.toString().getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException ex) {
            logger.error((Object)ex);
        }
        return cr;
    }

    public org.apache.juddi.model.ChangeRecord getChangeRecord_NewAssertion(PublisherAssertion apiPubAssertion, org.apache.juddi.model.PublisherAssertion modelPubAssertion, String node) {
        org.apache.juddi.model.ChangeRecord cr = new org.apache.juddi.model.ChangeRecord();
        cr.setNodeID(node);
        cr.setRecordType(ChangeRecord.RecordType.ChangeRecordPublisherAssertion);
        ChangeRecord crapi = new ChangeRecord();
        crapi.setChangeID(new ChangeRecordIDType(node, Long.valueOf(-1L)));
        crapi.setChangeRecordPublisherAssertion(new ChangeRecordPublisherAssertion());
        crapi.getChangeRecordPublisherAssertion().setFromBusinessCheck(modelPubAssertion.getFromCheck().equalsIgnoreCase("true"));
        crapi.getChangeRecordPublisherAssertion().setToBusinessCheck(modelPubAssertion.getToCheck().equalsIgnoreCase("true"));
        crapi.getChangeRecordPublisherAssertion().setPublisherAssertion(apiPubAssertion);
        crapi.getChangeRecordPublisherAssertion().setModified(this.df.newXMLGregorianCalendar(new GregorianCalendar()));
        StringWriter sw = new StringWriter();
        JAXB.marshal((Object)crapi, (Writer)sw);
        try {
            cr.setContents(sw.toString().getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException ex) {
            logger.error((Object)ex);
        }
        return cr;
    }

    private List<org.apache.juddi.model.PublisherAssertion> diff(List<PublisherAssertion> value, List<org.apache.juddi.model.PublisherAssertion> existingAssertions) throws DispositionReportFaultMessage {
        ArrayList<org.apache.juddi.model.PublisherAssertion> ret = new ArrayList<org.apache.juddi.model.PublisherAssertion>();
        if (value == null || value.isEmpty()) {
            return existingAssertions;
        }
        if (existingAssertions == null) {
            return new ArrayList<org.apache.juddi.model.PublisherAssertion>();
        }
        for (org.apache.juddi.model.PublisherAssertion model : existingAssertions) {
            boolean found = false;
            for (PublisherAssertion paapi : value) {
                if (!model.getBusinessEntityByFromKey().getEntityKey().equalsIgnoreCase(paapi.getFromKey()) || !model.getBusinessEntityByToKey().getEntityKey().equalsIgnoreCase(paapi.getToKey()) || !model.getKeyName().equals(paapi.getKeyedReference().getKeyName()) || !model.getKeyValue().equals(paapi.getKeyedReference().getKeyValue()) || !model.getTmodelKey().equalsIgnoreCase(paapi.getKeyedReference().getTModelKey())) continue;
                found = true;
                break;
            }
            if (found) continue;
            ret.add(model);
        }
        return ret;
    }

    private static org.apache.juddi.model.ChangeRecord getChangeRecordConditional(Tmodel modelTModel, TModel apiTModel, String node) throws DispositionReportFaultMessage {
        org.apache.juddi.model.ChangeRecord cr = new org.apache.juddi.model.ChangeRecord();
        if (!apiTModel.getTModelKey().equals(modelTModel.getEntityKey())) {
            throw new FatalErrorException(new ErrorMessage("E_fatalError", "the model and api keys do not match when saving a tmodel!"));
        }
        cr.setEntityKey(modelTModel.getEntityKey());
        cr.setNodeID(node);
        cr.setRecordType(ChangeRecord.RecordType.ChangeRecordNewDataConditional);
        ChangeRecord crapi = new ChangeRecord();
        crapi.setChangeID(new ChangeRecordIDType(node, Long.valueOf(-1L)));
        crapi.setChangeRecordNewDataConditional(new ChangeRecordNewDataConditional());
        crapi.getChangeRecordNewDataConditional().setChangeRecordNewData(new ChangeRecordNewData());
        crapi.getChangeRecordNewDataConditional().getChangeRecordNewData().setTModel(apiTModel);
        crapi.getChangeRecordNewDataConditional().getChangeRecordNewData().getTModel().setTModelKey(modelTModel.getEntityKey());
        crapi.getChangeRecordNewDataConditional().getChangeRecordNewData().setOperationalInfo(new OperationalInfo());
        MappingModelToApi.mapOperationalInfo(modelTModel, crapi.getChangeRecordNewDataConditional().getChangeRecordNewData().getOperationalInfo());
        StringWriter sw = new StringWriter();
        JAXB.marshal((Object)crapi, (Writer)sw);
        try {
            cr.setContents(sw.toString().getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException ex) {
            logger.error((Object)ex);
        }
        return cr;
    }

    private void removeExistingPublisherAssertionSignatures(String from, String to, EntityManager em) {
        Query createQuery = em.createQuery("delete from Signature pa where pa.publisherAssertionFromKey=:from and pa.publisherAssertionToKey=:to");
        createQuery.setParameter("from", (Object)from);
        createQuery.setParameter("to", (Object)to);
        createQuery.executeUpdate();
    }

    private void savePushliserAssertionSignatures(String from, String to, List<Signature> signatures, EntityManager em) {
        if (signatures == null) {
            return;
        }
        for (Signature s : signatures) {
            s.setPublisherAssertionFromKey(from);
            s.setPublisherAssertionToKey(to);
            em.persist((Object)s);
        }
    }
}

