/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.api.impl;

import java.util.ArrayList;
import java.util.List;
import javax.jws.WebService;
import javax.xml.ws.Holder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.api.impl.AuthenticatedService;
import org.apache.juddi.api.impl.ServiceCounterLifecycleResource;
import org.apache.juddi.api.impl.UDDIServiceCounter;
import org.apache.juddi.api.impl.UDDIValueSetValidationImpl;
import org.apache.juddi.api.util.QueryStatus;
import org.apache.juddi.api.util.ValueSetCachingQuery;
import org.uddi.v3_service.DispositionReportFaultMessage;
import org.uddi.v3_service.UDDIValueSetCachingPortType;
import org.uddi.vscache_v3.ValidValue;

@WebService(serviceName="UDDIValueSetCachingService", endpointInterface="org.uddi.v3_service.UDDIValueSetCachingPortType", targetNamespace="urn:uddi-org:v3_service")
public class UDDIValueSetCachingImpl
extends AuthenticatedService
implements UDDIValueSetCachingPortType {
    private static Log logger = LogFactory.getLog(UDDIValueSetCachingImpl.class);
    private UDDIServiceCounter serviceCounter = ServiceCounterLifecycleResource.getServiceCounter(this.getClass());

    public void getAllValidValues(String authInfo, String modelKey, Holder<String> chunkToken, Holder<List<ValidValue>> validValue) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        List<String> validValues = UDDIValueSetValidationImpl.getValidValues(modelKey);
        Holder ret = new Holder(new ArrayList());
        if (validValues != null) {
            for (int i = 0; i < validValues.size(); ++i) {
                ValidValue x = new ValidValue(validValues.get(i));
                ((List)ret.value).add(x);
            }
        }
        chunkToken = new Holder();
        chunkToken.value = "0";
        long procTime = System.currentTimeMillis() - startTime;
        this.serviceCounter.update(ValueSetCachingQuery.GET_ALLVALIDVALUES, QueryStatus.SUCCESS, procTime);
    }
}

