/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.api.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.jws.WebService;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.apache.juddi.api.impl.AuthenticatedService;
import org.apache.juddi.api.impl.ServiceCounterLifecycleResource;
import org.apache.juddi.api.impl.UDDIServiceCounter;
import org.apache.juddi.api.util.QueryStatus;
import org.apache.juddi.api.util.ValueSetValidationQuery;
import org.apache.juddi.config.PersistenceManager;
import org.apache.juddi.model.Tmodel;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.FatalErrorException;
import org.apache.juddi.v3.error.ValueNotAllowedException;
import org.apache.juddi.validation.vsv.ValueSetValidator;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BusinessEntity;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.DispositionReport;
import org.uddi.api_v3.KeyedReference;
import org.uddi.api_v3.KeyedReferenceGroup;
import org.uddi.api_v3.PublisherAssertion;
import org.uddi.api_v3.Result;
import org.uddi.api_v3.TModel;
import org.uddi.v3_service.DispositionReportFaultMessage;
import org.uddi.v3_service.UDDIValueSetValidationPortType;
import org.uddi.vs_v3.ValidateValues;

@WebService(serviceName="UDDIValueSetCachingService", endpointInterface="org.uddi.v3_service.UDDIValueSetValidationPortType", targetNamespace="urn:uddi-org:api_v3_portType")
public class UDDIValueSetValidationImpl
extends AuthenticatedService
implements UDDIValueSetValidationPortType {
    private UDDIServiceCounter serviceCounter = ServiceCounterLifecycleResource.getServiceCounter(this.getClass());

    public DispositionReport validateValues(ValidateValues body) throws DispositionReportFaultMessage {
        long startTime = System.currentTimeMillis();
        if (body == null) {
            long procTime = System.currentTimeMillis() - startTime;
            this.serviceCounter.update(ValueSetValidationQuery.VALIDATE_VALUES, QueryStatus.FAILED, procTime);
            throw new ValueNotAllowedException(new ErrorMessage("errors.valuesetvalidation.noinput"));
        }
        ArrayList<String> classNames = new ArrayList<String>();
        classNames.addAll(this.validateValuesBindingTemplate(body.getBindingTemplate()));
        classNames.addAll(this.validateValuesBusinessEntity(body.getBusinessEntity()));
        classNames.addAll(this.validateValuesBusinessService(body.getBusinessService()));
        classNames.addAll(this.validateValuesPublisherAssertion(body.getPublisherAssertion()));
        classNames.addAll(this.validateValuesTModel(body.getTModel()));
        HashSet set = new HashSet(classNames);
        Iterator iterator = set.iterator();
        HashSet<String> validators = new HashSet<String>();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                Tmodel find = (Tmodel)em.find(Tmodel.class, (Object)key);
                if (find == null) continue;
                if (this.containsValidatedKey(find, "uddi:uddi.org:categorization:validatedby")) {
                    validators.add(key);
                }
                if (!this.containsValidatedKey(find, "uuid:25b22e3e-3dfa-3024-b02a-3438b9050b59")) continue;
                validators.add(key);
            }
        }
        catch (Exception drfm) {
            logger.warn((Object)"Unable to process vsv validation", (Throwable)drfm);
            throw new FatalErrorException(new ErrorMessage("errors.valuesetvalidation.fatal", drfm.getMessage()));
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
        for (String tmodelkey : validators) {
            String clazz = UDDIValueSetValidationImpl.convertKeyToClass(tmodelkey);
            if (clazz == null) {
                logger.info((Object)("No validator found for " + tmodelkey));
                continue;
            }
            try {
                ValueSetValidator vsv = (ValueSetValidator)Class.forName(clazz).newInstance();
                logger.info((Object)("translated " + tmodelkey + " to class " + clazz));
                vsv.validateValuesBindingTemplate(body.getBindingTemplate(), "");
                vsv.validateValuesBusinessEntity(body.getBusinessEntity());
                vsv.validateValuesBusinessService(body.getBusinessService(), "");
                vsv.validateValuesPublisherAssertion(body.getPublisherAssertion());
                vsv.validateValuesTModel(body.getTModel());
            }
            catch (ClassNotFoundException ex) {
                logger.warn((Object)("Unable to process vsv validation for " + tmodelkey), (Throwable)ex);
                throw new FatalErrorException(new ErrorMessage("errors.valuesetvalidation.fatal", "key=" + tmodelkey + " class=" + clazz + " " + ex.getMessage()));
            }
            catch (InstantiationException ex) {
                logger.warn((Object)("Unable to process vsv validation for " + tmodelkey), (Throwable)ex);
                throw new FatalErrorException(new ErrorMessage("errors.valuesetvalidation.fatal", "key=" + tmodelkey + " class=" + clazz + " " + ex.getMessage()));
            }
            catch (IllegalAccessException ex) {
                logger.warn((Object)("Unable to process vsv validation for " + tmodelkey), (Throwable)ex);
                throw new FatalErrorException(new ErrorMessage("errors.valuesetvalidation.fatal", "key=" + tmodelkey + " class=" + clazz + " " + ex.getMessage()));
            }
        }
        DispositionReport r = new DispositionReport();
        r.getResult().add(new Result());
        long procTime = System.currentTimeMillis() - startTime;
        this.serviceCounter.update(ValueSetValidationQuery.VALIDATE_VALUES, QueryStatus.SUCCESS, procTime);
        return r;
    }

    private List<String> validateValuesBindingTemplate(List<BindingTemplate> items) {
        ArrayList<String> ret = new ArrayList<String>();
        if (items == null) {
            return ret;
        }
        for (int i = 0; i < items.size(); ++i) {
            if (items.get(i).getCategoryBag() != null) {
                ret.addAll(this.validateValuesKeyRef(items.get(i).getCategoryBag().getKeyedReference()));
                ret.addAll(this.validateValuesKeyRefGrp(items.get(i).getCategoryBag().getKeyedReferenceGroup()));
            }
            if (items.get(i).getTModelInstanceDetails() == null) continue;
        }
        return ret;
    }

    private List<String> validateValuesBusinessEntity(List<BusinessEntity> items) {
        ArrayList<String> ret = new ArrayList<String>();
        if (items == null) {
            return ret;
        }
        for (int i = 0; i < items.size(); ++i) {
            if (items.get(i).getCategoryBag() != null) {
                ret.addAll(this.validateValuesKeyRef(items.get(i).getCategoryBag().getKeyedReference()));
                ret.addAll(this.validateValuesKeyRefGrp(items.get(i).getCategoryBag().getKeyedReferenceGroup()));
            }
            if (items.get(i).getIdentifierBag() != null) {
                ret.addAll(this.validateValuesKeyRef(items.get(i).getIdentifierBag().getKeyedReference()));
            }
            if (items.get(i).getBusinessServices() == null) continue;
            ret.addAll(this.validateValuesBusinessService(items.get(i).getBusinessServices().getBusinessService()));
        }
        return ret;
    }

    private List<String> validateValuesBusinessService(List<BusinessService> items) {
        ArrayList<String> ret = new ArrayList<String>();
        if (items == null) {
            return ret;
        }
        for (int i = 0; i < items.size(); ++i) {
            if (items.get(i).getCategoryBag() != null) {
                ret.addAll(this.validateValuesKeyRef(items.get(i).getCategoryBag().getKeyedReference()));
                ret.addAll(this.validateValuesKeyRefGrp(items.get(i).getCategoryBag().getKeyedReferenceGroup()));
            }
            if (items.get(i).getBindingTemplates() == null) continue;
            ret.addAll(this.validateValuesBindingTemplate(items.get(i).getBindingTemplates().getBindingTemplate()));
        }
        return ret;
    }

    private List<String> validateValuesPublisherAssertion(List<PublisherAssertion> items) {
        ArrayList<String> ret = new ArrayList<String>();
        if (items == null) {
            return ret;
        }
        for (int i = 0; i < items.size(); ++i) {
            if (items.get(i).getKeyedReference() == null) continue;
            ArrayList<KeyedReference> temp = new ArrayList<KeyedReference>();
            temp.add(items.get(i).getKeyedReference());
            ret.addAll(this.validateValuesKeyRef(temp));
        }
        return ret;
    }

    private List<String> validateValuesTModel(List<TModel> items) {
        ArrayList<String> ret = new ArrayList<String>();
        if (items == null) {
            return ret;
        }
        for (int i = 0; i < items.size(); ++i) {
            if (items.get(i).getCategoryBag() != null) {
                ret.addAll(this.validateValuesKeyRef(items.get(i).getCategoryBag().getKeyedReference()));
                ret.addAll(this.validateValuesKeyRefGrp(items.get(i).getCategoryBag().getKeyedReferenceGroup()));
            }
            if (items.get(i).getIdentifierBag() == null) continue;
            ret.addAll(this.validateValuesKeyRef(items.get(i).getIdentifierBag().getKeyedReference()));
        }
        return ret;
    }

    private List<String> validateValuesKeyRef(List<KeyedReference> items) {
        ArrayList<String> ret = new ArrayList<String>();
        if (items == null) {
            return ret;
        }
        for (int i = 0; i < items.size(); ++i) {
            ret.add(items.get(i).getTModelKey());
        }
        return ret;
    }

    private List<String> validateValuesKeyRefGrp(List<KeyedReferenceGroup> items) {
        ArrayList<String> ret = new ArrayList<String>();
        if (items == null) {
            return ret;
        }
        for (int i = 0; i < items.size(); ++i) {
            ret.addAll(this.validateValuesKeyRef(items.get(i).getKeyedReference()));
        }
        return ret;
    }

    public static String convertKeyToClass(String tmodelkey) {
        if (tmodelkey == null) {
            return null;
        }
        if (tmodelkey.length() < 2) {
            return null;
        }
        String key = new String(new char[]{tmodelkey.charAt(0)}).toUpperCase() + tmodelkey.substring(1).toLowerCase();
        key = key.replaceAll("[^a-zA-Z0-9]", "");
        String clazz = "org.apache.juddi.validation.vsv." + key;
        return clazz;
    }

    public static List<String> getValidValues(String modelKey) {
        try {
            ValueSetValidator vsv = (ValueSetValidator)Class.forName(UDDIValueSetValidationImpl.convertKeyToClass(modelKey)).newInstance();
            return vsv.getValidValues();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    private boolean containsValidatedKey(Tmodel find, String key) {
        int i;
        if (find.getCategoryBag() != null) {
            if (find.getCategoryBag().getKeyedReferences() != null) {
                for (i = 0; i < find.getCategoryBag().getKeyedReferences().size(); ++i) {
                    if (!key.equalsIgnoreCase(find.getCategoryBag().getKeyedReferences().get(i).getTmodelKeyRef())) continue;
                    return true;
                }
            }
            if (find.getCategoryBag().getKeyedReferenceGroups() != null) {
                for (i = 0; i < find.getCategoryBag().getKeyedReferenceGroups().size(); ++i) {
                    for (int k = 0; k < find.getCategoryBag().getKeyedReferenceGroups().get(i).getKeyedReferences().size(); ++k) {
                        if (!key.equalsIgnoreCase(find.getCategoryBag().getKeyedReferenceGroups().get(i).getKeyedReferences().get(k).getTmodelKeyRef())) continue;
                        return true;
                    }
                }
            }
        }
        if (find.getTmodelIdentifiers() != null) {
            for (i = 0; i < find.getTmodelIdentifiers().size(); ++i) {
                if (!key.equalsIgnoreCase(find.getTmodelIdentifiers().get(i).getTmodelKeyRef())) continue;
                return true;
            }
        }
        return false;
    }
}

