/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.api.impl;

import java.util.List;
import javax.jws.WebService;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.xml.ws.Holder;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.api.impl.UDDIPublicationImpl;
import org.apache.juddi.api.impl.UDDISecurityImpl;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.config.PersistenceManager;
import org.apache.juddi.v3.client.mapping.MapUDDIv2Tov3;
import org.apache.juddi.v3.client.mapping.MapUDDIv3Tov2;
import org.uddi.api_v2.AddPublisherAssertions;
import org.uddi.api_v2.AssertionStatusReport;
import org.uddi.api_v2.AuthToken;
import org.uddi.api_v2.BindingDetail;
import org.uddi.api_v2.BusinessDetail;
import org.uddi.api_v2.DeleteBinding;
import org.uddi.api_v2.DeleteBusiness;
import org.uddi.api_v2.DeletePublisherAssertions;
import org.uddi.api_v2.DeleteService;
import org.uddi.api_v2.DeleteTModel;
import org.uddi.api_v2.DiscardAuthToken;
import org.uddi.api_v2.GetAssertionStatusReport;
import org.uddi.api_v2.GetAuthToken;
import org.uddi.api_v2.GetPublisherAssertions;
import org.uddi.api_v2.GetRegisteredInfo;
import org.uddi.api_v2.PublisherAssertions;
import org.uddi.api_v2.RegisteredInfo;
import org.uddi.api_v2.Result;
import org.uddi.api_v2.SaveBinding;
import org.uddi.api_v2.SaveBusiness;
import org.uddi.api_v2.SaveService;
import org.uddi.api_v2.SaveTModel;
import org.uddi.api_v2.ServiceDetail;
import org.uddi.api_v2.SetPublisherAssertions;
import org.uddi.api_v2.Truncated;
import org.uddi.api_v3.PublisherAssertion;
import org.uddi.api_v3.TModelDetail;
import org.uddi.v2_service.DispositionReport;
import org.uddi.v2_service.Publish;
import org.uddi.v3_service.DispositionReportFaultMessage;

@WebService(serviceName="Publish", targetNamespace="urn:uddi-org:publication_v2", endpointInterface="org.uddi.v2_service.Publish")
public class UDDIv2PublishImpl
implements Publish {
    static String nodeId = null;
    private static Log logger = LogFactory.getLog(UDDIv2PublishImpl.class);
    static UDDIPublicationImpl publishService = new UDDIPublicationImpl();
    static UDDISecurityImpl securityService = new UDDISecurityImpl();

    public UDDIv2PublishImpl() {
        logger.warn((Object)("This implementation of UDDIv2 Publish service " + UDDIv2PublishImpl.class.getCanonicalName() + " is considered BETA. Please report any issues to https://issues.apache.org/jira/browse/JUDDI"));
    }

    private static String getNodeID() {
        try {
            nodeId = AppConfig.getConfiguration().getString("juddi.nodeId");
        }
        catch (ConfigurationException ex) {
            logger.warn((Object)ex.getMessage());
            nodeId = "JUDDI_v3";
        }
        return nodeId;
    }

    public org.uddi.api_v2.DispositionReport addPublisherAssertions(AddPublisherAssertions body) throws DispositionReport {
        try {
            publishService.addPublisherAssertions(MapUDDIv2Tov3.MapAddPublisherAssertions((AddPublisherAssertions)body));
        }
        catch (DispositionReportFaultMessage ex) {
            throw MapUDDIv3Tov2.MapException((DispositionReportFaultMessage)ex, (String)UDDIv2PublishImpl.getNodeID());
        }
        return this.getSuccessMessage();
    }

    public org.uddi.api_v2.DispositionReport deleteBinding(DeleteBinding body) throws DispositionReport {
        try {
            publishService.deleteBinding(MapUDDIv2Tov3.MapDeleteBinding((DeleteBinding)body));
        }
        catch (DispositionReportFaultMessage ex) {
            throw MapUDDIv3Tov2.MapException((DispositionReportFaultMessage)ex, (String)UDDIv2PublishImpl.getNodeID());
        }
        return this.getSuccessMessage();
    }

    public org.uddi.api_v2.DispositionReport deleteBusiness(DeleteBusiness body) throws DispositionReport {
        try {
            publishService.deleteBusiness(MapUDDIv2Tov3.MapDeleteBusiness((DeleteBusiness)body));
        }
        catch (DispositionReportFaultMessage ex) {
            throw MapUDDIv3Tov2.MapException((DispositionReportFaultMessage)ex, (String)UDDIv2PublishImpl.getNodeID());
        }
        return this.getSuccessMessage();
    }

    public org.uddi.api_v2.DispositionReport deletePublisherAssertions(DeletePublisherAssertions body) throws DispositionReport {
        try {
            publishService.deletePublisherAssertions(MapUDDIv2Tov3.MapDeletePublisherAssertion((DeletePublisherAssertions)body));
        }
        catch (DispositionReportFaultMessage ex) {
            throw MapUDDIv3Tov2.MapException((DispositionReportFaultMessage)ex, (String)UDDIv2PublishImpl.getNodeID());
        }
        return this.getSuccessMessage();
    }

    public org.uddi.api_v2.DispositionReport deleteService(DeleteService body) throws DispositionReport {
        try {
            publishService.deleteService(MapUDDIv2Tov3.MapDeleteService((DeleteService)body));
        }
        catch (DispositionReportFaultMessage ex) {
            throw MapUDDIv3Tov2.MapException((DispositionReportFaultMessage)ex, (String)UDDIv2PublishImpl.getNodeID());
        }
        return this.getSuccessMessage();
    }

    public org.uddi.api_v2.DispositionReport deleteTModel(DeleteTModel body) throws DispositionReport {
        try {
            publishService.deleteTModel(MapUDDIv2Tov3.MapDeleteTModel((DeleteTModel)body));
        }
        catch (DispositionReportFaultMessage ex) {
            throw MapUDDIv3Tov2.MapException((DispositionReportFaultMessage)ex, (String)UDDIv2PublishImpl.getNodeID());
        }
        return this.getSuccessMessage();
    }

    public org.uddi.api_v2.DispositionReport discardAuthToken(DiscardAuthToken body) throws DispositionReport {
        try {
            securityService.discardAuthToken(new org.uddi.api_v3.DiscardAuthToken(body.getAuthInfo()));
        }
        catch (DispositionReportFaultMessage ex) {
            throw MapUDDIv3Tov2.MapException((DispositionReportFaultMessage)ex, (String)UDDIv2PublishImpl.getNodeID());
        }
        return this.getSuccessMessage();
    }

    public AssertionStatusReport getAssertionStatusReport(GetAssertionStatusReport body) throws DispositionReport {
        try {
            return MapUDDIv3Tov2.MapAssertionStatusReport(publishService.getAssertionStatusReport(body.getAuthInfo(), MapUDDIv2Tov3.MapCompletionStatus((String)body.getCompletionStatus())));
        }
        catch (DispositionReportFaultMessage ex) {
            throw MapUDDIv3Tov2.MapException((DispositionReportFaultMessage)ex, (String)UDDIv2PublishImpl.getNodeID());
        }
    }

    public AuthToken getAuthToken(GetAuthToken body) throws DispositionReport {
        try {
            org.uddi.api_v3.GetAuthToken r = new org.uddi.api_v3.GetAuthToken();
            r.setCred(body.getCred());
            r.setUserID(body.getUserID());
            org.uddi.api_v3.AuthToken authToken = securityService.getAuthToken(r);
            AuthToken ret = new AuthToken();
            ret.setAuthInfo(authToken.getAuthInfo());
            ret.setGeneric("2.0");
            ret.setOperator(UDDIv2PublishImpl.getNodeID());
            return ret;
        }
        catch (DispositionReportFaultMessage ex) {
            throw MapUDDIv3Tov2.MapException((DispositionReportFaultMessage)ex, (String)UDDIv2PublishImpl.getNodeID());
        }
    }

    public PublisherAssertions getPublisherAssertions(GetPublisherAssertions body) throws DispositionReport {
        try {
            return MapUDDIv3Tov2.MapPublisherAssertions(publishService.getPublisherAssertions(body.getAuthInfo()), (String)UDDIv2PublishImpl.getNodeID(), (String)this.getUsername(body.getAuthInfo()));
        }
        catch (DispositionReportFaultMessage ex) {
            throw MapUDDIv3Tov2.MapException((DispositionReportFaultMessage)ex, (String)UDDIv2PublishImpl.getNodeID());
        }
    }

    public RegisteredInfo getRegisteredInfo(GetRegisteredInfo body) throws DispositionReport {
        try {
            return MapUDDIv3Tov2.MapRegisteredInfo((org.uddi.api_v3.RegisteredInfo)publishService.getRegisteredInfo(MapUDDIv2Tov3.MapGetRegisteredInfo((GetRegisteredInfo)body)), (String)UDDIv2PublishImpl.getNodeID());
        }
        catch (DispositionReportFaultMessage ex) {
            throw MapUDDIv3Tov2.MapException((DispositionReportFaultMessage)ex, (String)UDDIv2PublishImpl.getNodeID());
        }
    }

    public BindingDetail saveBinding(SaveBinding body) throws DispositionReport {
        try {
            return MapUDDIv3Tov2.MapBindingDetail((org.uddi.api_v3.BindingDetail)publishService.saveBinding(MapUDDIv2Tov3.MapSaveBinding((SaveBinding)body)), (String)UDDIv2PublishImpl.getNodeID());
        }
        catch (DispositionReportFaultMessage ex) {
            throw MapUDDIv3Tov2.MapException((DispositionReportFaultMessage)ex, (String)UDDIv2PublishImpl.getNodeID());
        }
    }

    public BusinessDetail saveBusiness(SaveBusiness body) throws DispositionReport {
        try {
            return MapUDDIv3Tov2.MapBusinessDetail((org.uddi.api_v3.BusinessDetail)publishService.saveBusiness(MapUDDIv2Tov3.MapSaveBusiness((SaveBusiness)body)), (String)UDDIv2PublishImpl.getNodeID());
        }
        catch (DispositionReportFaultMessage ex) {
            throw MapUDDIv3Tov2.MapException((DispositionReportFaultMessage)ex, (String)UDDIv2PublishImpl.getNodeID());
        }
    }

    public ServiceDetail saveService(SaveService body) throws DispositionReport {
        try {
            return MapUDDIv3Tov2.MapServiceDetail((org.uddi.api_v3.ServiceDetail)publishService.saveService(MapUDDIv2Tov3.MapSaveService((SaveService)body)), (String)UDDIv2PublishImpl.getNodeID());
        }
        catch (DispositionReportFaultMessage ex) {
            throw MapUDDIv3Tov2.MapException((DispositionReportFaultMessage)ex, (String)UDDIv2PublishImpl.getNodeID());
        }
    }

    public org.uddi.api_v2.TModelDetail saveTModel(SaveTModel body) throws DispositionReport {
        try {
            return MapUDDIv3Tov2.MapTModelDetail((TModelDetail)publishService.saveTModel(MapUDDIv2Tov3.MapSaveTModel((SaveTModel)body)), (String)UDDIv2PublishImpl.getNodeID());
        }
        catch (DispositionReportFaultMessage ex) {
            throw MapUDDIv3Tov2.MapException((DispositionReportFaultMessage)ex, (String)UDDIv2PublishImpl.getNodeID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUsername(String authinfo) {
        String user = "N/A";
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            user = publishService.getEntityPublisher(em, authinfo).getAuthorizedName();
            tx.commit();
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
        return user;
    }

    public PublisherAssertions setPublisherAssertions(SetPublisherAssertions body) throws DispositionReport {
        try {
            Holder req = new Holder();
            req.value = MapUDDIv2Tov3.MapSetPublisherAssertions((SetPublisherAssertions)body);
            publishService.setPublisherAssertions(body.getAuthInfo(), (Holder<List<PublisherAssertion>>)req);
            return MapUDDIv3Tov2.MapPublisherAssertions((List)((List)req.value), (String)UDDIv2PublishImpl.getNodeID(), (String)this.getUsername(body.getAuthInfo()));
        }
        catch (DispositionReportFaultMessage ex) {
            throw MapUDDIv3Tov2.MapException((DispositionReportFaultMessage)ex, (String)UDDIv2PublishImpl.getNodeID());
        }
    }

    private org.uddi.api_v2.DispositionReport getSuccessMessage() {
        org.uddi.api_v2.DispositionReport r = new org.uddi.api_v2.DispositionReport();
        r.setGeneric("2.0");
        r.setTruncated(Truncated.FALSE);
        Result x = new Result();
        r.setOperator(UDDIv2PublishImpl.getNodeID());
        r.getResult().add(x);
        return r;
    }
}

